/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v400.logic.marking.Marking;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class ProcedureFunctionMarking
extends Marking
implements Link {
    private static final Attribute ARTERIAL = new Attribute("arterial");
    private static final Attribute NOR_DRUG_STENT = new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue());
    private static final Attribute NOR_STENT = new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue());
    private static final List<Attribute> STENTS = Arrays.asList(new Attribute("stent1"), new Attribute("stent2"), new Attribute("stent3"), new Attribute("stent4"));
    private static final List<Attribute> ARTERIAL_AND_NOR_DRUG_STENT = Arrays.asList(ARTERIAL, NOR_DRUG_STENT);
    private static final List<Attribute> ARTERIAL_AND_NOR_STENT = Arrays.asList(ARTERIAL, NOR_STENT);
    private static final List<Attribute> VESSELS = Arrays.asList(new Attribute("vessel1"), new Attribute("vessel2"), new Attribute("vessel3"), new Attribute("vessel4"));

    abstract void setMarked(MsdrgProcedureCode var1);

    abstract void setDrgImpact(MsdrgProcedureCode var1);

    abstract boolean isMarked(MsdrgProcedureCode var1);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        ProcessingData processingData = context.getProcessingData();
        this.markSpecialFunctionsProcedure(groupingContext.getMatchAttributes(), processingData.getProcedureCodes());
        return new Link.LinkResult(context, true);
    }

    private void markSpecialFunctionsProcedure(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        this.markStents(matchedAttributes, procedureCodes);
        this.markVessels(matchedAttributes, procedureCodes);
    }

    private void markStents(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        if (!Collections.disjoint(matchedAttributes, STENTS)) {
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.is(MsdrgCode.CodeFlag.STENT_4)) continue;
                this.setMarked(procCode);
                this.setDrgImpact(procCode);
            }
            if (matchedAttributes.containsAll(ARTERIAL_AND_NOR_DRUG_STENT)) {
                for (MsdrgProcedureCode procCode : procedureCodes) {
                    if (this.isMarked(procCode) || !procCode.hasAttributes(ARTERIAL, NOR_DRUG_STENT)) continue;
                    this.setMarked(procCode);
                    this.setDrgImpact(procCode);
                }
            } else if (matchedAttributes.containsAll(ARTERIAL_AND_NOR_STENT)) {
                for (MsdrgProcedureCode procCode : procedureCodes) {
                    if (this.isMarked(procCode) || !procCode.hasAttributes(ARTERIAL, NOR_STENT)) continue;
                    this.setMarked(procCode);
                    this.setDrgImpact(procCode);
                }
            }
            STENTS.forEach(matchedAttributes::remove);
            matchedAttributes.remove(ARTERIAL);
            matchedAttributes.remove(NOR_DRUG_STENT);
            matchedAttributes.remove(NOR_STENT);
        }
    }

    private void markVessels(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        if (!Collections.disjoint(matchedAttributes, VESSELS)) {
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.is(MsdrgCode.CodeFlag.VESSEL_4)) continue;
                this.setMarked(procCode);
                this.setDrgImpact(procCode);
            }
            VESSELS.forEach(matchedAttributes::remove);
        }
    }
}

