/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class ProcedureMarking
implements Link {
    private static final Set<String> COMPLETE_SYSTEM = new HashSet<String>(Collections.singletonList("revision"));
    private static final Set<Integer> UNRELATED_DRGS = new HashSet<Integer>(Arrays.asList(981, 982, 983, 987, 988, 989));

    protected boolean unrelated(MsdrgMatchedDrgFormula formula) {
        return UNRELATED_DRGS.contains(formula.getDrg());
    }

    abstract GroupingContext fetchGroupingContext(ProcessingContext var1);

    abstract int fetchMdc(ProcessingContext var1);

    abstract void setMarked(MsdrgProcedureCode var1);

    abstract void setDrgImpact(MsdrgProcedureCode var1);

    abstract void hacMarking(ProcessingContext var1) throws FoundationException;

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        if (context.getRuntime().getComputeAffectDrg() != MsdrgAffectDrgOptionFlag.COMPUTE) {
            return new Link.LinkResult(context, true);
        }
        ProcessingData processingData = context.getProcessingData();
        GroupingContext matchedFormula = this.fetchGroupingContext(context);
        List<MsdrgProcedureCode> procCodes = processingData.getProcedureCodes();
        List<MsdrgProcedureCode> clusterCodes = processingData.getClusters();
        MsdrgProcedureCode principalProc = processingData.getPrincipalProc();
        int mdc = this.fetchMdc(context);
        if (!this.oneProcForAllAttributes(matchedFormula, procCodes, clusterCodes, mdc)) {
            block0: for (Attribute attr : matchedFormula.getMatchAttributes()) {
                if (COMPLETE_SYSTEM.contains(attr.getListName()) && this.completeSystemTieBreaker(attr, procCodes, clusterCodes, mdc, principalProc)) continue;
                if (this.multipleProcsHaveSameAttribute(attr, procCodes, mdc)) {
                    if (principalProc.hasAttribute(attr) && !principalProc.getMdcSuppression().get(mdc)) {
                        this.setMarked(principalProc);
                        this.setDrgImpact(principalProc);
                        continue;
                    }
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                        this.setMarked(procCode);
                        this.setDrgImpact(procCode);
                        continue block0;
                    }
                    continue;
                }
                boolean matchFound = false;
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                    this.setMarked(procCode);
                    this.setDrgImpact(procCode);
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                for (MsdrgProcedureCode cluster : clusterCodes) {
                    if (!cluster.hasAttribute(attr)) continue;
                    TreeSet<String> codeValues = new TreeSet<String>();
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.getClusterIds().contains(cluster.getValue()) || codeValues.contains(procCode.getValue())) continue;
                        codeValues.add(procCode.getValue());
                        this.setMarked(procCode);
                        this.setDrgImpact(procCode);
                    }
                    continue block0;
                }
            }
        }
        this.hacMarking(context);
        processingData = processingData.toBuilder().withPrincipalProcedure(principalProc).withClusters(clusterCodes).withProcedures(procCodes).build();
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }

    public MsdrgGroupingImpact impactMarking(MsdrgGroupingImpact existingImpact) {
        if (existingImpact == MsdrgGroupingImpact.BOTH) {
            return MsdrgGroupingImpact.BOTH;
        }
        if (existingImpact == MsdrgGroupingImpact.INITIAL) {
            return MsdrgGroupingImpact.BOTH;
        }
        return MsdrgGroupingImpact.FINAL;
    }

    private Set<Integer> getAllHacNumbersWhereCriteriaIsMet(List<MsdrgDiagnosisCode> dxCodes) {
        HashSet<Integer> hacNumbers = new HashSet<Integer>();
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            if (dxCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : dxCode.getHacs()) {
                if (hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                hacNumbers.add(hac.getHacNumber());
            }
        }
        return hacNumbers;
    }

    private boolean oneProcForAllAttributes(GroupingContext matchedAttr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusterCodes, int mdc) {
        List<Attribute> procAttributes = this.getOnlyProcedureAttributes(matchedAttr.getMatch());
        if (!procAttributes.isEmpty()) {
            for (MsdrgProcedureCode procCode : procCodes) {
                if (!procCode.is(MsdrgCode.CodeFlag.FIRST_POSITION) || procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                this.setMarked(procCode);
                this.setDrgImpact(procCode);
                return true;
            }
            for (MsdrgProcedureCode procCode : procCodes) {
                if (procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                this.setMarked(procCode);
                this.setDrgImpact(procCode);
                return true;
            }
            for (MsdrgProcedureCode cluster : clusterCodes) {
                if (!cluster.getAttributes().containsAll(procAttributes)) continue;
                TreeSet<String> procValues = new TreeSet<String>();
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.getClusterIds().contains(cluster.getValue()) || procValues.contains(procCode.getValue())) continue;
                    procValues.add(procCode.getValue());
                    this.setMarked(procCode);
                    this.setDrgImpact(procCode);
                }
                return true;
            }
        }
        return false;
    }

    private boolean completeSystemTieBreaker(Attribute attr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusters, int mdc, MsdrgProcedureCode principalProc) {
        ArrayList<MsdrgProcedureCode> procCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        ArrayList<MsdrgProcedureCode> clusterCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            procCodesWithAttribute.add(procCode);
        }
        for (MsdrgProcedureCode cluster : clusters) {
            if (!cluster.hasAttribute(attr)) continue;
            clusterCodesWithAttribute.add(cluster);
        }
        if (!procCodesWithAttribute.isEmpty() && !clusterCodesWithAttribute.isEmpty()) {
            if (principalProc.hasAttribute(attr)) {
                this.setMarked(principalProc);
                this.setDrgImpact(principalProc);
                return true;
            }
            Iterator<MsdrgProcedureCode> iterator = procCodesWithAttribute.iterator();
            if (iterator.hasNext()) {
                MsdrgProcedureCode procCode;
                procCode = iterator.next();
                this.setMarked(procCode);
                this.setDrgImpact(procCode);
                return true;
            }
        }
        return false;
    }

    private boolean multipleProcsHaveSameAttribute(Attribute attr, List<MsdrgProcedureCode> procCodes, int mdc) {
        int counter = 0;
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            ++counter;
        }
        return counter >= 2;
    }

    private List<Attribute> getOnlyProcedureAttributes(MsdrgMatchedDrgFormula matchedAttr) {
        ArrayList<Attribute> procAttributes = new ArrayList<Attribute>();
        for (Attribute attr : matchedAttr.getMatchedAttributes()) {
            if (attr.getPrefix() != MsdrgAttributePrefix.NONE || attr.getListName().equals(MsdrgSeverity.MCC.name()) || attr.getListName().equals(MsdrgSeverity.CC.name()) || attr.getListName().equals(MsdrgSeverity.NON_CC.name())) continue;
            procAttributes.add(attr);
        }
        return procAttributes;
    }
}

