/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.MsdrgUtility;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;

public class MsdrgLifeStatus
implements Link {
    private static final String MCC_ALIVE = "MCCALIVE";
    private final DescriptionDao descriptionAccess;

    public MsdrgLifeStatus(DescriptionDao descriptionAccess) {
        this.descriptionAccess = descriptionAccess;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        ProcessingData processingData = context.getProcessingData();
        for (MsdrgDiagnosisCode dxCode : processingData.getSdxCodes()) {
            if (dxCode.hasAttribute(MCC_ALIVE) && processingData.getDischargeStatus() == MsdrgDischargeStatus.NONE) {
                MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.descriptionAccess);
                ProcessingData data = processingData.toBuilder().withInitialResult(grouperResult).withFinalResult(grouperResult).build();
                context = context.toBuilder().withProcessingData(data).build();
                return new Link.LinkResult(context, false);
            }
            if (!dxCode.hasAttribute(MCC_ALIVE) || processingData.getDischargeStatus() != MsdrgDischargeStatus.DIED) continue;
            dxCode.mark(MsdrgCode.CodeFlag.DEATH_EXCLUSION);
        }
        return new Link.LinkResult(context, true);
    }
}

