/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.DiagnosisDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.DiagnosisAttributeProcessor;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdxAttributeProcessor
extends DiagnosisAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(PdxAttributeProcessor.class);
    private static final String HAC_11_PDX = "hac11_pdx";
    private static final int HAC_11 = 11;
    private final DescriptionDao descriptionAccess;

    public PdxAttributeProcessor(DiagnosisDao diagnosisAccess, DescriptionDao descriptionAccess) {
        super(diagnosisAccess);
        this.descriptionAccess = descriptionAccess;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        ProcessingData processingData = context.getProcessingData();
        logger.debug("Begin processing of attributes");
        MsdrgDiagnosisCode pdx = this.getPdx(processingData.getPrincipalDx(), processingData);
        context.getTraceUtility().tracePdxCode(pdx);
        MsdrgDiagnosisCode admitDx = processingData.getAdmitDx();
        if (this.diagnosisAccess.isCodeValid(admitDx.getValue())) {
            admitDx.mark(MsdrgCode.CodeFlag.VALID);
        }
        context = context.toBuilder().withProcessingData(processingData.toBuilder().withAdmitDx(admitDx).withPdx(pdx).build()).build();
        logger.debug("Attributes processed");
        return new Link.LinkResult(context, true);
    }

    private MsdrgDiagnosisCode getPdx(MsdrgDiagnosisCode pdx, ProcessingData processingData) {
        if (pdx.getValue().isEmpty()) {
            return pdx;
        }
        Set<Attribute> attributes = this.getPdxAttributes(pdx);
        pdx.setAttributes(attributes);
        Set<Attribute> dxCatAttributes = this.getPdxDxCatAttributes(pdx);
        pdx.setDxCatAttributes(dxCatAttributes);
        Set<Attribute> dxHacAttributes = this.getPdxHacAttributes(pdx);
        pdx.setHacAttributes(dxHacAttributes);
        for (Attribute attr : dxHacAttributes) {
            if (!attr.getListName().endsWith(HAC_11_PDX)) continue;
            MsdrgHac hac = new MsdrgHac();
            hac.setHacStatus(MsdrgHacUsage.NOT_ON_HAC_LIST);
            hac.setHacList(HAC_11_PDX);
            hac.setHacNumber(11);
            this.descriptionAccess.getHacDescription(11).ifPresent(hac::setDescription);
            pdx.setHacs(Collections.singletonList(hac));
        }
        if (this.diagnosisAccess.isCodeValid(pdx.getValue())) {
            pdx.mark(MsdrgCode.CodeFlag.VALID);
        }
        try {
            if (this.diagnosisAccess.isCodeOnGenderList(pdx.getValue())) {
                Optional<Integer> mdc = this.diagnosisAccess.getMdcOfGenderCode(pdx.getValue(), processingData.getSex().getIntValue());
                if (!mdc.isPresent()) {
                    pdx.mark(MsdrgCode.CodeFlag.SEX_CONFLICT);
                    Optional<Integer> mdcOfGenderCode = this.diagnosisAccess.getMdcOfGenderCode(pdx.getValue(), MsdrgSex.FEMALE.getIntValue());
                    mdcOfGenderCode.orElseThrow(() -> new DataFormatException("Code designated as on gender list but no MDC exists for either gender"));
                    mdcOfGenderCode.ifPresent(pdx::setMdc);
                } else {
                    pdx.setMdc(mdc.get());
                }
            } else {
                pdx.setMdc(this.getDiagnosisMdc(pdx));
            }
            pdx.setSeverity(this.getDiagnosisSeverity(pdx));
        }
        catch (IOException | SQLException | DataFormatException exception) {
            exception.printStackTrace();
        }
        return pdx;
    }
}

