/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.model;

import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import java.util.BitSet;
import java.util.Objects;

public class Attribute
implements Comparable<Attribute> {
    private final MsdrgAttributePrefix prefix;
    private final boolean negated;
    private final String listName;
    private BitSet mdcSuppression = new BitSet(32);

    public Attribute(MsdrgAttributePrefix prefix, boolean negated, String listName) {
        this.prefix = prefix;
        this.negated = negated;
        this.listName = listName;
    }

    public Attribute(MsdrgAttributePrefix prefix, String attribute) {
        this.prefix = prefix;
        this.negated = false;
        this.listName = attribute;
    }

    public Attribute(String attribute) {
        this.prefix = MsdrgAttributePrefix.NONE;
        this.negated = false;
        this.listName = attribute;
    }

    public final String getListName() {
        return this.listName;
    }

    public final boolean getNegated() {
        return this.negated;
    }

    public final MsdrgAttributePrefix getPrefix() {
        return this.prefix;
    }

    public final BitSet getMdcSuppression() {
        return this.mdcSuppression;
    }

    public void setMdcSuppression(BitSet mdcSuppression) {
        this.mdcSuppression.xor(mdcSuppression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listName, this.prefix});
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute attrObj = (Attribute)obj;
        if (this.prefix == MsdrgAttributePrefix.ANY) {
            if (attrObj.prefix != MsdrgAttributePrefix.ANY && attrObj.prefix != MsdrgAttributePrefix.SDX && attrObj.prefix != MsdrgAttributePrefix.PDX) {
                return false;
            }
            return Objects.equals(this.listName, attrObj.listName) && Objects.equals(this.negated, attrObj.negated);
        }
        if (attrObj.prefix == MsdrgAttributePrefix.ANY) {
            if (this.prefix != MsdrgAttributePrefix.SDX && this.prefix != MsdrgAttributePrefix.PDX) {
                return false;
            }
            return Objects.equals(this.listName, attrObj.listName) && Objects.equals(this.negated, attrObj.negated);
        }
        return Objects.equals(this.listName, attrObj.listName) && Objects.equals(this.negated, attrObj.negated) && Objects.equals((Object)this.prefix, (Object)attrObj.prefix);
    }

    public String toString() {
        return "Attribute{prefix=" + (Object)((Object)this.prefix) + ", negated=" + this.negated + ", listName='" + this.listName + '\'' + '}';
    }

    @Override
    public int compareTo(Attribute attr) {
        return this.listName.compareTo(attr.getListName());
    }
}

