/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.model;

import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgPoaErrorCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode;
import gov.agency.msdrg.v400.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class MsdrgDiagnosisCode
implements MsdrgCode {
    private final MsdrgInputDxCode inputDxCode;
    private final EnumSet<MsdrgCode.CodeFlag> internalFlags = EnumSet.noneOf(MsdrgCode.CodeFlag.class);
    private Set<Attribute> attributes = new HashSet<Attribute>();
    private Set<Attribute> dxCatAttributes = new HashSet<Attribute>();
    private Set<Attribute> hacAttributes = new HashSet<Attribute>();
    private MsdrgSeverity severity;
    private List<MsdrgHac> hacs = new ArrayList<MsdrgHac>();
    private List<MsdrgHac> hacsFlags = new ArrayList<MsdrgHac>();
    private Integer mdc;
    private MsdrgGroupingImpact drgImpact = MsdrgGroupingImpact.NONE;
    private MsdrgCodeSeverityFlag initialSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
    private MsdrgCodeSeverityFlag finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
    private Integer clinicalSignificanceRank;
    private MsdrgPoaErrorCode poaErrorCodeFlag = MsdrgPoaErrorCode.POA_NOT_CHECKED;
    private Attribute attributeMarkedFor;

    public MsdrgDiagnosisCode(MsdrgInputDxCode inputDxCode) {
        Objects.requireNonNull(inputDxCode, "Input dx code cannot be null");
        this.inputDxCode = inputDxCode;
    }

    public MsdrgInputDxCode getInputDxCode() {
        return this.inputDxCode;
    }

    public Attribute getAttributeMarkedFor() {
        return this.attributeMarkedFor;
    }

    public void setAttributeMarkedFor(Attribute attributeMarkedFor) {
        this.attributeMarkedFor = attributeMarkedFor;
    }

    @Override
    public boolean is(MsdrgCode.CodeFlag dxProcessingFlag) {
        return this.internalFlags.contains((Object)dxProcessingFlag);
    }

    @Override
    public void mark(MsdrgCode.CodeFlag dxProcessingFlag) {
        this.internalFlags.add(dxProcessingFlag);
    }

    @Override
    public void mark(MsdrgCode.CodeFlag ... dxProcessingFlag) {
        this.internalFlags.addAll(Arrays.asList(dxProcessingFlag));
    }

    @Override
    public void unMark(MsdrgCode.CodeFlag dxProcessingFlag) {
        this.internalFlags.remove((Object)dxProcessingFlag);
    }

    public List<MsdrgHac> getHacsFlags() {
        return this.hacsFlags;
    }

    public void setHacsFlags(List<MsdrgHac> hacsFlags) {
        this.hacsFlags = hacsFlags;
    }

    public int getMdc() {
        return this.mdc;
    }

    public void setMdc(Integer mdc) {
        this.mdc = mdc;
    }

    public List<MsdrgHac> getHacs() {
        return this.hacs;
    }

    public void setHacs(List<MsdrgHac> hacs) {
        this.hacs = hacs;
    }

    public MsdrgSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(MsdrgSeverity severity) {
        this.severity = severity;
    }

    public GfcPoa getPoa() {
        return this.inputDxCode.getPoa();
    }

    public boolean hasHacs() {
        for (MsdrgHac hac : this.getHacsFlags()) {
            if (hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
            return true;
        }
        return false;
    }

    @Override
    public MsdrgGroupingImpact getDrgImpact() {
        return this.drgImpact;
    }

    @Override
    public void setDrgImpact(MsdrgGroupingImpact drgImpact) {
        this.drgImpact = drgImpact;
    }

    public MsdrgCodeSeverityFlag getInitialSeverityFlag() {
        return this.initialSeverityFlag;
    }

    public void markSeverityFlag(MsdrgMaskBuildingConditions conditions) {
        if (conditions != MsdrgMaskBuildingConditions.INITIAL && conditions != MsdrgMaskBuildingConditions.FINAL) {
            return;
        }
        Consumer<MsdrgCodeSeverityFlag> setMethod = conditions == MsdrgMaskBuildingConditions.INITIAL ? flag -> {
            this.initialSeverityFlag = flag;
        } : flag -> {
            this.finalSeverityFlag = flag;
        };
        boolean deathExcluded = this.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION);
        boolean excluded = this.is(MsdrgCode.CodeFlag.EXCLUDED);
        if (deathExcluded && !excluded) {
            setMethod.accept(MsdrgCodeSeverityFlag.NEITHER);
        } else if ((deathExcluded || excluded) && this.getSeverity() == MsdrgSeverity.MCC) {
            setMethod.accept(MsdrgCodeSeverityFlag.MCC_EXCLUDED);
        } else if ((deathExcluded || excluded) && this.getSeverity() == MsdrgSeverity.CC) {
            setMethod.accept(MsdrgCodeSeverityFlag.CC_EXCLUDED);
        } else if (!excluded && this.getSeverity() == MsdrgSeverity.MCC) {
            setMethod.accept(MsdrgCodeSeverityFlag.MCC);
        } else if (!excluded && this.getSeverity() == MsdrgSeverity.CC) {
            setMethod.accept(MsdrgCodeSeverityFlag.CC);
        } else {
            setMethod.accept(MsdrgCodeSeverityFlag.NEITHER);
        }
        if (conditions == MsdrgMaskBuildingConditions.FINAL && this.hasHacs()) {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
        }
    }

    public void processSeverityFlag(MsdrgDischargeStatus dischargeStatus) {
        if (this.internalFlags.contains((Object)MsdrgCode.CodeFlag.EXCLUDED)) {
            if (this.getSeverity() == MsdrgSeverity.MCC) {
                this.finalSeverityFlag = MsdrgCodeSeverityFlag.MCC_EXCLUDED;
            } else if (this.getSeverity() == MsdrgSeverity.CC) {
                this.finalSeverityFlag = MsdrgCodeSeverityFlag.CC_EXCLUDED;
            }
        } else if (this.hasHacs()) {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
        } else if (this.hasAttribute("mccalive") && dischargeStatus == MsdrgDischargeStatus.DIED) {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
        } else if (this.getSeverity() == MsdrgSeverity.MCC) {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.MCC;
        } else if (this.getSeverity() == MsdrgSeverity.CC) {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.CC;
        }
    }

    public void setSeverityFlag(MsdrgMaskBuildingConditions condition) {
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            this.initialSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
        } else {
            this.finalSeverityFlag = MsdrgCodeSeverityFlag.NEITHER;
        }
    }

    public MsdrgCodeSeverityFlag getFinalSeverityFlag() {
        return this.finalSeverityFlag;
    }

    public Integer getClinicalSignificanceRank() {
        return this.clinicalSignificanceRank;
    }

    public void setClinicalSignificanceRank(Integer clinicalSignificanceRank) {
        this.clinicalSignificanceRank = clinicalSignificanceRank;
    }

    public Set<Attribute> getDxCatAttributes() {
        return this.dxCatAttributes;
    }

    public void setDxCatAttributes(Set<Attribute> dxCatAttributes) {
        this.dxCatAttributes = dxCatAttributes;
    }

    public Set<Attribute> getHacAttributes() {
        return this.hacAttributes;
    }

    public void setHacAttributes(Set<Attribute> hacAttributes) {
        this.hacAttributes = hacAttributes;
    }

    public boolean hasAttribute(String attributeName) {
        block3: {
            block2: {
                if (this.attributes == null) break block2;
                for (Attribute attribute : this.attributes) {
                    if (!attribute.getListName().equalsIgnoreCase(attributeName)) continue;
                    return true;
                }
                break block3;
            }
            if (this.dxCatAttributes == null) break block3;
            for (Attribute attribute : this.dxCatAttributes) {
                if (!attribute.getListName().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public MsdrgPoaErrorCode getPoaErrorCodeFlag() {
        return this.poaErrorCodeFlag;
    }

    public void setPoaErrorCodeFlag(MsdrgPoaErrorCode poaErrorCodeFlag) {
        this.poaErrorCodeFlag = poaErrorCodeFlag;
    }

    @Override
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getValue() {
        return this.inputDxCode.getValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.severity, this.hacs, this.mdc, this.drgImpact, this.initialSeverityFlag, this.finalSeverityFlag, this.clinicalSignificanceRank, this.hacAttributes, this.dxCatAttributes, this.poaErrorCodeFlag, this.internalFlags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgDiagnosisCode)) {
            return false;
        }
        MsdrgDiagnosisCode that = (MsdrgDiagnosisCode)obj;
        return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.dxCatAttributes, that.dxCatAttributes) && Objects.equals(this.hacAttributes, that.hacAttributes) && this.severity == that.severity && Objects.equals(this.hacs, that.hacs) && Objects.equals(this.hacsFlags, that.hacsFlags) && Objects.equals(this.mdc, that.mdc) && this.drgImpact == that.drgImpact && this.initialSeverityFlag == that.initialSeverityFlag && this.finalSeverityFlag == that.finalSeverityFlag && Objects.equals(this.clinicalSignificanceRank, that.clinicalSignificanceRank) && this.poaErrorCodeFlag == that.poaErrorCodeFlag && Objects.equals(this.attributeMarkedFor, that.attributeMarkedFor) && Objects.equals(this.internalFlags, that.internalFlags);
    }
}

