/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.model;

import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode;
import gov.agency.msdrg.v400.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MsdrgProcedureCode
implements MsdrgCode {
    private final MsdrgInputPrCode inputPrCode;
    private final EnumSet<MsdrgCode.CodeFlag> internalFlags = EnumSet.noneOf(MsdrgCode.CodeFlag.class);
    private Set<Attribute> attributes;
    private final BitSet mdcSuppression;
    private Set<String> clusterIds;
    private boolean isValidCode;
    private MsdrgGroupingImpact drgImpact = MsdrgGroupingImpact.NONE;
    private boolean isOperatingRoomProcedure = true;
    private Set<MsdrgProcedureHacUsage> hacUsageFlag = new HashSet<MsdrgProcedureHacUsage>();

    public MsdrgProcedureCode(MsdrgInputPrCode inputPrCode) {
        this.inputPrCode = inputPrCode;
        this.mdcSuppression = new BitSet(32);
        this.clusterIds = new HashSet<String>();
    }

    @Override
    public boolean is(MsdrgCode.CodeFlag dxProcessingFlag) {
        return this.internalFlags.contains((Object)dxProcessingFlag);
    }

    @Override
    public void mark(MsdrgCode.CodeFlag dxProcessingFlag) {
        this.internalFlags.add(dxProcessingFlag);
    }

    @Override
    public void mark(MsdrgCode.CodeFlag ... dxProcessingFlag) {
        this.internalFlags.addAll(Arrays.asList(dxProcessingFlag));
    }

    @Override
    public void unMark(MsdrgCode.CodeFlag dxProcessingFlag) {
        this.internalFlags.remove((Object)dxProcessingFlag);
    }

    @Override
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
        this.applyOperatingRoom();
    }

    public MsdrgInputPrCode getInputPrCode() {
        return this.inputPrCode;
    }

    @Override
    public String getValue() {
        return this.inputPrCode.getValue();
    }

    private void applyOperatingRoom() {
        this.attributes.stream().filter(item -> item.getListName().equalsIgnoreCase(MsdrgSourceLogicLists.NONOR.getValue())).findAny().ifPresent(attribute -> this.setOperatingRoomProcedure(false));
    }

    public Set<String> getClusterIds() {
        return this.clusterIds;
    }

    public void setClusterIds(Set<String> clusterIds) {
        this.clusterIds = clusterIds;
    }

    public BitSet getMdcSuppression() {
        return this.mdcSuppression;
    }

    public void setMdcSuppression(Set<Integer> mdcSupression) {
        for (Integer integer : mdcSupression) {
            this.mdcSuppression.set(integer);
        }
    }

    public boolean isValidCode() {
        return this.isValidCode;
    }

    public void setValidCode(boolean validCode) {
        this.isValidCode = validCode;
    }

    @Override
    public MsdrgGroupingImpact getDrgImpact() {
        return this.drgImpact;
    }

    @Override
    public void setDrgImpact(MsdrgGroupingImpact drgImpact) {
        this.drgImpact = drgImpact;
    }

    public boolean isOperatingRoomProcedure() {
        return this.isOperatingRoomProcedure;
    }

    public void setOperatingRoomProcedure(boolean operatingRoomProcedure) {
        this.isOperatingRoomProcedure = operatingRoomProcedure;
    }

    public Set<MsdrgProcedureHacUsage> getHacUsageFlag() {
        return this.hacUsageFlag;
    }

    public void setHacUsageFlag(Set<MsdrgProcedureHacUsage> hacUsageFlag) {
        this.hacUsageFlag = hacUsageFlag;
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributes.contains(attribute);
    }

    public boolean hasAttributes(Attribute ... attributes) {
        return this.attributes.containsAll(Arrays.asList(attributes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MsdrgProcedureCode)) {
            return false;
        }
        MsdrgProcedureCode that = (MsdrgProcedureCode)o;
        return this.isValidCode == that.isValidCode && this.isOperatingRoomProcedure == that.isOperatingRoomProcedure && Objects.equals(this.inputPrCode, that.inputPrCode) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.mdcSuppression, that.mdcSuppression) && Objects.equals(this.clusterIds, that.clusterIds) && this.drgImpact == that.drgImpact && Objects.equals(this.hacUsageFlag, that.hacUsageFlag) && Objects.equals(this.internalFlags, that.internalFlags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputPrCode, this.attributes, this.mdcSuppression, this.clusterIds, this.isValidCode, this.drgImpact, this.isOperatingRoomProcedure, this.hacUsageFlag, this.internalFlags});
    }
}

