/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.utility.farser.lexer;

import gov.agency.msdrg.v400.utility.farser.lexer.CommonTokenType;
import gov.agency.msdrg.v400.utility.farser.lexer.FarserException;
import gov.agency.msdrg.v400.utility.farser.lexer.LexerToken;
import gov.agency.msdrg.v400.utility.farser.lexer.LexerTokenFactory;
import gov.agency.msdrg.v400.utility.farser.lexer.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Lexer {
    private Lexer() {
    }

    public static <L extends LexerToken<T>, T extends TokenType<?>> List<L> lex(Class<T> tokenTypeEnumClass, String input, LexerTokenFactory<L, T> factory) {
        L atomToken;
        String atom;
        ArrayList<L> result = new ArrayList<L>();
        Pattern delimiterPattern = TokenType.createTokenPattern(tokenTypeEnumClass);
        Matcher delimiterMatcher = delimiterPattern.matcher(input);
        T atomTokenType = TokenType.getForCommonTypeMandatory(tokenTypeEnumClass, CommonTokenType.ATOM);
        T spaceTokenType = TokenType.getForCommonTypeMandatory(tokenTypeEnumClass, CommonTokenType.SPACE);
        Optional<T> spaceTokenTypeTmp = Optional.of(spaceTokenType);
        int pos = 0;
        while (delimiterMatcher.find()) {
            String delimiter;
            Optional<T> delimiterTokenType;
            if (pos != delimiterMatcher.start() && !(atom = input.substring(pos, delimiterMatcher.start()).trim()).isEmpty() && (atomToken = factory.create((TokenType)atomTokenType, atom)) != null) {
                result.add(atomToken);
            }
            if ((delimiterTokenType = (delimiter = delimiterMatcher.group()).trim().isEmpty() ? spaceTokenTypeTmp : TokenType.getForValue(tokenTypeEnumClass, delimiter)).isPresent()) {
                L atomToken2 = factory.create((TokenType)delimiterTokenType.get(), delimiter);
                if (atomToken2 != null) {
                    result.add(atomToken2);
                }
            } else {
                throw new FarserException("No match found for delimiter '" + delimiter + "'. No such token type seems to exist in " + tokenTypeEnumClass.getSimpleName());
            }
            pos = delimiterMatcher.end();
        }
        if (pos != input.length() && !(atom = input.substring(pos).trim()).isEmpty() && (atomToken = factory.create((TokenType)atomTokenType, atom)) != null) {
            result.add(atomToken);
        }
        return result;
    }

    public static <L extends LexerToken<T>, T extends TokenType<?>> List<String> getTokens(List<L> tokens, T forTokenType) {
        return tokens.stream().filter(token -> token.getType() == forTokenType).map(LexerToken::getValue).collect(Collectors.toList());
    }
}

