/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.utility.farser.lexer.drg;

import gov.agency.msdrg.v400.utility.farser.lexer.LexerTokenFactory;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgFormulaToken;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.security.InvalidParameterException;

public class DrgFormulaTokenFactory
implements LexerTokenFactory<DrgLexerToken, DrgFormulaToken> {
    @Override
    public DrgLexerToken create(DrgFormulaToken tokenType, String value) {
        if (tokenType == DrgFormulaToken.SPACE) {
            return null;
        }
        if (tokenType == DrgFormulaToken.ATOM) {
            return DrgFormulaTokenFactory.buildTokenFromAtom(value);
        }
        return new DrgLexerToken(tokenType, value);
    }

    private static DrgLexerToken buildTokenFromAtom(String atom) {
        String[] split = DrgLexerToken.PREFIX_SEPARATOR_PATTERN.split(atom);
        if (split.length == 2) {
            return new DrgLexerToken(DrgFormulaToken.ATOM, split[1].trim(), split[0].trim());
        }
        if (split.length == 1) {
            return new DrgLexerToken(DrgFormulaToken.ATOM, split[0].trim());
        }
        throw new InvalidParameterException("Invalid " + DrgFormulaToken.ATOM.name() + " '" + atom + "'. Only 'prefix" + ":" + "value' or 'value' are allowed.");
    }
}

