/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.mainframe;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.mainframe.utility.v310.MainframeWrapperException;
import gov.agency.mainframe.utility.v310.format.FixedWidthField;
import gov.agency.mainframe.utility.v310.format.FormatUtilities;
import gov.agency.mainframe.utility.v310.impl.WrappedComponent;
import gov.agency.mainframe.utility.v310.util.MainframeProperties;
import gov.agency.mainframe.utility.v310.util.StringUtilities;
import gov.agency.mainframe.utility.v310.util.ValueAlignment;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.MsdrgRuntimeOption;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.transfer.MsdrgInput;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import gov.agency.msdrg.model.transfer.MsdrgInputPrCode;
import gov.agency.msdrg.model.transfer.MsdrgOutputDxCode;
import gov.agency.msdrg.model.transfer.MsdrgOutputPrCode;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.MsdrgOption;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.model.v2.transfer.MsdrgClaim;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInput;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputData;
import gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputData;
import gov.agency.msdrg.v391.MsdrgComponent;
import gov.cms.grouper.mainframe.FieldName;
import gov.cms.grouper.mainframe.date.DateBeforeValidVersionException;
import gov.cms.grouper.mainframe.date.MalformedDateException;
import gov.cms.grouper.mainframe.date.VersionDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MsdrgMainframeWrapper
implements WrappedComponent {
    private static final int DATE_BEFORE_VERSIONS_ERROR = 98;
    private static final int MALFORMED_DATE_ERROR = 99;
    private static final int FALL_BACK_EXCEPTION_ERROR = 88;
    private static final char HOSPITAL_EXEMPT = 'X';
    private static final int MISSING_VALUE = -1;
    private static final int NUM_DIAGS = 25;
    private static final int DIAG_WIDTH = 7;
    private static final int NUM_PROCS = 25;
    private static final int PROC_WIDTH = 7;
    private static final int DIAG_FLAG_WIDTH = 25;
    private static final int PROC_FLAG_WIDTH = 20;
    private static final String FILLER = "0000000";
    private static final List<FixedWidthField<?>> inputFields = Arrays.asList(new FixedWidthField(FieldName.AGE.name(), 1, 3), new FixedWidthField(FieldName.SEX.name(), 4, 4), new FixedWidthField(FieldName.DISCHARGE_STATUS.name(), 5, 6), new FixedWidthField(FieldName.HOSPITAL_STATUS.name(), 7, 7), new FixedWidthField(FieldName.DISCHARGE_DATE.name(), 16, 23), new FixedWidthField(FieldName.DIAGNOSES.name(), 24, 223), new FixedWidthField(FieldName.PROCEDURES.name(), 224, 398), new FixedWidthField(FieldName.DEBUG_FLAG.name(), 638, 638));
    private static final List<FixedWidthField<?>> outputFields = Arrays.asList(FixedWidthField.builder(Integer.class).withName(FieldName.FI_GRC.name()).withCharacterPosition(1, 2).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.FI_MDC.name()).withCharacterPosition(3, 4).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.FI_DRG.name()).withCharacterPosition(5, 8).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder().withName(FieldName.GROUPER_FLAGS.name()).withAlignment(ValueAlignment.LEFT).withCharacterPosition(9, 13).withFill(Character.valueOf('0')).build(), FixedWidthField.builder().withName(FieldName.DIAGNOSIS_FLAGS.name()).withAlignment(ValueAlignment.LEFT).withCharacterPosition(14, 638).withFill(Character.valueOf(' ')).build(), FixedWidthField.builder().withName(FieldName.PROCEDURE_FLAGS.name()).withAlignment(ValueAlignment.LEFT).withCharacterPosition(639, 1138).withFill(Character.valueOf(' ')).build(), FixedWidthField.builder(Integer.class).withName(FieldName.FI_BASE_DRG.name()).withCharacterPosition(1139, 1142).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.FI_SEVERITY.name()).withCharacterPosition(1143, 1143).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.FI_MED_SURG.name()).withCharacterPosition(1144, 1144).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.IN_DRG.name()).withCharacterPosition(1145, 1148).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.IN_BASE_DRG.name()).withCharacterPosition(1149, 1152).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.IN_SEVERITY.name()).withCharacterPosition(1153, 1153).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder(Integer.class).withName(FieldName.IN_MED_SURG.name()).withCharacterPosition(1154, 1154).withFill(Character.valueOf('0')).withToOutputStringConversion(StringUtilities::toStringWithNullCheck).build(), FixedWidthField.builder().withName(FieldName.GROUPER_VERSION.name()).withAlignment(ValueAlignment.LEFT).withCharacterPosition(1155, 1162).withFill(Character.valueOf('0')).build());
    private final Map<VersionDate, Processable<gov.agency.msdrg.model.transfer.MsdrgClaim, gov.agency.msdrg.model.MsdrgOption, MsdrgRuntimeOption>> componentCache = new HashMap<VersionDate, Processable<gov.agency.msdrg.model.transfer.MsdrgClaim, gov.agency.msdrg.model.MsdrgOption, MsdrgRuntimeOption>>();
    private final MsdrgRuntimeOption options = new MsdrgRuntimeOption();
    private final gov.agency.msdrg.model.RuntimeOptions runtime = new gov.agency.msdrg.model.RuntimeOptions();
    private final Map<VersionDate, Processable<MsdrgClaim, MsdrgOption, gov.agency.msdrg.model.v2.MsdrgRuntimeOption>> componentCacheV2 = new HashMap<VersionDate, Processable<MsdrgClaim, MsdrgOption, gov.agency.msdrg.model.v2.MsdrgRuntimeOption>>();
    private final gov.agency.msdrg.model.v2.MsdrgRuntimeOption optionsV2 = new gov.agency.msdrg.model.v2.MsdrgRuntimeOption();
    private final RuntimeOptions runtimeV2 = new RuntimeOptions();
    private boolean debugEnabled;

    @Override
    public String process(String inputString) throws MainframeWrapperException {
        Map<String, Object> parsed = FormatUtilities.parseFixedWidthString(inputFields, inputString);
        VersionDate versionDate = VersionDate.getVersionFromDate((String)parsed.get(FieldName.DISCHARGE_DATE.name()));
        if (versionDate.getVersion() < 400) {
            return this.processWithModelV1(parsed, versionDate);
        }
        return this.processWithModelV2(parsed, versionDate);
    }

    public String processWithModelV1(Map<String, Object> parsed, VersionDate versionDate) throws MainframeWrapperException {
        Processable processable;
        gov.agency.msdrg.model.transfer.MsdrgClaim claim = this.populateClaimWithModelV1(parsed);
        this.runtime.setMarkingLogicTieBreaker(MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE);
        this.runtime.setComputeAffectDrg(gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag.COMPUTE);
        this.options.put(gov.agency.msdrg.model.MsdrgOption.RUNTIME_OPTION_FLAGS, (Object)this.runtime);
        switch (versionDate) {
            case VERSION_390: {
                processable = this.componentCache.computeIfAbsent(versionDate, key -> new gov.agency.msdrg.v390.MsdrgComponent(this.options));
                break;
            }
            case VERSION_391: {
                processable = this.componentCache.computeIfAbsent(versionDate, key -> new MsdrgComponent(this.options));
                break;
            }
            default: {
                throw new MainframeWrapperException("Could not create component for version " + versionDate.getVersion());
            }
        }
        try {
            processable.reconfigure(this.options);
            processable.process(claim);
        }
        catch (FoundationException exc) {
            throw new MainframeWrapperException(exc.getMessage(), exc);
        }
        parsed.put("parsed_version_date", (Object)versionDate);
        Map<String, Object> extracted = this.extractFromClaimWithModelV1(parsed, claim);
        return FormatUtilities.formatFixedWidthString(outputFields, extracted);
    }

    public String processWithModelV2(Map<String, Object> parsed, VersionDate versionDate) throws MainframeWrapperException {
        Processable processable;
        MsdrgClaim claim = this.populateClaimWithModelV2(parsed);
        this.runtimeV2.setMarkingLogicTieBreaker(gov.agency.msdrg.model.v2.enumeration.MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE);
        this.runtimeV2.setComputeAffectDrg(MsdrgAffectDrgOptionFlag.COMPUTE);
        this.optionsV2.put(MsdrgOption.RUNTIME_OPTION_FLAGS, (Object)this.runtimeV2);
        switch (versionDate) {
            case VERSION_400: {
                processable = this.componentCacheV2.computeIfAbsent(versionDate, key -> new gov.agency.msdrg.v400.MsdrgComponent(this.optionsV2));
                break;
            }
            default: {
                throw new MainframeWrapperException("Could not create component for version " + versionDate.getVersion());
            }
        }
        try {
            processable.reconfigure(this.optionsV2);
            processable.process(claim);
        }
        catch (FoundationException exc) {
            throw new MainframeWrapperException(exc.getMessage(), exc);
        }
        parsed.put("parsed_version_date", (Object)versionDate);
        Map<String, Object> extracted = this.extractFromClaimWithModelV2(parsed, claim);
        return FormatUtilities.formatFixedWidthString(outputFields, extracted);
    }

    public gov.agency.msdrg.model.transfer.MsdrgClaim populateClaimWithModelV1(Map<String, Object> inputFields) {
        int sex;
        String tmp = (String)inputFields.get("DEBUG_FLAG");
        this.debugEnabled = tmp != null && tmp.equalsIgnoreCase("Y");
        MsdrgInput.MsdrgInputBuilder claimInput = gov.agency.msdrg.model.transfer.MsdrgInput.builder();
        String ageString = (String)inputFields.get("AGE");
        try {
            int age = Integer.parseInt(ageString);
            claimInput.withAgeInYears(age);
        }
        catch (NumberFormatException age) {
            // empty catch block
        }
        String sexString = (String)inputFields.get("SEX");
        try {
            sex = Integer.parseInt(sexString);
        }
        catch (NumberFormatException ignored) {
            sex = -1;
        }
        switch (sex) {
            case 1: {
                claimInput.withSex(gov.agency.msdrg.model.enumeration.MsdrgSex.MALE);
                break;
            }
            case 2: {
                claimInput.withSex(gov.agency.msdrg.model.enumeration.MsdrgSex.FEMALE);
                break;
            }
            default: {
                claimInput.withSex(gov.agency.msdrg.model.enumeration.MsdrgSex.UNKNOWN);
            }
        }
        String dischargeStatusString = (String)inputFields.get("DISCHARGE_STATUS");
        try {
            int dischargeStatusInt = Integer.parseInt(dischargeStatusString);
            MsdrgDischargeStatus dischargeStatus = MsdrgDischargeStatus.getEnumFromInt(dischargeStatusInt);
            claimInput.withDischargeStatus(dischargeStatus);
        }
        catch (NumberFormatException dischargeStatusInt) {
            // empty catch block
        }
        String diagnosesString = (String)inputFields.get("DIAGNOSES");
        ArrayList<MsdrgInputDxCode> sdxCodes = new ArrayList<MsdrgInputDxCode>();
        int index = 0;
        for (int ii = 1; ii < 26; ++ii) {
            String code = diagnosesString.substring(index, index + 7);
            if (code.trim().length() == 0) continue;
            String poaDaa = diagnosesString.substring(index + 7, index + 7 + 1);
            String dxCode = code.trim();
            Object tmpPoa = GfcPoa.BLANK;
            if (!poaDaa.trim().isEmpty()) {
                try {
                    tmpPoa = GfcPoa.valueOf(poaDaa);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    tmpPoa = GfcPoa.BLANK;
                }
            }
            if (ii == 1) {
                claimInput.withPrincipalDiagnosisCode(new MsdrgInputDxCode(dxCode, (GfcPoa)tmpPoa));
            } else {
                sdxCodes.add(new MsdrgInputDxCode(dxCode, (GfcPoa)tmpPoa));
            }
            index += 8;
        }
        claimInput.withSecondaryDiagnosisCodes(sdxCodes);
        String proceduresString = (String)inputFields.get("PROCEDURES");
        ArrayList<MsdrgInputPrCode> procCodes = new ArrayList<MsdrgInputPrCode>();
        index = 0;
        for (int ii = 0; ii < 25; ++ii) {
            String code = proceduresString.substring(index, index + 7);
            if (code.trim().length() == 0) continue;
            procCodes.add(new MsdrgInputPrCode(code.trim()));
            index += 7;
        }
        claimInput.withProcedureCodes(procCodes);
        claimInput.withAgeDaysAdmit(-1);
        claimInput.withAgeDaysDischarge(-1);
        gov.agency.msdrg.model.transfer.MsdrgClaim claim = new gov.agency.msdrg.model.transfer.MsdrgClaim(claimInput.build());
        String hospitalStatusString = (String)inputFields.get("HOSPITAL_STATUS");
        if (hospitalStatusString.equals(String.valueOf('X'))) {
            this.runtime.setPoaReportingExempt(MsdrgHospitalStatusOptionFlag.EXEMPT);
        } else {
            this.runtime.setPoaReportingExempt(MsdrgHospitalStatusOptionFlag.NON_EXEMPT);
        }
        if (this.debugEnabled) {
            System.out.println("***DEBUG INFO FOR " + claim.getClaimId());
            System.out.println("Hospital considered: " + (Object)((Object)this.runtime.getPoaReportingExempt()));
            System.out.println("-raw inputs:");
            for (Map.Entry entry : inputFields.entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + "->" + entry.getValue());
            }
            gov.agency.msdrg.model.transfer.MsdrgInputData inputData = claim.getInput();
            System.out.println("-on GFC claim:");
            MsdrgInputDxCode msdrgInputDxCode = inputData.getPrincipalDiagnosisCode().orElseThrow(() -> new RuntimeException("No PDX on input"));
            System.out.println("\tPDX-> " + msdrgInputDxCode.getValue() + " POA->" + msdrgInputDxCode.getPoa());
            for (MsdrgInputDxCode dx : inputData.getSecondaryDiagnosisCodes()) {
                System.out.println("\tSDX-> " + dx.getValue() + " POA->" + dx.getPoa());
            }
            for (MsdrgInputPrCode proc : inputData.getProcedureCodes()) {
                System.out.println("\tPROC-> " + proc.getValue());
            }
        }
        return claim;
    }

    public MsdrgClaim populateClaimWithModelV2(Map<String, Object> inputFields) {
        int sex;
        String tmp = (String)inputFields.get("DEBUG_FLAG");
        this.debugEnabled = tmp != null && tmp.equalsIgnoreCase("Y");
        MsdrgInput.MsdrgInputBuilder claimInput = MsdrgInput.builder();
        String ageString = (String)inputFields.get("AGE");
        try {
            int age = Integer.parseInt(ageString);
            claimInput.withAgeInYears(age);
        }
        catch (NumberFormatException age) {
            // empty catch block
        }
        String sexString = (String)inputFields.get("SEX");
        try {
            sex = Integer.parseInt(sexString);
        }
        catch (NumberFormatException ignored) {
            sex = -1;
        }
        switch (sex) {
            case 1: {
                claimInput.withSex(MsdrgSex.MALE);
                break;
            }
            case 2: {
                claimInput.withSex(MsdrgSex.FEMALE);
                break;
            }
            default: {
                claimInput.withSex(MsdrgSex.UNKNOWN);
            }
        }
        String dischargeStatusString = (String)inputFields.get("DISCHARGE_STATUS");
        try {
            int dischargeStatusInt = Integer.parseInt(dischargeStatusString);
            gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus dischargeStatus = gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus.getEnumFromInt(dischargeStatusInt);
            claimInput.withDischargeStatus(dischargeStatus);
        }
        catch (NumberFormatException dischargeStatusInt) {
            // empty catch block
        }
        String diagnosesString = (String)inputFields.get("DIAGNOSES");
        ArrayList<gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode> sdxCodes = new ArrayList<gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode>();
        int index = 0;
        for (int ii = 1; ii < 26; ++ii) {
            String code = diagnosesString.substring(index, index + 7);
            if (code.trim().length() == 0) continue;
            String poaDaa = diagnosesString.substring(index + 7, index + 7 + 1);
            String dxCode = code.trim();
            Object tmpPoa = GfcPoa.BLANK;
            if (!poaDaa.trim().isEmpty()) {
                try {
                    tmpPoa = GfcPoa.valueOf(poaDaa);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    tmpPoa = GfcPoa.BLANK;
                }
            }
            if (ii == 1) {
                claimInput.withPrincipalDiagnosisCode(new gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode(dxCode, (GfcPoa)tmpPoa));
            } else {
                sdxCodes.add(new gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode(dxCode, (GfcPoa)tmpPoa));
            }
            index += 8;
        }
        claimInput.withSecondaryDiagnosisCodes(sdxCodes);
        String proceduresString = (String)inputFields.get("PROCEDURES");
        ArrayList<gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode> procCodes = new ArrayList<gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode>();
        index = 0;
        for (int ii = 0; ii < 25; ++ii) {
            String code = proceduresString.substring(index, index + 7);
            if (code.trim().length() == 0) continue;
            procCodes.add(new gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode(code.trim()));
            index += 7;
        }
        claimInput.withProcedureCodes(procCodes);
        claimInput.withAgeDaysAdmit(-1);
        claimInput.withAgeDaysDischarge(-1);
        MsdrgClaim claim = new MsdrgClaim(claimInput.build());
        String hospitalStatusString = (String)inputFields.get("HOSPITAL_STATUS");
        if (hospitalStatusString.equals(String.valueOf('X'))) {
            this.runtimeV2.setPoaReportingExempt(gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag.EXEMPT);
        } else {
            this.runtimeV2.setPoaReportingExempt(gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag.NON_EXEMPT);
        }
        if (this.debugEnabled) {
            System.out.println("***DEBUG INFO FOR " + claim.getClaimId());
            System.out.println("Hospital considered: " + (Object)((Object)this.runtimeV2.getPoaReportingExempt()));
            System.out.println("-raw inputs:");
            for (Map.Entry entry : inputFields.entrySet()) {
                System.out.println("\t" + (String)entry.getKey() + "->" + entry.getValue());
            }
            MsdrgInputData inputData = claim.getInput();
            System.out.println("-on GFC claim:");
            gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode msdrgInputDxCode = inputData.getPrincipalDiagnosisCode().orElseThrow(() -> new RuntimeException("No PDX on input"));
            System.out.println("\tPDX-> " + msdrgInputDxCode.getValue() + " POA->" + msdrgInputDxCode.getPoa());
            for (gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode dx : inputData.getSecondaryDiagnosisCodes()) {
                System.out.println("\tSDX-> " + dx.getValue() + " POA->" + dx.getPoa());
            }
            for (gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode proc : inputData.getProcedureCodes()) {
                System.out.println("\tPROC-> " + proc.getValue());
            }
        }
        return claim;
    }

    public Map<String, Object> extractFromClaimWithModelV1(Map<String, Object> inputRecord, gov.agency.msdrg.model.transfer.MsdrgClaim claim) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        gov.agency.msdrg.model.transfer.MsdrgOutputData outputData = claim.getOutput().orElseThrow(() -> new RuntimeException("No output on claim"));
        int grc = outputData.getFinalGrc().getGrouperReturnCode();
        output.put(FieldName.FI_GRC.name(), grc);
        output.put(FieldName.FI_MDC.name(), outputData.getFinalMdc().getValue());
        output.put(FieldName.FI_DRG.name(), outputData.getFinalDrg().getValue());
        output.put(FieldName.FI_BASE_DRG.name(), outputData.getFinalBaseDrg().getValue());
        int severity = 0;
        if (outputData.getFinalSeverity() != null) {
            severity = outputData.getFinalSeverity().getSeverityLevel();
        }
        output.put(FieldName.FI_SEVERITY.name(), severity);
        int medSurg = 0;
        if (outputData.getFinalMedSugType() != null) {
            medSurg = outputData.getFinalMedSugType().getIntValue();
        }
        output.put(FieldName.FI_MED_SURG.name(), medSurg);
        output.put(FieldName.IN_DRG.name(), outputData.getInitialDrg().getValue());
        output.put(FieldName.IN_BASE_DRG.name(), outputData.getInitialBaseDrg().getValue());
        severity = 0;
        if (outputData.getInitialSeverity() != null) {
            severity = outputData.getInitialSeverity().getSeverityLevel();
        }
        output.put(FieldName.IN_SEVERITY.name(), severity);
        medSurg = 0;
        if (outputData.getInitialMedSugType() != null) {
            medSurg = outputData.getInitialMedSugType().getIntValue();
        }
        output.put(FieldName.IN_MED_SURG.name(), medSurg);
        String grouperFlags = this.mapGrouperFlagOutputWithModelV1(outputData);
        output.put(FieldName.GROUPER_FLAGS.name(), grouperFlags);
        StringBuilder codeFlags = new StringBuilder();
        codeFlags.append((CharSequence)this.mapDxFlagOutputWithModelV1(outputData));
        output.put(FieldName.DIAGNOSIS_FLAGS.name(), codeFlags.toString());
        codeFlags = new StringBuilder();
        List<MsdrgOutputPrCode> procFlags = outputData.getProcOutput();
        for (MsdrgOutputPrCode flgValue : procFlags) {
            StringBuilder flags = new StringBuilder();
            if (!flgValue.isProcedureRecognizedByGrouper()) {
                flags.append(String.format("%-20d", 0));
            } else {
                flags.append(1);
                flags.append(flgValue.getProcedureAffectsDrg().intValue());
                flags.append(flgValue.isProcedureIsOperatingRoomProcedure() ? 1 : 0);
                for (gov.agency.msdrg.model.enumeration.MsdrgProcedureHacUsage hacUsage : flgValue.getHacUsage()) {
                    flags.append(String.format("%02d", hacUsage.getIntValue()));
                }
                flags.append(String.format("%0" + (20 - flags.length()) + "d", 0));
            }
            codeFlags.append((CharSequence)flags);
        }
        output.put(FieldName.PROCEDURE_FLAGS.name(), codeFlags.toString());
        VersionDate versionDate = (VersionDate)((Object)inputRecord.get("parsed_version_date"));
        output.put(FieldName.GROUPER_VERSION.name(), "001" + versionDate.getVersion() + "00");
        if (this.debugEnabled) {
            System.out.println("-outputs:");
            for (Map.Entry me : output.entrySet()) {
                System.out.println("\t" + (String)me.getKey() + "->" + me.getValue());
            }
        }
        return output;
    }

    public Map<String, Object> extractFromClaimWithModelV2(Map<String, Object> inputRecord, MsdrgClaim claim) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        MsdrgOutputData outputData = claim.getOutput().orElseThrow(() -> new RuntimeException("No output on claim"));
        int grc = outputData.getFinalGrc().getGrouperReturnCode();
        output.put(FieldName.FI_GRC.name(), grc);
        output.put(FieldName.FI_MDC.name(), outputData.getFinalMdc().getValue());
        output.put(FieldName.FI_DRG.name(), outputData.getFinalDrg().getValue());
        output.put(FieldName.FI_BASE_DRG.name(), outputData.getFinalBaseDrg().getValue());
        int severity = 0;
        if (outputData.getFinalSeverity() != null) {
            severity = outputData.getFinalSeverity().getSeverityLevel();
        }
        output.put(FieldName.FI_SEVERITY.name(), severity);
        int medSurg = 0;
        if (outputData.getFinalMedSugType() != null) {
            medSurg = outputData.getFinalMedSugType().getIntValue();
        }
        output.put(FieldName.FI_MED_SURG.name(), medSurg);
        output.put(FieldName.IN_DRG.name(), outputData.getInitialDrg().getValue());
        output.put(FieldName.IN_BASE_DRG.name(), outputData.getInitialBaseDrg().getValue());
        severity = 0;
        if (outputData.getInitialSeverity() != null) {
            severity = outputData.getInitialSeverity().getSeverityLevel();
        }
        output.put(FieldName.IN_SEVERITY.name(), severity);
        medSurg = 0;
        if (outputData.getInitialMedSugType() != null) {
            medSurg = outputData.getInitialMedSugType().getIntValue();
        }
        output.put(FieldName.IN_MED_SURG.name(), medSurg);
        String grouperFlags = this.mapGrouperFlagOutputWithModelV2(outputData);
        output.put(FieldName.GROUPER_FLAGS.name(), grouperFlags);
        StringBuilder codeFlags = new StringBuilder();
        codeFlags.append((CharSequence)this.mapDxFlagOutputWithModelV2(outputData));
        output.put(FieldName.DIAGNOSIS_FLAGS.name(), codeFlags.toString());
        codeFlags = new StringBuilder();
        List<gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputPrCode> procFlags = outputData.getProcOutput();
        for (gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputPrCode flgValue : procFlags) {
            StringBuilder flags = new StringBuilder();
            if (!flgValue.isProcedureRecognizedByGrouper()) {
                flags.append(String.format("%-20d", 0));
            } else {
                flags.append(1);
                flags.append(flgValue.getProcedureAffectsDrg().intValue());
                flags.append(flgValue.isProcedureIsOperatingRoomProcedure() ? 1 : 0);
                for (MsdrgProcedureHacUsage hacUsage : flgValue.getHacUsage()) {
                    flags.append(String.format("%02d", hacUsage.getIntValue()));
                }
                flags.append(String.format("%0" + (20 - flags.length()) + "d", 0));
            }
            codeFlags.append((CharSequence)flags);
        }
        output.put(FieldName.PROCEDURE_FLAGS.name(), codeFlags.toString());
        VersionDate versionDate = (VersionDate)((Object)inputRecord.get("parsed_version_date"));
        output.put(FieldName.GROUPER_VERSION.name(), "001" + versionDate.getVersion() + "00");
        if (this.debugEnabled) {
            System.out.println("-outputs:");
            for (Map.Entry me : output.entrySet()) {
                System.out.println("\t" + (String)me.getKey() + "->" + me.getValue());
            }
        }
        return output;
    }

    protected String mapGrouperFlagOutputWithModelV1(gov.agency.msdrg.model.transfer.MsdrgOutputData outputData) {
        StringBuilder flags = new StringBuilder();
        String tmp = String.format("%2d", outputData.getGrouperFlags().getNumHacCategoriesSatisfied());
        flags.append(tmp.replace(' ', '0'));
        tmp = "0";
        if (outputData.getGrouperFlags().getFinalDrgSecondaryDxCcMcc() != null) {
            tmp = String.valueOf(outputData.getGrouperFlags().getFinalDrgSecondaryDxCcMcc().getSeverityLevel());
        }
        if (tmp.equals("5")) {
            tmp = "2";
        }
        if (tmp.equals("3")) {
            tmp = "0";
        }
        flags.append(tmp);
        tmp = "0";
        if (outputData.getGrouperFlags().getInitialDrgSecondaryDxCcMcc() != null) {
            tmp = String.valueOf(outputData.getGrouperFlags().getInitialDrgSecondaryDxCcMcc().getSeverityLevel());
        }
        if (tmp.equals("5")) {
            tmp = "2";
        }
        if (tmp.equals("3")) {
            tmp = "0";
        }
        flags.append(tmp);
        gov.agency.msdrg.model.enumeration.MsdrgHacStatus hacStatus = outputData.getGrouperFlags().getHacStatusValue();
        if (hacStatus != null) {
            switch (hacStatus) {
                default: {
                    tmp = "0";
                    break;
                }
                case FINAL_DRG_NO_CHANGE: {
                    tmp = "1";
                    break;
                }
                case FINAL_DRG_CHANGES: {
                    tmp = "2";
                    break;
                }
                case FINAL_DRG_UNGROUPABLE: {
                    tmp = "3";
                }
            }
            flags.append(tmp);
        }
        return flags.toString();
    }

    protected String mapGrouperFlagOutputWithModelV2(MsdrgOutputData outputData) {
        StringBuilder flags = new StringBuilder();
        String tmp = String.format("%2d", outputData.getGrouperFlags().getNumHacCategoriesSatisfied());
        flags.append(tmp.replace(' ', '0'));
        tmp = "0";
        if (outputData.getGrouperFlags().getFinalDrgSecondaryDxCcMcc() != null) {
            tmp = String.valueOf(outputData.getGrouperFlags().getFinalDrgSecondaryDxCcMcc().getSeverityLevel());
        }
        if (tmp.equals("5")) {
            tmp = "2";
        }
        if (tmp.equals("3")) {
            tmp = "0";
        }
        flags.append(tmp);
        tmp = "0";
        if (outputData.getGrouperFlags().getInitialDrgSecondaryDxCcMcc() != null) {
            tmp = String.valueOf(outputData.getGrouperFlags().getInitialDrgSecondaryDxCcMcc().getSeverityLevel());
        }
        if (tmp.equals("5")) {
            tmp = "2";
        }
        if (tmp.equals("3")) {
            tmp = "0";
        }
        flags.append(tmp);
        MsdrgHacStatus hacStatus = outputData.getGrouperFlags().getHacStatusValue();
        if (hacStatus != null) {
            switch (hacStatus) {
                default: {
                    tmp = "0";
                    break;
                }
                case FINAL_DRG_NO_CHANGE: {
                    tmp = "1";
                    break;
                }
                case FINAL_DRG_CHANGES: {
                    tmp = "2";
                    break;
                }
                case FINAL_DRG_UNGROUPABLE: {
                    tmp = "3";
                }
            }
            flags.append(tmp);
        }
        return flags.toString();
    }

    protected StringBuilder mapProcFlagOutput(MsdrgProcedureCode prCode) {
        StringBuilder mappedPrFlags = new StringBuilder();
        if (!prCode.isValidCode()) {
            mappedPrFlags.append(String.format("%-20d", 0));
            return mappedPrFlags;
        }
        mappedPrFlags.append("1");
        mappedPrFlags.append(prCode.getDrgImpact().intValue());
        int isOrProc = prCode.isOperatingRoomProcedure() ? 1 : 0;
        mappedPrFlags.append(isOrProc);
        for (gov.agency.msdrg.model.enumeration.MsdrgProcedureHacUsage hac : prCode.getHacUsageFlag()) {
            mappedPrFlags.append(String.format("%2d", hac.getHacValue()));
        }
        mappedPrFlags.append(String.format("%0" + (20 - mappedPrFlags.length()) + "d", 0));
        return mappedPrFlags;
    }

    protected StringBuilder mapDxFlagOutputWithModelV1(gov.agency.msdrg.model.transfer.MsdrgOutputData outputData) {
        StringBuilder codeFlags = new StringBuilder();
        ArrayList<MsdrgOutputDxCode> diagFlags = new ArrayList<MsdrgOutputDxCode>(outputData.getSdxOutput());
        MsdrgOutputDxCode pdxFlags = outputData.getPdxOutput();
        diagFlags.add(0, pdxFlags);
        for (MsdrgOutputDxCode flgValue : diagFlags) {
            gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag finalSeverity = flgValue.getFinalSeverityUsage();
            gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag initialSeverity = flgValue.getInitialSeverityUsage();
            String severityFlag = "0";
            if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.NEITHER) && initialSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.MCC)) {
                severityFlag = "3";
            } else if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.NEITHER) && initialSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.CC)) {
                severityFlag = "4";
            } else if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.MCC_EXCLUDED)) {
                severityFlag = "5";
            } else if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.CC_EXCLUDED)) {
                severityFlag = "6";
            } else if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.MCC) && initialSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.MCC)) {
                severityFlag = "1";
            } else if (finalSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.CC) && initialSeverity.equals((Object)gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag.CC)) {
                severityFlag = "2";
            }
            if (!flgValue.isDiagnosisRecognizedByGrouper()) {
                codeFlags.append(String.format("%-25d", 0));
                continue;
            }
            String validityFlag = "1";
            String dxAffectDrgFlag = String.valueOf(flgValue.getDiagnosisAffectsDrg().intValue());
            codeFlags.append(validityFlag);
            codeFlags.append(dxAffectDrgFlag);
            codeFlags.append(severityFlag);
            List<gov.agency.msdrg.model.MsdrgHac> hacs = flgValue.getHacs();
            for (int i = 0; i < 5; ++i) {
                try {
                    gov.agency.msdrg.model.MsdrgHac hac = hacs.get(i);
                    int hacUsage = hac.getHacStatus().getIntValue();
                    codeFlags.append(String.format("%02d", hac.getHacNumber()));
                    codeFlags.append(hacUsage);
                    continue;
                }
                catch (IndexOutOfBoundsException exc) {
                    codeFlags.append("000");
                }
            }
            codeFlags.append(FILLER);
        }
        return codeFlags;
    }

    protected StringBuilder mapDxFlagOutputWithModelV2(MsdrgOutputData outputData) {
        StringBuilder codeFlags = new StringBuilder();
        ArrayList<gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputDxCode> diagFlags = new ArrayList<gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputDxCode>(outputData.getSdxOutput());
        gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputDxCode pdxFlags = outputData.getPdxOutput();
        diagFlags.add(0, pdxFlags);
        for (gov.agency.msdrg.model.v2.transfer.output.MsdrgOutputDxCode flgValue : diagFlags) {
            MsdrgCodeSeverityFlag finalSeverity = flgValue.getFinalSeverityUsage();
            MsdrgCodeSeverityFlag initialSeverity = flgValue.getInitialSeverityUsage();
            String severityFlag = "0";
            if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.NEITHER) && initialSeverity.equals((Object)MsdrgCodeSeverityFlag.MCC)) {
                severityFlag = "3";
            } else if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.NEITHER) && initialSeverity.equals((Object)MsdrgCodeSeverityFlag.CC)) {
                severityFlag = "4";
            } else if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.MCC_EXCLUDED)) {
                severityFlag = "5";
            } else if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.CC_EXCLUDED)) {
                severityFlag = "6";
            } else if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.MCC) && initialSeverity.equals((Object)MsdrgCodeSeverityFlag.MCC)) {
                severityFlag = "1";
            } else if (finalSeverity.equals((Object)MsdrgCodeSeverityFlag.CC) && initialSeverity.equals((Object)MsdrgCodeSeverityFlag.CC)) {
                severityFlag = "2";
            }
            if (!flgValue.isDiagnosisRecognizedByGrouper()) {
                codeFlags.append(String.format("%-25d", 0));
                continue;
            }
            String validityFlag = "1";
            String dxAffectDrgFlag = String.valueOf(flgValue.getDiagnosisAffectsDrg().intValue());
            codeFlags.append(validityFlag);
            codeFlags.append(dxAffectDrgFlag);
            codeFlags.append(severityFlag);
            List<MsdrgHac> hacs = flgValue.getHacs();
            for (int i = 0; i < 5; ++i) {
                try {
                    MsdrgHac hac = hacs.get(i);
                    int hacUsage = hac.getHacStatus().getIntValue();
                    codeFlags.append(String.format("%02d", hac.getHacNumber()));
                    codeFlags.append(hacUsage);
                    continue;
                }
                catch (IndexOutOfBoundsException exc) {
                    codeFlags.append("000");
                }
            }
            codeFlags.append(FILLER);
        }
        return codeFlags;
    }

    private String generateErrorString(int errorCode) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (FixedWidthField<?> outputField : outputFields) {
            if (outputField.getName().equalsIgnoreCase(FieldName.DIAGNOSIS_FLAGS.name()) || outputField.getName().equals(FieldName.PROCEDURE_FLAGS.name())) continue;
            if (outputField.getDataType() == Integer.class) {
                data.put(outputField.getName(), 0);
                continue;
            }
            if (outputField.getDataType() == String.class) {
                data.put(outputField.getName(), "");
                continue;
            }
            if (!outputField.getFill().isPresent()) continue;
            data.put(outputField.getName(), new String(new char[outputField.getFieldWidth()]).replace("\u0000", outputField.getFill().get().toString()));
        }
        data.put(FieldName.FI_GRC.name(), errorCode);
        return FormatUtilities.formatFixedWidthString(outputFields, data);
    }

    @Override
    public void initialize(MainframeProperties mainframeProperties) {
    }

    @Override
    public String processException(Exception exc, String inputString) {
        if (exc instanceof MalformedDateException) {
            return this.generateErrorString(99);
        }
        if (exc instanceof DateBeforeValidVersionException) {
            return this.generateErrorString(98);
        }
        return this.generateErrorString(88);
    }
}

