/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.DataValidityFlagIF;

public class DataValidityFlag
implements DataValidityFlagIF {
    protected static final String[] FLAG_VALUES = new String[]{"1", "2", "3", "5", "4", "7", "6", "8", "A", "B", "C", "E", "D", "G", "F", "H"};
    private boolean manifestationSequenceIssue;
    private boolean clinicalIssue;
    private boolean functionalIssue;
    private boolean serviceIssue;

    @Override
    public boolean isClinicalIssue() {
        return this.clinicalIssue;
    }

    @Override
    public void setClinicalIssue(boolean clinicalIssue) {
        this.clinicalIssue = clinicalIssue;
    }

    @Override
    public boolean isFunctionalIssue() {
        return this.functionalIssue;
    }

    @Override
    public void setFunctionalIssue(boolean functionalIssue) {
        this.functionalIssue = functionalIssue;
    }

    @Override
    public boolean isManifestationSequenceIssue() {
        return this.manifestationSequenceIssue;
    }

    @Override
    public void setManifestationSequenceIssue(boolean manifestationSequenceIssue) {
        this.manifestationSequenceIssue = manifestationSequenceIssue;
    }

    @Override
    public boolean isServiceIssue() {
        return this.serviceIssue;
    }

    @Override
    public void setServiceIssue(boolean serviceIssue) {
        this.serviceIssue = serviceIssue;
    }

    @Override
    public void reset() {
        this.manifestationSequenceIssue = false;
        this.clinicalIssue = false;
        this.functionalIssue = false;
        this.serviceIssue = false;
    }

    @Override
    public String getValidityFlag() {
        int tmpInt = 0;
        if (this.clinicalIssue) {
            ++tmpInt;
        }
        if (this.functionalIssue) {
            tmpInt += 2;
        }
        if (this.serviceIssue) {
            tmpInt += 4;
        }
        if (this.manifestationSequenceIssue) {
            tmpInt += 8;
        }
        return FLAG_VALUES[tmpInt];
    }

    @Override
    public void setValidityFlag(String val) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("manifistationIssue=");
        buffer.append(this.manifestationSequenceIssue);
        buffer.append(",clinicalIssue=");
        buffer.append(this.clinicalIssue);
        buffer.append(",functionalIssue=");
        buffer.append(this.functionalIssue);
        buffer.append(",serviceIssue=");
        buffer.append(this.serviceIssue);
        buffer.append(",validityFlag=");
        buffer.append(this.getValidityFlag());
        return buffer.toString();
    }

    @Override
    public boolean isIssuePresent() {
        return this.manifestationSequenceIssue || this.clinicalIssue || this.functionalIssue || this.serviceIssue;
    }
}

