/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordType;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeHealthRecord
implements HomeHealthRecordIF {
    private transient HashMap<String, Method> getMethodsTable = new HashMap();
    public static final String oneSpace = " ";
    public static final String twoSpace = "  ";
    private Calendar START_CARE_DT;
    private Calendar INFO_COMPLETED_DT;
    private String ASSMT_REASON = "  ";
    private DiagnosisCodeIF PRIMARY_DIAG_ICD;
    private DiagnosisCodeIF OTH_DIAG1_ICD;
    private DiagnosisCodeIF OTH_DIAG2_ICD;
    private DiagnosisCodeIF OTH_DIAG3_ICD;
    private DiagnosisCodeIF OTH_DIAG4_ICD;
    private DiagnosisCodeIF OTH_DIAG5_ICD;
    private String THH_IV_INFUSION = " ";
    private String THH_PAR_NUTRITION = " ";
    private String THH_ENT_NUTRITION = " ";
    private String THH_NONE_ABOVE = " ";
    private String VISION = "  ";
    private String FREQ_PAIN = "  ";
    private String LESION_OPEN_WND = " ";
    private String NBR_PRSULC_STG1 = "  ";
    private String NBR_PRSULC_STG2 = "  ";
    private String NBR_PRSULC_STG3 = "  ";
    private String NBR_PRSULC_STG4 = "  ";
    private String STG_PRBLM_ULCER = "  ";
    private String STASIS_ULCER = " ";
    private String NBR_STASULC = "  ";
    private String STAT_PRB_STASULC = "  ";
    private String SURG_WOUND = " ";
    private String STAT_PRB_SURGWND = "  ";
    private String WHEN_DYSPNEIC = "  ";
    private String UR_INCONT = "  ";
    private String BWL_INCONT = "  ";
    private String OSTOMY = "  ";
    private String CUR_DRESS_UPPER = "  ";
    private String CUR_DRESS_LOWER = "  ";
    private String CUR_BATHING = "  ";
    private String CUR_TOILETING = "  ";
    private String CUR_TRANSFERRING = "  ";
    private String CUR_AMBULATION = "  ";
    private String CUR_INJECT_MEDS = "  ";
    private String EPISODE_TIMING = "  ";
    private DiagnosisCodeIF PMT_DIAG_ICD_A3;
    private DiagnosisCodeIF PMT_DIAG_ICD_B3;
    private DiagnosisCodeIF PMT_DIAG_ICD_C3;
    private DiagnosisCodeIF PMT_DIAG_ICD_D3;
    private DiagnosisCodeIF PMT_DIAG_ICD_E3;
    private DiagnosisCodeIF PMT_DIAG_ICD_F3;
    private DiagnosisCodeIF PMT_DIAG_ICD_A4;
    private DiagnosisCodeIF PMT_DIAG_ICD_B4;
    private DiagnosisCodeIF PMT_DIAG_ICD_C4;
    private DiagnosisCodeIF PMT_DIAG_ICD_D4;
    private DiagnosisCodeIF PMT_DIAG_ICD_E4;
    private DiagnosisCodeIF PMT_DIAG_ICD_F4;
    private int THER_NEED_NUM;
    private String THER_NEED_NA = " ";
    private String HIPPS_CODE;

    @Override
    public RecordType getRecordType() {
        return RecordType.UNKNOWN;
    }

    @Override
    public DiagnosisCodeIF getDiagnosisCode(int index) {
        DiagnosisCodeIF code;
        switch (index) {
            case 0: {
                code = this.PRIMARY_DIAG_ICD;
                break;
            }
            case 1: {
                code = this.OTH_DIAG1_ICD;
                break;
            }
            case 2: {
                code = this.OTH_DIAG2_ICD;
                break;
            }
            case 3: {
                code = this.OTH_DIAG3_ICD;
                break;
            }
            case 4: {
                code = this.OTH_DIAG4_ICD;
                break;
            }
            case 5: {
                code = this.OTH_DIAG5_ICD;
                break;
            }
            case 6: {
                code = this.PMT_DIAG_ICD_A3;
                break;
            }
            case 7: {
                code = this.PMT_DIAG_ICD_B3;
                break;
            }
            case 8: {
                code = this.PMT_DIAG_ICD_C3;
                break;
            }
            case 9: {
                code = this.PMT_DIAG_ICD_D3;
                break;
            }
            case 10: {
                code = this.PMT_DIAG_ICD_E3;
                break;
            }
            case 11: {
                code = this.PMT_DIAG_ICD_F3;
                break;
            }
            case 12: {
                code = this.PMT_DIAG_ICD_A4;
                break;
            }
            case 13: {
                code = this.PMT_DIAG_ICD_B4;
                break;
            }
            case 14: {
                code = this.PMT_DIAG_ICD_C4;
                break;
            }
            case 15: {
                code = this.PMT_DIAG_ICD_D4;
                break;
            }
            case 16: {
                code = this.PMT_DIAG_ICD_E4;
                break;
            }
            case 17: {
                code = this.PMT_DIAG_ICD_F4;
                break;
            }
            default: {
                code = null;
            }
        }
        return code;
    }

    @Override
    public DiagnosisCodeIF getOptionalDiagnosisCode3(int index) {
        DiagnosisCodeIF code;
        switch (index) {
            case 0: {
                code = this.PMT_DIAG_ICD_A3;
                break;
            }
            case 1: {
                code = this.PMT_DIAG_ICD_B3;
                break;
            }
            case 2: {
                code = this.PMT_DIAG_ICD_C3;
                break;
            }
            case 3: {
                code = this.PMT_DIAG_ICD_D3;
                break;
            }
            case 4: {
                code = this.PMT_DIAG_ICD_E3;
                break;
            }
            case 5: {
                code = this.PMT_DIAG_ICD_F3;
                break;
            }
            default: {
                code = null;
            }
        }
        return code;
    }

    @Override
    public DiagnosisCodeIF getOptionalDiagnosisCode4(int index) {
        DiagnosisCodeIF code;
        switch (index) {
            case 0: {
                code = this.PMT_DIAG_ICD_A4;
                break;
            }
            case 1: {
                code = this.PMT_DIAG_ICD_B4;
                break;
            }
            case 2: {
                code = this.PMT_DIAG_ICD_C4;
                break;
            }
            case 3: {
                code = this.PMT_DIAG_ICD_D4;
                break;
            }
            case 4: {
                code = this.PMT_DIAG_ICD_E4;
                break;
            }
            case 5: {
                code = this.PMT_DIAG_ICD_F4;
                break;
            }
            default: {
                code = null;
            }
        }
        return code;
    }

    @Override
    public boolean isDiagnosticGroupOnRecord(int groupNum, int codePosition) {
        int idx = 18;
        boolean isPresent = false;
        while (idx-- > 0) {
            DiagnosisCodeIF diagCode;
            if (idx == codePosition || (diagCode = this.getDiagnosisCode(idx)) == null || !diagCode.isValidForScoring() || groupNum != diagCode.getDiagnosticGroup().getId()) continue;
            isPresent = true;
            break;
        }
        return isPresent;
    }

    @Override
    public Calendar getSTART_CARE_DT() {
        return this.START_CARE_DT;
    }

    @Override
    public void setSTART_CARE_DT(Calendar val) {
        this.START_CARE_DT = val;
    }

    @Override
    public Calendar getINFO_COMPLETED_DT() {
        return this.INFO_COMPLETED_DT;
    }

    @Override
    public void setINFO_COMPLETED_DT(Calendar val) {
        this.INFO_COMPLETED_DT = val;
    }

    @Override
    public String getASSMT_REASON() {
        return this.ASSMT_REASON;
    }

    @Override
    public void setASSMT_REASON(String val) {
        this.ASSMT_REASON = val;
    }

    @Override
    public DiagnosisCodeIF getPRIMARY_DIAG_ICD() {
        return this.PRIMARY_DIAG_ICD;
    }

    @Override
    public void setPRIMARY_DIAG_ICD(DiagnosisCodeIF val) {
        this.PRIMARY_DIAG_ICD = val;
    }

    @Override
    public DiagnosisCodeIF getOTH_DIAG1_ICD() {
        return this.OTH_DIAG1_ICD;
    }

    @Override
    public void setOTH_DIAG1_ICD(DiagnosisCodeIF val) {
        this.OTH_DIAG1_ICD = val;
    }

    @Override
    public DiagnosisCodeIF getOTH_DIAG2_ICD() {
        return this.OTH_DIAG2_ICD;
    }

    @Override
    public void setOTH_DIAG2_ICD(DiagnosisCodeIF val) {
        this.OTH_DIAG2_ICD = val;
    }

    @Override
    public DiagnosisCodeIF getOTH_DIAG3_ICD() {
        return this.OTH_DIAG3_ICD;
    }

    @Override
    public void setOTH_DIAG3_ICD(DiagnosisCodeIF val) {
        this.OTH_DIAG3_ICD = val;
    }

    @Override
    public DiagnosisCodeIF getOTH_DIAG4_ICD() {
        return this.OTH_DIAG4_ICD;
    }

    @Override
    public void setOTH_DIAG4_ICD(DiagnosisCodeIF val) {
        this.OTH_DIAG4_ICD = val;
    }

    @Override
    public DiagnosisCodeIF getOTH_DIAG5_ICD() {
        return this.OTH_DIAG5_ICD;
    }

    @Override
    public void setOTH_DIAG5_ICD(DiagnosisCodeIF val) {
        this.OTH_DIAG5_ICD = val;
    }

    @Override
    public String getTHH_IV_INFUSION() {
        return this.THH_IV_INFUSION;
    }

    @Override
    public void setTHH_IV_INFUSION(String val) {
        this.THH_IV_INFUSION = val;
    }

    @Override
    public String getTHH_PAR_NUTRITION() {
        return this.THH_PAR_NUTRITION;
    }

    @Override
    public void setTHH_PAR_NUTRITION(String val) {
        this.THH_PAR_NUTRITION = val;
    }

    @Override
    public String getTHH_ENT_NUTRITION() {
        return this.THH_ENT_NUTRITION;
    }

    @Override
    public void setTHH_ENT_NUTRITION(String val) {
        this.THH_ENT_NUTRITION = val;
    }

    @Override
    public String getTHH_NONE_ABOVE() {
        return this.THH_NONE_ABOVE;
    }

    @Override
    public void setTHH_NONE_ABOVE(String val) {
        this.THH_NONE_ABOVE = val;
    }

    @Override
    public String getVISION() {
        return this.VISION;
    }

    @Override
    public void setVISION(String val) {
        this.VISION = val;
    }

    @Override
    public String getPAIN_FREQ_ACTVTY_MVMT() {
        return this.FREQ_PAIN;
    }

    @Override
    public void setPAIN_FREQ_ACTVTY_MVMT(String val) {
        this.FREQ_PAIN = val;
    }

    @Override
    public String getLESION_OPEN_WND() {
        return this.LESION_OPEN_WND;
    }

    @Override
    public void setLESION_OPEN_WND(String val) {
        this.LESION_OPEN_WND = val;
    }

    @Override
    public String getNBR_PRSULC_STG1() {
        return this.NBR_PRSULC_STG1;
    }

    @Override
    public void setNBR_PRSULC_STG1(String val) {
        this.NBR_PRSULC_STG1 = val;
    }

    @Override
    public String getNBR_PRSULC_STG2() {
        return this.NBR_PRSULC_STG2;
    }

    @Override
    public void setNBR_PRSULC_STG2(String val) {
        this.NBR_PRSULC_STG2 = val;
    }

    @Override
    public String getNBR_PRSULC_STG3() {
        return this.NBR_PRSULC_STG3;
    }

    @Override
    public void setNBR_PRSULC_STG3(String val) {
        this.NBR_PRSULC_STG3 = val;
    }

    @Override
    public String getNBR_PRSULC_STG4() {
        return this.NBR_PRSULC_STG4;
    }

    @Override
    public void setNBR_PRSULC_STG4(String val) {
        this.NBR_PRSULC_STG4 = val;
    }

    @Override
    public String getSTG_PRBLM_ULCER() {
        return this.STG_PRBLM_ULCER;
    }

    @Override
    public void setSTG_PRBLM_ULCER(String val) {
        this.STG_PRBLM_ULCER = val;
    }

    @Override
    public String getSTAS_ULCR_PRSNT() {
        return this.STASIS_ULCER;
    }

    @Override
    public void setSTAS_ULCR_PRSNT(String val) {
        this.STASIS_ULCER = val;
    }

    @Override
    public String getNBR_STAS_ULCR() {
        return this.NBR_STASULC;
    }

    @Override
    public void setNBR_STAS_ULCR(String val) {
        this.NBR_STASULC = val;
    }

    @Override
    public String getSTUS_PRBLM_STAS_ULCR() {
        return this.STAT_PRB_STASULC;
    }

    @Override
    public void setSTUS_PRBLM_STAS_ULCR(String val) {
        this.STAT_PRB_STASULC = val;
    }

    @Override
    public String getSRGCL_WND_PRSNT() {
        return this.SURG_WOUND;
    }

    @Override
    public void setSRGCL_WND_PRSNT(String val) {
        this.SURG_WOUND = val;
    }

    @Override
    public String getSTUS_PRBLM_SRGCL_WND() {
        return this.STAT_PRB_SURGWND;
    }

    @Override
    public void setSTUS_PRBLM_SRGCL_WND(String val) {
        this.STAT_PRB_SURGWND = val;
    }

    @Override
    public String getWHEN_DYSPNEIC() {
        return this.WHEN_DYSPNEIC;
    }

    @Override
    public void setWHEN_DYSPNEIC(String val) {
        this.WHEN_DYSPNEIC = val;
    }

    @Override
    public String getUR_INCONT() {
        return this.UR_INCONT;
    }

    @Override
    public void setUR_INCONT(String val) {
        this.UR_INCONT = val;
    }

    @Override
    public String getBWL_INCONT() {
        return this.BWL_INCONT;
    }

    @Override
    public void setBWL_INCONT(String val) {
        this.BWL_INCONT = val;
    }

    @Override
    public String getOSTOMY() {
        return this.OSTOMY;
    }

    @Override
    public void setOSTOMY(String val) {
        this.OSTOMY = val;
    }

    @Override
    public String getCRNT_DRESS_UPPER() {
        return this.CUR_DRESS_UPPER;
    }

    @Override
    public void setCRNT_DRESS_UPPER(String val) {
        this.CUR_DRESS_UPPER = val;
    }

    @Override
    public String getCRNT_DRESS_LOWER() {
        return this.CUR_DRESS_LOWER;
    }

    @Override
    public void setCRNT_DRESS_LOWER(String val) {
        this.CUR_DRESS_LOWER = val;
    }

    @Override
    public String getCRNT_BATHG() {
        return this.CUR_BATHING;
    }

    @Override
    public void setCRNT_BATHG(String val) {
        this.CUR_BATHING = val;
    }

    @Override
    public String getCRNT_TOILTG() {
        return this.CUR_TOILETING;
    }

    @Override
    public void setCRNT_TOILTG(String val) {
        this.CUR_TOILETING = val;
    }

    @Override
    public String getCRNT_TRNSFRNG() {
        return this.CUR_TRANSFERRING;
    }

    @Override
    public void setCRNT_TRNSFRNG(String val) {
        this.CUR_TRANSFERRING = val;
    }

    @Override
    public String getCRNT_AMBLTN() {
        return this.CUR_AMBULATION;
    }

    @Override
    public void setCRNT_AMBLTN(String val) {
        this.CUR_AMBULATION = val;
    }

    @Override
    public String getCRNT_MGMT_INJCTN_MDCTN() {
        return this.CUR_INJECT_MEDS;
    }

    @Override
    public void setCRNT_MGMT_INJCTN_MDCTN(String val) {
        this.CUR_INJECT_MEDS = val;
    }

    @Override
    public String getEPISODE_TIMING() {
        return this.EPISODE_TIMING;
    }

    @Override
    public void setEPISODE_TIMING(String val) {
        this.EPISODE_TIMING = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_A3() {
        return this.PMT_DIAG_ICD_A3;
    }

    @Override
    public void setPMT_DIAG_ICD_A3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_A3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_B3() {
        return this.PMT_DIAG_ICD_B3;
    }

    @Override
    public void setPMT_DIAG_ICD_B3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_B3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_C3() {
        return this.PMT_DIAG_ICD_C3;
    }

    @Override
    public void setPMT_DIAG_ICD_C3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_C3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_D3() {
        return this.PMT_DIAG_ICD_D3;
    }

    @Override
    public void setPMT_DIAG_ICD_D3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_D3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_E3() {
        return this.PMT_DIAG_ICD_E3;
    }

    @Override
    public void setPMT_DIAG_ICD_E3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_E3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_F3() {
        return this.PMT_DIAG_ICD_F3;
    }

    @Override
    public void setPMT_DIAG_ICD_F3(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_F3 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_A4() {
        return this.PMT_DIAG_ICD_A4;
    }

    @Override
    public void setPMT_DIAG_ICD_A4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_A4 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_B4() {
        return this.PMT_DIAG_ICD_B4;
    }

    @Override
    public void setPMT_DIAG_ICD_B4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_B4 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_C4() {
        return this.PMT_DIAG_ICD_C4;
    }

    @Override
    public void setPMT_DIAG_ICD_C4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_C4 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_D4() {
        return this.PMT_DIAG_ICD_D4;
    }

    @Override
    public void setPMT_DIAG_ICD_D4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_D4 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_E4() {
        return this.PMT_DIAG_ICD_E4;
    }

    @Override
    public void setPMT_DIAG_ICD_E4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_E4 = val;
    }

    @Override
    public DiagnosisCodeIF getPMT_DIAG_ICD_F4() {
        return this.PMT_DIAG_ICD_F4;
    }

    @Override
    public void setPMT_DIAG_ICD_F4(DiagnosisCodeIF val) {
        this.PMT_DIAG_ICD_F4 = val;
    }

    @Override
    public int getTHER_NEED_NBR() {
        return this.THER_NEED_NUM;
    }

    @Override
    public void setTHER_NEED_NBR(int val) {
        this.THER_NEED_NUM = val;
    }

    @Override
    public String getTHER_NEED_NA() {
        return this.THER_NEED_NA;
    }

    @Override
    public void setTHER_NEED_NA(String val) {
        this.THER_NEED_NA = val;
    }

    @Override
    public String getHIPPS_CODE() {
        return this.HIPPS_CODE;
    }

    @Override
    public void setHIPPS_CODE(String val) {
        this.HIPPS_CODE = val;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("M0030_START_CARE_DT=");
        OasisCalendarFormatter.format(this.START_CARE_DT, buffer);
        buffer.append(",M0090_INFO_COMPLETED_DT=");
        OasisCalendarFormatter.format(this.INFO_COMPLETED_DT, buffer);
        buffer.append(",M0100_ASSMT_REASON=");
        buffer.append(this.ASSMT_REASON);
        buffer.append(",M0230_PRIMARY_DIAG_ICD=");
        buffer.append(this.PRIMARY_DIAG_ICD);
        buffer.append(",M0240_OTH_DIAG1_ICD=");
        buffer.append(this.OTH_DIAG1_ICD);
        buffer.append(",M0240_OTH_DIAG2_ICD=");
        buffer.append(this.OTH_DIAG2_ICD);
        buffer.append(",M0240_OTH_DIAG3_ICD=");
        buffer.append(this.OTH_DIAG3_ICD);
        buffer.append(",M0240_OTH_DIAG4_ICD=");
        buffer.append(this.OTH_DIAG4_ICD);
        buffer.append(",M0240_OTH_DIAG5_ICD=");
        buffer.append(this.OTH_DIAG5_ICD);
        buffer.append(",M0250_THH_IV_INFUSION=");
        buffer.append(this.THH_IV_INFUSION);
        buffer.append(",M0250_THH_PAR_NUTRITION=");
        buffer.append(this.THH_PAR_NUTRITION);
        buffer.append(",M0250_THH_ENT_NUTRITION=");
        buffer.append(this.THH_ENT_NUTRITION);
        buffer.append(",M0250_THH_NONE_ABOVE=");
        buffer.append(this.THH_NONE_ABOVE);
        buffer.append(",M0390_VISION=");
        buffer.append(this.VISION);
        buffer.append(",M0420_FREQ_PAIN=");
        buffer.append(this.FREQ_PAIN);
        buffer.append(",M0440_LESION_OPEN_WND=");
        buffer.append(this.LESION_OPEN_WND);
        buffer.append(",M0450_NBR_PRSULC_STG1=");
        buffer.append(this.NBR_PRSULC_STG1);
        buffer.append(",M0450_NBR_PRSULC_STG2=");
        buffer.append(this.NBR_PRSULC_STG2);
        buffer.append(",M0450_NBR_PRSULC_STG3=");
        buffer.append(this.NBR_PRSULC_STG3);
        buffer.append(",M0450_NBR_PRSULC_STG4=");
        buffer.append(this.NBR_PRSULC_STG4);
        buffer.append(",M0460_STG_PRBLM_ULCER=");
        buffer.append(this.STG_PRBLM_ULCER);
        buffer.append(",M0468_STASIS_ULCER=");
        buffer.append(this.STASIS_ULCER);
        buffer.append(",M0470_NBR_STASULC=");
        buffer.append(this.NBR_STASULC);
        buffer.append(",M0476_STAT_PRB_STASULC=");
        buffer.append(this.STAT_PRB_STASULC);
        buffer.append(",M0482_SURG_WOUND=");
        buffer.append(this.SURG_WOUND);
        buffer.append(",M0488_STAT_PRB_SURGWND=");
        buffer.append(this.STAT_PRB_SURGWND);
        buffer.append(",M0490_WHEN_DYSPNEIC=");
        buffer.append(this.WHEN_DYSPNEIC);
        buffer.append(",M0520_UR_INCONT=");
        buffer.append(this.UR_INCONT);
        buffer.append(",M0540_BWL_INCONT=");
        buffer.append(this.BWL_INCONT);
        buffer.append(",M0550_OSTOMY=");
        buffer.append(this.OSTOMY);
        buffer.append(",M0650_CUR_DRESS_UPPER=");
        buffer.append(this.CUR_DRESS_UPPER);
        buffer.append(",M0660_CUR_DRESS_LOWER=");
        buffer.append(this.CUR_DRESS_LOWER);
        buffer.append(",M0670_CUR_BATHING=");
        buffer.append(this.CUR_BATHING);
        buffer.append(",M0680_CUR_TOILETING=");
        buffer.append(this.CUR_TOILETING);
        buffer.append(",M0690_CUR_TRANSFERRING=");
        buffer.append(this.CUR_TRANSFERRING);
        buffer.append(",M0700_CUR_AMBULATION=");
        buffer.append(this.CUR_AMBULATION);
        buffer.append(",M0800_CUR_INJECT_MEDS=");
        buffer.append(this.CUR_INJECT_MEDS);
        buffer.append(",M0110_EPISODE_TIMING=");
        buffer.append(this.EPISODE_TIMING);
        buffer.append(",M0246_PMT_DIAG_ICD_A3=");
        buffer.append(this.PMT_DIAG_ICD_A3);
        buffer.append(",M0246_PMT_DIAG_ICD_B3=");
        buffer.append(this.PMT_DIAG_ICD_B3);
        buffer.append(",M0246_PMT_DIAG_ICD_C3=");
        buffer.append(this.PMT_DIAG_ICD_C3);
        buffer.append(",M0246_PMT_DIAG_ICD_D3=");
        buffer.append(this.PMT_DIAG_ICD_D3);
        buffer.append(",M0246_PMT_DIAG_ICD_E3=");
        buffer.append(this.PMT_DIAG_ICD_E3);
        buffer.append(",M0246_PMT_DIAG_ICD_F3=");
        buffer.append(this.PMT_DIAG_ICD_F3);
        buffer.append(",M0246_PMT_DIAG_ICD_A4=");
        buffer.append(this.PMT_DIAG_ICD_A4);
        buffer.append(",M0246_PMT_DIAG_ICD_B4=");
        buffer.append(this.PMT_DIAG_ICD_B4);
        buffer.append(",M0246_PMT_DIAG_ICD_C4=");
        buffer.append(this.PMT_DIAG_ICD_C4);
        buffer.append(",M0246_PMT_DIAG_ICD_D4=");
        buffer.append(this.PMT_DIAG_ICD_D4);
        buffer.append(",M0246_PMT_DIAG_ICD_E4=");
        buffer.append(this.PMT_DIAG_ICD_E4);
        buffer.append(",M0246_PMT_DIAG_ICD_F4=");
        buffer.append(this.PMT_DIAG_ICD_F4);
        buffer.append(",M0826_THER_NEED_NUM=");
        buffer.append(this.THER_NEED_NUM);
        buffer.append(",M0826_THER_NEED_NA=");
        buffer.append(this.THER_NEED_NA);
        return buffer.toString();
    }

    @Override
    public void setBlank() {
        this.START_CARE_DT = new GregorianCalendar();
        this.INFO_COMPLETED_DT = new GregorianCalendar();
        this.PRIMARY_DIAG_ICD = new DiagnosisCode();
        this.OTH_DIAG1_ICD = new DiagnosisCode();
        this.OTH_DIAG2_ICD = new DiagnosisCode();
        this.OTH_DIAG3_ICD = new DiagnosisCode();
        this.OTH_DIAG4_ICD = new DiagnosisCode();
        this.OTH_DIAG5_ICD = new DiagnosisCode();
        this.THER_NEED_NA = "";
        this.EPISODE_TIMING = "";
        this.CUR_INJECT_MEDS = "";
        this.CUR_AMBULATION = "";
        this.CUR_TRANSFERRING = "";
        this.CUR_TOILETING = "";
        this.CUR_BATHING = "";
        this.CUR_DRESS_LOWER = "";
        this.CUR_DRESS_UPPER = "";
        this.OSTOMY = "";
        this.BWL_INCONT = "";
        this.UR_INCONT = "";
        this.WHEN_DYSPNEIC = "";
        this.STAT_PRB_SURGWND = "";
        this.SURG_WOUND = "";
        this.STAT_PRB_STASULC = "";
        this.NBR_STASULC = "";
        this.STASIS_ULCER = "";
        this.STG_PRBLM_ULCER = "";
        this.NBR_PRSULC_STG4 = "";
        this.NBR_PRSULC_STG3 = "";
        this.NBR_PRSULC_STG2 = "";
        this.NBR_PRSULC_STG1 = "";
        this.LESION_OPEN_WND = "";
        this.FREQ_PAIN = "";
        this.VISION = "";
        this.THH_NONE_ABOVE = "";
        this.THH_ENT_NUTRITION = "";
        this.THH_PAR_NUTRITION = "";
        this.THH_IV_INFUSION = "";
        this.ASSMT_REASON = "";
        this.PMT_DIAG_ICD_A3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_B3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_C3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_D3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_E3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_F3 = new DiagnosisCode();
        this.PMT_DIAG_ICD_A4 = new DiagnosisCode();
        this.PMT_DIAG_ICD_B4 = new DiagnosisCode();
        this.PMT_DIAG_ICD_C4 = new DiagnosisCode();
        this.PMT_DIAG_ICD_D4 = new DiagnosisCode();
        this.PMT_DIAG_ICD_E4 = new DiagnosisCode();
        this.PMT_DIAG_ICD_F4 = new DiagnosisCode();
        this.THER_NEED_NUM = 0;
    }

    @Override
    public String getFieldValue(String fieldName) {
        String value;
        block8: {
            value = null;
            try {
                Method method = this.getClass().getMethod("get" + fieldName, null);
                this.getMethodsTable.put(fieldName, method);
                try {
                    Object obj = method.invoke((Object)this, (Object[])null);
                    if (obj == null) break block8;
                    if (obj instanceof String) {
                        value = (String)obj;
                        break block8;
                    }
                    value = obj.toString();
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
                }
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            }
        }
        return value;
    }
}

