/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

public class SeverityLimitValue {
    private final int lowerLimit;
    private final int upperLimit;
    private final char hippsSeverityValue;

    public SeverityLimitValue(int lowerLimit, int upperLimit, char hippsSeverityValue) throws IllegalArgumentException {
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException("Low limit of " + lowerLimit + " can not be larger than upperLimit of " + upperLimit);
        }
        if (lowerLimit < 0) {
            throw new IllegalArgumentException("Low limit of " + lowerLimit + " can not be less than 0");
        }
        if (upperLimit < 0) {
            throw new IllegalArgumentException("Low limit of " + lowerLimit + " can not be less than 0");
        }
        if (!Character.isLetter(hippsSeverityValue)) {
            throw new IllegalArgumentException("HIPPS Severity value must be Alphabetic - value used: '" + hippsSeverityValue + "'");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.hippsSeverityValue = Character.isUpperCase(hippsSeverityValue) ? hippsSeverityValue : Character.toUpperCase(hippsSeverityValue);
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public char getHippsSeverityValue() {
        return this.hippsSeverityValue;
    }
}

