/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.io.OasisXMLConverter;
import com.mmm.cms.homehealth.io.Oasis_B_RecordUtil;
import com.mmm.cms.homehealth.io.Oasis_C1_RecordUtil_v2_11;
import com.mmm.cms.homehealth.io.Oasis_C1_RecordUtil_v2_12;
import com.mmm.cms.homehealth.io.Oasis_C2_RecordUtil_v2_20;
import com.mmm.cms.homehealth.io.Oasis_C_RecordUtil_v2_00;
import com.mmm.cms.homehealth.io.Oasis_C_RecordUtil_v2_00a;
import com.mmm.cms.homehealth.io.Oasis_C_RecordUtil_v2_10;
import com.mmm.cms.util.Initializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class OasisReaderFactory
implements Initializable {
    public static final String PROPERTY_OASIS_RECORD_CONVERTER = "oasis.record.converters";
    private final List<OasisRecordConverterIF> converters = new ArrayList<OasisRecordConverterIF>(7);

    public OasisRecordConverterIF getRecordConverter(String oasisRecord) {
        OasisRecordConverterIF converter = null;
        if (this.converters.isEmpty()) {
            this.loadDefaultConverters();
        }
        for (OasisRecordConverterIF curConverter : this.converters) {
            if (!curConverter.isRecordConvertable(oasisRecord)) continue;
            converter = curConverter;
            break;
        }
        return converter;
    }

    protected void loadDefaultConverters() {
        this.converters.clear();
        this.converters.add(new Oasis_B_RecordUtil());
        this.converters.add(new Oasis_C_RecordUtil_v2_00());
        this.converters.add(new Oasis_C_RecordUtil_v2_00a());
        this.converters.add(new Oasis_C_RecordUtil_v2_10());
        this.converters.add(new Oasis_C1_RecordUtil_v2_11());
        this.converters.add(new Oasis_C1_RecordUtil_v2_12());
        this.converters.add(new Oasis_C2_RecordUtil_v2_20());
        this.converters.add(new OasisXMLConverter());
    }

    public List<OasisRecordConverterIF> getConverters() {
        return this.converters;
    }

    @Override
    public void init(Properties properties) throws Exception {
        String tmpStr;
        if (properties != null && (tmpStr = properties.getProperty(PROPERTY_OASIS_RECORD_CONVERTER)) != null) {
            String[] array;
            for (String item : array = tmpStr.split(" ")) {
                item = item.trim();
                OasisRecordConverterIF converter = (OasisRecordConverterIF)Class.forName(item).newInstance();
                this.converters.add(converter);
            }
        }
        if (this.converters.isEmpty()) {
            this.loadDefaultConverters();
        }
        if (properties != null) {
            for (OasisRecordConverterIF converter : this.converters) {
                String classname = converter.getClass().getName();
                tmpStr = properties.getProperty(classname + ".start.date");
                if (tmpStr != null) {
                    converter.setStartDate(tmpStr);
                }
                if ((tmpStr = properties.getProperty(classname + ".end.date")) == null) continue;
                converter.setEndDate(tmpStr);
            }
        }
    }
}

