/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.io.OasisXMLConverter;
import com.mmm.cms.homehealth.io.Oasis_C1_Record_2_11;
import com.mmm.cms.homehealth.io.Oasis_C1_Record_2_12;
import com.mmm.cms.homehealth.io.Oasis_C2_Record_2_20;
import com.mmm.cms.homehealth.io.Oasis_C_Record;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OasisXmlHandler
extends DefaultHandler {
    private final List<HomeHealthRecordIF> records = new ArrayList<HomeHealthRecordIF>();
    private transient String currentElementName;
    private final transient StringBuilder currentElementValue = new StringBuilder();
    private final Map<String, String> tagValues = new HashMap<String, String>();
    private transient Map<String, Method> fieldMethods = new HashMap<String, Method>();
    private transient Map<String, Class> homeHealthRecordFactory = new HashMap<String, Class>(10);

    public OasisXmlHandler() {
        this.homeHealthRecordFactory.put("DEFAULT", Oasis_C2_Record_2_20.class);
        this.homeHealthRecordFactory.put("2.10", Oasis_C_Record.class);
        this.homeHealthRecordFactory.put("2.11", Oasis_C1_Record_2_11.class);
        this.homeHealthRecordFactory.put("2.12", Oasis_C1_Record_2_12.class);
        this.homeHealthRecordFactory.put("2.20", Oasis_C2_Record_2_20.class);
        this.homeHealthRecordFactory.put("02.00", Oasis_C_Record.class);
        this.homeHealthRecordFactory.put("2.00", Oasis_C_Record.class);
    }

    public List<HomeHealthRecordIF> getRecords() {
        return this.records;
    }

    @Override
    public void characters(char[] chars, int startIdx, int endIdx) throws SAXException {
        this.currentElementValue.append(chars, startIdx, endIdx);
    }

    @Override
    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        if ("ASSESSMENT".equalsIgnoreCase(qualifiedName)) {
            String tmpStr = this.tagValues.get("SPEC_VRSN_CD");
            if (tmpStr != null) {
                Class clazz = this.homeHealthRecordFactory.get(tmpStr);
                if (clazz == null) {
                    clazz = this.homeHealthRecordFactory.get("DEFAULT");
                }
                try {
                    HomeHealthRecordIF currentRecord = (HomeHealthRecordIF)clazz.newInstance();
                    this.fillInRecord(currentRecord);
                    if (currentRecord.getPRIMARY_DIAG_ICD() == null) {
                        currentRecord.setPRIMARY_DIAG_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getOTH_DIAG1_ICD() == null) {
                        currentRecord.setOTH_DIAG1_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getOTH_DIAG2_ICD() == null) {
                        currentRecord.setOTH_DIAG2_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getOTH_DIAG3_ICD() == null) {
                        currentRecord.setOTH_DIAG3_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getOTH_DIAG4_ICD() == null) {
                        currentRecord.setOTH_DIAG4_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getOTH_DIAG5_ICD() == null) {
                        currentRecord.setOTH_DIAG5_ICD(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_A3() == null) {
                        currentRecord.setPMT_DIAG_ICD_A3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_B3() == null) {
                        currentRecord.setPMT_DIAG_ICD_B3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_C3() == null) {
                        currentRecord.setPMT_DIAG_ICD_C3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_D3() == null) {
                        currentRecord.setPMT_DIAG_ICD_D3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_E3() == null) {
                        currentRecord.setPMT_DIAG_ICD_E3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_F3() == null) {
                        currentRecord.setPMT_DIAG_ICD_F3(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_A4() == null) {
                        currentRecord.setPMT_DIAG_ICD_A4(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_B4() == null) {
                        currentRecord.setPMT_DIAG_ICD_B4(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_C4() == null) {
                        currentRecord.setPMT_DIAG_ICD_C4(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_D4() == null) {
                        currentRecord.setPMT_DIAG_ICD_D4(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_E4() == null) {
                        currentRecord.setPMT_DIAG_ICD_E4(new DiagnosisCode());
                    }
                    if (currentRecord.getPMT_DIAG_ICD_F4() == null) {
                        currentRecord.setPMT_DIAG_ICD_F4(new DiagnosisCode());
                    }
                    this.records.add(currentRecord);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(OasisXMLConverter.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(OasisXMLConverter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            this.tagValues.put(this.currentElementName, this.currentElementValue.toString());
            this.currentElementValue.setLength(0);
        }
    }

    public void fillInRecord(HomeHealthRecordIF record) {
        Set<String> keySet = this.tagValues.keySet();
        for (String key : keySet) {
            String value = this.tagValues.get(key);
            this.fillInRecordValue(record, key, value);
        }
    }

    public void fillInRecordValue(HomeHealthRecordIF record, String tag, String value) {
        try {
            Object settingObj;
            Class[] clazzParams;
            if (tag.indexOf("_DIAG", 0) > -1) {
                clazzParams = new Class[]{DiagnosisCodeIF.class};
                settingObj = new DiagnosisCode("^".equals(value = HomeHealthRecordUtil.trimWithCarets(value)) ? "" : value);
            } else if (tag.startsWith("M0030") || tag.startsWith("M0090")) {
                clazzParams = new Class[]{Calendar.class};
                settingObj = OasisCalendarFormatter.parse(value.substring(0, 8));
            } else if (tag.indexOf("NEED_NUM", 0) > -1 || tag.indexOf("NEED_NBR", 0) > -1) {
                clazzParams = new Class[]{Integer.TYPE};
                settingObj = HomeHealthRecordUtil.parseTherapyNeedNumber_C1(value, -1);
            } else {
                clazzParams = new Class[]{String.class};
                settingObj = value.intern();
            }
            Method method = this.getSetMethod(record, tag, clazzParams);
            method.setAccessible(true);
            method.invoke((Object)record, settingObj);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (ParseException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "HH-PPS: ", ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes arg3) throws SAXException {
        if ("ASSESSMENT".equalsIgnoreCase(qualifiedName)) {
            this.tagValues.clear();
        } else {
            this.currentElementName = qualifiedName;
            this.currentElementValue.setLength(0);
        }
    }

    protected Method getSetMethod(Object obj, String fieldName, Class[] params) throws NoSuchMethodException {
        String methodName = "set" + this.getBaseMethodName(fieldName);
        Method method = this.fieldMethods.get(methodName);
        if (method == null) {
            Class<?> clazz = obj.getClass();
            method = clazz.getMethod(methodName, params);
            this.fieldMethods.put(methodName, method);
        }
        return method;
    }

    private String getBaseMethodName(String variableName) {
        String retName = null;
        if (variableName.charAt(0) == 'M') {
            if (variableName.startsWith("M1311")) {
                if (variableName.equals("M1311_NSTG_DEEP_TSUE_F1")) {
                    retName = "NSTG_DEEP_TISUE";
                } else {
                    retName = variableName.substring(6);
                    retName = retName.substring(0, retName.length() - 3);
                }
            } else {
                retName = variableName.substring(6);
            }
        } else {
            retName = variableName;
        }
        return retName;
    }
}

