/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.pps;

import com.mmm.cms.homehealth.HomeHealthGrouperFactory;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.io.OasisReaderFactory;
import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import java.io.File;
import java.io.FileReader;
import java.text.ParseException;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HH_PPS {
    private long gcInterval = 120000L;
    private transient long lastGC;
    protected boolean initComplete;
    protected HomeHealthGrouperFactory homeHealthFactory;
    protected OasisReaderFactory readerFactory = new OasisReaderFactory();
    protected static final HH_PPS gHhPps = new HH_PPS();

    public static HH_PPS getInstance() {
        return gHhPps;
    }

    private HH_PPS() {
    }

    public void init() {
        this.init((Properties)null);
    }

    public void init(File propertiesFile) {
        try {
            Properties properties = new Properties();
            FileReader reader = new FileReader(propertiesFile);
            properties.load(reader);
            this.init(properties);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: init() - no not load properties file: '" + propertiesFile + "'", ex);
        }
    }

    public void init(Properties properties) {
        if (!this.initComplete) {
            try {
                String strGcInterval;
                this.homeHealthFactory = new HomeHealthGrouperFactory();
                this.homeHealthFactory.init(properties);
                if (properties == null) {
                    properties = this.homeHealthFactory.getProperties();
                }
                this.initComplete = true;
                this.readerFactory.init(properties);
                if (properties != null && (strGcInterval = properties.getProperty("gcInterval")) != null) {
                    try {
                        this.gcInterval = Long.parseLong(strGcInterval);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: init() ", ex);
            }
        }
    }

    public ScoringResultsIF scoreRecord(String record) {
        return this.scoreRecord(record, true, null, null);
    }

    public ScoringResultsIF scoreRecord(String record, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringResultsIF results;
        try {
            if (this.initComplete) {
                if (this.gcInterval >= 1000L && System.currentTimeMillis() - this.lastGC > this.gcInterval) {
                    System.gc();
                    this.lastGC = System.currentTimeMillis();
                }
            } else {
                throw new Exception(this.getClass().getName() + ".init() must be called once prior to calling scoreRecord()");
            }
            HomeHealthRecordIF homeHealthRecord = this.convertRecord(record);
            results = this.scoreRecord(homeHealthRecord, validateDates, validationEdits, listeners);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Exception: " + e.toString(), e);
            results = new ScoringResults();
            results.setException(e);
        }
        return results;
    }

    public ScoringResultsIF scoreRecord(HomeHealthRecordIF homeHealthRecord, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringResultsIF results;
        block5: {
            try {
                if (this.initComplete) {
                    HomeHealthGrouperIF grouper = this.homeHealthFactory.getGrouper(homeHealthRecord);
                    if (grouper != null) {
                        results = grouper.score(homeHealthRecord, validateDates, validationEdits, listeners);
                    } else {
                        results = new ScoringResults();
                        results.setException(new Exception("No Grouper found for record."));
                    }
                    break block5;
                }
                throw new Exception(this.getClass().getName() + ".init() must be called once prior to calling scoreRecord()");
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Exception: " + e.toString(), e);
                results = new ScoringResults();
                results.setException(e);
            }
        }
        return results;
    }

    public HomeHealthRecordIF convertRecord(String strRecord) {
        HomeHealthRecordIF record = null;
        OasisRecordConverterIF recordConverter = this.readerFactory.getRecordConverter(strRecord);
        if (recordConverter != null) {
            try {
                record = recordConverter.convertToHomeHealthRec(strRecord, 1, true);
            }
            catch (ParseException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Could not convert record with cnoverter: " + recordConverter.getClass().getName(), ex);
            }
        }
        return record;
    }
}

