/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.test;

import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.io.Oasis_B_RecordUtil;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class OasisRecord_B_ReadWriteTest {
    public static final String DURING_READTEST = "During ReadTest: ";
    public static final String ELAPSED_TIME = " elapsed time: ";
    public static final String SUFFIX = "_TESTOUT";
    private String inputFilename;
    private String outputFilename;
    private Properties properties;

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public static void main(String[] args) {
        OasisRecord_B_ReadWriteTest tester = new OasisRecord_B_ReadWriteTest();
        tester.runTests(args);
    }

    public int parseArguments(String[] args) {
        int count = 0;
        if (args.length > 0) {
            String configFilename = null;
            Pattern pattern = Pattern.compile("=");
            for (String arg : args) {
                String[] tokens = pattern.split(arg);
                if ("CONFIG".equalsIgnoreCase(tokens[0])) {
                    ++count;
                    configFilename = tokens[1];
                    continue;
                }
                if ("OUTPUTFILE".equalsIgnoreCase(tokens[0])) {
                    ++count;
                    this.outputFilename = tokens[1];
                    continue;
                }
                if (!"INPUT".equalsIgnoreCase(tokens[0])) continue;
                ++count;
                this.inputFilename = tokens[1];
            }
            if (this.outputFilename == null) {
                int idx = this.inputFilename.lastIndexOf(".");
                this.outputFilename = idx > -1 ? this.inputFilename.substring(0, idx) + SUFFIX + this.inputFilename.substring(idx) : this.inputFilename + SUFFIX;
            }
            if (configFilename != null) {
                this.properties = new Properties();
                try {
                    this.properties.load(new FileInputStream(configFilename));
                }
                catch (IOException ex) {
                    Logger.getLogger(OasisRecord_B_ReadWriteTest.class.getName()).log(Level.SEVERE, "HH-PPS: Could not open properties file: " + args[1], ex);
                }
            }
            System.out.println("Input file is: " + this.inputFilename);
            System.out.println("Output file is: " + this.outputFilename);
        } else {
            count = 0;
            System.out.println("Syntax: OasisRecordReadWriteTest \"input file name\" <output file name - optional>");
        }
        return count;
    }

    public void runTests(String[] args) {
        if (this.parseArguments(args) > 0) {
            long elapsedTime;
            long starttime;
            try {
                starttime = System.currentTimeMillis();
                int count = this.readTest(new File(this.inputFilename));
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Records read: " + count + "," + ELAPSED_TIME + elapsedTime);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(OasisRecord_B_ReadWriteTest.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest: ", ex);
                System.out.println(DURING_READTEST + ex);
                System.exit(2);
            }
            catch (IOException ex) {
                Logger.getLogger(OasisRecord_B_ReadWriteTest.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest: ", ex);
                System.out.println(DURING_READTEST + ex);
                System.exit(3);
            }
            try {
                starttime = System.currentTimeMillis();
                List<HomeHealthRecordIF> oasisRecords = this.readConvertTest(new File(this.inputFilename));
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Oasis Records read: " + oasisRecords.size() + "," + ELAPSED_TIME + elapsedTime);
                starttime = System.currentTimeMillis();
                this.writeTest(oasisRecords, new File(this.outputFilename));
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Oasis Records written: " + oasisRecords.size() + "," + ELAPSED_TIME + elapsedTime);
                starttime = System.currentTimeMillis();
                this.writeTestDelimitted(oasisRecords, new File(this.outputFilename + ".delimited.txt"), "\t");
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Oasis Records written: " + oasisRecords.size() + "," + ELAPSED_TIME + elapsedTime);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(OasisRecord_B_ReadWriteTest.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest: ", ex);
                System.out.println(DURING_READTEST + ex);
                System.exit(2);
            }
            catch (IOException ex) {
                Logger.getLogger(OasisRecord_B_ReadWriteTest.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest: ", ex);
                System.out.println(DURING_READTEST + ex);
                System.exit(3);
            }
        }
    }

    public OasisRecordConverterIF getConverterReader() {
        return new Oasis_B_RecordUtil();
    }

    public OasisRecordConverterIF getConverterWriter() {
        return new Oasis_B_RecordUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readTest(File input) throws FileNotFoundException, IOException {
        int idx = 1;
        FileReader fileReader = new FileReader(input);
        try (BufferedReader reader = new BufferedReader(fileReader);){
            while (reader.readLine() != null) {
                ++idx;
            }
        }
        return --idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HomeHealthRecordIF> readConvertTest(File input) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(input);
        try (BufferedReader reader = new BufferedReader(fileReader, 16384);){
            List<HomeHealthRecordIF> list = this.readConvertTest(reader);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HomeHealthRecordIF> readConvertTest(Reader reader) throws FileNotFoundException, IOException {
        int idx = 1;
        OasisRecordConverterIF recordConverter = this.getConverterReader();
        BufferedReader bufReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 16384);
        ArrayList<HomeHealthRecordIF> records = new ArrayList<HomeHealthRecordIF>();
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                try {
                    if (idx == 14714) {
                        System.out.println("Found input record number " + idx);
                    }
                    HomeHealthRecordIF record = recordConverter.convertToHomeHealthRec(line, idx++);
                    records.add(record);
                }
                catch (ParseException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Could convert record: " + ex, ex);
                }
            }
        }
        finally {
            reader.close();
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTest(List<HomeHealthRecordIF> oasisRecords, File output) throws IOException {
        OasisRecordConverterIF recordConverter = this.getConverterWriter();
        int count = 0;
        Logger logger = Logger.getLogger(this.getClass().getName());
        FileWriter fileWriter = new FileWriter(output);
        try (BufferedWriter writer = new BufferedWriter(fileWriter);){
            for (HomeHealthRecordIF record : oasisRecords) {
                ++count;
                try {
                    StringBuilder line = recordConverter.convertFromHomeHealthRec(record);
                    writer.write(line.toString());
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, "Record with error: " + record);
                    logger.log(Level.SEVERE, "Error Writing record item: " + count, ex);
                }
            }
        }
        logger.log(Level.INFO, "Number of records written: {0}", count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTestDelimitted(List<HomeHealthRecordIF> oasisRecords, File output, String delimiter) throws IOException {
        OasisRecordConverterIF recordConverter = this.getConverterWriter();
        FileWriter fileWriter = new FileWriter(output);
        try (BufferedWriter writer = new BufferedWriter(fileWriter);){
            for (HomeHealthRecordIF record : oasisRecords) {
                StringBuilder line = recordConverter.convertFromHomeHealthRecDelimeted(record, delimiter);
                writer.write(line.toString());
            }
        }
    }
}

