/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v2308_1;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.util.HomeHealthUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class NRS_ScoringModel_v2308
implements HomeHealthScoringModelIF {
    static String SET_TO_0 = " set to 0";
    private final GrouperDataManager grouperDataManager;
    private HomeHealthGrouperIF grouper;
    public static final String SHORTNAME = "NRS Equation";

    public NRS_ScoringModel_v2308(HomeHealthGrouperIF grouper, GrouperDataManager dataManager) {
        this.grouper = grouper;
        this.grouperDataManager = dataManager;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        int tmpScore;
        String tmpStr;
        ScoringPoints scorePoints = new ScoringPoints(1);
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Main scoring module");
        this.preprocessRecord(record, validator);
        int[] codePoints = this.calculateInitialScore(record, validator);
        this.determinePrimaryDiagnosis(record, validator, codePoints);
        this.recalculateNonPrimaryCodes(record, validator, codePoints, null);
        this.resolveEtiologyManifestationContention(record, validator, codePoints, null);
        int score = this.scoreRemainingVariables(record, validator, codePoints);
        int skinConditionScore = score + HomeHealthUtils.sumIntArray(codePoints);
        if (validator.isOSTOMY_Valid()) {
            tmpStr = record.getOSTOMY();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(43);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY", 43, tmpScore);
                if (skinConditionScore > 0) {
                    tmpScore = this.getCaseMixAdjustmentEquation(45);
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY and skin score > 0", 45, tmpScore);
                }
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(44);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY", 44, tmpScore);
                if (skinConditionScore > 0) {
                    score += this.getCaseMixAdjustmentEquation(46);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY and skin score > 0", 46, tmpScore);
                }
            }
        }
        if (validator.isTHERAPIES_Valid() && validator.isINTERNAL_LOGIC_Valid() && "1".equals(record.getTHH_IV_INFUSION())) {
            tmpScore = this.getCaseMixAdjustmentEquation(47);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to THH_IV_INFUSION", 47, tmpScore);
        }
        if (validator.isUR_INCONT_Valid() && "02".equals(record.getUR_INCONT())) {
            tmpScore = this.getCaseMixAdjustmentEquation(48);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UR_INCONT", 48, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ((tmpStr = record.getBWL_INCONT()).equals("04") || tmpStr.equals("05"))) {
            tmpScore = this.getCaseMixAdjustmentEquation(49);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to BWL_INCONT", 49, tmpScore);
        }
        scorePoints.setScoreAt(0, score += HomeHealthUtils.sumIntArray(codePoints));
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Main scoring module", score);
        return scorePoints;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        return this.score(record, validator);
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        return this.score(record, validator);
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Pre-process record");
        DiagnosisCodeIF primaryCode = record.getPRIMARY_DIAG_ICD();
        if (primaryCode.isValidForScoring() && primaryCode.isDiabeticUlcer()) {
            this.setUlcerDiagnosisScoring(record, primaryCode);
        }
        if ((primaryCode = record.getPMT_DIAG_ICD_A3()).isValidForScoring() && primaryCode.isDiabeticUlcer()) {
            this.setUlcerDiagnosisScoring(record, primaryCode);
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Pre-process record", 0);
    }

    private void setUlcerDiagnosisScoring(HomeHealthRecordIF record, DiagnosisCodeIF primaryCode) {
        DiagnosisCodeIF code = record.getOTH_DIAG1_ICD();
        if (code.isUlcer()) {
            primaryCode.setDiagnosticGroup(this.grouperDataManager.getNRSDiagnosticGroup(3L));
            code.setDiagnosticGroup(this.grouperDataManager.getNRSDiagnosticGroup(0L));
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diabeic Ulcer: Set " + primaryCode.getCode() + " Group to 3 and " + code.getCode() + " to 0.");
        } else if (code.isOptionalPaymentCode()) {
            code = record.getPMT_DIAG_ICD_B3();
            if (code.isUlcer()) {
                primaryCode.setDiagnosticGroup(this.grouperDataManager.getNRSDiagnosticGroup(3L));
                code.setDiagnosticGroup(this.grouperDataManager.getNRSDiagnosticGroup(0L));
                ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diabeic Ulcer: Set " + primaryCode.getCode() + " Group to 3 and " + code.getCode() + " to 0.");
            } else {
                primaryCode.setValidForScoring(false);
                ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diabeic Ulcer: Set " + primaryCode.getCode() + " to NOT score.");
            }
        } else {
            primaryCode.setValidForScoring(false);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Diabeic Ulcer: Set " + primaryCode.getCode() + " to NOT score due to non-optional VCode.");
        }
    }

    private String getCodePointsPositionHeader(int idx, DiagnosisCodeIF code) {
        return "Diagnosis code '" + code.getCode() + "' at position " + ++idx + " ";
    }

    public int[] calculateInitialScore(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "calculateInitialScore");
        int[] codePoints = new int[18];
        boolean[] nrsDiagGroupsUsed = new boolean[22];
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        if (code.isValidForScoring() && code.getDiagnosticGroup().getId() == 3) {
            codePoints[0] = codePoints[0] + this.getCaseMixAdjustmentEquation(5);
            nrsDiagGroupsUsed[2] = true;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(0, code), 5, codePoints[0]);
        }
        if ((code = record.getPMT_DIAG_ICD_A3()).isValidForScoring() && code.getDiagnosticGroup().getId() == 3) {
            codePoints[6] = codePoints[6] + this.getCaseMixAdjustmentEquation(5);
            nrsDiagGroupsUsed[2] = true;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(6, code), 5, codePoints[6]);
        }
        block13: for (int idx = 0; idx < codePoints.length; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (!code.isValidForScoring()) {
                if (!code.isValidCode()) {
                    if (code.isEmpty()) continue;
                    ScoringEventFormatter.fireScoringWarning(this.grouper.getEventListenersList(), this.grouper, this, "Diagnosis code '" + code.getCode() + "' at position " + (idx + 1) + " is NOT a valid code.");
                    continue;
                }
                ScoringEventFormatter.fireScoringWarning(this.grouper.getEventListenersList(), this.grouper, this, "Diagnosis code '" + code.getCode() + "' at position " + (idx + 1) + " is valid code BUT NOT valid for scoring.");
                continue;
            }
            int diagGroupId = code.getDiagnosticGroup().getId();
            switch (diagGroupId) {
                case 1: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(1);
                    nrsDiagGroupsUsed[0] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 1);
                    continue block13;
                }
                case 2: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(3);
                    nrsDiagGroupsUsed[1] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 3);
                    continue block13;
                }
                case 4: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(6);
                    nrsDiagGroupsUsed[3] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 6);
                    continue block13;
                }
                case 5: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(8);
                    nrsDiagGroupsUsed[4] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 8);
                    continue block13;
                }
                case 6: {
                    if (nrsDiagGroupsUsed[2]) continue block13;
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(10);
                    nrsDiagGroupsUsed[5] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 10);
                    continue block13;
                }
                case 7: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(11);
                    nrsDiagGroupsUsed[6] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 11);
                    continue block13;
                }
                case 8: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(13);
                    nrsDiagGroupsUsed[7] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 13);
                    continue block13;
                }
                case 9: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(15);
                    nrsDiagGroupsUsed[8] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 15);
                    continue block13;
                }
                case 10: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(17);
                    nrsDiagGroupsUsed[9] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 17);
                    continue block13;
                }
                case 11: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(18);
                    nrsDiagGroupsUsed[10] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 18);
                    continue block13;
                }
                case 12: {
                    int n = idx;
                    codePoints[n] = codePoints[n] + this.getCaseMixAdjustmentEquation(19);
                    nrsDiagGroupsUsed[11] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 19);
                    continue block13;
                }
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "calculateInitialScore", codePoints);
        return codePoints;
    }

    public void determinePrimaryDiagnosis(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePoints) {
        DiagnosisCodeIF M0230_PRIMARY_DIAG_ICD = record.getPRIMARY_DIAG_ICD();
        DiagnosisCodeIF M0240_OTH_DIAG1_ICD = record.getOTH_DIAG1_ICD();
        DiagnosisCodeIF M0246_PMT_DIAG_ICD_A3 = record.getPMT_DIAG_ICD_A3();
        DiagnosisCodeIF M0246_PMT_DIAG_ICD_A4 = record.getPMT_DIAG_ICD_A4();
        M0230_PRIMARY_DIAG_ICD.setPrimary(false);
        M0240_OTH_DIAG1_ICD.setPrimary(false);
        M0246_PMT_DIAG_ICD_A3.setPrimary(false);
        M0246_PMT_DIAG_ICD_A4.setPrimary(false);
        if (M0246_PMT_DIAG_ICD_A4.isValidForScoring() && M0246_PMT_DIAG_ICD_A4.isSecondaryOnly()) {
            if (M0246_PMT_DIAG_ICD_A3.isValidCode()) {
                if (M0246_PMT_DIAG_ICD_A4.getDiagnosticGroup().getId() == M0246_PMT_DIAG_ICD_A3.getDiagnosticGroup().getId()) {
                    M0246_PMT_DIAG_ICD_A3.setPrimary(true);
                } else {
                    M0246_PMT_DIAG_ICD_A3.setPrimary(true);
                    M0246_PMT_DIAG_ICD_A4.setPrimary(true);
                }
            } else {
                M0246_PMT_DIAG_ICD_A4.setPrimary(true);
            }
        } else if (M0246_PMT_DIAG_ICD_A3.isValidForScoring()) {
            M0246_PMT_DIAG_ICD_A3.setPrimary(true);
        } else if (M0240_OTH_DIAG1_ICD.isSecondaryOnly()) {
            if (M0230_PRIMARY_DIAG_ICD.isValidCode()) {
                if (M0230_PRIMARY_DIAG_ICD.getDiagnosticGroup().getId() == M0240_OTH_DIAG1_ICD.getDiagnosticGroup().getId()) {
                    M0230_PRIMARY_DIAG_ICD.setPrimary(true);
                } else if (codePoints[1] > codePoints[0]) {
                    M0240_OTH_DIAG1_ICD.setPrimary(true);
                } else {
                    M0230_PRIMARY_DIAG_ICD.setPrimary(true);
                }
            } else {
                M0240_OTH_DIAG1_ICD.setPrimary(true);
            }
        } else {
            M0230_PRIMARY_DIAG_ICD.setPrimary(true);
        }
    }

    public boolean[] resolveEtiologyManifestationContention(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePoints, boolean[] diagGroupsUsed) {
        DiagnosisCodeIF tmpCode;
        int idx;
        int diagGroupId;
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "resolve Etiology Manifestation Contention");
        boolean[] nrsDiagGroupsUsed = new boolean[22];
        boolean[] pointsLost = new boolean[18];
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        if (code.isValidCode() && (diagGroupId = code.getDiagnosticGroup().getId()) > 0 && codePoints[0] > 0) {
            nrsDiagGroupsUsed[diagGroupId - 1] = true;
        }
        if ((code = record.getPMT_DIAG_ICD_A3()).isValidCode() && (diagGroupId = code.getDiagnosticGroup().getId()) > 0 && codePoints[6] > 0) {
            if (nrsDiagGroupsUsed[diagGroupId - 1]) {
                codePoints[6] = 0;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(6, code) + SET_TO_0, 7, 0);
            } else {
                nrsDiagGroupsUsed[diagGroupId - 1] = true;
            }
        }
        if ((code = record.getPMT_DIAG_ICD_A4()).isValidCode() && (diagGroupId = code.getDiagnosticGroup().getId()) > 0 && codePoints[12] > 0) {
            if (nrsDiagGroupsUsed[diagGroupId - 1]) {
                codePoints[12] = 0;
            } else {
                if (code.isSecondaryOnly() && codePoints[6] > 0) {
                    if (codePoints[12] > codePoints[6]) {
                        codePoints[6] = 0;
                        ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(6, code) + SET_TO_0, 12, 0);
                        nrsDiagGroupsUsed[diagGroupId - 1] = true;
                        pointsLost[6] = true;
                    } else {
                        codePoints[12] = 0;
                        ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(12, code) + SET_TO_0, 12, 0);
                        pointsLost[12] = true;
                    }
                }
                if (codePoints[12] > 0) {
                    nrsDiagGroupsUsed[diagGroupId - 1] = true;
                }
            }
        }
        for (idx = 1; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (!code.isValidCode() || (diagGroupId = code.getDiagnosticGroup().getId()) <= 0 || codePoints[idx] <= 0) continue;
            if (nrsDiagGroupsUsed[diagGroupId - 1]) {
                codePoints[idx] = 0;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code) + SET_TO_0, idx, 0);
                continue;
            }
            if (code.isSecondaryOnly() && codePoints[idx - 1] > 0) {
                if (codePoints[idx] > codePoints[idx - 1]) {
                    codePoints[idx - 1] = 0;
                    tmpCode = record.getDiagnosisCode(idx - 1);
                    if (tmpCode != null && tmpCode.getDiagnosticGroup().getId() > 0) {
                        nrsDiagGroupsUsed[tmpCode.getDiagnosticGroup().getId() - 1] = true;
                    }
                    pointsLost[idx - 1] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx - 1, code) + SET_TO_0, idx, 0);
                } else {
                    codePoints[idx] = 0;
                    pointsLost[idx] = true;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code) + SET_TO_0, idx, 0);
                }
            }
            if (codePoints[idx] <= 0) continue;
            nrsDiagGroupsUsed[diagGroupId - 1] = true;
        }
        idx = 1;
        int scoreIdx = 7;
        while (idx < 6) {
            code = record.getOptionalDiagnosisCode3(idx);
            if (code.isValidCode() && (diagGroupId = code.getDiagnosticGroup().getId()) > 0) {
                if (nrsDiagGroupsUsed[diagGroupId - 1]) {
                    codePoints[scoreIdx] = 0;
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(scoreIdx, code) + SET_TO_0, scoreIdx, 0);
                } else if (codePoints[scoreIdx] > 0) {
                    nrsDiagGroupsUsed[diagGroupId - 1] = true;
                }
            }
            ++idx;
            ++scoreIdx;
        }
        idx = 1;
        scoreIdx = 13;
        while (idx < 6) {
            code = record.getOptionalDiagnosisCode4(idx);
            if (code.isValidCode() && (diagGroupId = code.getDiagnosticGroup().getId()) > 0) {
                if (nrsDiagGroupsUsed[diagGroupId - 1]) {
                    codePoints[scoreIdx] = 0;
                } else {
                    if (code.isSecondaryOnly() && codePoints[scoreIdx - 6] > 0) {
                        if (codePoints[scoreIdx] > codePoints[scoreIdx - 6]) {
                            codePoints[scoreIdx - 6] = 0;
                            tmpCode = record.getDiagnosisCode(idx - 6);
                            if (tmpCode != null && tmpCode.getDiagnosticGroup().getId() > 0) {
                                nrsDiagGroupsUsed[tmpCode.getDiagnosticGroup().getId() - 1] = true;
                            }
                            pointsLost[scoreIdx - 6] = true;
                            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(scoreIdx - 6, code) + SET_TO_0, scoreIdx, 0);
                        } else {
                            codePoints[scoreIdx] = 0;
                            pointsLost[scoreIdx] = true;
                            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(scoreIdx, code) + SET_TO_0, scoreIdx, 0);
                        }
                    }
                    if (codePoints[scoreIdx] > 0) {
                        nrsDiagGroupsUsed[diagGroupId - 1] = true;
                    }
                }
            }
            ++idx;
            ++scoreIdx;
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "resolve Etiology Manifestation Contention", codePoints);
        return pointsLost;
    }

    public void recalculateNonPrimaryCodes(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePoints, int[] dualPoints) {
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "recalculate Non-Primary Codes");
        block9: for (int idx = 0; idx < codePoints.length; ++idx) {
            DiagnosisCodeIF code = record.getDiagnosisCode(idx);
            if (!code.isValidForScoring() || code.isPrimary()) continue;
            int groupId = code.getDiagnosticGroup().getId();
            switch (groupId) {
                case 1: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(2);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 2);
                    continue block9;
                }
                case 2: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(4);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 4);
                    continue block9;
                }
                case 4: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(7);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 7);
                    continue block9;
                }
                case 5: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(9);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 9);
                    continue block9;
                }
                case 7: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(12);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 12);
                    continue block9;
                }
                case 8: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(14);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 14);
                    continue block9;
                }
                case 9: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(16);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, this.getCodePointsPositionHeader(idx, code), idx, 16);
                    continue block9;
                }
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "recalculate Non-Primary Codes", codePoints);
    }

    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] points) {
        String tmpStr;
        int tmpScore;
        int score = 0;
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "calculate Special Items");
        if (validator.isNPRSULC1_Valid()) {
            if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                tmpScore = this.getCaseMixAdjustmentEquation(20);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG1", 20, tmpScore);
            } else if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR})) {
                tmpScore = this.getCaseMixAdjustmentEquation(21);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG1", 21, tmpScore);
            }
        }
        if (validator.isNPRSULC2_Valid()) {
            tmpStr = record.getNBR_PRSULC_STG2();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(22);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 22, tmpScore);
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(23);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 23, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(24);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 24, tmpScore);
            } else if ("04".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(25);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG2", 25, tmpScore);
            }
        }
        if (validator.isNPRSULC3_Valid()) {
            tmpStr = record.getNBR_PRSULC_STG3();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(26);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 26, tmpScore);
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(27);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 27, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(28);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 28, tmpScore);
            } else if ("04".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(29);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3", 29, tmpScore);
            }
        }
        if (validator.isNPRSULC4_Valid()) {
            tmpStr = record.getNBR_PRSULC_STG4();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(30);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 30, tmpScore);
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(31);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 31, tmpScore);
            } else if ("03".equals(tmpStr) || "04".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(32);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG4", 32, tmpScore);
            }
        }
        if (validator.isUNOBS_PRSULC_Valid() && "1".equals(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC())) {
            tmpScore = this.getCaseMixAdjustmentEquation(33);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UNOBS_PRSULC", 33, tmpScore);
        }
        if (validator.isNBR_STASULC_Valid()) {
            tmpStr = record.getNBR_STAS_ULCR();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(34);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 34, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(35);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 35, tmpScore);
            } else if ("04".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(36);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_STASULC", 36, tmpScore);
            }
        }
        if (validator.isUNOBS_STASULC_Valid() && "1".equals(((HomeHealthRecord_B_IF)record).getUNOBS_STASULC())) {
            tmpScore = this.getCaseMixAdjustmentEquation(37);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to UNOBS_STASULC", 37, tmpScore);
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpStr = record.getSTUS_PRBLM_STAS_ULCR();
            if ("01".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(38);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 38, tmpScore);
            } else if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(39);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 39, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(40);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 40, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpStr = record.getSTUS_PRBLM_SRGCL_WND();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(41);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 41, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(42);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 42, tmpScore);
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "calculate Special Items", score);
        return score;
    }

    @Override
    public void populateCodes(HomeHealthRecordIF record) {
        record.setPRIMARY_DIAG_ICD(this.getDiagnosisCode(record.getPRIMARY_DIAG_ICD().getCode()));
        record.setOTH_DIAG1_ICD(this.getDiagnosisCode(record.getOTH_DIAG1_ICD().getCode()));
        record.setOTH_DIAG2_ICD(this.getDiagnosisCode(record.getOTH_DIAG2_ICD().getCode()));
        record.setOTH_DIAG3_ICD(this.getDiagnosisCode(record.getOTH_DIAG3_ICD().getCode()));
        record.setOTH_DIAG4_ICD(this.getDiagnosisCode(record.getOTH_DIAG4_ICD().getCode()));
        record.setOTH_DIAG5_ICD(this.getDiagnosisCode(record.getOTH_DIAG5_ICD().getCode()));
        record.setPMT_DIAG_ICD_A3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_A3().getCode()));
        record.setPMT_DIAG_ICD_B3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_B3().getCode()));
        record.setPMT_DIAG_ICD_C3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_C3().getCode()));
        record.setPMT_DIAG_ICD_D3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_D3().getCode()));
        record.setPMT_DIAG_ICD_E3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_E3().getCode()));
        record.setPMT_DIAG_ICD_F3(this.getDiagnosisCode(record.getPMT_DIAG_ICD_F3().getCode()));
        record.setPMT_DIAG_ICD_A4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_A4().getCode()));
        record.setPMT_DIAG_ICD_B4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_B4().getCode()));
        record.setPMT_DIAG_ICD_C4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_C4().getCode()));
        record.setPMT_DIAG_ICD_D4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_D4().getCode()));
        record.setPMT_DIAG_ICD_E4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_E4().getCode()));
        record.setPMT_DIAG_ICD_F4(this.getDiagnosisCode(record.getPMT_DIAG_ICD_F4().getCode()));
    }

    @Override
    public String getName() {
        return "Non-Routine Supplies Scoring Model 2308";
    }

    @Override
    public void setName(String arg0) {
    }

    public int getCaseMixAdjustmentEquation(int caseMixId) {
        CaseMixAdjustmentItemIF nrsCasemix = this.grouperDataManager.getNRSCaseMixAdjustment(caseMixId);
        return nrsCasemix != null ? nrsCasemix.getEarly13AndUnder() : 0;
    }

    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getNRSDiagnosisCode(codeValue)) == null) {
            code = new DiagnosisCode(codeValue);
        }
        return code;
    }

    @Override
    public HomeHealthGrouperIF getGrouper() {
        return this.grouper;
    }

    @Override
    public void setGrouper(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void setId(int id) {
    }
}

