/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3110_1;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.v3110_1.AbstractBaseValidator_v3110;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.Collection;

public class HomeHealthRecordNRSValidator_3110
extends AbstractBaseValidator_v3110 {
    public HomeHealthRecordNRSValidator_3110(HomeHealthGrouperIF grouper) {
        super(grouper);
    }

    @Override
    public boolean validateDiagnosisCodes(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        DiagnosisCodeIF tmpCode;
        int idx;
        boolean valid = true;
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        if (code.isSecondaryOnly()) {
            code.setValidForScoring(false);
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (code.isValidForScoring()) {
                tmpCode = record.getOptionalDiagnosisCode3(idx);
                if (!tmpCode.isEmpty()) {
                    tmpCode.setValidForScoring(false);
                    ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 7) + " is NOT valid for scoring because code in position " + (idx + 1) + " is valid for scoring.");
                }
                if ((tmpCode = record.getOptionalDiagnosisCode4(idx)).isEmpty()) continue;
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because code in position " + (idx + 1) + " is valid for scoring.");
                continue;
            }
            if (!code.isOptionalPaymentCode()) {
                tmpCode = record.getOptionalDiagnosisCode3(idx);
                if (!tmpCode.isEmpty()) {
                    tmpCode.setValidForScoring(false);
                    ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 7) + " is NOT valid for scoring because code in position " + (idx + 1) + " is NOT an optional payment code.");
                }
                if ((tmpCode = record.getOptionalDiagnosisCode4(idx)).isEmpty()) continue;
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because code in position " + (idx + 1) + " is NOT an optional payment code.");
                continue;
            }
            if (record.getOptionalDiagnosisCode4(idx).isValidCode() && !record.getOptionalDiagnosisCode4(idx).isSecondaryOnly()) {
                tmpCode = record.getOptionalDiagnosisCode4(idx);
                if (tmpCode.isEmpty()) continue;
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because it is NOT a manifestation code");
                continue;
            }
            if (!record.getOptionalDiagnosisCode3(idx).isValidCode() || !record.getOptionalDiagnosisCode3(idx).isSecondaryOnly()) continue;
            code.setValidForScoring(false);
            record.getOptionalDiagnosisCode3(idx).setValidForScoring(false);
            valid = false;
        }
        for (idx = 1; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (!code.isValidCode() || !code.isSecondaryOnly()) continue;
            tmpCode = record.getDiagnosisCode(idx - 1);
            if (!tmpCode.isValidCode() || tmpCode.isVCode() || tmpCode.isExternalCauseCode() || tmpCode.isSecondaryOnly()) {
                code.setValidForScoring(false);
                valid = false;
                continue;
            }
            if ("785.4".equals(code.getCode())) {
                if (tmpCode.isValidCode() && !code.isEtiologyInPairingList(tmpCode)) {
                    code.setValidForScoring(true);
                    continue;
                }
                code.setValidForScoring(false);
                valid = false;
                continue;
            }
            if (code.isEtiologyInPairingList(tmpCode)) {
                code.setValidForScoring(true);
                continue;
            }
            if (!code.isValidForScoring() || !tmpCode.isValidForScoring()) continue;
            code.setValidForScoring(false);
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getOptionalDiagnosisCode4(idx);
            if (!code.isValidForScoring() || !code.isSecondaryOnly()) continue;
            tmpCode = record.getOptionalDiagnosisCode3(idx);
            if (tmpCode.isVCode() || tmpCode.isExternalCauseCode() || tmpCode.isSecondaryOnly()) {
                code.setValidForScoring(false);
                valid = false;
                continue;
            }
            if ("785.4".equals(code.getCode())) {
                if (tmpCode.isValidCode() && !code.isEtiologyInPairingList(tmpCode)) {
                    code.setValidForScoring(true);
                    continue;
                }
                code.setValidForScoring(false);
                valid = false;
                continue;
            }
            if (code.isEtiologyInPairingList(tmpCode)) {
                code.setValidForScoring(true);
                if (!tmpCode.isValidCode()) continue;
                tmpCode.setValidForScoring(true);
                continue;
            }
            if (!code.isValidForScoring() || !tmpCode.isValidForScoring()) continue;
            code.setValidForScoring(false);
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getOptionalDiagnosisCode3(idx);
            if (!code.isSecondaryOnly()) continue;
            code.setValidForScoring(false);
        }
        return valid;
    }
}

