/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3210;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.v3210.AbstractBaseValidator_v3210;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.Collection;

public class HomeHealthRecordClinicalValidator_v3210
extends AbstractBaseValidator_v3210 {
    public HomeHealthRecordClinicalValidator_v3210(HomeHealthGrouperIF grouper) {
        super(grouper);
    }

    @Override
    public boolean validateDiagnosisCodes(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        DiagnosisCodeIF tmpCode;
        int idx;
        DiagnosisCodeIF code;
        boolean valid = true;
        if (!this.isValidPrincipalDiagnosisCode(record)) {
            code = record.getPRIMARY_DIAG_ICD();
            code.setValidForScoring(false);
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (code.isValidForScoring()) {
                tmpCode = record.getOptionalDiagnosisCode3(idx);
                if (!tmpCode.isEmpty()) {
                    tmpCode.setValidForScoring(false);
                    ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 7) + " is NOT valid for scoring because code in position " + (idx + 1) + " is valid for scoring.");
                }
                if ((tmpCode = record.getOptionalDiagnosisCode4(idx)).isEmpty()) continue;
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because code in position " + (idx + 1) + " is valid for scoring.");
                continue;
            }
            if (!code.isOptionalPaymentCode()) {
                tmpCode = record.getOptionalDiagnosisCode3(idx);
                if (!tmpCode.isEmpty()) {
                    tmpCode.setValidForScoring(false);
                    ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 7) + " is NOT valid for scoring because code in position " + (idx + 1) + " is NOT an optional payment code.");
                }
                if ((tmpCode = record.getOptionalDiagnosisCode4(idx)).isEmpty()) continue;
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because code in position " + (idx + 1) + " is NOT an optional payment code.");
                continue;
            }
            tmpCode = record.getOptionalDiagnosisCode4(idx);
            if (tmpCode.isValidCode() && !tmpCode.isSecondaryOnly() && !tmpCode.isEmpty()) {
                tmpCode.setValidForScoring(false);
                ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 13) + " is NOT valid for scoring because it is NOT a manifestation code");
            }
            if (!(tmpCode = record.getOptionalDiagnosisCode3(idx)).isSecondaryOnly()) continue;
            tmpCode.setValidForScoring(false);
            ScoringEventFormatter.fireIssueEvent(listeners, this.grouper, null, "Diagnosis Code '" + tmpCode.getCode() + "' at position " + (idx + 7) + " is NOT valid for scoring because it is NOT an etiology code");
            valid = false;
        }
        for (idx = 1; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (!code.isValidCode() || !code.isSecondaryOnly() || this.evaluateManifestionEtiology(code, tmpCode = record.getDiagnosisCode(idx - 1))) continue;
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getOptionalDiagnosisCode4(idx);
            if (!code.isValidForScoring() || !code.isSecondaryOnly() || this.evaluateManifestionEtiology(code, tmpCode = record.getOptionalDiagnosisCode3(idx))) continue;
            valid = false;
        }
        return valid;
    }

    protected boolean evaluateManifestionEtiology(DiagnosisCodeIF manifestation, DiagnosisCodeIF etiology) {
        boolean valid = true;
        if (!etiology.isValidCode() || etiology.isVCode() || etiology.isExternalCauseCode() || etiology.isSecondaryOnly()) {
            manifestation.setValidForScoring(false);
            valid = false;
        } else if ("785.4".equals(manifestation.getCode())) {
            if (etiology.isValidCode() && !manifestation.isEtiologyInPairingList(etiology)) {
                manifestation.setValidForScoring(true);
            } else {
                manifestation.setValidForScoring(false);
                valid = false;
            }
        } else if (manifestation.isEtiologyInPairingList(etiology)) {
            manifestation.setValidForScoring(true);
        } else {
            manifestation.setValidForScoring(false);
            valid = false;
        }
        return valid;
    }
}

