/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3413;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.v3312.GrouperVersion_v3312;
import com.mmm.cms.homehealth.v3413.ClinicalFunctional_ScoringModel_v3413;
import com.mmm.cms.homehealth.v3413.GrouperDataManager_V3413;
import com.mmm.cms.homehealth.v3413.HomeHealthRecordClinicalValidator_v3413;
import com.mmm.cms.homehealth.v3413.NRS_ScoringModel_v3413;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;

public class GrouperVersion_v3413
extends GrouperVersion_v3312
implements HomeHealthGrouperIF {
    Calendar gracePeriodThruDate = new GregorianCalendar(2013, 11, 31);

    public GrouperVersion_v3413() {
        this(new GregorianCalendar(2013, 0, 1), new GregorianCalendar(2013, 8, 30), null, "V3413");
    }

    public GrouperVersion_v3413(Calendar start, Calendar thru, Calendar window, String versionName) {
        super(start, thru, window, versionName);
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator_v3413(this);
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - January 2013 Logic updates, " + this.getVersion();
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordClinicalValidator_v3413(this);
    }

    @Override
    public void init(Properties props) throws Exception {
        GrouperDataManager_V3413 grouperManager = new GrouperDataManager_V3413(this);
        this.setGrouperDataManager(grouperManager);
        ((GrouperDataManager)grouperManager).init(props);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v3413(this, grouperManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v3413(this, grouperManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v3413(this, grouperManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v3413(this, grouperManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v3413(this, grouperManager);
    }

    @Override
    public boolean isValidForVersion(HomeHealthRecordIF record) {
        Calendar infoComplete;
        boolean valid = super.isValidForVersion(record);
        if (!valid && (infoComplete = record.getINFO_COMPLETED_DT()) != null && infoComplete.after(super.getEffectiveDateThru())) {
            valid = !infoComplete.after(this.gracePeriodThruDate);
        }
        return valid;
    }
}

