/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C2_IF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateDrugRegimenReview
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4431});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        String drugRegemine = ((HomeHealthRecord_C2_IF)record).getDRUG_RGMN_RVW();
        String injectMeds = record.getCRNT_MGMT_INJCTN_MDCTN();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_ONLY})) {
            if (!ValidateUtils.isValidValue(drugRegemine, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_9, ValidateUtils.ARRAY_DASH_VALUES)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M2001_DRUG_RGMN_RVW", drugRegemine)));
            }
            if (ValidateUtils.isValidValue(drugRegemine, new String[][]{ValidateUtils.ARRAY_DOUBLE_1}) && ValidateUtils.isValidValue(injectMeds, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4431, new HHOasisDataItem("M2030_CRNT_MGMT_INJCTN_MDCTN", injectMeds)));
            }
            if (ValidateUtils.isValidValue(drugRegemine, new String[][]{ValidateUtils.ARRAY_DOUBLE_9}) && !ValidateUtils.isValidValue(injectMeds, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4441, new HHOasisDataItem("M2030_CRNT_MGMT_INJCTN_MDCTN", injectMeds)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Drug Regimen Review for edits: 3060";
    }
}

