/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateStasisUlcer
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4220, OasisEditsEN.EDIT_4230});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            String stasPresent = record.getSTAS_ULCR_PRSNT();
            String numStas = record.getNBR_STAS_ULCR();
            String statStas = record.getSTUS_PRBLM_STAS_ULCR();
            if (ValidateUtils.isValidValue(stasPresent, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2)) {
                if (ValidateUtils.isValidValue(numStas, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4230, new HHOasisDataItem("M1332_NBR_STAS_ULCR", numStas)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4230, new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", stasPresent)));
                }
                if (ValidateUtils.isValidValue(statStas, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4230, new HHOasisDataItem("M1334_STUS_PRBLM_STAS_ULCR", statStas)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4230, new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", stasPresent)));
                }
            } else if (ValidateUtils.isValidValue(stasPresent, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_3)) {
                if (!ValidateUtils.isValidValue(numStas, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4220, new HHOasisDataItem("M1332_NBR_STAS_ULCR", numStas)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4220, new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", stasPresent)));
                }
                if (!ValidateUtils.isValidValue(statStas, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4220, new HHOasisDataItem("M1334_STUS_PRBLM_STAS_ULCR", statStas)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4220, new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", stasPresent)));
                }
            } else {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", stasPresent)));
            }
            if (!ValidateUtils.isValidValue(numStas, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4, ValidateUtils.ARRAY_CARET_VALUES)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1332_NBR_STAS_ULCR", numStas)));
            }
            if (!ValidateUtils.isValidValue(statStas, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_CARET_VALUES)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1334_STUS_PRBLM_STAS_ULCR", statStas)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Stasis Ulcer for edits: 3060, 4220, 4230";
    }
}

