/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.DataValidityFlagIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.pps.AbstractPPSManifestationItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateManifestationAsPrimaryDiagnosis
extends AbstractPPSManifestationItemValidator
implements RecordItemValidator_HH_PPS_IF {
    public ValidateManifestationAsPrimaryDiagnosis() {
    }

    public ValidateManifestationAsPrimaryDiagnosis(String primaryPrefix, String otherPrefix, String optPrefix) {
        super(primaryPrefix, otherPrefix, optPrefix);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(HH_PPS_OasisC1EditsEN.EDIT_70020);
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits, DataValidityFlagIF dataValidity) {
        int count = super.validate(grouper, record, edits, dataValidity);
        if (count > 0) {
            dataValidity.setClinicalIssue(true);
        }
        return count;
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        DiagnosisCodeIF code;
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY}) && (code = record.getPRIMARY_DIAG_ICD()).isSecondaryOnly()) {
            ++count;
            edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70020, new HHOasisDataItem(this.getPrimaryPrefix(), code.getCode())));
            code.setValidForScoring(false);
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates OptionalPaymentCodes for  edits: 70020";
    }
}

