/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.pps.AbstractPPSClinicalItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidatePrimaryDiagnosis
extends AbstractPPSClinicalItemValidator
implements RecordItemValidator_HH_PPS_IF {
    public ValidatePrimaryDiagnosis() {
    }

    public ValidatePrimaryDiagnosis(String primaryPrefix, String otherPrefix, String optPrefix) {
        super(primaryPrefix, otherPrefix, optPrefix);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(HH_PPS_OasisC1EditsEN.EDIT_70000, HH_PPS_OasisC1EditsEN.EDIT_70010);
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
            if (code.isEmpty()) {
                ++count;
                int idx = 1;
                while (idx < 18) {
                    DiagnosisCodeIF codeOther;
                    if ((codeOther = record.getDiagnosisCode(idx++)) == null) continue;
                    codeOther.setValidForScoring(false);
                }
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70000, new HHOasisDataItem(this.getPrimaryPrefix(), code.getCode())));
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70010, new HHOasisDataItem(this.getPrimaryPrefix(), code.getCode())));
            } else if (!code.isValidCode()) {
                ++count;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70000, new HHOasisDataItem(this.getPrimaryPrefix(), code.getCode())));
            } else if (code.isExternalCauseCode()) {
                ++count;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70010, new HHOasisDataItem(this.getPrimaryPrefix(), code.getCode())));
                code.setValidForScoring(false);
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Primary Diagnosis Code for edits: 70000, 70010";
    }
}

