/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.Collection;

public class ScoringModelUtils {
    public static int calculatePrimaryAdjustment(DataManagerIF grouperDataManager, boolean clinical, int equationId, DiagnosisScoringGridIF scoringGrid, int primaryAdjustmentRow, int otherAdjustmentRow) {
        int primaryScore = scoringGrid.isCaseMixAdjustmentRowScored(otherAdjustmentRow) ? ScoringModelUtils.getCaseMixAdjustmentEquation(grouperDataManager, clinical, primaryAdjustmentRow, equationId) - ScoringModelUtils.getCaseMixAdjustmentEquation(grouperDataManager, clinical, otherAdjustmentRow, equationId) : ScoringModelUtils.getCaseMixAdjustmentEquation(grouperDataManager, clinical, primaryAdjustmentRow, equationId);
        return primaryScore;
    }

    public static int getCaseMixAdjustmentEquation(DataManagerIF grouperDataManager, boolean clinical, int caseMixId, int equationId) {
        CaseMixAdjustmentItemIF caseMix = clinical ? grouperDataManager.getCaseMixAdjustment(caseMixId) : grouperDataManager.getNRSCaseMixAdjustment(caseMixId);
        return caseMix == null ? 0 : caseMix.getAdjustment(equationId);
    }

    public static void resolveEtiologyManifestationContention(HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, DiagnosisCodeIF etiologyCode, int etiologyIdx, DiagnosisCodeIF manifestionCode, int manifestIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) {
        if (scoringGrid.getScoredByWinningContention(etiologyIdx)) {
            ScoringEventFormatter.fireScoringGeneral(listeners, grouper, scoringModel, "Manifestation/Etiology Contention: Previous etiology code ", etiologyCode.getCode(), " already scored due to previous contention.");
            return;
        }
        if (scoringGrid.getTotalScoreForDiagnosis(manifestIdx) > scoringGrid.getTotalScoreForDiagnosis(etiologyIdx)) {
            scoringGrid.clearScore(etiologyIdx);
            ScoringEventFormatter.fireScoringGeneral(listeners, grouper, scoringModel, "Manifestation/Etiology Contention: Previous etiology code ", etiologyCode.getCode(), " loses score for contention.");
        } else {
            scoringGrid.clearScore(manifestIdx);
            scoringGrid.setScoredByWinningContention(etiologyIdx, true);
            ScoringEventFormatter.fireScoringGeneral(listeners, grouper, scoringModel, "Manifestation/Etiology Contention: Manifestation code ", manifestionCode.getCode(), " loses score for contention.");
        }
    }
}

