/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.DiagnosticGroup;
import com.mmm.cms.homehealth.proto.CodeType_EN;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;

public abstract class AbstractDiagnosisCode
implements DiagnosisCodeIF,
Cloneable {
    public static final String EMPTY_CODE = "";
    private String code;
    private String description;
    private CodeType_EN codeType;
    private DiagnosticGroupIF diagnosticGroup;
    private boolean validForScoring;
    private boolean validCode;
    private boolean optionalPaymentCode;

    public AbstractDiagnosisCode() {
        this.code = EMPTY_CODE;
        this.diagnosticGroup = DiagnosticGroup.GROUP_UNKNOWN;
    }

    public AbstractDiagnosisCode(String code, CodeType_EN codeType) {
        this.code = code.intern().toUpperCase();
        this.codeType = codeType;
        this.diagnosticGroup = DiagnosticGroup.GROUP_UNKNOWN;
    }

    public AbstractDiagnosisCode(String code, CodeType_EN codeType, boolean validCode, boolean validForScoring) {
        this.code = code.intern().toUpperCase();
        this.codeType = codeType;
        this.validCode = validCode;
        this.validForScoring = validForScoring;
        this.diagnosticGroup = DiagnosticGroup.GROUP_UNKNOWN;
    }

    @Override
    public DiagnosisCodeIF clone() throws CloneNotSupportedException {
        return (DiagnosisCodeIF)super.clone();
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        int diff;
        if (obj instanceof DiagnosisCodeIF) {
            DiagnosisCodeIF other = (DiagnosisCodeIF)obj;
            String otherCode = other.getCode();
            diff = this.code == null ? (otherCode != null ? -1 : 0) : this.code.compareTo(otherCode);
        } else {
            diff = 1;
        }
        return diff;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        char[] chars;
        if (code == null) {
            throw new IllegalArgumentException("Code value can not be null");
        }
        for (char curChar : chars = code.toCharArray()) {
            if (curChar == '.' || Character.isLetterOrDigit(curChar)) continue;
            throw new IllegalArgumentException("Code value can not be illegal character of '" + curChar + "'. Full code value = '" + code + "'");
        }
        this.code = code;
    }

    @Override
    public void setCodeType(CodeType_EN type) {
        this.codeType = type;
    }

    @Override
    public CodeType_EN getCodeType() {
        return this.codeType;
    }

    @Override
    public DiagnosticGroupIF getDiagnosticGroup() {
        return this.diagnosticGroup;
    }

    @Override
    public void setDiagnosticGroup(DiagnosticGroupIF diagnosticGroup) {
        this.diagnosticGroup = diagnosticGroup;
    }

    @Override
    public boolean isExternalCauseCode() {
        boolean bool;
        if (this.code.isEmpty()) {
            bool = false;
        } else if (this.codeType == CodeType_EN.ICD_9) {
            bool = 'E' == this.code.charAt(0);
        } else if (this.codeType == CodeType_EN.ICD_10) {
            switch (this.code.charAt(0)) {
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': {
                    bool = true;
                    break;
                }
                default: {
                    bool = false;
                    break;
                }
            }
        } else {
            bool = false;
        }
        return bool;
    }

    @Override
    public boolean isVCode() {
        boolean bool = this.code.isEmpty() ? false : (this.codeType == CodeType_EN.ICD_9 ? 'V' == this.code.charAt(0) : 'Z' == this.code.charAt(0));
        return bool;
    }

    @Override
    public boolean isValidForScoring() {
        return this.validForScoring;
    }

    @Override
    public void setValidForScoring(boolean validForScoring) {
        this.validForScoring = validForScoring;
    }

    @Override
    public boolean isEmpty() {
        boolean isblank = true;
        if (this.code != null && this.code != EMPTY_CODE) {
            int idx = 0;
            char[] chars = this.code.toCharArray();
            while (idx < chars.length) {
                if (chars[idx++] == ' ') continue;
                isblank = false;
                break;
            }
        }
        return isblank;
    }

    @Override
    public boolean isValidCode() {
        return this.validCode;
    }

    @Override
    public void setValidCode(boolean validCode) {
        this.validCode = validCode;
    }

    @Override
    public boolean isOptionalPaymentCode() {
        return this.optionalPaymentCode;
    }

    @Override
    public void setOptionalPaymentCode(boolean bool) {
        this.optionalPaymentCode = bool;
    }

    public String toString() {
        return this.code;
    }

    public String toStringFinest() {
        return "AbstractDiagnosisCode{code=" + this.code + ", description=" + this.description + ", codeType=" + (Object)((Object)this.codeType) + ", diagnosticGroup=" + this.diagnosticGroup + ", validForScoring=" + this.validForScoring + ", validCode=" + this.validCode + ", optionalPaymentCode=" + this.optionalPaymentCode + '}';
    }
}

