/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringStatus_EN;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.util.Describable;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.Namable;
import com.mmm.cms.util.ScoringEventFormatter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public abstract class AbstractGrouper
implements Namable,
Describable {
    protected Calendar effectiveDateStart;
    protected Calendar effectiveDateStartWindow;
    protected Calendar effectiveDateThru;
    protected DataManagerIF dataManager;
    protected HomeHealthScoringModelIF nrsScoringModel;
    protected HomeHealthScoringModelIF clinicalModel_1;
    protected HomeHealthScoringModelIF clinicalModel_2;
    protected HomeHealthScoringModelIF clinicalModel_3;
    protected HomeHealthScoringModelIF clinicalModel_4;
    protected String version;

    public AbstractGrouper(Calendar start, Calendar thru, Calendar window, String versionName) {
        if (start == null || thru == null) {
            throw new IllegalArgumentException("Neither the start date nor the thru date can be null");
        }
        if (versionName == null || versionName.length() != 5) {
            throw new IllegalArgumentException("versionName " + (versionName == null ? " can not be null!" : " of '" + versionName + "' is invalid. Must be a 5 characte string."));
        }
        this.effectiveDateStart = start;
        this.effectiveDateThru = thru;
        this.effectiveDateStartWindow = window == null ? this.effectiveDateStart : window;
        this.version = versionName;
    }

    public void copyCodes(HomeHealthRecordIF recordSrc, HomeHealthRecordIF recordDest) {
        recordDest.setPRIMARY_DIAG_ICD(recordSrc.getPRIMARY_DIAG_ICD());
        recordDest.setOTH_DIAG1_ICD(recordSrc.getOTH_DIAG1_ICD());
        recordDest.setOTH_DIAG2_ICD(recordSrc.getOTH_DIAG2_ICD());
        recordDest.setOTH_DIAG3_ICD(recordSrc.getOTH_DIAG3_ICD());
        recordDest.setOTH_DIAG4_ICD(recordSrc.getOTH_DIAG4_ICD());
        recordDest.setOTH_DIAG5_ICD(recordSrc.getOTH_DIAG5_ICD());
        recordDest.setPMT_DIAG_ICD_A3(recordSrc.getPMT_DIAG_ICD_A3());
        recordDest.setPMT_DIAG_ICD_B3(recordSrc.getPMT_DIAG_ICD_B3());
        recordDest.setPMT_DIAG_ICD_C3(recordSrc.getPMT_DIAG_ICD_C3());
        recordDest.setPMT_DIAG_ICD_D3(recordSrc.getPMT_DIAG_ICD_D3());
        recordDest.setPMT_DIAG_ICD_E3(recordSrc.getPMT_DIAG_ICD_E3());
        recordDest.setPMT_DIAG_ICD_F3(recordSrc.getPMT_DIAG_ICD_F3());
        recordDest.setPMT_DIAG_ICD_A4(recordSrc.getPMT_DIAG_ICD_A4());
        recordDest.setPMT_DIAG_ICD_B4(recordSrc.getPMT_DIAG_ICD_B4());
        recordDest.setPMT_DIAG_ICD_C4(recordSrc.getPMT_DIAG_ICD_C4());
        recordDest.setPMT_DIAG_ICD_D4(recordSrc.getPMT_DIAG_ICD_D4());
        recordDest.setPMT_DIAG_ICD_E4(recordSrc.getPMT_DIAG_ICD_E4());
        recordDest.setPMT_DIAG_ICD_F4(recordSrc.getPMT_DIAG_ICD_F4());
    }

    public int[][] determineScoreOrder(HomeHealthRecordIF record) {
        int[][] scoreOrder = new int[6][3];
        for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
            if (diagCode.isOptionalPaymentCode()) {
                DiagnosisCodeIF diagCodeOptional = record.getOptionalDiagnosisCode4(diagIdx);
                if (diagCodeOptional.isValidForScoring()) {
                    scoreOrder[diagIdx][2] = 2;
                    scoreOrder[diagIdx][1] = 2;
                    continue;
                }
                diagCodeOptional = record.getOptionalDiagnosisCode3(diagIdx);
                if (!diagCodeOptional.isValidForScoring()) continue;
                scoreOrder[diagIdx][1] = 1;
                continue;
            }
            if (!diagCode.isValidForScoring()) continue;
            if (diagCode.isSecondaryOnly()) {
                scoreOrder[diagIdx][0] = 2;
                scoreOrder[diagIdx - 1][0] = 2;
                continue;
            }
            scoreOrder[diagIdx][0] = 1;
        }
        return scoreOrder;
    }

    public abstract Class getAcceptableRecordClass();

    public List<CaseMixAdjustmentItemIF> getCaseMixAdjustments() {
        return this.dataManager.getCaseMixAdjustments();
    }

    public List<DiagnosisCodeIF> getClinicalCodes() {
        return this.dataManager.getClinicalCodes();
    }

    public HomeHealthScoringModelIF getClinicalModel_1() {
        return this.clinicalModel_1;
    }

    public HomeHealthScoringModelIF getClinicalModel_2() {
        return this.clinicalModel_2;
    }

    public HomeHealthScoringModelIF getClinicalModel_3() {
        return this.clinicalModel_3;
    }

    public HomeHealthScoringModelIF getClinicalModel_4() {
        return this.clinicalModel_4;
    }

    public List<CaseMixAdjustmentItemIF> getNRSCaseMixAdjustments() {
        return this.dataManager.getNRSCaseMixAdjustments();
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        SimpleDateFormat dformatter = new SimpleDateFormat("MMM d, yyyy");
        buffer.append(this.getName());
        buffer.append(" - Effective dates: ");
        buffer.append(dformatter.format(this.getEffectiveDateStart().getTime()));
        buffer.append(" thru ");
        buffer.append(dformatter.format(this.getEffectiveDateThru().getTime()));
        if (this.getEffectiveDateStartWindow() != null && this.getEffectiveDateStartWindow() != this.getEffectiveDateStart()) {
            buffer.append(" (with effective start window of ");
            buffer.append(dformatter.format(this.getEffectiveDateStartWindow().getTime()));
            buffer.append(")");
        }
        return buffer.toString();
    }

    public List<DiagnosticGroupIF> getDiagnosticGroups() {
        return this.dataManager.getDiagnosticGroups();
    }

    public List<DiagnosticGroupIF> getDiagnosticGroupsNRS() {
        return this.dataManager.getDiagnosticGroupsNRS();
    }

    public Calendar getEffectiveDateStart() {
        return this.effectiveDateStart;
    }

    public Calendar getEffectiveDateStartWindow() {
        if (this.effectiveDateStartWindow == null) {
            this.effectiveDateStartWindow = this.effectiveDateStart;
        }
        return this.effectiveDateStartWindow;
    }

    public Calendar getEffectiveDateThru() {
        return this.effectiveDateThru;
    }

    public DataManagerIF getGrouperDataManager() {
        return this.dataManager;
    }

    public HomeHealthScoringModelIF getNrsScoringModel() {
        return this.nrsScoringModel;
    }

    public List<DiagnosisCodeIF> getNonRoutineCodes() {
        return this.dataManager.getNonRoutineCodes();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isValidForVersion(HomeHealthRecordIF record) {
        boolean valid = true;
        Class acceptableRecordClass = this.getAcceptableRecordClass();
        if (record == null || !acceptableRecordClass.isAssignableFrom(record.getClass())) {
            valid = false;
        } else {
            Calendar date = record.getINFO_COMPLETED_DT();
            if (date != null) {
                int tmpInt = IntegerUtils.parseInt(record.getASSMT_REASON(), 0);
                switch (tmpInt) {
                    case 1: 
                    case 3: {
                        if (!date.before(this.getEffectiveDateStart())) break;
                        valid = false;
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (!date.before(this.getEffectiveDateStartWindow())) break;
                        valid = false;
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
                if (valid) {
                    valid ^= date.after(this.getEffectiveDateThru());
                }
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public boolean isValidDiagnosisCode(HomeHealthRecordIF record, DiagnosisCodeIF code) {
        return code == null ? false : this.dataManager.getDiagnosisCode(code.getCode()) != null;
    }

    public void setGrouperDataManager(GrouperDataManager grouperDataManager) {
        this.dataManager = grouperDataManager;
    }

    public void setNrsScoringModel(HomeHealthScoringModelIF nrsScoringModel) {
        this.nrsScoringModel = nrsScoringModel;
    }

    public void setClinicalModel_1(HomeHealthScoringModelIF clinicalModel_1) {
        this.clinicalModel_1 = clinicalModel_1;
    }

    public void setClinicalModel_2(HomeHealthScoringModelIF clinicalModel_2) {
        this.clinicalModel_2 = clinicalModel_2;
    }

    public void setClinicalModel_3(HomeHealthScoringModelIF clinicalModel_3) {
        this.clinicalModel_3 = clinicalModel_3;
    }

    public void setClinicalModel_4(HomeHealthScoringModelIF clinicalModel_4) {
        this.clinicalModel_4 = clinicalModel_4;
    }

    @Override
    public final void setDescription(String desc) {
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - " + this.getVersion();
    }

    @Override
    public final void setName(String name) {
    }

    public final void setVersion(String versionName) {
        this.version = versionName;
    }

    public void setEffectiveDateStart(Calendar effectiveDateStart) {
        this.effectiveDateStart = effectiveDateStart;
    }

    public void setEffectiveDateStartWindow(Calendar effectiveDateStartWindow) {
        this.effectiveDateStartWindow = effectiveDateStartWindow;
    }

    public void setEffectiveDateThru(Calendar effectiveDateThru) {
        this.effectiveDateThru = effectiveDateThru;
    }

    public void reportNonScoringDiagnosis(HomeHealthRecordIF recordOasisC, DiagnosisScoringStatus_EN[] diagnosisStatus, HomeHealthScoringModelIF scoringModel, Collection<HomeHealthEventListenerIF> listeners) {
        for (int idx = 0; idx < diagnosisStatus.length; ++idx) {
            DiagnosisCodeIF diagCode = recordOasisC.getDiagnosisCode(idx);
            DiagnosisScoringStatus_EN diagnosisScoringStatus_EN = diagCode.isValidCode() ? (diagCode.isValidForScoring() ? DiagnosisScoringStatus_EN.VALID_SCORABLE : DiagnosisScoringStatus_EN.VALID) : (diagnosisStatus[idx] = DiagnosisScoringStatus_EN.INVALID);
            if (diagCode.isEmpty() || diagCode.isValidForScoring()) continue;
            ScoringEventFormatter.fireValidCodeWarning(listeners, this instanceof HomeHealthGrouperIF ? (HomeHealthGrouperIF)((Object)this) : null, scoringModel, diagCode, idx + 1, diagCode.isValidCode());
        }
    }
}

