/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import java.util.ArrayList;

public class DiagnosisScoringGrid
implements DiagnosisScoringGridIF {
    private ScoringItem[] scores = new ScoringItem[0];
    private transient int totalScore;
    private boolean[] scoredByWinningContention = new boolean[18];

    @Override
    public void addScore(DiagnosisCodeIF diagnosisCode, int diagnosisIdx, int caseMixAdjustmentRow, int score, boolean checkDiagnosticGroup) throws AlreadyScoredException {
        int diagnosticGroupId = diagnosisCode.getDiagnosticGroup().getId();
        boolean scoredDxGroup = checkDiagnosticGroup ? this.isDiagnosticGroupScored(diagnosisIdx, diagnosticGroupId) : false;
        boolean scoredRow = this.isCaseMixAdjustmentRowScored(caseMixAdjustmentRow);
        if (scoredDxGroup || scoredRow) {
            throw new AlreadyScoredException(scoredDxGroup ? diagnosticGroupId : 0, scoredRow ? caseMixAdjustmentRow : 0, diagnosisCode);
        }
        ScoringItem[] tmpScores = new ScoringItem[this.scores.length + 1];
        System.arraycopy(this.scores, 0, tmpScores, 0, this.scores.length);
        tmpScores[this.scores.length] = new ScoringItem(diagnosisIdx, diagnosticGroupId, caseMixAdjustmentRow, score);
        this.scores = tmpScores;
        this.totalScore += score;
    }

    @Override
    public void clearScore(int diagnosisIdx) {
        int idx = this.scores.length;
        if (idx > 0) {
            ArrayList<ScoringItem> tmpScores = new ArrayList<ScoringItem>();
            this.totalScore = 0;
            while (idx-- > 0) {
                ScoringItem item = this.scores[idx];
                if (item.getDiagnosisIdx() == diagnosisIdx) continue;
                tmpScores.add(item);
                this.totalScore += item.getScore();
            }
            if (tmpScores.size() > 0) {
                this.scores = new ScoringItem[tmpScores.size()];
                tmpScores.toArray(this.scores);
            } else {
                this.scores = new ScoringItem[0];
            }
        }
    }

    @Override
    public boolean getScoredByWinningContention(int diagnosisIdx) {
        return this.scoredByWinningContention[diagnosisIdx];
    }

    @Override
    public int getTotalScore() {
        return this.totalScore;
    }

    @Override
    public int getTotalScoreForDiagnosis(int diagnosisIdx) {
        int score = 0;
        int idx = this.scores.length;
        while (idx-- > 0) {
            ScoringItem item = this.scores[idx];
            if (diagnosisIdx != item.getDiagnosisIdx()) continue;
            score += item.getScore();
        }
        return score;
    }

    @Override
    public boolean isDiagnosticGroupScored(int diagnosisIdx, int groupId) {
        int idx = this.scores.length;
        boolean isScored = false;
        while (idx-- > 0) {
            ScoringItem item = this.scores[idx];
            if (item.getDiagnosisIdx() == diagnosisIdx || item.getDiagnosticGroupId() != groupId) continue;
            isScored = true;
            break;
        }
        return isScored;
    }

    @Override
    public boolean isCaseMixAdjustmentRowScored(int caseMixAdjustmentRow) {
        int idx = this.scores.length;
        boolean isScored = false;
        while (idx-- > 0) {
            ScoringItem item = this.scores[idx];
            if (item.getCaseMixAdjustmentRow() != caseMixAdjustmentRow) continue;
            isScored = true;
            break;
        }
        return isScored;
    }

    @Override
    public void setScore(DiagnosisCodeIF diagnosisCode, int diagnosisIdx, int caseMixAdjustmentRow, int score, boolean checkDiagnosticGroup) throws AlreadyScoredException {
        this.clearScore(diagnosisIdx);
        this.addScore(diagnosisCode, diagnosisIdx, caseMixAdjustmentRow, score, checkDiagnosticGroup);
    }

    @Override
    public void setScoredByWinningContention(int diagnosisIdx, boolean scoredByWinningContention) {
        this.scoredByWinningContention[diagnosisIdx] = scoredByWinningContention;
    }

    class ScoringItem {
        protected int score;
        protected int diagnosticGroupId;
        protected int caseMixAdjustmentRow;
        protected int diagnosisIdx;

        public ScoringItem(int diagnosisIdx, int diagnosticGroupId, int caseMixAdjustmentRow, int score) {
            this.score = score;
            this.diagnosticGroupId = diagnosticGroupId;
            this.caseMixAdjustmentRow = caseMixAdjustmentRow;
            this.diagnosisIdx = diagnosisIdx;
        }

        public int getDiagnosisIdx() {
            return this.diagnosisIdx;
        }

        public void setDiagnosisIdx(int diagnosisIdx) {
            this.diagnosisIdx = diagnosisIdx;
        }

        public int getCaseMixAdjustmentRow() {
            return this.caseMixAdjustmentRow;
        }

        public void setCaseMixAdjustmentRow(int caseMixAdjustmentRow) {
            this.caseMixAdjustmentRow = caseMixAdjustmentRow;
        }

        public int getDiagnosticGroupId() {
            return this.diagnosticGroupId;
        }

        public void setDiagnosticGroupId(int diagnosticGroupId) {
            this.diagnosticGroupId = diagnosticGroupId;
        }

        public int getScore() {
            return this.score;
        }

        public void setScore(int score) {
            this.score = score;
        }
    }
}

