/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.io.Oasis_B_Record;
import com.mmm.cms.homehealth.io.Oasis_C_Record;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C_IF;
import com.mmm.cms.util.IntegerUtils;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HomeHealthRecordUtil {
    public static Node createHomeHealthNode(Document document, String name, String value) {
        Text node = document.createTextNode(value);
        return node;
    }

    public static void buildTransformerNode(TransformerHandler transformerHandler, String name, String value) throws SAXException {
        transformerHandler.startElement("", "", name, new AttributesImpl());
        String tmpStr = value != null ? value.trim() : "";
        if (!tmpStr.isEmpty()) {
            transformerHandler.characters(tmpStr.toCharArray(), 0, tmpStr.length());
        }
        transformerHandler.endElement("", "", name);
    }

    public static HomeHealthRecord_B_IF convertToHomeHealthRecord_OasisB(HomeHealthRecord_C_IF record_C, boolean mapValues) {
        int tmpInt;
        String str;
        Oasis_B_Record record_B;
        block96: {
            block95: {
                block94: {
                    block93: {
                        record_B = new Oasis_B_Record();
                        record_B.setSTART_CARE_DT(record_C.getSTART_CARE_DT());
                        record_B.setINFO_COMPLETED_DT(record_C.getINFO_COMPLETED_DT());
                        record_B.setASSMT_REASON(record_C.getASSMT_REASON());
                        record_B.setPRIMARY_DIAG_ICD(record_C.getPRIMARY_DIAG_ICD());
                        record_B.setOTH_DIAG1_ICD(record_C.getOTH_DIAG1_ICD());
                        record_B.setOTH_DIAG2_ICD(record_C.getOTH_DIAG2_ICD());
                        record_B.setOTH_DIAG3_ICD(record_C.getOTH_DIAG3_ICD());
                        record_B.setOTH_DIAG4_ICD(record_C.getOTH_DIAG4_ICD());
                        record_B.setOTH_DIAG5_ICD(record_C.getOTH_DIAG5_ICD());
                        record_B.setTHH_IV_INFUSION(record_C.getTHH_IV_INFUSION());
                        record_B.setTHH_PAR_NUTRITION(record_C.getTHH_PAR_NUTRITION());
                        record_B.setTHH_ENT_NUTRITION(record_C.getTHH_ENT_NUTRITION());
                        record_B.setTHH_NONE_ABOVE(record_C.getTHH_NONE_ABOVE());
                        record_B.setVISION(record_C.getVISION());
                        str = record_C.getPAIN_FREQ_ACTVTY_MVMT();
                        if (mapValues) {
                            if ("00".equals(str) || "01".equals(str)) {
                                record_B.setPAIN_FREQ_ACTVTY_MVMT("00");
                            } else if ("02".equals(str)) {
                                record_B.setPAIN_FREQ_ACTVTY_MVMT("01");
                            } else if ("03".equals(str)) {
                                record_B.setPAIN_FREQ_ACTVTY_MVMT("02");
                            } else if ("04".equals(str)) {
                                record_B.setPAIN_FREQ_ACTVTY_MVMT("03");
                            } else {
                                record_B.setPAIN_FREQ_ACTVTY_MVMT(str);
                            }
                        } else {
                            record_B.setPAIN_FREQ_ACTVTY_MVMT(str);
                        }
                        record_B.setLESION_OPEN_WND(record_C.getLESION_OPEN_WND());
                        record_B.setPRESS_ULCER(record_C.getUNHLD_STG2_PRSR_ULCR());
                        str = record_C.getNBR_PRSULC_STG1();
                        if (mapValues) {
                            try {
                                tmpInt = IntegerUtils.parseInt(str, 0);
                                if (tmpInt > 4) {
                                    record_B.setNBR_PRSULC_STG1("04");
                                    break block93;
                                }
                                record_B.setNBR_PRSULC_STG1(str);
                            }
                            catch (NumberFormatException e) {
                                record_B.setNBR_PRSULC_STG1("  ");
                            }
                        } else {
                            record_B.setNBR_PRSULC_STG1(str);
                        }
                    }
                    str = record_C.getNBR_PRSULC_STG2();
                    if (mapValues) {
                        try {
                            tmpInt = IntegerUtils.parseInt(str, 0);
                            if (tmpInt > 4) {
                                record_B.setNBR_PRSULC_STG2("04");
                                break block94;
                            }
                            record_B.setNBR_PRSULC_STG2(str);
                        }
                        catch (NumberFormatException e) {
                            record_B.setNBR_PRSULC_STG2("  ");
                        }
                    } else {
                        record_B.setNBR_PRSULC_STG2(str);
                    }
                }
                str = record_C.getNBR_PRSULC_STG3();
                if (mapValues) {
                    try {
                        tmpInt = IntegerUtils.parseInt(str, 0);
                        if (tmpInt > 4) {
                            record_B.setNBR_PRSULC_STG3("04");
                            break block95;
                        }
                        record_B.setNBR_PRSULC_STG3(str);
                    }
                    catch (NumberFormatException e) {
                        record_B.setNBR_PRSULC_STG3("  ");
                    }
                } else {
                    record_B.setNBR_PRSULC_STG3(str);
                }
            }
            str = record_C.getNBR_PRSULC_STG4();
            if (mapValues) {
                try {
                    tmpInt = IntegerUtils.parseInt(str, 0);
                    if (tmpInt > 4) {
                        record_B.setNBR_PRSULC_STG4("04");
                        break block96;
                    }
                    record_B.setNBR_PRSULC_STG4(str);
                }
                catch (NumberFormatException e) {
                    record_B.setNBR_PRSULC_STG4("  ");
                }
            } else {
                record_B.setNBR_PRSULC_STG4(str);
            }
        }
        record_B.setUNOBS_PRSULC(" ");
        str = record_C.getNSTG_DRSG();
        if (mapValues) {
            try {
                tmpInt = IntegerUtils.parseInt(str, 0);
                if (tmpInt > 0 && tmpInt <= 99) {
                    record_B.setUNOBS_PRSULC("1");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            str = record_C.getNSTG_CVRG();
            try {
                tmpInt = IntegerUtils.parseInt(str, 0);
                if (tmpInt > 0 && tmpInt <= 99) {
                    record_B.setUNOBS_PRSULC("1");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        record_B.setSTG_PRBLM_ULCER(record_C.getSTG_PRBLM_ULCER());
        str = record_C.getSTAS_ULCR_PRSNT();
        if (str != null) {
            if ((str = str.trim()).length() == 2) {
                str = str.substring(1);
            } else if (str.isEmpty()) {
                str = " ";
            }
        }
        if (mapValues) {
            if ("3".equals(str)) {
                record_B.setSTAS_ULCR_PRSNT("0");
                record_B.setUNOBS_STASULC("1");
            } else if ("2".equals(str)) {
                record_B.setSTAS_ULCR_PRSNT("1");
                record_B.setUNOBS_STASULC("0");
            } else if ("1".equals(str)) {
                record_B.setSTAS_ULCR_PRSNT("1");
                record_B.setUNOBS_STASULC("1");
            } else {
                record_B.setSTAS_ULCR_PRSNT(str);
                record_B.setUNOBS_STASULC("0");
            }
        } else {
            record_B.setSTAS_ULCR_PRSNT(str);
            record_B.setUNOBS_STASULC(str);
        }
        str = record_C.getNBR_STAS_ULCR();
        if (mapValues) {
            if ("  ".equals(str)) {
                record_B.setNBR_STAS_ULCR("00");
            } else {
                record_B.setNBR_STAS_ULCR(str);
            }
        } else {
            record_B.setNBR_STAS_ULCR(str);
        }
        str = record_C.getSTUS_PRBLM_STAS_ULCR();
        if (mapValues) {
            if ("00".equals(str)) {
                record_B.setSTUS_PRBLM_STAS_ULCR("NA");
            } else {
                record_B.setSTUS_PRBLM_STAS_ULCR(str);
            }
        } else {
            record_B.setSTUS_PRBLM_STAS_ULCR(str);
        }
        str = record_C.getSRGCL_WND_PRSNT();
        if (str != null) {
            if ((str = str.trim()).length() == 2) {
                str = str.substring(1);
            } else if (str.isEmpty()) {
                str = " ";
            }
        }
        if (mapValues) {
            if ("02".equals(str)) {
                record_B.setSRGCL_WND_PRSNT("01");
            } else {
                record_B.setSRGCL_WND_PRSNT(str);
            }
        } else {
            record_B.setSRGCL_WND_PRSNT(str);
        }
        record_B.setNBR_SURGWND(record_C.getSRGCL_WND_PRSNT());
        str = record_C.getSTUS_PRBLM_SRGCL_WND();
        if (mapValues) {
            if ("00".equals(str)) {
                record_B.setSTUS_PRBLM_SRGCL_WND("01");
            } else {
                record_B.setSTUS_PRBLM_SRGCL_WND(str);
            }
        } else {
            record_B.setSTUS_PRBLM_SRGCL_WND(str);
        }
        record_B.setWHEN_DYSPNEIC(record_C.getWHEN_DYSPNEIC());
        record_B.setUR_INCONT(record_C.getUR_INCONT());
        record_B.setBWL_INCONT(record_C.getBWL_INCONT());
        record_B.setOSTOMY(record_C.getOSTOMY());
        record_B.setCRNT_DRESS_UPPER(record_C.getCRNT_DRESS_UPPER());
        record_B.setCRNT_DRESS_LOWER(record_C.getCRNT_DRESS_LOWER());
        str = record_C.getCRNT_BATHG();
        if (mapValues) {
            if ("06".equals(str)) {
                record_B.setCRNT_BATHG("05");
            } else if ("05".equals(str)) {
                record_B.setCRNT_BATHG("04");
            } else {
                record_B.setCRNT_BATHG(str);
            }
        } else {
            record_B.setCRNT_BATHG(str);
        }
        record_B.setCRNT_TOILTG(record_C.getCRNT_TOILTG());
        record_B.setCRNT_TRNSFRNG(record_C.getCRNT_TRNSFRNG());
        str = record_C.getCRNT_AMBLTN();
        if (mapValues) {
            if ("02".equals(str)) {
                record_B.setCRNT_AMBLTN("01");
            } else if ("03".equals(str)) {
                record_B.setCRNT_AMBLTN("02");
            } else if ("04".equals(str)) {
                record_B.setCRNT_AMBLTN("03");
            } else if ("05".equals(str)) {
                record_B.setCRNT_AMBLTN("04");
            } else if ("06".equals(str)) {
                record_B.setCRNT_AMBLTN("05");
            } else {
                record_B.setCRNT_AMBLTN(str);
            }
        } else {
            record_B.setCRNT_AMBLTN(str);
        }
        str = record_C.getCRNT_MGMT_INJCTN_MDCTN();
        if (mapValues) {
            if ("02".equals(str)) {
                record_B.setCRNT_MGMT_INJCTN_MDCTN("01");
            } else if ("03".equals(str)) {
                record_B.setCRNT_MGMT_INJCTN_MDCTN("02");
            } else {
                record_B.setCRNT_MGMT_INJCTN_MDCTN(str);
            }
        } else {
            record_B.setCRNT_MGMT_INJCTN_MDCTN(str);
        }
        record_B.setEPISODE_TIMING(record_C.getEPISODE_TIMING());
        record_B.setPMT_DIAG_ICD_A3(record_C.getPMT_DIAG_ICD_A3());
        record_B.setPMT_DIAG_ICD_B3(record_C.getPMT_DIAG_ICD_B3());
        record_B.setPMT_DIAG_ICD_C3(record_C.getPMT_DIAG_ICD_C3());
        record_B.setPMT_DIAG_ICD_D3(record_C.getPMT_DIAG_ICD_D3());
        record_B.setPMT_DIAG_ICD_E3(record_C.getPMT_DIAG_ICD_E3());
        record_B.setPMT_DIAG_ICD_F3(record_C.getPMT_DIAG_ICD_F3());
        record_B.setPMT_DIAG_ICD_A4(record_C.getPMT_DIAG_ICD_A4());
        record_B.setPMT_DIAG_ICD_B4(record_C.getPMT_DIAG_ICD_B4());
        record_B.setPMT_DIAG_ICD_C4(record_C.getPMT_DIAG_ICD_C4());
        record_B.setPMT_DIAG_ICD_D4(record_C.getPMT_DIAG_ICD_D4());
        record_B.setPMT_DIAG_ICD_E4(record_C.getPMT_DIAG_ICD_E4());
        record_B.setPMT_DIAG_ICD_F4(record_C.getPMT_DIAG_ICD_F4());
        record_B.setTHER_NEED_NBR(record_C.getTHER_NEED_NBR());
        record_B.setTHER_NEED_NA(record_C.getTHER_NEED_NA());
        return record_B;
    }

    public static DiagnosisCodeIF parseDxCode(String strDx) {
        String tmpStr;
        DiagnosisCodeIF code = strDx == null ? DiagnosisCode_Empty.DEFAULT : ((tmpStr = HomeHealthRecordUtil.trimWithCarets(strDx)).isEmpty() ? DiagnosisCode_Empty.DEFAULT : new DiagnosisCode(tmpStr));
        return code;
    }

    public static String trimWithCarets(String strOrig) {
        int st;
        int count;
        int len = count = strOrig.length();
        int off = 0;
        char[] val = strOrig.toCharArray();
        for (st = 0; st < len && (val[off + st] <= ' ' || val[off + st] == '^'); ++st) {
        }
        while (st < len && (val[off + len - 1] <= ' ' || val[off + len - 1] == '^')) {
            --len;
        }
        try {
            return st > 0 || len < count ? new String(val, st, len - st) : strOrig;
        }
        catch (Exception ex) {
            return strOrig;
        }
    }

    public static int parseTherapyNeedNumber_C1(String strInt, int defaultValue) {
        int value;
        if (strInt == null) {
            value = defaultValue;
        } else if ((strInt = strInt.trim()).length() == 0 || strInt.charAt(0) == '^') {
            value = defaultValue;
        } else if (strInt.charAt(0) == '+' || strInt.charAt(0) == '-') {
            value = -2;
        } else {
            try {
                value = IntegerUtils.parseInt(strInt, -3);
            }
            catch (NumberFormatException e) {
                value = -3;
            }
        }
        return value;
    }

    public static String justifyRight(String str, int length, char fillchar) {
        StringBuilder buffer = new StringBuilder(length);
        str = str == null ? "" : str.trim();
        int spaceCount = length - str.length();
        while (spaceCount-- > 0) {
            buffer.append(fillchar);
        }
        buffer.append(str);
        return buffer.toString();
    }

    public static void justifyOasisCValues(Oasis_C_Record oasisRecord) {
        int caret = 94;
        oasisRecord.setNBR_PRSULC_STG2(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_PRSULC_STG2()));
        oasisRecord.setNBR_STG2_AT_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_STG2_AT_SOC_ROC()));
        oasisRecord.setNBR_PRSULC_STG3(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_PRSULC_STG3()));
        oasisRecord.setNBR_STG3_AT_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_STG3_AT_SOC_ROC()));
        oasisRecord.setNBR_PRSULC_STG4(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_PRSULC_STG4()));
        oasisRecord.setNBR_STG4_AT_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNBR_STG4_AT_SOC_ROC()));
        oasisRecord.setNSTG_DRSG(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_DRSG()));
        oasisRecord.setNSTG_DRSG_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_DRSG_SOC_ROC()));
        oasisRecord.setNSTG_CVRG(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_CVRG()));
        oasisRecord.setNSTG_CVRG_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_CVRG_SOC_ROC()));
        oasisRecord.setNSTG_DEEP_TISUE(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_DEEP_TISUE()));
        oasisRecord.setNSTG_DEEP_TISSUE_SOC_ROC(HomeHealthRecordUtil.getNormalizedIntValue(oasisRecord.getNSTG_DEEP_TISSUE_SOC_ROC()));
    }

    public static String getNormalizedIntValue(String str) {
        if (str == null || str.isEmpty()) {
            str = "  ";
        } else if (str.length() == 2) {
            if (!"  ".equals(str) && !"^ ".equals(str) && Character.isDigit(str.charAt(0)) && str.charAt(1) == ' ') {
                str = HomeHealthRecordUtil.justifyRight(str.trim(), 2, '0');
            }
        } else if (str.length() == 1 && Character.isDigit(str.charAt(0))) {
            str = HomeHealthRecordUtil.justifyRight(str.trim(), 2, '0');
        }
        return str;
    }

    public static String formatDiagnosisCodeI9(DiagnosisCodeIF dxcode) {
        String value = dxcode.getCode();
        if (value != null && !value.isEmpty()) {
            if (value.length() < 7) {
                String suffix;
                String prefix;
                int pointIdx = value.indexOf(".");
                if (pointIdx > -1) {
                    prefix = value.substring(0, pointIdx);
                    suffix = pointIdx < value.length() - 1 ? value.substring(pointIdx + 1) : "  ";
                } else {
                    prefix = value;
                    suffix = "  ";
                }
                switch (prefix.length()) {
                    case 0: {
                        prefix = "    ";
                        break;
                    }
                    case 1: {
                        prefix = "   " + prefix;
                        break;
                    }
                    case 2: {
                        prefix = "  " + prefix;
                        break;
                    }
                    case 3: {
                        prefix = " " + prefix;
                    }
                }
                switch (suffix.length()) {
                    case 0: {
                        suffix = "  ";
                        break;
                    }
                    case 1: {
                        suffix = suffix + " ";
                    }
                }
                value = pointIdx > -1 ? prefix + "." + suffix : prefix + " " + suffix;
            }
        } else {
            value = "       ";
        }
        return value;
    }

    public static String formatDxCode_C1(DiagnosisCodeIF dxCode) {
        return HomeHealthRecordUtil.formatDxCode_C1(dxCode, 7);
    }

    public static String formatDxCode_C1(DiagnosisCodeIF dxCode, int codeLength) {
        String tmpStr;
        String string = tmpStr = dxCode == null ? "" : dxCode.getCode();
        if (tmpStr.isEmpty()) {
            tmpStr = "^       ";
        } else if (tmpStr.length() < codeLength) {
            StringBuilder buffer = new StringBuilder();
            HomeHealthRecordUtil.justifyLeft(buffer, dxCode.getCode(), codeLength, '^');
            tmpStr = buffer.toString();
        }
        return tmpStr;
    }

    public static String formatTherapyNeedNum(int needNum) {
        StringBuilder buffer = new StringBuilder();
        if (needNum < 10) {
            buffer.append("0");
        }
        if (needNum < 100) {
            buffer.append("0");
        }
        buffer.append(Integer.toString(needNum));
        return buffer.toString();
    }

    public static StringBuilder justifyLeft(StringBuilder buffer, String str, int length, char fillchar) {
        int spaceCount = length - (str == null ? 0 : str.length());
        if (str != null) {
            buffer.append(str);
        }
        while (spaceCount-- > 0) {
            buffer.append(fillchar);
        }
        return buffer;
    }
}

