/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.io.AbstractRecordConverter;
import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.io.Oasis_C1_Record_2_11;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C_IF;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.text.ParseException;

public class Oasis_C1_RecordUtil_v2_11
extends AbstractRecordConverter
implements OasisRecordConverterIF {
    public Oasis_C1_RecordUtil_v2_11() {
        this("20150101", "20150930");
    }

    public Oasis_C1_RecordUtil_v2_11(String startDate, String endDate) {
        super(startDate, endDate, 3256, "2.11");
    }

    @Override
    protected String getRecordDate(String record) {
        return record.substring(434, 442);
    }

    @Override
    protected String getVersionCD(String record) {
        return record.substring(24, 34);
    }

    @Override
    public StringBuilder convertFromHomeHealthRec(HomeHealthRecordIF homeHealthRecord) {
        return this.convertFromHomeHealthToFlatRecord((HomeHealthRecord_C_IF)homeHealthRecord);
    }

    @Override
    public StringBuilder convertFromHomeHealthRecDelimeted(HomeHealthRecordIF homeHealthRecord, String delimiter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum) throws ParseException {
        return this.convertToHomeHealthRec(strRecord, recNum, true);
    }

    public HomeHealthRecordIF convertToHomeHealthRec(String M0030_START_CARE_DT, String M0090_INFO_COMPLETED_DT, String M0100_ASSMT_REASON, String M0110_EPISODE_TIMING, String M1030_THH_IV_INFUSION, String M1030_THH_PAR_NUTRITION, String M1030_THH_ENT_NUTRITION, String M1030_THH_NONE_ABOVE, String M1200_VISION, String M1242_PAIN_FREQ_ACTVTY_MVMT, String M1306_UNHLD_STG2_PRSR_ULCR, String M1308_NBR_PRSULC_STG2, String M1308_NBR_PRSULC_STG3, String M1308_NBR_PRSULC_STG4, String M1308_NSTG_DRSG, String M1308_NSTG_CVRG, String M1308_NSTG_DEEP_TISUE, String M1320_STUS_PRBLM_PRSR_ULCR, String M1322_NBR_PRSULC_STG1, String M1324_STG_PRBLM_ULCER, String M1330_STAS_ULCR_PRSNT, String M1332_NBR_STAS_ULCR, String M1334_STUS_PRBLM_STAS_ULCR, String M1340_SRGCL_WND_PRSNT, String M1342_STUS_PRBLM_SRGCL_WND, String M1350_LESION_OPEN_WND, String M1400_WHEN_DYSPNEIC, String M1610_UR_INCONT, String M1615_INCNTNT_TIMING, String M1620_BWL_INCONT, String M1630_OSTOMY, String M1810_CRNT_DRESS_UPPER, String M1820_CRNT_DRESS_LOWER, String M1830_CRNT_BATHG, String M1840_CRNT_TOILTG, String M1850_CRNT_TRNSFRNG, String M1860_CRNT_AMBLTN, String M2000_DRUG_RGMN_RVW, String M2030_CRNT_MGMT_INJCTN_MDCTN, String M2200_THER_NEED_NBR, String M2200_THER_NEED_NA, String M1021_PRIMARY_DIAG_ICD, String M1023_OTH_DIAG1_ICD, String M1023_OTH_DIAG2_ICD, String M1023_OTH_DIAG3_ICD, String M1023_OTH_DIAG4_ICD, String M1023_OTH_DIAG5_ICD, String M1025_PMT_DIAG_ICD_A3, String M1025_PMT_DIAG_ICD_A4, String M1025_PMT_DIAG_ICD_B3, String M1025_PMT_DIAG_ICD_B4, String M1025_PMT_DIAG_ICD_C3, String M1025_PMT_DIAG_ICD_C4, String M1025_PMT_DIAG_ICD_D3, String M1025_PMT_DIAG_ICD_D4, String M1025_PMT_DIAG_ICD_E3, String M1025_PMT_DIAG_ICD_E4, String M1025_PMT_DIAG_ICD_F3, String M1025_PMT_DIAG_ICD_F4) throws ParseException {
        Oasis_C1_Record_2_11 oasisRecord = new Oasis_C1_Record_2_11();
        oasisRecord.setSTART_CARE_DT(OasisCalendarFormatter.parse(M0030_START_CARE_DT));
        oasisRecord.setINFO_COMPLETED_DT(OasisCalendarFormatter.parse(M0090_INFO_COMPLETED_DT));
        oasisRecord.setASSMT_REASON(M0100_ASSMT_REASON);
        oasisRecord.setEPISODE_TIMING(M0110_EPISODE_TIMING);
        oasisRecord.setTHH_IV_INFUSION(M1030_THH_IV_INFUSION);
        oasisRecord.setTHH_PAR_NUTRITION(M1030_THH_PAR_NUTRITION);
        oasisRecord.setTHH_ENT_NUTRITION(M1030_THH_ENT_NUTRITION);
        oasisRecord.setTHH_NONE_ABOVE(M1030_THH_NONE_ABOVE);
        oasisRecord.setVISION(M1200_VISION);
        oasisRecord.setPAIN_FREQ_ACTVTY_MVMT(M1242_PAIN_FREQ_ACTVTY_MVMT);
        oasisRecord.setUNHLD_STG2_PRSR_ULCR(M1306_UNHLD_STG2_PRSR_ULCR);
        oasisRecord.setNBR_PRSULC_STG2(M1308_NBR_PRSULC_STG2);
        oasisRecord.setNBR_PRSULC_STG3(M1308_NBR_PRSULC_STG3);
        oasisRecord.setNBR_PRSULC_STG4(M1308_NBR_PRSULC_STG4);
        oasisRecord.setNSTG_DRSG(M1308_NSTG_DRSG);
        oasisRecord.setNSTG_CVRG(M1308_NSTG_CVRG);
        oasisRecord.setNSTG_DEEP_TISUE(M1308_NSTG_DEEP_TISUE);
        oasisRecord.setSTUS_PRBLM_PRSR_ULCR(M1320_STUS_PRBLM_PRSR_ULCR);
        oasisRecord.setNBR_PRSULC_STG1(M1322_NBR_PRSULC_STG1);
        oasisRecord.setSTG_PRBLM_ULCER(M1324_STG_PRBLM_ULCER);
        oasisRecord.setSTAS_ULCR_PRSNT(M1330_STAS_ULCR_PRSNT);
        oasisRecord.setNBR_STAS_ULCR(M1332_NBR_STAS_ULCR);
        oasisRecord.setSTUS_PRBLM_STAS_ULCR(M1334_STUS_PRBLM_STAS_ULCR);
        oasisRecord.setSRGCL_WND_PRSNT(M1340_SRGCL_WND_PRSNT);
        oasisRecord.setSTUS_PRBLM_SRGCL_WND(M1342_STUS_PRBLM_SRGCL_WND);
        oasisRecord.setLESION_OPEN_WND(M1350_LESION_OPEN_WND);
        oasisRecord.setWHEN_DYSPNEIC(M1400_WHEN_DYSPNEIC);
        oasisRecord.setUR_INCONT(M1610_UR_INCONT);
        oasisRecord.setINCNTNT_TIMING(M1615_INCNTNT_TIMING);
        oasisRecord.setBWL_INCONT(M1620_BWL_INCONT);
        oasisRecord.setOSTOMY(M1630_OSTOMY);
        oasisRecord.setCRNT_DRESS_UPPER(M1810_CRNT_DRESS_UPPER);
        oasisRecord.setCRNT_DRESS_LOWER(M1820_CRNT_DRESS_LOWER);
        oasisRecord.setCRNT_BATHG(M1830_CRNT_BATHG);
        oasisRecord.setCRNT_TOILTG(M1840_CRNT_TOILTG);
        oasisRecord.setCRNT_TRNSFRNG(M1850_CRNT_TRNSFRNG);
        oasisRecord.setCRNT_AMBLTN(M1860_CRNT_AMBLTN);
        oasisRecord.setDRUG_RGMN_RVW(M2000_DRUG_RGMN_RVW);
        oasisRecord.setCRNT_MGMT_INJCTN_MDCTN(M2030_CRNT_MGMT_INJCTN_MDCTN);
        oasisRecord.setTHER_NEED_NBR(HomeHealthRecordUtil.parseTherapyNeedNumber_C1(M2200_THER_NEED_NBR, -1));
        oasisRecord.setTHER_NEED_NA(M2200_THER_NEED_NA);
        oasisRecord.setPRIMARY_DIAG_ICD(HomeHealthRecordUtil.parseDxCode(M1021_PRIMARY_DIAG_ICD));
        oasisRecord.setOTH_DIAG1_ICD(HomeHealthRecordUtil.parseDxCode(M1023_OTH_DIAG1_ICD));
        oasisRecord.setOTH_DIAG2_ICD(HomeHealthRecordUtil.parseDxCode(M1023_OTH_DIAG2_ICD));
        oasisRecord.setOTH_DIAG3_ICD(HomeHealthRecordUtil.parseDxCode(M1023_OTH_DIAG3_ICD));
        oasisRecord.setOTH_DIAG4_ICD(HomeHealthRecordUtil.parseDxCode(M1023_OTH_DIAG4_ICD));
        oasisRecord.setOTH_DIAG5_ICD(HomeHealthRecordUtil.parseDxCode(M1023_OTH_DIAG5_ICD));
        oasisRecord.setPMT_DIAG_ICD_A3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_A3));
        oasisRecord.setPMT_DIAG_ICD_A4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_A4));
        oasisRecord.setPMT_DIAG_ICD_B3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_B3));
        oasisRecord.setPMT_DIAG_ICD_B4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_B4));
        oasisRecord.setPMT_DIAG_ICD_C3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_C3));
        oasisRecord.setPMT_DIAG_ICD_C4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_C4));
        oasisRecord.setPMT_DIAG_ICD_D3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_D3));
        oasisRecord.setPMT_DIAG_ICD_D4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_D4));
        oasisRecord.setPMT_DIAG_ICD_E3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_E3));
        oasisRecord.setPMT_DIAG_ICD_E4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_E4));
        oasisRecord.setPMT_DIAG_ICD_F3(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_F3));
        oasisRecord.setPMT_DIAG_ICD_F4(HomeHealthRecordUtil.parseDxCode(M1025_PMT_DIAG_ICD_F4));
        return oasisRecord;
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum, boolean skipPassthru) throws ParseException {
        Oasis_C1_Record_2_11 oasisRecord = new Oasis_C1_Record_2_11();
        if (strRecord == null) {
            throw new ParseException("OASIS record string can not be null", 0);
        }
        if (!this.isRecordConvertable(strRecord)) {
            if (strRecord.length() < this.getRecordLength()) {
                throw new ParseException("Unknown record due to invalid length of " + strRecord.length() + ", should be at least " + this.getRecordLength() + "  characters.", 0);
            }
            if (strRecord.charAt(0) != 'B' || strRecord.charAt(1) != '1') {
                throw new ParseException("Unknown record - not OASIS-C record - ID characters: \"" + strRecord.substring(0, 2) + "\"", 0);
            }
            throw new ParseException("Unknown record due to invalid dates: \"" + strRecord.substring(0, 2) + "\"", 0);
        }
        oasisRecord.setSTART_CARE_DT(OasisCalendarFormatter.parse(strRecord.substring(302, 310)));
        oasisRecord.setINFO_COMPLETED_DT(OasisCalendarFormatter.parse(strRecord.substring(434, 442)));
        oasisRecord.setASSMT_REASON(strRecord.substring(442, 444).intern());
        oasisRecord.setEPISODE_TIMING(strRecord.substring(461, 463).intern());
        oasisRecord.setPRIMARY_DIAG_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(604, 611)));
        oasisRecord.setOTH_DIAG1_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(613, 620)));
        oasisRecord.setOTH_DIAG2_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(622, 629)));
        oasisRecord.setOTH_DIAG3_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(631, 638)));
        oasisRecord.setOTH_DIAG4_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(640, 647)));
        oasisRecord.setOTH_DIAG5_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(649, 656)));
        oasisRecord.setPMT_DIAG_ICD_A3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(658, 665)));
        oasisRecord.setPMT_DIAG_ICD_B3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(665, 672)));
        oasisRecord.setPMT_DIAG_ICD_C3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(672, 679)));
        oasisRecord.setPMT_DIAG_ICD_D3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(679, 686)));
        oasisRecord.setPMT_DIAG_ICD_E3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(686, 693)));
        oasisRecord.setPMT_DIAG_ICD_F3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(693, 700)));
        oasisRecord.setPMT_DIAG_ICD_A4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(700, 707)));
        oasisRecord.setPMT_DIAG_ICD_B4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(707, 714)));
        oasisRecord.setPMT_DIAG_ICD_C4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(714, 721)));
        oasisRecord.setPMT_DIAG_ICD_D4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(721, 728)));
        oasisRecord.setPMT_DIAG_ICD_E4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(728, 735)));
        oasisRecord.setPMT_DIAG_ICD_F4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(735, 742)));
        oasisRecord.setTHH_IV_INFUSION(strRecord.substring(742, 743).intern());
        oasisRecord.setTHH_PAR_NUTRITION(strRecord.substring(743, 744).intern());
        oasisRecord.setTHH_ENT_NUTRITION(strRecord.substring(744, 745).intern());
        oasisRecord.setTHH_NONE_ABOVE(strRecord.substring(745, 746).intern());
        oasisRecord.setVISION(strRecord.substring(770, 772).intern());
        oasisRecord.setPAIN_FREQ_ACTVTY_MVMT(strRecord.substring(780, 782).intern());
        oasisRecord.setUNHLD_STG2_PRSR_ULCR(strRecord.substring(785, 786).intern());
        oasisRecord.setNBR_PRSULC_STG2(strRecord.substring(796, 798).intern());
        oasisRecord.setNBR_PRSULC_STG3(strRecord.substring(800, 802).intern());
        oasisRecord.setNBR_PRSULC_STG4(strRecord.substring(804, 806).intern());
        oasisRecord.setNSTG_DRSG(strRecord.substring(808, 810).intern());
        oasisRecord.setNSTG_CVRG(strRecord.substring(812, 814).intern());
        oasisRecord.setNSTG_DEEP_TISUE(strRecord.substring(816, 818).intern());
        oasisRecord.setSTUS_PRBLM_PRSR_ULCR(strRecord.substring(832, 834).intern());
        oasisRecord.setNBR_PRSULC_STG1(strRecord.substring(834, 836).intern());
        oasisRecord.setSTG_PRBLM_ULCER(strRecord.substring(836, 838).intern());
        oasisRecord.setSTAS_ULCR_PRSNT(strRecord.substring(838, 840).intern());
        oasisRecord.setNBR_STAS_ULCR(strRecord.substring(840, 842).intern());
        oasisRecord.setSTUS_PRBLM_STAS_ULCR(strRecord.substring(842, 844).intern());
        oasisRecord.setSRGCL_WND_PRSNT(strRecord.substring(844, 846).intern());
        oasisRecord.setSTUS_PRBLM_SRGCL_WND(strRecord.substring(846, 848).intern());
        oasisRecord.setLESION_OPEN_WND(strRecord.substring(848, 849).intern());
        oasisRecord.setWHEN_DYSPNEIC(strRecord.substring(849, 851).intern());
        oasisRecord.setUR_INCONT(strRecord.substring(865, 867).intern());
        oasisRecord.setINCNTNT_TIMING(strRecord.substring(867, 869).intern());
        oasisRecord.setBWL_INCONT(strRecord.substring(869, 871).intern());
        oasisRecord.setOSTOMY(strRecord.substring(871, 873).intern());
        oasisRecord.setCRNT_DRESS_UPPER(strRecord.substring(897, 899).intern());
        oasisRecord.setCRNT_DRESS_LOWER(strRecord.substring(899, 901).intern());
        oasisRecord.setCRNT_BATHG(strRecord.substring(901, 903).intern());
        oasisRecord.setCRNT_TOILTG(strRecord.substring(903, 905).intern());
        oasisRecord.setCRNT_TRNSFRNG(strRecord.substring(907, 909).intern());
        oasisRecord.setCRNT_AMBLTN(strRecord.substring(909, 911).intern());
        oasisRecord.setDRUG_RGMN_RVW(strRecord.substring(927, 929).intern());
        oasisRecord.setCRNT_MGMT_INJCTN_MDCTN(strRecord.substring(938, 940).intern());
        oasisRecord.setTHER_NEED_NBR(HomeHealthRecordUtil.parseTherapyNeedNumber_C1(strRecord.substring(960, 963), -1));
        oasisRecord.setTHER_NEED_NA(strRecord.substring(963, 964).intern());
        this.postProcessRecord(oasisRecord);
        return oasisRecord;
    }

    public StringBuilder convertFromHomeHealthToFlatRecord(HomeHealthRecord_C_IF oasisRecord) {
        StringBuilder buffer = new StringBuilder(3260);
        buffer.append("OASIS     ");
        buffer.append(" ");
        buffer.append("   ");
        buffer.append("C1-102014 ");
        buffer.append("2.11      ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("                ");
        buffer.append("          ");
        buffer.append("         ");
        buffer.append("                              ");
        buffer.append("                                                  ");
        buffer.append("                                                  ");
        buffer.append("                    ");
        buffer.append("                    ");
        buffer.append("     ");
        buffer.append("     ");
        buffer.append("      ");
        buffer.append("  ");
        buffer.append("          ");
        buffer.append("          ");
        buffer.append(" ");
        buffer.append("                    ");
        OasisCalendarFormatter.format(oasisRecord.getSTART_CARE_DT(), buffer);
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("            ");
        buffer.append(" ");
        buffer.append("                  ");
        buffer.append("   ");
        buffer.append("  ");
        buffer.append("           ");
        buffer.append("            ");
        buffer.append(" ");
        buffer.append("         ");
        buffer.append(" ");
        buffer.append("              ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        OasisCalendarFormatter.format(oasisRecord.getINFO_COMPLETED_DT(), buffer);
        buffer.append(oasisRecord.getASSMT_REASON());
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(oasisRecord.getEPISODE_TIMING());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("  ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append(oasisRecord.getTHH_IV_INFUSION());
        buffer.append(oasisRecord.getTHH_PAR_NUTRITION());
        buffer.append(oasisRecord.getTHH_ENT_NUTRITION());
        buffer.append(oasisRecord.getTHH_NONE_ABOVE());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getVISION());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getPAIN_FREQ_ACTVTY_MVMT());
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(oasisRecord.getUNHLD_STG2_PRSR_ULCR());
        buffer.append("  ");
        buffer.append("        ");
        buffer.append(oasisRecord.getNBR_PRSULC_STG2());
        buffer.append("  ");
        buffer.append(oasisRecord.getNBR_PRSULC_STG3());
        buffer.append("  ");
        buffer.append(oasisRecord.getNBR_PRSULC_STG4());
        buffer.append("  ");
        buffer.append(oasisRecord.getNSTG_DRSG());
        buffer.append("  ");
        buffer.append(oasisRecord.getNSTG_CVRG());
        buffer.append("  ");
        buffer.append(oasisRecord.getNSTG_DEEP_TISUE());
        buffer.append("  ");
        buffer.append("    ");
        buffer.append("    ");
        buffer.append("    ");
        buffer.append(oasisRecord.getSTUS_PRBLM_PRSR_ULCR());
        buffer.append(oasisRecord.getNBR_PRSULC_STG1());
        buffer.append(oasisRecord.getSTG_PRBLM_ULCER());
        buffer.append(oasisRecord.getSTAS_ULCR_PRSNT());
        buffer.append(oasisRecord.getNBR_STAS_ULCR());
        buffer.append(oasisRecord.getSTUS_PRBLM_STAS_ULCR());
        buffer.append(oasisRecord.getSRGCL_WND_PRSNT());
        buffer.append(oasisRecord.getSTUS_PRBLM_SRGCL_WND());
        buffer.append(oasisRecord.getLESION_OPEN_WND());
        buffer.append(oasisRecord.getWHEN_DYSPNEIC());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(oasisRecord.getUR_INCONT());
        buffer.append(oasisRecord.getINCNTNT_TIMING());
        buffer.append(oasisRecord.getBWL_INCONT());
        buffer.append(oasisRecord.getOSTOMY());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_DRESS_UPPER());
        buffer.append(oasisRecord.getCRNT_DRESS_LOWER());
        buffer.append(oasisRecord.getCRNT_BATHG());
        buffer.append(oasisRecord.getCRNT_TOILTG());
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_TRNSFRNG());
        buffer.append(oasisRecord.getCRNT_AMBLTN());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getDRUG_RGMN_RVW());
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_MGMT_INJCTN_MDCTN());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatTherapyNeedNum(oasisRecord.getTHER_NEED_NBR()));
        buffer.append(oasisRecord.getTHER_NEED_NA());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("                                                                                                                                                                                                        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPRIMARY_DIAG_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG1_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG2_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG3_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG4_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG5_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F4()));
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                              ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ");
        buffer.append("               ");
        buffer.append("               ");
        buffer.append("          ");
        buffer.append("        ");
        buffer.append("          ");
        buffer.append("          ");
        buffer.append("               ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("                              ");
        buffer.append("  ");
        buffer.append("   ");
        buffer.append(" ");
        buffer.append("     ");
        buffer.append("     ");
        buffer.append("%");
        buffer.append("\r");
        buffer.append("\n");
        return buffer;
    }

    public String getStartDate() {
        return this.dateRanger.getStartDate();
    }

    public String getEndDate() {
        return this.dateRanger.getEndDate();
    }

    @Override
    public void setStartDate(String date) {
        this.dateRanger.setStartDate(date);
    }

    @Override
    public void setEndDate(String date) throws IllegalArgumentException {
        this.dateRanger.setEndDate(date);
    }

    public void postProcessRecord(Oasis_C1_Record_2_11 oasisRecord) {
        HomeHealthRecordUtil.justifyOasisCValues(oasisRecord);
    }
}

