/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.io.AbstractRecordConverter;
import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.io.Oasis_C_Record;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C_IF;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.text.ParseException;

public class Oasis_C_RecordUtil_v2_10
extends AbstractRecordConverter
implements OasisRecordConverterIF {
    protected static final int OASIS_C_FLAT_RECORD_LENGTH = 3256;
    public static final String OASIS_ITEM_ASMT_SYS_CD = "ASMT_SYS_CD";
    public static final String OASIS_ITEM_TRANS_TYPE_CD = "TRANS_TYPE_CD";
    public static final String OASIS_ITEM_ITM_SBST_CD = "ITM_SBST_CD";
    public static final String OASIS_ITEM_ITM_SET_VRSN_CD = "ITM_SET_VRSN_CD";
    public static final String OASIS_ITEM_SPEC_VRSN_CD = "SPEC_VRSN_CD";
    public static final String OASIS_ITEM_CORRECTION_NUM = "CORRECTION_NUM";
    public static final String OASIS_ITEM_STATE_CD = "STATE_CD";
    public static final String OASIS_ITEM_HHA_AGENCY_ID = "HHA_AGENCY_ID";
    public static final String OASIS_ITEM_NATL_PRVDR_ID = "NATL_PRVDR_ID";
    public static final String OASIS_ITEM_SFW_ID = "SFW_ID";
    public static final String OASIS_ITEM_SFW_NAME = "SFW_NAME";
    public static final String OASIS_ITEM_SFW_EMAIL_ADR = "SFW_EMAIL_ADR";
    public static final String OASIS_ITEM_SFW_PROD_NAME = "SFW_PROD_NAME";
    public static final String OASIS_ITEM_SFW_PROD_VRSN_CD = "SFW_PROD_VRSN_CD";
    public static final String OASIS_ITEM_ACY_DOC_CD = "ACY_DOC_CD";
    public static final String OASIS_ITEM_SUBM_HIPPS_CODE = "SUBM_HIPPS_CODE";
    public static final String OASIS_ITEM_SUBM_HIPPS_VERSION = "SUBM_HIPPS_VERSION";
    public static final String OASIS_ITEM_M0010_CCN = "M0010_CCN";
    public static final String OASIS_ITEM_M0014_BRANCH_STATE = "M0014_BRANCH_STATE";
    public static final String OASIS_ITEM_M0016_BRANCH_ID = "M0016_BRANCH_ID";
    public static final String OASIS_ITEM_M0018_PHYSICIAN_ID = "M0018_PHYSICIAN_ID";
    public static final String OASIS_ITEM_M0018_PHYSICIAN_UK = "M0018_PHYSICIAN_UK";
    public static final String OASIS_ITEM_M0020_PAT_ID = "M0020_PAT_ID";
    public static final String OASIS_ITEM_M0030_START_CARE_DT = "M0030_START_CARE_DT";
    public static final String OASIS_ITEM_M0032_ROC_DT = "M0032_ROC_DT";
    public static final String OASIS_ITEM_M0032_ROC_DT_NA = "M0032_ROC_DT_NA";
    public static final String OASIS_ITEM_M0040_PAT_FNAME = "M0040_PAT_FNAME";
    public static final String OASIS_ITEM_M0040_PAT_MI = "M0040_PAT_MI";
    public static final String OASIS_ITEM_M0040_PAT_LNAME = "M0040_PAT_LNAME";
    public static final String OASIS_ITEM_M0040_PAT_SUFFIX = "M0040_PAT_SUFFIX";
    public static final String OASIS_ITEM_M0050_PAT_ST = "M0050_PAT_ST";
    public static final String OASIS_ITEM_M0060_PAT_ZIP = "M0060_PAT_ZIP";
    public static final String OASIS_ITEM_M0063_MEDICARE_NUM = "M0063_MEDICARE_NUM";
    public static final String OASIS_ITEM_M0063_MEDICARE_NA = "M0063_MEDICARE_NA";
    public static final String OASIS_ITEM_M0064_SSN = "M0064_SSN";
    public static final String OASIS_ITEM_M0064_SSN_UK = "M0064_SSN_UK";
    public static final String OASIS_ITEM_M0065_MEDICAID_NUM = "M0065_MEDICAID_NUM";
    public static final String OASIS_ITEM_M0065_MEDICAID_NA = "M0065_MEDICAID_NA";
    public static final String OASIS_ITEM_M0066_PAT_BIRTH_DT = "M0066_PAT_BIRTH_DT";
    public static final String OASIS_ITEM_M0069_PAT_GENDER = "M0069_PAT_GENDER";
    public static final String OASIS_ITEM_M0140_ETHNIC_AI_AN = "M0140_ETHNIC_AI_AN";
    public static final String OASIS_ITEM_M0140_ETHNIC_ASIAN = "M0140_ETHNIC_ASIAN";
    public static final String OASIS_ITEM_M0140_ETHNIC_BLACK = "M0140_ETHNIC_BLACK";
    public static final String OASIS_ITEM_M0140_ETHNIC_HISP = "M0140_ETHNIC_HISP";
    public static final String OASIS_ITEM_M0140_ETHNIC_NH_PI = "M0140_ETHNIC_NH_PI";
    public static final String OASIS_ITEM_M0140_ETHNIC_WHITE = "M0140_ETHNIC_WHITE";
    public static final String OASIS_ITEM_M0150_CPAY_NONE = "M0150_CPAY_NONE";
    public static final String OASIS_ITEM_M0150_CPAY_MCARE_FFS = "M0150_CPAY_MCARE_FFS";
    public static final String OASIS_ITEM_M0150_CPAY_MCARE_HMO = "M0150_CPAY_MCARE_HMO";
    public static final String OASIS_ITEM_M0150_CPAY_MCAID_FFS = "M0150_CPAY_MCAID_FFS";
    public static final String OASIS_ITEM_M0150_CPAY_MCAID_HMO = "M0150_CPAY_MCAID_HMO";
    public static final String OASIS_ITEM_M0150_CPAY_WRKCOMP = "M0150_CPAY_WRKCOMP";
    public static final String OASIS_ITEM_M0150_CPAY_TITLEPGMS = "M0150_CPAY_TITLEPGMS";
    public static final String OASIS_ITEM_M0150_CPAY_OTH_GOVT = "M0150_CPAY_OTH_GOVT";
    public static final String OASIS_ITEM_M0150_CPAY_PRIV_INS = "M0150_CPAY_PRIV_INS";
    public static final String OASIS_ITEM_M0150_CPAY_PRIV_HMO = "M0150_CPAY_PRIV_HMO";
    public static final String OASIS_ITEM_M0150_CPAY_SELFPAY = "M0150_CPAY_SELFPAY";
    public static final String OASIS_ITEM_M0150_CPAY_OTHER = "M0150_CPAY_OTHER";
    public static final String OASIS_ITEM_M0150_CPAY_UK = "M0150_CPAY_UK";
    public static final String OASIS_ITEM_M0080_ASSESSOR_DISCIPLINE = "M0080_ASSESSOR_DISCIPLINE";
    public static final String OASIS_ITEM_M0090_INFO_COMPLETED_DT = "M0090_INFO_COMPLETED_DT";
    public static final String OASIS_ITEM_M0100_ASSMT_REASON = "M0100_ASSMT_REASON";
    public static final String OASIS_ITEM_M0102_PHYSN_ORDRD_SOCROC_DT = "M0102_PHYSN_ORDRD_SOCROC_DT";
    public static final String OASIS_ITEM_M0102_PHYSN_ORDRD_SOCROC_DT_NA = "M0102_PHYSN_ORDRD_SOCROC_DT_NA";
    public static final String OASIS_ITEM_M0104_PHYSN_RFRL_DT = "M0104_PHYSN_RFRL_DT";
    public static final String OASIS_ITEM_M0110_EPISODE_TIMING = "M0110_EPISODE_TIMING";
    public static final String OASIS_ITEM_M1000_DC_LTC_14_DA = "M1000_DC_LTC_14_DA";
    public static final String OASIS_ITEM_M1000_DC_SNF_14_DA = "M1000_DC_SNF_14_DA";
    public static final String OASIS_ITEM_M1000_DC_IPPS_14_DA = "M1000_DC_IPPS_14_DA";
    public static final String OASIS_ITEM_M1000_DC_LTCH_14_DA = "M1000_DC_LTCH_14_DA";
    public static final String OASIS_ITEM_M1000_DC_IRF_14_DA = "M1000_DC_IRF_14_DA";
    public static final String OASIS_ITEM_M1000_DC_PSYCH_14_DA = "M1000_DC_PSYCH_14_DA";
    public static final String OASIS_ITEM_M1000_DC_OTH_14_DA = "M1000_DC_OTH_14_DA";
    public static final String OASIS_ITEM_M1000_DC_NONE_14_DA = "M1000_DC_NONE_14_DA";
    public static final String OASIS_ITEM_M1005_INP_DISCHARGE_DT = "M1005_INP_DISCHARGE_DT";
    public static final String OASIS_ITEM_M1005_INP_DSCHG_UNKNOWN = "M1005_INP_DSCHG_UNKNOWN";
    public static final String OASIS_ITEM_M1010_14_DAY_INP1_ICD = "M1010_14_DAY_INP1_ICD";
    public static final String OASIS_ITEM_M1010_14_DAY_INP2_ICD = "M1010_14_DAY_INP2_ICD";
    public static final String OASIS_ITEM_M1010_14_DAY_INP3_ICD = "M1010_14_DAY_INP3_ICD";
    public static final String OASIS_ITEM_M1010_14_DAY_INP4_ICD = "M1010_14_DAY_INP4_ICD";
    public static final String OASIS_ITEM_M1010_14_DAY_INP5_ICD = "M1010_14_DAY_INP5_ICD";
    public static final String OASIS_ITEM_M1010_14_DAY_INP6_ICD = "M1010_14_DAY_INP6_ICD";
    public static final String OASIS_ITEM_M1012_INP_PRCDR1_ICD = "M1012_INP_PRCDR1_ICD";
    public static final String OASIS_ITEM_M1012_INP_PRCDR2_ICD = "M1012_INP_PRCDR2_ICD";
    public static final String OASIS_ITEM_M1012_INP_PRCDR3_ICD = "M1012_INP_PRCDR3_ICD";
    public static final String OASIS_ITEM_M1012_INP_PRCDR4_ICD = "M1012_INP_PRCDR4_ICD";
    public static final String OASIS_ITEM_M1012_INP_NA_ICD = "M1012_INP_NA_ICD";
    public static final String OASIS_ITEM_M1012_INP_UK_ICD = "M1012_INP_UK_ICD";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD1 = "M1016_CHGREG_ICD1";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD2 = "M1016_CHGREG_ICD2";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD3 = "M1016_CHGREG_ICD3";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD4 = "M1016_CHGREG_ICD4";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD5 = "M1016_CHGREG_ICD5";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD6 = "M1016_CHGREG_ICD6";
    public static final String OASIS_ITEM_M1016_CHGREG_ICD_NA = "M1016_CHGREG_ICD_NA";
    public static final String OASIS_ITEM_M1018_PRIOR_UR_INCON = "M1018_PRIOR_UR_INCON";
    public static final String OASIS_ITEM_M1018_PRIOR_CATH = "M1018_PRIOR_CATH";
    public static final String OASIS_ITEM_M1018_PRIOR_INTRACT_PAIN = "M1018_PRIOR_INTRACT_PAIN";
    public static final String OASIS_ITEM_M1018_PRIOR_IMPR_DECSN = "M1018_PRIOR_IMPR_DECSN";
    public static final String OASIS_ITEM_M1018_PRIOR_DISRUPTIVE = "M1018_PRIOR_DISRUPTIVE";
    public static final String OASIS_ITEM_M1018_PRIOR_MEM_LOSS = "M1018_PRIOR_MEM_LOSS";
    public static final String OASIS_ITEM_M1018_PRIOR_NONE = "M1018_PRIOR_NONE";
    public static final String OASIS_ITEM_M1018_PRIOR_NOCHG_14D = "M1018_PRIOR_NOCHG_14D";
    public static final String OASIS_ITEM_M1018_PRIOR_UNKNOWN = "M1018_PRIOR_UNKNOWN";
    public static final String OASIS_ITEM_M1020_PRIMARY_DIAG_ICD = "M1020_PRIMARY_DIAG_ICD";
    public static final String OASIS_ITEM_M1020_PRIMARY_DIAG_SEVERITY = "M1020_PRIMARY_DIAG_SEVERITY";
    public static final String OASIS_ITEM_M1022_OTH_DIAG1_ICD = "M1022_OTH_DIAG1_ICD";
    public static final String OASIS_ITEM_M1022_OTH_DIAG1_SEVERITY = "M1022_OTH_DIAG1_SEVERITY";
    public static final String OASIS_ITEM_M1022_OTH_DIAG2_ICD = "M1022_OTH_DIAG2_ICD";
    public static final String OASIS_ITEM_M1022_OTH_DIAG2_SEVERITY = "M1022_OTH_DIAG2_SEVERITY";
    public static final String OASIS_ITEM_M1022_OTH_DIAG3_ICD = "M1022_OTH_DIAG3_ICD";
    public static final String OASIS_ITEM_M1022_OTH_DIAG3_SEVERITY = "M1022_OTH_DIAG3_SEVERITY";
    public static final String OASIS_ITEM_M1022_OTH_DIAG4_ICD = "M1022_OTH_DIAG4_ICD";
    public static final String OASIS_ITEM_M1022_OTH_DIAG4_SEVERITY = "M1022_OTH_DIAG4_SEVERITY";
    public static final String OASIS_ITEM_M1022_OTH_DIAG5_ICD = "M1022_OTH_DIAG5_ICD";
    public static final String OASIS_ITEM_M1022_OTH_DIAG5_SEVERITY = "M1022_OTH_DIAG5_SEVERITY";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_A3 = "M1024_PMT_DIAG_ICD_A3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_B3 = "M1024_PMT_DIAG_ICD_B3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_C3 = "M1024_PMT_DIAG_ICD_C3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_D3 = "M1024_PMT_DIAG_ICD_D3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_E3 = "M1024_PMT_DIAG_ICD_E3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_F3 = "M1024_PMT_DIAG_ICD_F3";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_A4 = "M1024_PMT_DIAG_ICD_A4";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_B4 = "M1024_PMT_DIAG_ICD_B4";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_C4 = "M1024_PMT_DIAG_ICD_C4";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_D4 = "M1024_PMT_DIAG_ICD_D4";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_E4 = "M1024_PMT_DIAG_ICD_E4";
    public static final String OASIS_ITEM_M1024_PMT_DIAG_ICD_F4 = "M1024_PMT_DIAG_ICD_F4";
    public static final String OASIS_ITEM_M1030_THH_IV_INFUSION = "M1030_THH_IV_INFUSION";
    public static final String OASIS_ITEM_M1030_THH_PAR_NUTRITION = "M1030_THH_PAR_NUTRITION";
    public static final String OASIS_ITEM_M1030_THH_ENT_NUTRITION = "M1030_THH_ENT_NUTRITION";
    public static final String OASIS_ITEM_M1030_THH_NONE_ABOVE = "M1030_THH_NONE_ABOVE";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_RCNT_DCLN = "M1032_HOSP_RISK_RCNT_DCLN";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_MLTPL_HOSPZTN = "M1032_HOSP_RISK_MLTPL_HOSPZTN";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_HSTRY_FALLS = "M1032_HOSP_RISK_HSTRY_FALLS";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_5PLUS_MDCTN = "M1032_HOSP_RISK_5PLUS_MDCTN";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_FRAILTY = "M1032_HOSP_RISK_FRAILTY";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_OTHR = "M1032_HOSP_RISK_OTHR";
    public static final String OASIS_ITEM_M1032_HOSP_RISK_NONE_ABOVE = "M1032_HOSP_RISK_NONE_ABOVE";
    public static final String OASIS_ITEM_M1034_PTNT_OVRAL_STUS = "M1034_PTNT_OVRAL_STUS";
    public static final String OASIS_ITEM_M1036_RSK_SMOKING = "M1036_RSK_SMOKING";
    public static final String OASIS_ITEM_M1036_RSK_OBESITY = "M1036_RSK_OBESITY";
    public static final String OASIS_ITEM_M1036_RSK_ALCOHOLISM = "M1036_RSK_ALCOHOLISM";
    public static final String OASIS_ITEM_M1036_RSK_DRUGS = "M1036_RSK_DRUGS";
    public static final String OASIS_ITEM_M1036_RSK_NONE = "M1036_RSK_NONE";
    public static final String OASIS_ITEM_M1036_RSK_UNKNOWN = "M1036_RSK_UNKNOWN";
    public static final String OASIS_ITEM_M1040_INFLNZ_RCVD_AGNCY = "M1040_INFLNZ_RCVD_AGNCY";
    public static final String OASIS_ITEM_M1045_INFLNZ_RSN_NOT_RCVD = "M1045_INFLNZ_RSN_NOT_RCVD";
    public static final String OASIS_ITEM_M1050_PPV_RCVD_AGNCY = "M1050_PPV_RCVD_AGNCY";
    public static final String OASIS_ITEM_M1055_PPV_RSN_NOT_RCVD_AGNCY = "M1055_PPV_RSN_NOT_RCVD_AGNCY";
    public static final String OASIS_ITEM_M1100_PTNT_LVG_STUTN = "M1100_PTNT_LVG_STUTN";
    public static final String OASIS_ITEM_M1200_VISION = "M1200_VISION";
    public static final String OASIS_ITEM_M1210_HEARG_ABLTY = "M1210_HEARG_ABLTY";
    public static final String OASIS_ITEM_M1220_UNDRSTG_VERBAL_CNTNT = "M1220_UNDRSTG_VERBAL_CNTNT";
    public static final String OASIS_ITEM_M1230_SPEECH = "M1230_SPEECH";
    public static final String OASIS_ITEM_M1240_FRML_PAIN_ASMT = "M1240_FRML_PAIN_ASMT";
    public static final String OASIS_ITEM_M1242_PAIN_FREQ_ACTVTY_MVMT = "M1242_PAIN_FREQ_ACTVTY_MVMT";
    public static final String OASIS_ITEM_M1300_PRSR_ULCR_RISK_ASMT = "M1300_PRSR_ULCR_RISK_ASMT";
    public static final String OASIS_ITEM_M1302_RISK_OF_PRSR_ULCR = "M1302_RISK_OF_PRSR_ULCR";
    public static final String OASIS_ITEM_M1306_UNHLD_STG2_PRSR_ULCR = "M1306_UNHLD_STG2_PRSR_ULCR";
    public static final String OASIS_ITEM_M1307_OLDST_STG2_AT_DSCHRG = "M1307_OLDST_STG2_AT_DSCHRG";
    public static final String OASIS_ITEM_M1307_OLDST_STG2_ONST_DT = "M1307_OLDST_STG2_ONST_DT";
    public static final String OASIS_ITEM_M1308_NBR_PRSULC_STG2 = "M1308_NBR_PRSULC_STG2";
    public static final String OASIS_ITEM_M1308_NBR_STG2_AT_SOC_ROC = "M1308_NBR_STG2_AT_SOC_ROC";
    public static final String OASIS_ITEM_M1308_NBR_PRSULC_STG3 = "M1308_NBR_PRSULC_STG3";
    public static final String OASIS_ITEM_M1308_NBR_STG3_AT_SOC_ROC = "M1308_NBR_STG3_AT_SOC_ROC";
    public static final String OASIS_ITEM_M1308_NBR_PRSULC_STG4 = "M1308_NBR_PRSULC_STG4";
    public static final String OASIS_ITEM_M1308_NBR_STG4_AT_SOC_ROC = "M1308_NBR_STG4_AT_SOC_ROC";
    public static final String OASIS_ITEM_M1308_NSTG_DRSG = "M1308_NSTG_DRSG";
    public static final String OASIS_ITEM_M1308_NSTG_DRSG_SOC_ROC = "M1308_NSTG_DRSG_SOC_ROC";
    public static final String OASIS_ITEM_M1308_NSTG_CVRG = "M1308_NSTG_CVRG";
    public static final String OASIS_ITEM_M1308_NSTG_CVRG_SOC_ROC = "M1308_NSTG_CVRG_SOC_ROC";
    public static final String OASIS_ITEM_M1308_NSTG_DEEP_TISUE = "M1308_NSTG_DEEP_TISUE";
    public static final String OASIS_ITEM_M1308_NSTG_DEEP_TISUE_SOC_ROC = "M1308_NSTG_DEEP_TISUE_SOC_ROC";
    public static final String OASIS_ITEM_M1310_PRSR_ULCR_LNGTH = "M1310_PRSR_ULCR_LNGTH";
    public static final String OASIS_ITEM_M1312_PRSR_ULCR_WDTH = "M1312_PRSR_ULCR_WDTH";
    public static final String OASIS_ITEM_M1314_PRSR_ULCR_DEPTH = "M1314_PRSR_ULCR_DEPTH";
    public static final String OASIS_ITEM_M1320_STUS_PRBLM_PRSR_ULCR = "M1320_STUS_PRBLM_PRSR_ULCR";
    public static final String OASIS_ITEM_M1322_NBR_PRSULC_STG1 = "M1322_NBR_PRSULC_STG1";
    public static final String OASIS_ITEM_M1324_STG_PRBLM_ULCER = "M1324_STG_PRBLM_ULCER";
    public static final String OASIS_ITEM_M1330_STAS_ULCR_PRSNT = "M1330_STAS_ULCR_PRSNT";
    public static final String OASIS_ITEM_M1332_NUM_STAS_ULCR = "M1332_NUM_STAS_ULCR";
    public static final String OASIS_ITEM_M1334_STUS_PRBLM_STAS_ULCR = "M1334_STUS_PRBLM_STAS_ULCR";
    public static final String OASIS_ITEM_M1340_SRGCL_WND_PRSNT = "M1340_SRGCL_WND_PRSNT";
    public static final String OASIS_ITEM_M1342_STUS_PRBLM_SRGCL_WND = "M1342_STUS_PRBLM_SRGCL_WND";
    public static final String OASIS_ITEM_M1350_LESION_OPEN_WND = "M1350_LESION_OPEN_WND";
    public static final String OASIS_ITEM_M1400_WHEN_DYSPNEIC = "M1400_WHEN_DYSPNEIC";
    public static final String OASIS_ITEM_M1410_RESPTX_OXYGEN = "M1410_RESPTX_OXYGEN";
    public static final String OASIS_ITEM_M1410_RESPTX_VENTILATOR = "M1410_RESPTX_VENTILATOR";
    public static final String OASIS_ITEM_M1410_RESPTX_AIRPRESS = "M1410_RESPTX_AIRPRESS";
    public static final String OASIS_ITEM_M1410_RESPTX_NONE = "M1410_RESPTX_NONE";
    public static final String OASIS_ITEM_M1500_SYMTM_HRT_FAILR_PTNTS = "M1500_SYMTM_HRT_FAILR_PTNTS";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_NO_ACTN = "M1510_HRT_FAILR_NO_ACTN";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_PHYSN_CNTCT = "M1510_HRT_FAILR_PHYSN_CNTCT";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_ER_TRTMT = "M1510_HRT_FAILR_ER_TRTMT";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_PHYSN_TRTMT = "M1510_HRT_FAILR_PHYSN_TRTMT";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_CLNCL_INTRVTN = "M1510_HRT_FAILR_CLNCL_INTRVTN";
    public static final String OASIS_ITEM_M1510_HRT_FAILR_CARE_PLAN_CHG = "M1510_HRT_FAILR_CARE_PLAN_CHG";
    public static final String OASIS_ITEM_M1600_UTI = "M1600_UTI";
    public static final String OASIS_ITEM_M1610_UR_INCONT = "M1610_UR_INCONT";
    public static final String OASIS_ITEM_M1615_INCNTNT_TIMING = "M1615_INCNTNT_TIMING";
    public static final String OASIS_ITEM_M1620_BWL_INCONT = "M1620_BWL_INCONT";
    public static final String OASIS_ITEM_M1630_OSTOMY = "M1630_OSTOMY";
    public static final String OASIS_ITEM_M1700_COG_FUNCTION = "M1700_COG_FUNCTION";
    public static final String OASIS_ITEM_M1710_WHEN_CONFUSED = "M1710_WHEN_CONFUSED";
    public static final String OASIS_ITEM_M1720_WHEN_ANXIOUS = "M1720_WHEN_ANXIOUS";
    public static final String OASIS_ITEM_M1730_STDZ_DPRSN_SCRNG = "M1730_STDZ_DPRSN_SCRNG";
    public static final String OASIS_ITEM_M1730_PHQ2_LACK_INTRST = "M1730_PHQ2_LACK_INTRST";
    public static final String OASIS_ITEM_M1730_PHQ2_DPRSN = "M1730_PHQ2_DPRSN";
    public static final String OASIS_ITEM_M1740_BD_MEM_DEFICIT = "M1740_BD_MEM_DEFICIT";
    public static final String OASIS_ITEM_M1740_BD_IMP_DECISN = "M1740_BD_IMP_DECISN";
    public static final String OASIS_ITEM_M1740_BD_VERBAL = "M1740_BD_VERBAL";
    public static final String OASIS_ITEM_M1740_BD_PHYSICAL = "M1740_BD_PHYSICAL";
    public static final String OASIS_ITEM_M1740_BD_SOC_INAPPRO = "M1740_BD_SOC_INAPPRO";
    public static final String OASIS_ITEM_M1740_BD_DELUSIONS = "M1740_BD_DELUSIONS";
    public static final String OASIS_ITEM_M1740_BD_NONE = "M1740_BD_NONE";
    public static final String OASIS_ITEM_M1745_BEH_PROB_FREQ = "M1745_BEH_PROB_FREQ";
    public static final String OASIS_ITEM_M1750_REC_PSYCH_NURS = "M1750_REC_PSYCH_NURS";
    public static final String OASIS_ITEM_M1800_CUR_GROOMING = "M1800_CUR_GROOMING";
    public static final String OASIS_ITEM_M1810_CUR_DRESS_UPPER = "M1810_CUR_DRESS_UPPER";
    public static final String OASIS_ITEM_M1820_CUR_DRESS_LOWER = "M1820_CUR_DRESS_LOWER";
    public static final String OASIS_ITEM_M1830_CRNT_BATHG = "M1830_CRNT_BATHG";
    public static final String OASIS_ITEM_M1840_CUR_TOILTG = "M1840_CUR_TOILTG";
    public static final String OASIS_ITEM_M1845_CUR_TOILTG_HYGN = "M1845_CUR_TOILTG_HYGN";
    public static final String OASIS_ITEM_M1850_CUR_TRNSFRNG = "M1850_CUR_TRNSFRNG";
    public static final String OASIS_ITEM_M1860_CRNT_AMBLTN = "M1860_CRNT_AMBLTN";
    public static final String OASIS_ITEM_M1870_CUR_FEEDING = "M1870_CUR_FEEDING";
    public static final String OASIS_ITEM_M1880_CUR_PREP_LT_MEALS = "M1880_CUR_PREP_LT_MEALS";
    public static final String OASIS_ITEM_M1890_CUR_PHONE_USE = "M1890_CUR_PHONE_USE";
    public static final String OASIS_ITEM_M1900_PRIOR_ADLIADL_SELF = "M1900_PRIOR_ADLIADL_SELF";
    public static final String OASIS_ITEM_M1900_PRIOR_ADLIADL_AMBLTN = "M1900_PRIOR_ADLIADL_AMBLTN";
    public static final String OASIS_ITEM_M1900_PRIOR_ADLIADL_TRNSFR = "M1900_PRIOR_ADLIADL_TRNSFR";
    public static final String OASIS_ITEM_M1900_PRIOR_ADLIADL_HSEHOLD = "M1900_PRIOR_ADLIADL_HSEHOLD";
    public static final String OASIS_ITEM_M1910_MLT_FCTR_FALL_RISK_ASMT = "M1910_MLT_FCTR_FALL_RISK_ASMT";
    public static final String OASIS_ITEM_M2000_DRUG_RGMN_RVW = "M2000_DRUG_RGMN_RVW";
    public static final String OASIS_ITEM_M2002_MDCTN_FLWP = "M2002_MDCTN_FLWP";
    public static final String OASIS_ITEM_M2004_MDCTN_INTRVTN = "M2004_MDCTN_INTRVTN";
    public static final String OASIS_ITEM_M2010_HIGH_RISK_DRUG_EDCTN = "M2010_HIGH_RISK_DRUG_EDCTN";
    public static final String OASIS_ITEM_M2015_DRUG_EDCTN_INTRVTN = "M2015_DRUG_EDCTN_INTRVTN";
    public static final String OASIS_ITEM_M2020_CRNT_MGMT_ORAL_MDCTN = "M2020_CRNT_MGMT_ORAL_MDCTN";
    public static final String OASIS_ITEM_M2030_CRNT_MGMT_INJCTN_MDCTN = "M2030_CRNT_MGMT_INJCTN_MDCTN";
    public static final String OASIS_ITEM_M2040_PRIOR_MGMT_ORAL_MDCTN = "M2040_PRIOR_MGMT_ORAL_MDCTN";
    public static final String OASIS_ITEM_M2040_PRIOR_MGMT_INJCTN_MDCTN = "M2040_PRIOR_MGMT_INJCTN_MDCTN";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_ADL = "M2100_CARE_TYPE_SRC_ADL";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_IADL = "M2100_CARE_TYPE_SRC_IADL";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_MDCTN = "M2100_CARE_TYPE_SRC_MDCTN";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_PRCDR = "M2100_CARE_TYPE_SRC_PRCDR";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_EQUIP = "M2100_CARE_TYPE_SRC_EQUIP";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_SPRVSN = "M2100_CARE_TYPE_SRC_SPRVSN";
    public static final String OASIS_ITEM_M2100_CARE_TYPE_SRC_ADVCY = "M2100_CARE_TYPE_SRC_ADVCY";
    public static final String OASIS_ITEM_M2110_ADL_IADL_ASTNC_FREQ = "M2110_ADL_IADL_ASTNC_FREQ";
    public static final String OASIS_ITEM_M2200_THER_NEED_NUM = "M2200_THER_NEED_NUM";
    public static final String OASIS_ITEM_M2200_THER_NEED_NA = "M2200_THER_NEED_NA";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_PTNT_SPECF = "M2250_PLAN_SMRY_PTNT_SPECF";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_DBTS_FT_CARE = "M2250_PLAN_SMRY_DBTS_FT_CARE";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_FALL_PRVNT = "M2250_PLAN_SMRY_FALL_PRVNT";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_DPRSN_INTRVTN = "M2250_PLAN_SMRY_DPRSN_INTRVTN";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_PAIN_INTRVTN = "M2250_PLAN_SMRY_PAIN_INTRVTN";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_PRSULC_PRVNT = "M2250_PLAN_SMRY_PRSULC_PRVNT";
    public static final String OASIS_ITEM_M2250_PLAN_SMRY_PRSULC_TRTMT = "M2250_PLAN_SMRY_PRSULC_TRTMT";
    public static final String OASIS_ITEM_M2300_EMER_USE_AFTR_LAST_ASMT = "M2300_EMER_USE_AFTR_LAST_ASMT";
    public static final String OASIS_ITEM_M2310_ECR_MEDICATION = "M2310_ECR_MEDICATION";
    public static final String OASIS_ITEM_M2310_ECR_INJRY_BY_FALL = "M2310_ECR_INJRY_BY_FALL";
    public static final String OASIS_ITEM_M2310_ECR_RSPRTRY_INFCTN = "M2310_ECR_RSPRTRY_INFCTN";
    public static final String OASIS_ITEM_M2310_ECR_RSPRTRY_OTHR = "M2310_ECR_RSPRTRY_OTHR";
    public static final String OASIS_ITEM_M2310_ECR_HRT_FAILR = "M2310_ECR_HRT_FAILR";
    public static final String OASIS_ITEM_M2310_ECR_CRDC_DSRTHM = "M2310_ECR_CRDC_DSRTHM";
    public static final String OASIS_ITEM_M2310_ECR_MI_CHST_PAIN = "M2310_ECR_MI_CHST_PAIN";
    public static final String OASIS_ITEM_M2310_ECR_OTHR_HRT_DEASE = "M2310_ECR_OTHR_HRT_DEASE";
    public static final String OASIS_ITEM_M2310_ECR_STROKE_TIA = "M2310_ECR_STROKE_TIA";
    public static final String OASIS_ITEM_M2310_ECR_HYPOGLYC = "M2310_ECR_HYPOGLYC";
    public static final String OASIS_ITEM_M2310_ECR_GI_PRBLM = "M2310_ECR_GI_PRBLM";
    public static final String OASIS_ITEM_M2310_ECR_DHYDRTN_MALNTR = "M2310_ECR_DHYDRTN_MALNTR";
    public static final String OASIS_ITEM_M2310_ECR_UTI = "M2310_ECR_UTI";
    public static final String OASIS_ITEM_M2310_ECR_CTHTR_CMPLCTN = "M2310_ECR_CTHTR_CMPLCTN";
    public static final String OASIS_ITEM_M2310_ECR_WND_INFCTN_DTRORTN = "M2310_ECR_WND_INFCTN_DTRORTN";
    public static final String OASIS_ITEM_M2310_ECR_UNCNTLD_PAIN = "M2310_ECR_UNCNTLD_PAIN";
    public static final String OASIS_ITEM_M2310_ECR_MENTL_BHVRL_PRBLM = "M2310_ECR_MENTL_BHVRL_PRBLM";
    public static final String OASIS_ITEM_M2310_ECR_DVT_PULMNRY = "M2310_ECR_DVT_PULMNRY";
    public static final String OASIS_ITEM_M2310_ECR_OTHER = "M2310_ECR_OTHER";
    public static final String OASIS_ITEM_M2310_ECR_UNKNOWN = "M2310_ECR_UNKNOWN";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_DBTS_FT = "M2400_INTRVTN_SMRY_DBTS_FT";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_FALL_PRVNT = "M2400_INTRVTN_SMRY_FALL_PRVNT";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_DPRSN = "M2400_INTRVTN_SMRY_DPRSN";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_PAIN_MNTR = "M2400_INTRVTN_SMRY_PAIN_MNTR";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_PRSULC_PRVN = "M2400_INTRVTN_SMRY_PRSULC_PRVN";
    public static final String OASIS_ITEM_M2400_INTRVTN_SMRY_PRSULC_WET = "M2400_INTRVTN_SMRY_PRSULC_WET";
    public static final String OASIS_ITEM_M2410_INPAT_FACILITY = "M2410_INPAT_FACILITY";
    public static final String OASIS_ITEM_M2420_DSCHRG_DISP = "M2420_DSCHRG_DISP";
    public static final String OASIS_ITEM_M2430_HOSP_MED = "M2430_HOSP_MED";
    public static final String OASIS_ITEM_M2430_HOSP_INJRY_BY_FALL = "M2430_HOSP_INJRY_BY_FALL";
    public static final String OASIS_ITEM_M2430_HOSP_RSPRTRY_INFCTN = "M2430_HOSP_RSPRTRY_INFCTN";
    public static final String OASIS_ITEM_M2430_HOSP_RSPRTRY_OTHR = "M2430_HOSP_RSPRTRY_OTHR";
    public static final String OASIS_ITEM_M2430_HOSP_HRT_FAILR = "M2430_HOSP_HRT_FAILR";
    public static final String OASIS_ITEM_M2430_HOSP_CRDC_DSRTHM = "M2430_HOSP_CRDC_DSRTHM";
    public static final String OASIS_ITEM_M2430_HOSP_MI_CHST_PAIN = "M2430_HOSP_MI_CHST_PAIN";
    public static final String OASIS_ITEM_M2430_HOSP_OTHR_HRT_DEASE = "M2430_HOSP_OTHR_HRT_DEASE";
    public static final String OASIS_ITEM_M2430_HOSP_STROKE_TIA = "M2430_HOSP_STROKE_TIA";
    public static final String OASIS_ITEM_M2430_HOSP_HYPOGLYC = "M2430_HOSP_HYPOGLYC";
    public static final String OASIS_ITEM_M2430_HOSP_GI_PRBLM = "M2430_HOSP_GI_PRBLM";
    public static final String OASIS_ITEM_M2430_HOSP_DHYDRTN_MALNTR = "M2430_HOSP_DHYDRTN_MALNTR";
    public static final String OASIS_ITEM_M2430_HOSP_UR_TRACT = "M2430_HOSP_UR_TRACT";
    public static final String OASIS_ITEM_M2430_HOSP_CTHTR_CMPLCTN = "M2430_HOSP_CTHTR_CMPLCTN";
    public static final String OASIS_ITEM_M2430_HOSP_WND_INFCTN = "M2430_HOSP_WND_INFCTN";
    public static final String OASIS_ITEM_M2430_HOSP_PAIN = "M2430_HOSP_PAIN";
    public static final String OASIS_ITEM_M2430_HOSP_MENTL_BHVRL_PRBLM = "M2430_HOSP_MENTL_BHVRL_PRBLM";
    public static final String OASIS_ITEM_M2430_HOSP_DVT_PULMNRY = "M2430_HOSP_DVT_PULMNRY";
    public static final String OASIS_ITEM_M2430_HOSP_SCHLD_TRTMT = "M2430_HOSP_SCHLD_TRTMT";
    public static final String OASIS_ITEM_M2430_HOSP_OTHER = "M2430_HOSP_OTHER";
    public static final String OASIS_ITEM_M2430_HOSP_UK = "M2430_HOSP_UK";
    public static final String OASIS_ITEM_M2440_NH_THERAPY = "M2440_NH_THERAPY";
    public static final String OASIS_ITEM_M2440_NH_RESPITE = "M2440_NH_RESPITE";
    public static final String OASIS_ITEM_M2440_NH_HOSPICE = "M2440_NH_HOSPICE";
    public static final String OASIS_ITEM_M2440_NH_PERMANENT = "M2440_NH_PERMANENT";
    public static final String OASIS_ITEM_M2440_NH_UNSAFE_HOME = "M2440_NH_UNSAFE_HOME";
    public static final String OASIS_ITEM_M2440_NH_OTHER = "M2440_NH_OTHER";
    public static final String OASIS_ITEM_M2440_NH_UNKNOWN = "M2440_NH_UNKNOWN";
    public static final String OASIS_ITEM_M0903_LAST_HOME_VISIT = "M0903_LAST_HOME_VISIT";
    public static final String OASIS_ITEM_M0906_DC_TRAN_DTH_DT = "M0906_DC_TRAN_DTH_DT";
    public static final String OASIS_ITEM_CONTROL_ITEMS_FILLER = "CONTROL_ITEMS_FILLER";
    public static final String OASIS_ITEM_ASMT_ITEMS_FILLER = "ASMT_ITEMS_FILLER";
    public static final String OASIS_ITEM_LEGACY_ITEMS_FILLER = "LEGACY_ITEMS_FILLER";
    public static final String OASIS_ITEM_CALCULATED_ITEMS_FILLER = "CALCULATED_ITEMS_FILLER";
    public static final String OASIS_ITEM_HHA_ASMT_INT_ID = "HHA_ASMT_INT_ID";
    public static final String OASIS_ITEM_ORIG_ASMT_INT_ID = "ORIG_ASMT_INT_ID";
    public static final String OASIS_ITEM_RES_INT_ID = "RES_INT_ID";
    public static final String OASIS_ITEM_ASMT_EFF_DATE = "ASMT_EFF_DATE";
    public static final String OASIS_ITEM_BRANCH_IDENTIFIER = "BRANCH_IDENTIFIER";
    public static final String OASIS_ITEM_FAC_INT_ID = "FAC_INT_ID";
    public static final String OASIS_ITEM_SUBMISSION_ID = "SUBMISSION_ID";
    public static final String OASIS_ITEM_SUBMISSION_DATE = "SUBMISSION_DATE";
    public static final String OASIS_ITEM_SUBMISSION_COMPLETE_DATE = "SUBMISSION_COMPLETE_DATE";
    public static final String OASIS_ITEM_SUBMITTING_USER_ID = "SUBMITTING_USER_ID";
    public static final String OASIS_ITEM_RES_MATCH_CRITERIA = "RES_MATCH_CRITERIA";
    public static final String OASIS_ITEM_RESIDENT_AGE = "RESIDENT_AGE";
    public static final String OASIS_ITEM_BIRTHDATE_SUBM_IND = "BIRTHDATE_SUBM_IND";
    public static final String OASIS_ITEM_CALC_HIPPS_CODE = "CALC_HIPPS_CODE";
    public static final String OASIS_ITEM_CALC_HIPPS_VERSION = "CALC_HIPPS_VERSION";
    public static final String OASIS_ITEM_DATA_END_INDICATOR = "DATA_END_INDICATOR";
    public static final String OASIS_ITEM_CR = "CR";
    public static final String OASIS_ITEM_LF = "LF";

    public Oasis_C_RecordUtil_v2_10() {
        super("20100101", "20141231", 3256, "2.10");
    }

    @Override
    protected String getRecordDate(String record) {
        return record.substring(434, 442);
    }

    @Override
    protected String getVersionCD(String record) {
        return record.substring(24, 34);
    }

    @Override
    public StringBuilder convertFromHomeHealthRecDelimeted(HomeHealthRecordIF homeHealthRecord, String delimiter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum, boolean skipPassthru) throws ParseException {
        Oasis_C_Record oasisRecord = new Oasis_C_Record();
        if (strRecord == null) {
            throw new ParseException("OASIS record string can not be null", 0);
        }
        if (!this.isRecordConvertable(strRecord)) {
            if (strRecord.length() < 3256) {
                throw new ParseException("Unknown record due to invalid length of " + strRecord.length() + ", should be at least " + 3256 + "  characters.", 0);
            }
            throw new ParseException("Unknown record due to invalid dates: \"" + strRecord.substring(0, 2) + "\"", 0);
        }
        oasisRecord.setSTART_CARE_DT(OasisCalendarFormatter.parse(strRecord.substring(302, 310)));
        oasisRecord.setINFO_COMPLETED_DT(OasisCalendarFormatter.parse(strRecord.substring(434, 442)));
        oasisRecord.setASSMT_REASON(strRecord.substring(442, 444));
        oasisRecord.setEPISODE_TIMING(strRecord.substring(461, 463));
        oasisRecord.setPRIMARY_DIAG_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(604, 611)));
        oasisRecord.setOTH_DIAG1_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(613, 620)));
        oasisRecord.setOTH_DIAG2_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(622, 629)));
        oasisRecord.setOTH_DIAG3_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(631, 638)));
        oasisRecord.setOTH_DIAG4_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(640, 647)));
        oasisRecord.setOTH_DIAG5_ICD(HomeHealthRecordUtil.parseDxCode(strRecord.substring(649, 656)));
        oasisRecord.setPMT_DIAG_ICD_A3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(658, 665)));
        oasisRecord.setPMT_DIAG_ICD_B3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(665, 672)));
        oasisRecord.setPMT_DIAG_ICD_C3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(672, 679)));
        oasisRecord.setPMT_DIAG_ICD_D3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(679, 686)));
        oasisRecord.setPMT_DIAG_ICD_E3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(686, 693)));
        oasisRecord.setPMT_DIAG_ICD_F3(HomeHealthRecordUtil.parseDxCode(strRecord.substring(693, 700)));
        oasisRecord.setPMT_DIAG_ICD_A4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(700, 707)));
        oasisRecord.setPMT_DIAG_ICD_B4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(707, 714)));
        oasisRecord.setPMT_DIAG_ICD_C4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(714, 721)));
        oasisRecord.setPMT_DIAG_ICD_D4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(721, 728)));
        oasisRecord.setPMT_DIAG_ICD_E4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(728, 735)));
        oasisRecord.setPMT_DIAG_ICD_F4(HomeHealthRecordUtil.parseDxCode(strRecord.substring(735, 742)));
        oasisRecord.setTHH_IV_INFUSION(strRecord.substring(742, 743));
        oasisRecord.setTHH_PAR_NUTRITION(strRecord.substring(743, 744));
        oasisRecord.setTHH_ENT_NUTRITION(strRecord.substring(744, 745));
        oasisRecord.setTHH_NONE_ABOVE(strRecord.substring(745, 746));
        oasisRecord.setVISION(strRecord.substring(770, 772));
        oasisRecord.setPAIN_FREQ_ACTVTY_MVMT(strRecord.substring(780, 782));
        oasisRecord.setUNHLD_STG2_PRSR_ULCR(strRecord.substring(785, 786));
        oasisRecord.setNBR_PRSULC_STG2(strRecord.substring(796, 798));
        oasisRecord.setNBR_STG2_AT_SOC_ROC(strRecord.substring(798, 800));
        oasisRecord.setNBR_PRSULC_STG3(strRecord.substring(800, 802));
        oasisRecord.setNBR_STG3_AT_SOC_ROC(strRecord.substring(802, 804));
        oasisRecord.setNBR_PRSULC_STG4(strRecord.substring(804, 806));
        oasisRecord.setNBR_STG4_AT_SOC_ROC(strRecord.substring(806, 808));
        oasisRecord.setNSTG_DRSG(strRecord.substring(808, 810));
        oasisRecord.setNSTG_DRSG_SOC_ROC(strRecord.substring(810, 812));
        oasisRecord.setNSTG_CVRG(strRecord.substring(812, 814));
        oasisRecord.setNSTG_CVRG_SOC_ROC(strRecord.substring(814, 816));
        oasisRecord.setNSTG_DEEP_TISUE(strRecord.substring(816, 818));
        oasisRecord.setNSTG_DEEP_TISSUE_SOC_ROC(strRecord.substring(818, 820));
        oasisRecord.setPRSR_ULCR_LNGTH(strRecord.substring(820, 824));
        oasisRecord.setPRSR_ULCR_WDTH(strRecord.substring(824, 828));
        oasisRecord.setPRSR_ULCR_DEPTH(strRecord.substring(828, 832));
        oasisRecord.setSTUS_PRBLM_PRSR_ULCR(strRecord.substring(832, 834));
        oasisRecord.setNBR_PRSULC_STG1(strRecord.substring(834, 836));
        oasisRecord.setSTG_PRBLM_ULCER(strRecord.substring(836, 838));
        oasisRecord.setSTAS_ULCR_PRSNT(strRecord.substring(838, 840));
        oasisRecord.setNBR_STAS_ULCR(strRecord.substring(840, 842));
        oasisRecord.setSTUS_PRBLM_STAS_ULCR(strRecord.substring(842, 844));
        oasisRecord.setSRGCL_WND_PRSNT(strRecord.substring(844, 846));
        oasisRecord.setSTUS_PRBLM_SRGCL_WND(strRecord.substring(846, 848));
        oasisRecord.setLESION_OPEN_WND(strRecord.substring(848, 849));
        oasisRecord.setWHEN_DYSPNEIC(strRecord.substring(849, 851));
        oasisRecord.setUR_INCONT(strRecord.substring(865, 867));
        oasisRecord.setINCNTNT_TIMING(strRecord.substring(867, 869));
        oasisRecord.setBWL_INCONT(strRecord.substring(869, 871));
        oasisRecord.setOSTOMY(strRecord.substring(871, 873));
        oasisRecord.setCRNT_DRESS_UPPER(strRecord.substring(897, 899));
        oasisRecord.setCRNT_DRESS_LOWER(strRecord.substring(899, 901));
        oasisRecord.setCRNT_BATHG(strRecord.substring(901, 903));
        oasisRecord.setCRNT_TOILTG(strRecord.substring(903, 905));
        oasisRecord.setCRNT_TRNSFRNG(strRecord.substring(907, 909));
        oasisRecord.setCRNT_AMBLTN(strRecord.substring(909, 911));
        oasisRecord.setDRUG_RGMN_RVW(strRecord.substring(927, 929));
        oasisRecord.setCRNT_MGMT_INJCTN_MDCTN(strRecord.substring(938, 940));
        oasisRecord.setTHER_NEED_NBR(HomeHealthRecordUtil.parseTherapyNeedNumber_C1(strRecord.substring(960, 963), -1));
        oasisRecord.setTHER_NEED_NA(strRecord.substring(963, 964));
        Oasis_C_RecordUtil_v2_10.postProcessRecord(oasisRecord);
        return oasisRecord;
    }

    public StringBuilder convertFromHomeHealthToFlatRecord(HomeHealthRecord_C_IF oasisRecord) {
        StringBuilder buffer = new StringBuilder(1450);
        buffer.append("          ");
        buffer.append(" ");
        buffer.append("   ");
        buffer.append("          ");
        buffer.append("          ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("                ");
        buffer.append("          ");
        buffer.append("         ");
        buffer.append("                              ");
        buffer.append("                                                  ");
        buffer.append("                                                  ");
        buffer.append("                    ");
        buffer.append("                    ");
        buffer.append("     ");
        buffer.append("     ");
        buffer.append("      ");
        buffer.append("  ");
        buffer.append("          ");
        buffer.append("          ");
        buffer.append(" ");
        buffer.append("                    ");
        OasisCalendarFormatter.format(oasisRecord.getSTART_CARE_DT(), buffer);
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("            ");
        buffer.append(" ");
        buffer.append("                  ");
        buffer.append("   ");
        buffer.append("  ");
        buffer.append("           ");
        buffer.append("            ");
        buffer.append(" ");
        buffer.append("         ");
        buffer.append(" ");
        buffer.append("              ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        OasisCalendarFormatter.format(oasisRecord.getINFO_COMPLETED_DT(), buffer);
        buffer.append(oasisRecord.getASSMT_REASON());
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(oasisRecord.getEPISODE_TIMING());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append(" ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append("       ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPRIMARY_DIAG_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG1_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG2_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG3_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG4_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG5_ICD()));
        buffer.append("  ");
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F3()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E4()));
        buffer.append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F4()));
        buffer.append(oasisRecord.getTHH_IV_INFUSION());
        buffer.append(oasisRecord.getTHH_PAR_NUTRITION());
        buffer.append(oasisRecord.getTHH_ENT_NUTRITION());
        buffer.append(oasisRecord.getTHH_NONE_ABOVE());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getVISION());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getPAIN_FREQ_ACTVTY_MVMT());
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(oasisRecord.getUNHLD_STG2_PRSR_ULCR());
        buffer.append("  ");
        buffer.append("        ");
        buffer.append(oasisRecord.getNBR_PRSULC_STG2());
        buffer.append(oasisRecord.getNBR_STG2_AT_SOC_ROC());
        buffer.append(oasisRecord.getNBR_PRSULC_STG3());
        buffer.append(oasisRecord.getNBR_STG3_AT_SOC_ROC());
        buffer.append(oasisRecord.getNBR_PRSULC_STG4());
        buffer.append(oasisRecord.getNBR_STG4_AT_SOC_ROC());
        buffer.append(oasisRecord.getNSTG_DRSG());
        buffer.append(oasisRecord.getNSTG_DRSG_SOC_ROC());
        buffer.append(oasisRecord.getNSTG_CVRG());
        buffer.append(oasisRecord.getNSTG_CVRG_SOC_ROC());
        buffer.append(oasisRecord.getNSTG_DEEP_TISUE());
        buffer.append("  ");
        buffer.append("    ");
        buffer.append("    ");
        buffer.append("    ");
        buffer.append(oasisRecord.getSTUS_PRBLM_PRSR_ULCR());
        buffer.append(oasisRecord.getNBR_PRSULC_STG1());
        buffer.append(oasisRecord.getSTG_PRBLM_ULCER());
        buffer.append(oasisRecord.getSTAS_ULCR_PRSNT());
        buffer.append("  ");
        buffer.append(oasisRecord.getSTUS_PRBLM_STAS_ULCR());
        buffer.append(oasisRecord.getSRGCL_WND_PRSNT());
        buffer.append(oasisRecord.getSTUS_PRBLM_SRGCL_WND());
        buffer.append(oasisRecord.getLESION_OPEN_WND());
        buffer.append(oasisRecord.getWHEN_DYSPNEIC());
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(oasisRecord.getUR_INCONT());
        buffer.append(oasisRecord.getINCNTNT_TIMING());
        buffer.append(oasisRecord.getBWL_INCONT());
        buffer.append(oasisRecord.getOSTOMY());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_BATHG());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_AMBLTN());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getDRUG_RGMN_RVW());
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(oasisRecord.getCRNT_MGMT_INJCTN_MDCTN());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("   ");
        buffer.append(oasisRecord.getTHER_NEED_NA());
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append("  ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append(" ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("                                                                                                                                                                                                        ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                              ");
        buffer.append("                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ");
        buffer.append("               ");
        buffer.append("               ");
        buffer.append("          ");
        buffer.append("        ");
        buffer.append("          ");
        buffer.append("          ");
        buffer.append("               ");
        buffer.append("        ");
        buffer.append("        ");
        buffer.append("                              ");
        buffer.append("  ");
        buffer.append("   ");
        buffer.append(" ");
        buffer.append("     ");
        buffer.append("     ");
        buffer.append(" ");
        buffer.append("\r");
        buffer.append("\n");
        return buffer;
    }

    public StringBuilder convertFromHomeHealthToXmlRecord(HomeHealthRecord_C_IF oasisRecord) {
        StringBuilder buffer = new StringBuilder(3000);
        buffer.append("<ASSESSMENT>");
        buffer.append("  <ASMT_SYS_CD>OASIS</ASMT_SYS_CD>");
        buffer.append("  <TRANS_TYPE_CD>1</TRANS_TYPE_CD>");
        buffer.append("  <ITM_SBST_CD>01</ITM_SBST_CD>");
        buffer.append("  <ITM_SET_VRSN_CD>C1-102014</ITM_SET_VRSN_CD>");
        buffer.append("  <SPEC_VRSN_CD>2.11</SPEC_VRSN_CD>");
        buffer.append("  <CORRECTION_NUM>").append("</CORRECTION_NUM>");
        buffer.append("  <STATE_CD>").append("</STATE_CD>");
        buffer.append("  <HHA_AGENCY_ID>").append("</HHA_AGENCY_ID>");
        buffer.append("  <NATL_PRVDR_ID>").append("</NATL_PRVDR_ID>");
        buffer.append("  <SFW_ID>").append("</SFW_ID>");
        buffer.append("  <SFW_NAME>").append("</SFW_NAME>");
        buffer.append("  <SFW_EMAIL_ADR>").append("</SFW_EMAIL_ADR>");
        buffer.append("  <SFW_PROD_NAME>").append("</SFW_PROD_NAME>");
        buffer.append("  <SFW_PROD_VRSN_CD>").append("</SFW_PROD_VRSN_CD>");
        buffer.append("  <ACY_DOC_CD>").append("</ACY_DOC_CD>");
        buffer.append("  <SUBM_HIPPS_CODE>").append("</SUBM_HIPPS_CODE>");
        buffer.append("  <SUBM_HIPPS_VERSION>").append("</SUBM_HIPPS_VERSION>");
        buffer.append("  <M0010_CCN>").append("</M0010_CCN>");
        buffer.append("  <M0014_BRANCH_STATE>").append("</M0014_BRANCH_STATE>");
        buffer.append("  <M0016_BRANCH_ID>").append("</M0016_BRANCH_ID>");
        buffer.append("  <M0018_PHYSICIAN_ID>").append("</M0018_PHYSICIAN_ID>");
        buffer.append("  <M0018_PHYSICIAN_UK>").append("</M0018_PHYSICIAN_UK>");
        buffer.append("  <M0020_PAT_ID>").append("</M0020_PAT_ID>");
        buffer.append("  <M0030_START_CARE_DT>");
        OasisCalendarFormatter.format(oasisRecord.getSTART_CARE_DT(), buffer).append("</M0030_START_CARE_DT>");
        buffer.append("  <M0032_ROC_DT>").append("</M0032_ROC_DT>");
        buffer.append("  <M0032_ROC_DT_NA>").append("</M0032_ROC_DT_NA>");
        buffer.append("  <M0040_PAT_FNAME>").append("</M0040_PAT_FNAME>");
        buffer.append("  <M0040_PAT_MI>").append("</M0040_PAT_MI>");
        buffer.append("  <M0040_PAT_LNAME>").append("</M0040_PAT_LNAME>");
        buffer.append("  <M0040_PAT_SUFFIX>").append("</M0040_PAT_SUFFIX>");
        buffer.append("  <M0050_PAT_ST>").append("</M0050_PAT_ST>");
        buffer.append("  <M0060_PAT_ZIP>").append("</M0060_PAT_ZIP>");
        buffer.append("  <M0063_MEDICARE_NUM>").append("</M0063_MEDICARE_NUM>");
        buffer.append("  <M0063_MEDICARE_NA>").append("</M0063_MEDICARE_NA>");
        buffer.append("  <M0064_SSN>").append("</M0064_SSN>");
        buffer.append("  <M0064_SSN_UK>").append("</M0064_SSN_UK>");
        buffer.append("  <M0065_MEDICAID_NUM>").append("</M0065_MEDICAID_NUM>");
        buffer.append("  <M0065_MEDICAID_NA>").append("</M0065_MEDICAID_NA>");
        buffer.append("  <M0066_PAT_BIRTH_DT>").append("</M0066_PAT_BIRTH_DT>");
        buffer.append("  <M0069_PAT_GENDER>").append("</M0069_PAT_GENDER>");
        buffer.append("  <M0140_ETHNIC_AI_AN>").append("</M0140_ETHNIC_AI_AN>");
        buffer.append("  <M0140_ETHNIC_ASIAN>").append("</M0140_ETHNIC_ASIAN>");
        buffer.append("  <M0140_ETHNIC_BLACK>").append("</M0140_ETHNIC_BLACK>");
        buffer.append("  <M0140_ETHNIC_HISP>").append("</M0140_ETHNIC_HISP>");
        buffer.append("  <M0140_ETHNIC_NH_PI>").append("</M0140_ETHNIC_NH_PI>");
        buffer.append("  <M0140_ETHNIC_WHITE>").append("</M0140_ETHNIC_WHITE>");
        buffer.append("  <M0150_CPAY_NONE>").append("</M0150_CPAY_NONE>");
        buffer.append("  <M0150_CPAY_MCARE_FFS>").append("</M0150_CPAY_MCARE_FFS>");
        buffer.append("  <M0150_CPAY_MCARE_HMO>").append("</M0150_CPAY_MCARE_HMO>");
        buffer.append("  <M0150_CPAY_MCAID_FFS>").append("</M0150_CPAY_MCAID_FFS>");
        buffer.append("  <M0150_CPAY_MCAID_HMO>").append("</M0150_CPAY_MCAID_HMO>");
        buffer.append("  <M0150_CPAY_WRKCOMP>").append("</M0150_CPAY_WRKCOMP>");
        buffer.append("  <M0150_CPAY_TITLEPGMS>").append("</M0150_CPAY_TITLEPGMS>");
        buffer.append("  <M0150_CPAY_OTH_GOVT>").append("</M0150_CPAY_OTH_GOVT>");
        buffer.append("  <M0150_CPAY_PRIV_INS>").append("</M0150_CPAY_PRIV_INS>");
        buffer.append("  <M0150_CPAY_PRIV_HMO>").append("</M0150_CPAY_PRIV_HMO>");
        buffer.append("  <M0150_CPAY_SELFPAY>").append("</M0150_CPAY_SELFPAY>");
        buffer.append("  <M0150_CPAY_OTHER>").append("</M0150_CPAY_OTHER>");
        buffer.append("  <M0150_CPAY_UK>").append("</M0150_CPAY_UK>");
        buffer.append("  <M0080_ASSESSOR_DISCIPLINE>").append("</M0080_ASSESSOR_DISCIPLINE>");
        buffer.append("  <M0090_INFO_COMPLETED_DT>");
        OasisCalendarFormatter.format(oasisRecord.getINFO_COMPLETED_DT(), buffer).append("</M0090_INFO_COMPLETED_DT>");
        buffer.append("  <M0100_ASSMT_REASON>").append(oasisRecord.getASSMT_REASON()).append("</M0100_ASSMT_REASON>");
        buffer.append("  <M0102_PHYSN_ORDRD_SOCROC_DT>").append("</M0102_PHYSN_ORDRD_SOCROC_DT>");
        buffer.append("  <M0102_PHYSN_ORDRD_SOCROC_DT_NA>").append("</M0102_PHYSN_ORDRD_SOCROC_DT_NA>");
        buffer.append("  <M0104_PHYSN_RFRL_DT>").append("</M0104_PHYSN_RFRL_DT>");
        buffer.append("  <M0110_EPISODE_TIMING>").append(oasisRecord.getEPISODE_TIMING()).append("</M0110_EPISODE_TIMING>");
        buffer.append("  <M1000_DC_LTC_14_DA>").append("</M1000_DC_LTC_14_DA>");
        buffer.append("  <M1000_DC_SNF_14_DA>").append("</M1000_DC_SNF_14_DA>");
        buffer.append("  <M1000_DC_IPPS_14_DA>").append("</M1000_DC_IPPS_14_DA>");
        buffer.append("  <M1000_DC_LTCH_14_DA>").append("</M1000_DC_LTCH_14_DA>");
        buffer.append("  <M1000_DC_IRF_14_DA>").append("</M1000_DC_IRF_14_DA>");
        buffer.append("  <M1000_DC_PSYCH_14_DA>").append("</M1000_DC_PSYCH_14_DA>");
        buffer.append("  <M1000_DC_OTH_14_DA>").append("</M1000_DC_OTH_14_DA>");
        buffer.append("  <M1000_DC_NONE_14_DA>").append("</M1000_DC_NONE_14_DA>");
        buffer.append("  <M1005_INP_DISCHARGE_DT>").append("</M1005_INP_DISCHARGE_DT>");
        buffer.append("  <M1005_INP_DSCHG_UNKNOWN>").append("</M1005_INP_DSCHG_UNKNOWN>");
        buffer.append("  <M1010_14_DAY_INP1_ICD>").append("</M1010_14_DAY_INP1_ICD>");
        buffer.append("  <M1010_14_DAY_INP2_ICD>").append("</M1010_14_DAY_INP2_ICD>");
        buffer.append("  <M1010_14_DAY_INP3_ICD>").append("</M1010_14_DAY_INP3_ICD>");
        buffer.append("  <M1010_14_DAY_INP4_ICD>").append("</M1010_14_DAY_INP4_ICD>");
        buffer.append("  <M1010_14_DAY_INP5_ICD>").append("</M1010_14_DAY_INP5_ICD>");
        buffer.append("  <M1010_14_DAY_INP6_ICD>").append("</M1010_14_DAY_INP6_ICD>");
        buffer.append("  <M1012_INP_PRCDR1_ICD>").append("</M1012_INP_PRCDR1_ICD>");
        buffer.append("  <M1012_INP_PRCDR2_ICD>").append("</M1012_INP_PRCDR2_ICD>");
        buffer.append("  <M1012_INP_PRCDR3_ICD>").append("</M1012_INP_PRCDR3_ICD>");
        buffer.append("  <M1012_INP_PRCDR4_ICD>").append("</M1012_INP_PRCDR4_ICD>");
        buffer.append("  <M1012_INP_NA_ICD>").append("</M1012_INP_NA_ICD>");
        buffer.append("  <M1012_INP_UK_ICD>").append("</M1012_INP_UK_ICD>");
        buffer.append("  <M1016_CHGREG_ICD1>").append("</M1016_CHGREG_ICD1>");
        buffer.append("  <M1016_CHGREG_ICD2>").append("</M1016_CHGREG_ICD2>");
        buffer.append("  <M1016_CHGREG_ICD3>").append("</M1016_CHGREG_ICD3>");
        buffer.append("  <M1016_CHGREG_ICD4>").append("</M1016_CHGREG_ICD4>");
        buffer.append("  <M1016_CHGREG_ICD5>").append("</M1016_CHGREG_ICD5>");
        buffer.append("  <M1016_CHGREG_ICD6>").append("</M1016_CHGREG_ICD6>");
        buffer.append("  <M1016_CHGREG_ICD_NA>").append("</M1016_CHGREG_ICD_NA>");
        buffer.append("  <M1018_PRIOR_UR_INCON>").append("</M1018_PRIOR_UR_INCON>");
        buffer.append("  <M1018_PRIOR_CATH>").append("</M1018_PRIOR_CATH>");
        buffer.append("  <M1018_PRIOR_INTRACT_PAIN>").append("</M1018_PRIOR_INTRACT_PAIN>");
        buffer.append("  <M1018_PRIOR_IMPR_DECSN>").append("</M1018_PRIOR_IMPR_DECSN>");
        buffer.append("  <M1018_PRIOR_DISRUPTIVE>").append("</M1018_PRIOR_DISRUPTIVE>");
        buffer.append("  <M1018_PRIOR_MEM_LOSS>").append("</M1018_PRIOR_MEM_LOSS>");
        buffer.append("  <M1018_PRIOR_NONE>").append("</M1018_PRIOR_NONE>");
        buffer.append("  <M1018_PRIOR_NOCHG_14D>").append("</M1018_PRIOR_NOCHG_14D>");
        buffer.append("  <M1018_PRIOR_UNKNOWN>").append("</M1018_PRIOR_UNKNOWN>");
        buffer.append("  <M1020_PRIMARY_DIAG_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPRIMARY_DIAG_ICD())).append("</M1020_PRIMARY_DIAG_ICD>");
        buffer.append("  <M1020_PRIMARY_DIAG_SEVERITY>").append("</M1020_PRIMARY_DIAG_SEVERITY>");
        buffer.append("  <M1022_OTH_DIAG1_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG1_ICD())).append("</M1022_OTH_DIAG1_ICD>");
        buffer.append("  <M1022_OTH_DIAG1_SEVERITY>").append("</M1022_OTH_DIAG1_SEVERITY>");
        buffer.append("  <M1022_OTH_DIAG2_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG2_ICD())).append("</M1022_OTH_DIAG2_ICD>");
        buffer.append("  <M1022_OTH_DIAG2_SEVERITY>").append("</M1022_OTH_DIAG2_SEVERITY>");
        buffer.append("  <M1022_OTH_DIAG3_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG3_ICD())).append("</M1022_OTH_DIAG3_ICD>");
        buffer.append("  <M1022_OTH_DIAG3_SEVERITY>").append("</M1022_OTH_DIAG3_SEVERITY>");
        buffer.append("  <M1022_OTH_DIAG4_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG4_ICD())).append("</M1022_OTH_DIAG4_ICD>");
        buffer.append("  <M1022_OTH_DIAG4_SEVERITY>").append("</M1022_OTH_DIAG4_SEVERITY>");
        buffer.append("  <M1022_OTH_DIAG5_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG5_ICD())).append("</M1022_OTH_DIAG5_ICD>");
        buffer.append("  <M1022_OTH_DIAG5_SEVERITY>").append("</M1022_OTH_DIAG5_SEVERITY>");
        buffer.append("  <M1024_PMT_DIAG_ICD_A3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A3())).append("</M1024_PMT_DIAG_ICD_A3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_B3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B3())).append("</M1024_PMT_DIAG_ICD_B3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_C3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C3())).append("</M1024_PMT_DIAG_ICD_C3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_D3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D3())).append("</M1024_PMT_DIAG_ICD_D3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_E3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E3())).append("</M1024_PMT_DIAG_ICD_E3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_F3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F3())).append("</M1024_PMT_DIAG_ICD_F3>");
        buffer.append("  <M1024_PMT_DIAG_ICD_A4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A4())).append("</M1024_PMT_DIAG_ICD_A4>");
        buffer.append("  <M1024_PMT_DIAG_ICD_B4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B4())).append("</M1024_PMT_DIAG_ICD_B4>");
        buffer.append("  <M1024_PMT_DIAG_ICD_C4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C4())).append("</M1024_PMT_DIAG_ICD_C4>");
        buffer.append("  <M1024_PMT_DIAG_ICD_D4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D4())).append("</M1024_PMT_DIAG_ICD_D4>");
        buffer.append("  <M1024_PMT_DIAG_ICD_E4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E4())).append("</M1024_PMT_DIAG_ICD_E4>");
        buffer.append("  <M1024_PMT_DIAG_ICD_F4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F4())).append("</M1024_PMT_DIAG_ICD_F4>");
        buffer.append("  <M1030_THH_IV_INFUSION>").append(oasisRecord.getTHH_IV_INFUSION()).append("</M1030_THH_IV_INFUSION>");
        buffer.append("  <M1030_THH_PAR_NUTRITION>").append(oasisRecord.getTHH_PAR_NUTRITION()).append("</M1030_THH_PAR_NUTRITION>");
        buffer.append("  <M1030_THH_ENT_NUTRITION>").append(oasisRecord.getTHH_ENT_NUTRITION()).append("</M1030_THH_ENT_NUTRITION>");
        buffer.append("  <M1030_THH_NONE_ABOVE>").append(oasisRecord.getTHH_NONE_ABOVE()).append("</M1030_THH_NONE_ABOVE>");
        buffer.append("  <M1032_HOSP_RISK_RCNT_DCLN>").append("</M1032_HOSP_RISK_RCNT_DCLN>");
        buffer.append("  <M1032_HOSP_RISK_MLTPL_HOSPZTN>").append("</M1032_HOSP_RISK_MLTPL_HOSPZTN>");
        buffer.append("  <M1032_HOSP_RISK_HSTRY_FALLS>").append("</M1032_HOSP_RISK_HSTRY_FALLS>");
        buffer.append("  <M1032_HOSP_RISK_5PLUS_MDCTN>").append("</M1032_HOSP_RISK_5PLUS_MDCTN>");
        buffer.append("  <M1032_HOSP_RISK_FRAILTY>").append("</M1032_HOSP_RISK_FRAILTY>");
        buffer.append("  <M1032_HOSP_RISK_OTHR>").append("</M1032_HOSP_RISK_OTHR>");
        buffer.append("  <M1032_HOSP_RISK_NONE_ABOVE>").append("</M1032_HOSP_RISK_NONE_ABOVE>");
        buffer.append("  <M1034_PTNT_OVRAL_STUS>").append("</M1034_PTNT_OVRAL_STUS>");
        buffer.append("  <M1036_RSK_SMOKING>").append("</M1036_RSK_SMOKING>");
        buffer.append("  <M1036_RSK_OBESITY>").append("</M1036_RSK_OBESITY>");
        buffer.append("  <M1036_RSK_ALCOHOLISM>").append("</M1036_RSK_ALCOHOLISM>");
        buffer.append("  <M1036_RSK_DRUGS>").append("</M1036_RSK_DRUGS>");
        buffer.append("  <M1036_RSK_NONE>").append("</M1036_RSK_NONE>");
        buffer.append("  <M1036_RSK_UNKNOWN>").append("</M1036_RSK_UNKNOWN>");
        buffer.append("  <M1040_INFLNZ_RCVD_AGNCY>").append("</M1040_INFLNZ_RCVD_AGNCY>");
        buffer.append("  <M1045_INFLNZ_RSN_NOT_RCVD>").append("</M1045_INFLNZ_RSN_NOT_RCVD>");
        buffer.append("  <M1050_PPV_RCVD_AGNCY>").append("</M1050_PPV_RCVD_AGNCY>");
        buffer.append("  <M1055_PPV_RSN_NOT_RCVD_AGNCY>").append("</M1055_PPV_RSN_NOT_RCVD_AGNCY>");
        buffer.append("  <M1100_PTNT_LVG_STUTN>").append("</M1100_PTNT_LVG_STUTN>");
        buffer.append("  <M1200_VISION>").append(oasisRecord.getVISION()).append("</M1200_VISION>");
        buffer.append("  <M1210_HEARG_ABLTY>").append("</M1210_HEARG_ABLTY>");
        buffer.append("  <M1220_UNDRSTG_VERBAL_CNTNT>").append("</M1220_UNDRSTG_VERBAL_CNTNT>");
        buffer.append("  <M1230_SPEECH>").append("</M1230_SPEECH>");
        buffer.append("  <M1240_FRML_PAIN_ASMT>").append("</M1240_FRML_PAIN_ASMT>");
        buffer.append("  <M1242_PAIN_FREQ_ACTVTY_MVMT>").append(oasisRecord.getPAIN_FREQ_ACTVTY_MVMT()).append("</M1242_PAIN_FREQ_ACTVTY_MVMT>");
        buffer.append("  <M1300_PRSR_ULCR_RISK_ASMT>").append("</M1300_PRSR_ULCR_RISK_ASMT>");
        buffer.append("  <M1302_RISK_OF_PRSR_ULCR>").append("</M1302_RISK_OF_PRSR_ULCR>");
        buffer.append("  <M1306_UNHLD_STG2_PRSR_ULCR>").append(oasisRecord.getUNHLD_STG2_PRSR_ULCR()).append("</M1306_UNHLD_STG2_PRSR_ULCR>");
        buffer.append("  <M1307_OLDST_STG2_AT_DSCHRG>").append("</M1307_OLDST_STG2_AT_DSCHRG>");
        buffer.append("  <M1307_OLDST_STG2_ONST_DT>").append("</M1307_OLDST_STG2_ONST_DT>");
        buffer.append("  <M1308_NBR_PRSULC_STG2>").append(oasisRecord.getNBR_PRSULC_STG2()).append("</M1308_NBR_PRSULC_STG2>");
        buffer.append("  <M1308_NBR_STG2_AT_SOC_ROC>").append(oasisRecord.getNBR_STG2_AT_SOC_ROC()).append("</M1308_NBR_STG2_AT_SOC_ROC>");
        buffer.append("  <M1308_NBR_PRSULC_STG3>").append(oasisRecord.getNBR_PRSULC_STG3()).append("</M1308_NBR_PRSULC_STG3>");
        buffer.append("  <M1308_NBR_STG3_AT_SOC_ROC>").append(oasisRecord.getNBR_STG3_AT_SOC_ROC()).append("</M1308_NBR_STG3_AT_SOC_ROC>");
        buffer.append("  <M1308_NBR_PRSULC_STG4>").append(oasisRecord.getNBR_PRSULC_STG4()).append("</M1308_NBR_PRSULC_STG4>");
        buffer.append("  <M1308_NBR_STG4_AT_SOC_ROC>").append(oasisRecord.getNBR_STG4_AT_SOC_ROC()).append("</M1308_NBR_STG4_AT_SOC_ROC>");
        buffer.append("  <M1308_NSTG_DRSG>").append(oasisRecord.getNSTG_DRSG()).append("</M1308_NSTG_DRSG>");
        buffer.append("  <M1308_NSTG_DRSG_SOC_ROC>").append(oasisRecord.getNSTG_DRSG_SOC_ROC()).append("</M1308_NSTG_DRSG_SOC_ROC>");
        buffer.append("  <M1308_NSTG_CVRG>").append(oasisRecord.getNSTG_CVRG()).append("</M1308_NSTG_CVRG>");
        buffer.append("  <M1308_NSTG_CVRG_SOC_ROC>").append(oasisRecord.getNSTG_CVRG_SOC_ROC()).append("</M1308_NSTG_CVRG_SOC_ROC>");
        buffer.append("  <M1308_NSTG_DEEP_TISUE>").append(oasisRecord.getNSTG_DEEP_TISUE()).append("</M1308_NSTG_DEEP_TISUE>");
        buffer.append("  <M1308_NSTG_DEEP_TISUE_SOC_ROC>").append("</M1308_NSTG_DEEP_TISUE_SOC_ROC>");
        buffer.append("  <M1310_PRSR_ULCR_LNGTH>").append("</M1310_PRSR_ULCR_LNGTH>");
        buffer.append("  <M1312_PRSR_ULCR_WDTH>").append("</M1312_PRSR_ULCR_WDTH>");
        buffer.append("  <M1314_PRSR_ULCR_DEPTH>").append("</M1314_PRSR_ULCR_DEPTH>");
        buffer.append("  <M1320_STUS_PRBLM_PRSR_ULCR>").append(oasisRecord.getSTUS_PRBLM_PRSR_ULCR()).append("</M1320_STUS_PRBLM_PRSR_ULCR>");
        buffer.append("  <M1322_NBR_PRSULC_STG1>").append(oasisRecord.getNBR_PRSULC_STG1()).append("</M1322_NBR_PRSULC_STG1>");
        buffer.append("  <M1324_STG_PRBLM_ULCER>").append(oasisRecord.getSTG_PRBLM_ULCER()).append("</M1324_STG_PRBLM_ULCER>");
        buffer.append("  <M1330_STAS_ULCR_PRSNT>").append(oasisRecord.getSTAS_ULCR_PRSNT()).append("</M1330_STAS_ULCR_PRSNT>");
        buffer.append("  <M1332_NUM_STAS_ULCR>").append("</M1332_NUM_STAS_ULCR>");
        buffer.append("  <M1334_STUS_PRBLM_STAS_ULCR>").append(oasisRecord.getSTUS_PRBLM_STAS_ULCR()).append("</M1334_STUS_PRBLM_STAS_ULCR>");
        buffer.append("  <M1340_SRGCL_WND_PRSNT>").append(oasisRecord.getSRGCL_WND_PRSNT()).append("</M1340_SRGCL_WND_PRSNT>");
        buffer.append("  <M1342_STUS_PRBLM_SRGCL_WND>").append(oasisRecord.getSTUS_PRBLM_SRGCL_WND()).append("</M1342_STUS_PRBLM_SRGCL_WND>");
        buffer.append("  <M1350_LESION_OPEN_WND>").append(oasisRecord.getLESION_OPEN_WND()).append("</M1350_LESION_OPEN_WND>");
        buffer.append("  <M1400_WHEN_DYSPNEIC>").append(oasisRecord.getWHEN_DYSPNEIC()).append("</M1400_WHEN_DYSPNEIC>");
        buffer.append("  <M1410_RESPTX_OXYGEN>").append("</M1410_RESPTX_OXYGEN>");
        buffer.append("  <M1410_RESPTX_VENTILATOR>").append("</M1410_RESPTX_VENTILATOR>");
        buffer.append("  <M1410_RESPTX_AIRPRESS>").append("</M1410_RESPTX_AIRPRESS>");
        buffer.append("  <M1410_RESPTX_NONE>").append("</M1410_RESPTX_NONE>");
        buffer.append("  <M1500_SYMTM_HRT_FAILR_PTNTS>").append("</M1500_SYMTM_HRT_FAILR_PTNTS>");
        buffer.append("  <M1510_HRT_FAILR_NO_ACTN>").append("</M1510_HRT_FAILR_NO_ACTN>");
        buffer.append("  <M1510_HRT_FAILR_PHYSN_CNTCT>").append("</M1510_HRT_FAILR_PHYSN_CNTCT>");
        buffer.append("  <M1510_HRT_FAILR_ER_TRTMT>").append("</M1510_HRT_FAILR_ER_TRTMT>");
        buffer.append("  <M1510_HRT_FAILR_PHYSN_TRTMT>").append("</M1510_HRT_FAILR_PHYSN_TRTMT>");
        buffer.append("  <M1510_HRT_FAILR_CLNCL_INTRVTN>").append("</M1510_HRT_FAILR_CLNCL_INTRVTN>");
        buffer.append("  <M1510_HRT_FAILR_CARE_PLAN_CHG>").append("</M1510_HRT_FAILR_CARE_PLAN_CHG>");
        buffer.append("  <M1600_UTI>").append("</M1600_UTI>");
        buffer.append("  <M1610_UR_INCONT>").append(oasisRecord.getUR_INCONT()).append("</M1610_UR_INCONT>");
        buffer.append("  <M1615_INCNTNT_TIMING>").append(oasisRecord.getINCNTNT_TIMING()).append("</M1615_INCNTNT_TIMING>");
        buffer.append("  <M1620_BWL_INCONT>").append(oasisRecord.getBWL_INCONT()).append("</M1620_BWL_INCONT>");
        buffer.append("  <M1630_OSTOMY>").append(oasisRecord.getOSTOMY()).append("</M1630_OSTOMY>");
        buffer.append("  <M1700_COG_FUNCTION>").append("</M1700_COG_FUNCTION>");
        buffer.append("  <M1710_WHEN_CONFUSED>").append("</M1710_WHEN_CONFUSED>");
        buffer.append("  <M1720_WHEN_ANXIOUS>").append("</M1720_WHEN_ANXIOUS>");
        buffer.append("  <M1730_STDZ_DPRSN_SCRNG>").append("</M1730_STDZ_DPRSN_SCRNG>");
        buffer.append("  <M1730_PHQ2_LACK_INTRST>").append("</M1730_PHQ2_LACK_INTRST>");
        buffer.append("  <M1730_PHQ2_DPRSN>").append("</M1730_PHQ2_DPRSN>");
        buffer.append("  <M1740_BD_MEM_DEFICIT>").append("</M1740_BD_MEM_DEFICIT>");
        buffer.append("  <M1740_BD_IMP_DECISN>").append("</M1740_BD_IMP_DECISN>");
        buffer.append("  <M1740_BD_VERBAL>").append("</M1740_BD_VERBAL>");
        buffer.append("  <M1740_BD_PHYSICAL>").append("</M1740_BD_PHYSICAL>");
        buffer.append("  <M1740_BD_SOC_INAPPRO>").append("</M1740_BD_SOC_INAPPRO>");
        buffer.append("  <M1740_BD_DELUSIONS>").append("</M1740_BD_DELUSIONS>");
        buffer.append("  <M1740_BD_NONE>").append("</M1740_BD_NONE>");
        buffer.append("  <M1745_BEH_PROB_FREQ>").append("</M1745_BEH_PROB_FREQ>");
        buffer.append("  <M1750_REC_PSYCH_NURS>").append("</M1750_REC_PSYCH_NURS>");
        buffer.append("  <M1800_CUR_GROOMING>").append("</M1800_CUR_GROOMING>");
        buffer.append("  <M1810_CUR_DRESS_UPPER>").append("</M1810_CUR_DRESS_UPPER>");
        buffer.append("  <M1820_CUR_DRESS_LOWER>").append("</M1820_CUR_DRESS_LOWER>");
        buffer.append("  <M1830_CRNT_BATHG>").append(oasisRecord.getCRNT_BATHG()).append("</M1830_CRNT_BATHG>");
        buffer.append("  <M1840_CUR_TOILTG>").append("</M1840_CUR_TOILTG>");
        buffer.append("  <M1845_CUR_TOILTG_HYGN>").append("</M1845_CUR_TOILTG_HYGN>");
        buffer.append("  <M1850_CUR_TRNSFRNG>").append("</M1850_CUR_TRNSFRNG>");
        buffer.append("  <M1860_CRNT_AMBLTN>").append(oasisRecord.getCRNT_AMBLTN()).append("</M1860_CRNT_AMBLTN>");
        buffer.append("  <M1870_CUR_FEEDING>").append("</M1870_CUR_FEEDING>");
        buffer.append("  <M1880_CUR_PREP_LT_MEALS>").append("</M1880_CUR_PREP_LT_MEALS>");
        buffer.append("  <M1890_CUR_PHONE_USE>").append("</M1890_CUR_PHONE_USE>");
        buffer.append("  <M1900_PRIOR_ADLIADL_SELF>").append("</M1900_PRIOR_ADLIADL_SELF>");
        buffer.append("  <M1900_PRIOR_ADLIADL_AMBLTN>").append("</M1900_PRIOR_ADLIADL_AMBLTN>");
        buffer.append("  <M1900_PRIOR_ADLIADL_TRNSFR>").append("</M1900_PRIOR_ADLIADL_TRNSFR>");
        buffer.append("  <M1900_PRIOR_ADLIADL_HSEHOLD>").append("</M1900_PRIOR_ADLIADL_HSEHOLD>");
        buffer.append("  <M1910_MLT_FCTR_FALL_RISK_ASMT>").append("</M1910_MLT_FCTR_FALL_RISK_ASMT>");
        buffer.append("  <M2000_DRUG_RGMN_RVW>").append(oasisRecord.getDRUG_RGMN_RVW()).append("</M2000_DRUG_RGMN_RVW>");
        buffer.append("  <M2002_MDCTN_FLWP>").append("</M2002_MDCTN_FLWP>");
        buffer.append("  <M2004_MDCTN_INTRVTN>").append("</M2004_MDCTN_INTRVTN>");
        buffer.append("  <M2010_HIGH_RISK_DRUG_EDCTN>").append("</M2010_HIGH_RISK_DRUG_EDCTN>");
        buffer.append("  <M2015_DRUG_EDCTN_INTRVTN>").append("</M2015_DRUG_EDCTN_INTRVTN>");
        buffer.append("  <M2020_CRNT_MGMT_ORAL_MDCTN>").append("</M2020_CRNT_MGMT_ORAL_MDCTN>");
        buffer.append("  <M2030_CRNT_MGMT_INJCTN_MDCTN>").append(oasisRecord.getCRNT_MGMT_INJCTN_MDCTN()).append("</M2030_CRNT_MGMT_INJCTN_MDCTN>");
        buffer.append("  <M2040_PRIOR_MGMT_ORAL_MDCTN>").append("</M2040_PRIOR_MGMT_ORAL_MDCTN>");
        buffer.append("  <M2040_PRIOR_MGMT_INJCTN_MDCTN>").append("</M2040_PRIOR_MGMT_INJCTN_MDCTN>");
        buffer.append("  <M2100_CARE_TYPE_SRC_ADL>").append("</M2100_CARE_TYPE_SRC_ADL>");
        buffer.append("  <M2100_CARE_TYPE_SRC_IADL>").append("</M2100_CARE_TYPE_SRC_IADL>");
        buffer.append("  <M2100_CARE_TYPE_SRC_MDCTN>").append("</M2100_CARE_TYPE_SRC_MDCTN>");
        buffer.append("  <M2100_CARE_TYPE_SRC_PRCDR>").append("</M2100_CARE_TYPE_SRC_PRCDR>");
        buffer.append("  <M2100_CARE_TYPE_SRC_EQUIP>").append("</M2100_CARE_TYPE_SRC_EQUIP>");
        buffer.append("  <M2100_CARE_TYPE_SRC_SPRVSN>").append("</M2100_CARE_TYPE_SRC_SPRVSN>");
        buffer.append("  <M2100_CARE_TYPE_SRC_ADVCY>").append("</M2100_CARE_TYPE_SRC_ADVCY>");
        buffer.append("  <M2110_ADL_IADL_ASTNC_FREQ>").append("</M2110_ADL_IADL_ASTNC_FREQ>");
        buffer.append("  <M2200_THER_NEED_NUM>").append("</M2200_THER_NEED_NUM>");
        buffer.append("  <M2200_THER_NEED_NA>").append(oasisRecord.getTHER_NEED_NA()).append("</M2200_THER_NEED_NA>");
        buffer.append("  <M2250_PLAN_SMRY_PTNT_SPECF>").append("</M2250_PLAN_SMRY_PTNT_SPECF>");
        buffer.append("  <M2250_PLAN_SMRY_DBTS_FT_CARE>").append("</M2250_PLAN_SMRY_DBTS_FT_CARE>");
        buffer.append("  <M2250_PLAN_SMRY_FALL_PRVNT>").append("</M2250_PLAN_SMRY_FALL_PRVNT>");
        buffer.append("  <M2250_PLAN_SMRY_DPRSN_INTRVTN>").append("</M2250_PLAN_SMRY_DPRSN_INTRVTN>");
        buffer.append("  <M2250_PLAN_SMRY_PAIN_INTRVTN>").append("</M2250_PLAN_SMRY_PAIN_INTRVTN>");
        buffer.append("  <M2250_PLAN_SMRY_PRSULC_PRVNT>").append("</M2250_PLAN_SMRY_PRSULC_PRVNT>");
        buffer.append("  <M2250_PLAN_SMRY_PRSULC_TRTMT>").append("</M2250_PLAN_SMRY_PRSULC_TRTMT>");
        buffer.append("  <M2300_EMER_USE_AFTR_LAST_ASMT>").append("</M2300_EMER_USE_AFTR_LAST_ASMT>");
        buffer.append("  <M2310_ECR_MEDICATION>").append("</M2310_ECR_MEDICATION>");
        buffer.append("  <M2310_ECR_INJRY_BY_FALL>").append("</M2310_ECR_INJRY_BY_FALL>");
        buffer.append("  <M2310_ECR_RSPRTRY_INFCTN>").append("</M2310_ECR_RSPRTRY_INFCTN>");
        buffer.append("  <M2310_ECR_RSPRTRY_OTHR>").append("</M2310_ECR_RSPRTRY_OTHR>");
        buffer.append("  <M2310_ECR_HRT_FAILR>").append("</M2310_ECR_HRT_FAILR>");
        buffer.append("  <M2310_ECR_CRDC_DSRTHM>").append("</M2310_ECR_CRDC_DSRTHM>");
        buffer.append("  <M2310_ECR_MI_CHST_PAIN>").append("</M2310_ECR_MI_CHST_PAIN>");
        buffer.append("  <M2310_ECR_OTHR_HRT_DEASE>").append("</M2310_ECR_OTHR_HRT_DEASE>");
        buffer.append("  <M2310_ECR_STROKE_TIA>").append("</M2310_ECR_STROKE_TIA>");
        buffer.append("  <M2310_ECR_HYPOGLYC>").append("</M2310_ECR_HYPOGLYC>");
        buffer.append("  <M2310_ECR_GI_PRBLM>").append("</M2310_ECR_GI_PRBLM>");
        buffer.append("  <M2310_ECR_DHYDRTN_MALNTR>").append("</M2310_ECR_DHYDRTN_MALNTR>");
        buffer.append("  <M2310_ECR_UTI>").append("</M2310_ECR_UTI>");
        buffer.append("  <M2310_ECR_CTHTR_CMPLCTN>").append("</M2310_ECR_CTHTR_CMPLCTN>");
        buffer.append("  <M2310_ECR_WND_INFCTN_DTRORTN>").append("</M2310_ECR_WND_INFCTN_DTRORTN>");
        buffer.append("  <M2310_ECR_UNCNTLD_PAIN>").append("</M2310_ECR_UNCNTLD_PAIN>");
        buffer.append("  <M2310_ECR_MENTL_BHVRL_PRBLM>").append("</M2310_ECR_MENTL_BHVRL_PRBLM>");
        buffer.append("  <M2310_ECR_DVT_PULMNRY>").append("</M2310_ECR_DVT_PULMNRY>");
        buffer.append("  <M2310_ECR_OTHER>").append("</M2310_ECR_OTHER>");
        buffer.append("  <M2310_ECR_UNKNOWN>").append("</M2310_ECR_UNKNOWN>");
        buffer.append("  <M2400_INTRVTN_SMRY_DBTS_FT>").append("</M2400_INTRVTN_SMRY_DBTS_FT>");
        buffer.append("  <M2400_INTRVTN_SMRY_FALL_PRVNT>").append("</M2400_INTRVTN_SMRY_FALL_PRVNT>");
        buffer.append("  <M2400_INTRVTN_SMRY_DPRSN>").append("</M2400_INTRVTN_SMRY_DPRSN>");
        buffer.append("  <M2400_INTRVTN_SMRY_PAIN_MNTR>").append("</M2400_INTRVTN_SMRY_PAIN_MNTR>");
        buffer.append("  <M2400_INTRVTN_SMRY_PRSULC_PRVN>").append("</M2400_INTRVTN_SMRY_PRSULC_PRVN>");
        buffer.append("  <M2400_INTRVTN_SMRY_PRSULC_WET>").append("</M2400_INTRVTN_SMRY_PRSULC_WET>");
        buffer.append("  <M2410_INPAT_FACILITY>").append("</M2410_INPAT_FACILITY>");
        buffer.append("  <M2420_DSCHRG_DISP>").append("</M2420_DSCHRG_DISP>");
        buffer.append("  <M2430_HOSP_MED>").append("</M2430_HOSP_MED>");
        buffer.append("  <M2430_HOSP_INJRY_BY_FALL>").append("</M2430_HOSP_INJRY_BY_FALL>");
        buffer.append("  <M2430_HOSP_RSPRTRY_INFCTN>").append("</M2430_HOSP_RSPRTRY_INFCTN>");
        buffer.append("  <M2430_HOSP_RSPRTRY_OTHR>").append("</M2430_HOSP_RSPRTRY_OTHR>");
        buffer.append("  <M2430_HOSP_HRT_FAILR>").append("</M2430_HOSP_HRT_FAILR>");
        buffer.append("  <M2430_HOSP_CRDC_DSRTHM>").append("</M2430_HOSP_CRDC_DSRTHM>");
        buffer.append("  <M2430_HOSP_MI_CHST_PAIN>").append("</M2430_HOSP_MI_CHST_PAIN>");
        buffer.append("  <M2430_HOSP_OTHR_HRT_DEASE>").append("</M2430_HOSP_OTHR_HRT_DEASE>");
        buffer.append("  <M2430_HOSP_STROKE_TIA>").append("</M2430_HOSP_STROKE_TIA>");
        buffer.append("  <M2430_HOSP_HYPOGLYC>").append("</M2430_HOSP_HYPOGLYC>");
        buffer.append("  <M2430_HOSP_GI_PRBLM>").append("</M2430_HOSP_GI_PRBLM>");
        buffer.append("  <M2430_HOSP_DHYDRTN_MALNTR>").append("</M2430_HOSP_DHYDRTN_MALNTR>");
        buffer.append("  <M2430_HOSP_UR_TRACT>").append("</M2430_HOSP_UR_TRACT>");
        buffer.append("  <M2430_HOSP_CTHTR_CMPLCTN>").append("</M2430_HOSP_CTHTR_CMPLCTN>");
        buffer.append("  <M2430_HOSP_WND_INFCTN>").append("</M2430_HOSP_WND_INFCTN>");
        buffer.append("  <M2430_HOSP_PAIN>").append("</M2430_HOSP_PAIN>");
        buffer.append("  <M2430_HOSP_MENTL_BHVRL_PRBLM>").append("</M2430_HOSP_MENTL_BHVRL_PRBLM>");
        buffer.append("  <M2430_HOSP_DVT_PULMNRY>").append("</M2430_HOSP_DVT_PULMNRY>");
        buffer.append("  <M2430_HOSP_SCHLD_TRTMT>").append("</M2430_HOSP_SCHLD_TRTMT>");
        buffer.append("  <M2430_HOSP_OTHER>").append("</M2430_HOSP_OTHER>");
        buffer.append("  <M2430_HOSP_UK>").append("</M2430_HOSP_UK>");
        buffer.append("  <M2440_NH_THERAPY>").append("</M2440_NH_THERAPY>");
        buffer.append("  <M2440_NH_RESPITE>").append("</M2440_NH_RESPITE>");
        buffer.append("  <M2440_NH_HOSPICE>").append("</M2440_NH_HOSPICE>");
        buffer.append("  <M2440_NH_PERMANENT>").append("</M2440_NH_PERMANENT>");
        buffer.append("  <M2440_NH_UNSAFE_HOME>").append("</M2440_NH_UNSAFE_HOME>");
        buffer.append("  <M2440_NH_OTHER>").append("</M2440_NH_OTHER>");
        buffer.append("  <M2440_NH_UNKNOWN>").append("</M2440_NH_UNKNOWN>");
        buffer.append("  <M0903_LAST_HOME_VISIT>").append("</M0903_LAST_HOME_VISIT>");
        buffer.append("  <M0906_DC_TRAN_DTH_DT>").append("</M0906_DC_TRAN_DTH_DT>");
        buffer.append("  <CONTROL_ITEMS_FILLER>").append("</CONTROL_ITEMS_FILLER>");
        buffer.append("  <ASMT_ITEMS_FILLER>").append("</ASMT_ITEMS_FILLER>");
        buffer.append("  <LEGACY_ITEMS_FILLER>").append("</LEGACY_ITEMS_FILLER>");
        buffer.append("  <CALCULATED_ITEMS_FILLER>").append("</CALCULATED_ITEMS_FILLER>");
        buffer.append("  <HHA_ASMT_INT_ID>").append("</HHA_ASMT_INT_ID>");
        buffer.append("  <ORIG_ASMT_INT_ID>").append("</ORIG_ASMT_INT_ID>");
        buffer.append("  <RES_INT_ID>").append("</RES_INT_ID>");
        buffer.append("  <ASMT_EFF_DATE>").append("</ASMT_EFF_DATE>");
        buffer.append("  <BRANCH_IDENTIFIER>").append("</BRANCH_IDENTIFIER>");
        buffer.append("  <FAC_INT_ID>").append("</FAC_INT_ID>");
        buffer.append("  <SUBMISSION_ID>").append("</SUBMISSION_ID>");
        buffer.append("  <SUBMISSION_DATE>").append("</SUBMISSION_DATE>");
        buffer.append("  <SUBMISSION_COMPLETE_DATE>").append("</SUBMISSION_COMPLETE_DATE>");
        buffer.append("  <SUBMITTING_USER_ID>").append("</SUBMITTING_USER_ID>");
        buffer.append("  <RES_MATCH_CRITERIA>").append("</RES_MATCH_CRITERIA>");
        buffer.append("  <RESIDENT_AGE>").append("</RESIDENT_AGE>");
        buffer.append("  <BIRTHDATE_SUBM_IND>").append("</BIRTHDATE_SUBM_IND>");
        buffer.append("  <CALC_HIPPS_CODE>").append("</CALC_HIPPS_CODE>");
        buffer.append("  <CALC_HIPPS_VERSION>").append("</CALC_HIPPS_VERSION>");
        buffer.append("</ASSESSMENT>");
        return buffer;
    }

    public static void postProcessRecord(HomeHealthRecordIF record) {
        Oasis_C_Record oasisRecord = (Oasis_C_Record)record;
        HomeHealthRecordUtil.justifyOasisCValues(oasisRecord);
        oasisRecord.setNBR_PRSULC_STG2(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_PRSULC_STG2(), 2));
        oasisRecord.setNBR_STG2_AT_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_STG2_AT_SOC_ROC(), 2));
        oasisRecord.setNBR_PRSULC_STG3(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_PRSULC_STG3(), 2));
        oasisRecord.setNBR_STG3_AT_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_STG3_AT_SOC_ROC(), 2));
        oasisRecord.setNBR_PRSULC_STG4(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_PRSULC_STG4(), 2));
        oasisRecord.setNBR_STG4_AT_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_STG4_AT_SOC_ROC(), 2));
        oasisRecord.setNSTG_DRSG(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_DRSG(), 2));
        oasisRecord.setNSTG_DRSG_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_DRSG_SOC_ROC(), 2));
        oasisRecord.setNSTG_CVRG(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_CVRG(), 2));
        oasisRecord.setNSTG_CVRG_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_CVRG_SOC_ROC(), 2));
        oasisRecord.setNSTG_DEEP_TISUE(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_DEEP_TISUE(), 2));
        oasisRecord.setNSTG_DEEP_TISSUE_SOC_ROC(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNSTG_DEEP_TISSUE_SOC_ROC(), 2));
        oasisRecord.setPRSR_ULCR_LNGTH(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getPRSR_ULCR_LNGTH(), 4));
        oasisRecord.setPRSR_ULCR_WDTH(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getPRSR_ULCR_WDTH(), 4));
        oasisRecord.setPRSR_ULCR_DEPTH(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getPRSR_ULCR_DEPTH(), 4));
        oasisRecord.setSTUS_PRBLM_PRSR_ULCR(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getSTUS_PRBLM_PRSR_ULCR(), 2));
        oasisRecord.setNBR_STAS_ULCR(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getNBR_STAS_ULCR(), 2));
        oasisRecord.setSTUS_PRBLM_STAS_ULCR(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getSTUS_PRBLM_STAS_ULCR(), 2));
        oasisRecord.setSTUS_PRBLM_SRGCL_WND(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getSTUS_PRBLM_SRGCL_WND(), 2));
        oasisRecord.setINCNTNT_TIMING(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getINCNTNT_TIMING(), 2));
        oasisRecord.setCRNT_MGMT_INJCTN_MDCTN(Oasis_C_RecordUtil_v2_10.convertCaretSpace(oasisRecord.getCRNT_MGMT_INJCTN_MDCTN(), 2));
    }

    public static final String convertCaretSpace(String str, int length) {
        if (str == null || str.charAt(0) == '^') {
            char[] chars = new char[length];
            for (int idx = 0; idx < length; ++idx) {
                chars[idx] = 32;
            }
            str = new String(chars);
        }
        return str;
    }
}

