/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3210;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.DiagnosisScoringGrid;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class ClinicalFunctional_ScoringModel_v3210
implements HomeHealthScoringModelIF {
    private int id;
    protected GrouperDataManager grouperDataManager;
    protected HomeHealthGrouperIF grouper;
    private transient String shortName;

    public ClinicalFunctional_ScoringModel_v3210(HomeHealthGrouperIF grouper, GrouperDataManager grouperDataManager, int equationId) {
        this.grouper = grouper;
        this.grouperDataManager = grouperDataManager;
        this.id = equationId;
        this.shortName = "Equation " + equationId + ": ";
    }

    protected int calculatePrimaryAdjustment(DiagnosisScoringGridIF scoringGrid, int primaryAdjustmentRow, int otherAdjustmentRow) {
        int primaryScore = scoringGrid.isCaseMixAdjustmentRowScored(otherAdjustmentRow) ? this.getCaseMixAdjustmentEquation(primaryAdjustmentRow, this.id) - this.getCaseMixAdjustmentEquation(otherAdjustmentRow, this.id) : this.getCaseMixAdjustmentEquation(primaryAdjustmentRow, this.id);
        return primaryScore;
    }

    public int determinePrimaryDiagnosis(HomeHealthRecordIF record, DiagnosisScoringGridIF scoringGrid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
    }

    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int currentScore) {
        int tmpScore;
        int score = 0;
        if (validator.isINTERNAL_LOGIC_Valid() && validator.isTHERAPIES_Valid()) {
            if ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION())) {
                tmpScore = this.getCaseMixAdjustmentEquation(31, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item THH_IV_INFUSION or THH_PAR_NUTRITION", 31, tmpScore);
            }
            if ("1".equals(record.getTHH_ENT_NUTRITION())) {
                tmpScore = this.getCaseMixAdjustmentEquation(32, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item THH_ENT_NUTRITION", 32, tmpScore);
            }
        }
        if (ValidateUtils.isValidValue(record.getVISION(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(33, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item VISION", 33, tmpScore);
        }
        if (ValidateUtils.isValidValue(record.getPAIN_FREQ_ACTVTY_MVMT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(34, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item FREQ_PAIN", 34, tmpScore);
        }
        if (validator.isNPRSULC3_Valid() && validator.isNPRSULC4_Valid()) {
            int tmpInt1 = 0;
            int tmpInt2 = 0;
            String tmpStr = record.getNBR_PRSULC_STG3();
            if (!ValidateUtils.isEmpty(tmpStr)) {
                tmpInt1 = IntegerUtils.parseInt(tmpStr, 0);
            }
            if (!ValidateUtils.isEmpty(tmpStr = record.getNBR_PRSULC_STG4())) {
                tmpInt2 = IntegerUtils.parseInt(tmpStr, 0);
            }
            if (tmpInt1 + tmpInt2 >= 2) {
                tmpScore = this.getCaseMixAdjustmentEquation(35, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item NBR_PRSULC_STG3 + NBR_PRSULC_STG4", 35, tmpScore);
            }
        }
        if (validator.isSTGPRSUL_Valid()) {
            if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                tmpScore = this.getCaseMixAdjustmentEquation(36, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STG_PRBLM_ULCER = 01 or 02", 36, tmpScore);
            } else if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR})) {
                tmpScore = this.getCaseMixAdjustmentEquation(37, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STG_PRBLM_ULCER = 03 or 04", 37, tmpScore);
            }
        }
        if (validator.isSTATSTASIS_Valid()) {
            String tmpStr = record.getSTUS_PRBLM_STAS_ULCR();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(38, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STAT_PRB_STASULC = 02", 38, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(39, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STAT_PRB_STASULC = 03", 39, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            String tmpStr = record.getSTUS_PRBLM_SRGCL_WND();
            if ("02".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(40, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STAT_PRB_SURGWND = 02", 40, tmpScore);
            } else if ("03".equals(tmpStr)) {
                tmpScore = this.getCaseMixAdjustmentEquation(41, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item STAT_PRB_SURGWND = 03", 41, tmpScore);
            }
        }
        if (validator.isDYSPNEIC_Valid() && ValidateUtils.isValidValue(record.getWHEN_DYSPNEIC(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
            tmpScore = this.getCaseMixAdjustmentEquation(42, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item WHEN_DYSPNEIC = 02,03, or 04", 42, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ValidateUtils.isValidValue(record.getBWL_INCONT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(43, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item BWL_INCONT = 02,03,04 or 05", 43, tmpScore);
        }
        if (validator.isOSTOMY_Valid() && ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(44, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item OSTOMY = 01 or 02", 44, tmpScore);
        }
        if (validator.isCUR_INJECT_MEDS_Valid() && ValidateUtils.isValidValue(record.getCRNT_MGMT_INJCTN_MDCTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(45, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Special Item CUR_INJECT_MEDS = 00, 01 or 02", 45, tmpScore);
        }
        return score;
    }

    @Override
    public String getName() {
        return "Clinical / Functional Scoring Model 3210";
    }

    public int getCaseMixAdjustmentEquation(int caseMixId, int equationId) {
        CaseMixAdjustmentItemIF caseMix = this.grouperDataManager.getCaseMixAdjustment(caseMixId);
        return caseMix != null ? caseMix.getAdjustment(equationId) : 0;
    }

    public CaseMixAdjustmentItemIF getCaseMixAdjustment(int caseMixId) {
        return this.grouperDataManager.getCaseMixAdjustment(caseMixId);
    }

    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getDiagnosisCode(codeValue)) == null) {
            code = new DiagnosisCode(codeValue);
        }
        return code;
    }

    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        return this.scoreClinical(record, validator, this.grouper.determineScoreOrder(record));
    }

    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        DiagnosisScoringGrid scoringGrid = new DiagnosisScoringGrid();
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Clinical Scoring");
        for (int currentPass = 1; currentPass <= 2; ++currentPass) {
            DiagnosisCodeIF prevDiagCode = null;
            for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
                DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
                if (diagCode.isOptionalPaymentCode()) {
                    this.scoreClinicalColumn3_4(record, validator, diagIdx, scoringGrid, scoreOrder, currentPass);
                    prevDiagCode = null;
                    continue;
                }
                if (currentPass == scoreOrder[diagIdx][0]) {
                    if (diagCode.isValidForScoring()) {
                        this.scoreClinicalCode(record, diagCode, validator, diagIdx, scoringGrid);
                        if (diagCode.isSecondaryOnly()) {
                            this.resolveEtiologyManifestationContention(prevDiagCode, diagIdx - 1, diagCode, diagIdx, scoringGrid);
                        }
                    }
                    prevDiagCode = diagCode;
                    continue;
                }
                prevDiagCode = null;
            }
        }
        int totalScore = scoringGrid.getTotalScore();
        totalScore += this.scoreRemainingVariables(record, validator, totalScore);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Clinical Scoring", totalScore);
        return totalScore;
    }

    public void scorePrimaryOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 4: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 4, 5);
                scoringGrid.addScore(diagCode, diagIdx, 4, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 4, tmpScore);
                break;
            }
            case 10: {
                int tmpScore = this.getCaseMixAdjustmentEquation(12, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 12, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 12, tmpScore);
                break;
            }
            case 19: {
                int tmpScore = this.calculatePrimaryAdjustment(scoringGrid, 25, 26);
                scoringGrid.addScore(diagCode, diagIdx, 25, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 25, tmpScore);
                break;
            }
        }
    }

    public void scoreOtherOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 4: {
                int tmpScore = this.getCaseMixAdjustmentEquation(5, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 5, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 5, tmpScore);
                break;
            }
            case 19: {
                int tmpScore = this.getCaseMixAdjustmentEquation(26, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 26, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 26, tmpScore);
                break;
            }
        }
    }

    public void scoreAny(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = this.getCaseMixAdjustmentEquation(1, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 1, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 1, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = this.getCaseMixAdjustmentEquation(2, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 2, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 2, tmpScore);
                break;
            }
            case 3: {
                int tmpScore = this.getCaseMixAdjustmentEquation(3, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 3, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 3, tmpScore);
                break;
            }
            case 5: {
                int tmpScore;
                if (record.isDiagnosticGroupOnRecord(12, diagIdx)) {
                    tmpScore = this.getCaseMixAdjustmentEquation(6, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 6, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 6, tmpScore);
                }
                if (!validator.isTHERAPIES_Valid() || !validator.isINTERNAL_LOGIC_Valid() || !"1".equals(record.getTHH_ENT_NUTRITION())) break;
                tmpScore = this.getCaseMixAdjustmentEquation(7, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 7, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 7, tmpScore);
                break;
            }
            case 6: {
                if (!validator.isSTGPRSUL_Valid() || !ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(19, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                break;
            }
            case 7: {
                int tmpScore = this.getCaseMixAdjustmentEquation(8, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 8, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 8, tmpScore);
                if (validator.isOSTOMY_Valid() && ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                    tmpScore = this.getCaseMixAdjustmentEquation(9, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 9, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 9, tmpScore);
                }
                if (!record.isDiagnosticGroupOnRecord(10, diagIdx) && !record.isDiagnosticGroupOnRecord(11, diagIdx) && !record.isDiagnosticGroupOnRecord(12, diagIdx) && !record.isDiagnosticGroupOnRecord(13, diagIdx)) break;
                tmpScore = this.getCaseMixAdjustmentEquation(10, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 10, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 10, tmpScore);
                break;
            }
            case 8: 
            case 9: {
                int tmpScore = this.getCaseMixAdjustmentEquation(11, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 11, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 11, tmpScore);
                break;
            }
            case 10: {
                int tmpScore;
                if (validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
                    tmpScore = this.getCaseMixAdjustmentEquation(13, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 13, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 13, tmpScore);
                }
            }
            case 11: {
                if (!validator.isCUR_DRESS_Valid() || !ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) && !ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE})) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(14, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 14, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 14, tmpScore);
                break;
            }
            case 12: {
                int tmpScore = this.getCaseMixAdjustmentEquation(15, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 15, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 15, tmpScore);
                if (validator.isCUR_DRESS_Valid() && (ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) || ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}))) {
                    tmpScore = this.getCaseMixAdjustmentEquation(16, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 16, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 16, tmpScore);
                }
                if (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE})) break;
                tmpScore = this.getCaseMixAdjustmentEquation(17, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 17, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 17, tmpScore);
                break;
            }
            case 13: {
                if (!(validator.isCUR_BATHING_Valid() && ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE}) || validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR}) || validator.isCUR_TRANSFER_Valid() && ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) && (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE}))) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(18, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 18, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 18, tmpScore);
                break;
            }
            case 14: {
                int tmpScore;
                if (validator.isSTGPRSUL_Valid() && ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                    tmpScore = this.getCaseMixAdjustmentEquation(19, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                }
            }
            case 15: {
                if (!validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid() || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION())) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(20, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 20, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 20, tmpScore);
                break;
            }
            case 16: {
                int tmpScore = this.getCaseMixAdjustmentEquation(21, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 21, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 21, tmpScore);
                break;
            }
            case 17: {
                int tmpScore = this.getCaseMixAdjustmentEquation(22, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 22, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 22, tmpScore);
                break;
            }
            case 18: {
                int tmpScore = this.getCaseMixAdjustmentEquation(23, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 23, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 23, tmpScore);
                if (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR_FIVE})) break;
                tmpScore = this.getCaseMixAdjustmentEquation(24, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 24, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 24, tmpScore);
                break;
            }
            case 20: {
                int tmpScore = this.getCaseMixAdjustmentEquation(28, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 28, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 28, tmpScore);
            }
            case 19: {
                if (!validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid() || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION())) break;
                int tmpScore = this.getCaseMixAdjustmentEquation(27, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 27, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 27, tmpScore);
                break;
            }
            case 21: {
                int tmpScore = this.getCaseMixAdjustmentEquation(29, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 29, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 29, tmpScore);
                break;
            }
            case 22: {
                int tmpScore = this.getCaseMixAdjustmentEquation(30, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 30, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, 30, tmpScore);
                break;
            }
        }
    }

    public void scoreClinicalCode(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid) {
        if (this.grouper.getListenerCount() > 0) {
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Attempting to score Diagnosis ", diagCode.getCode(), " (", diagCode.getDiagnosticGroup().getDescription(), ") at position ", Integer.toString(diagIdx + 1));
        }
        try {
            if (diagIdx == 0 || diagIdx == 6 || diagCode.isSecondaryOnly() && (diagIdx == 1 || diagIdx == 12)) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid);
            } else {
                this.scoreOtherOnly(record, diagCode, diagIdx, scoringGrid);
            }
            this.scoreAny(record, diagCode, validator, diagIdx, scoringGrid);
        }
        catch (AlreadyScoredException e) {
            ScoringEventFormatter.fireDxGroupAlreadyScored(this.grouper.getEventListenersList(), this.grouper, this, diagCode, diagIdx + 1, e);
        }
    }

    public void scoreClinicalColumn3_4(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int rowIdx, DiagnosisScoringGridIF scoringGrid, int[][] scoreOrder, int currentPass) {
        DiagnosisCodeIF diagCodeCol_4;
        DiagnosisCodeIF diagCodeCol_3 = null;
        if (currentPass == scoreOrder[rowIdx][1] && (diagCodeCol_3 = record.getOptionalDiagnosisCode3(rowIdx)).isValidForScoring()) {
            this.scoreClinicalCode(record, diagCodeCol_3, validator, rowIdx + 6, scoringGrid);
        }
        if (currentPass == scoreOrder[rowIdx][2] && (diagCodeCol_4 = record.getOptionalDiagnosisCode4(rowIdx)).isValidForScoring() && diagCodeCol_4.isSecondaryOnly()) {
            this.scoreClinicalCode(record, diagCodeCol_4, validator, rowIdx + 12, scoringGrid);
            this.resolveEtiologyManifestationContention(diagCodeCol_3, rowIdx + 6, diagCodeCol_4, rowIdx + 12, scoringGrid);
        }
    }

    public int scoreFunctional(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        int tmpScore;
        int score = 0;
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Functional scoring");
        if (validator.isCUR_DRESS_Valid() && (ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) || ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}))) {
            tmpScore = this.getCaseMixAdjustmentEquation(46, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_DRESS", 46, tmpScore);
        }
        if (validator.isCUR_BATHING_Valid() && ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(47, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_BATHING", 47, tmpScore);
        }
        if (validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
            tmpScore = this.getCaseMixAdjustmentEquation(48, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_TOILETING", 48, tmpScore);
        }
        if (validator.isCUR_TRANSFER_Valid() && ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(49, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_TRANSFER", 49, tmpScore);
        }
        if (validator.isCUR_AMBULATION_Valid()) {
            if (ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                tmpScore = this.getCaseMixAdjustmentEquation(50, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_AMBULATION", 50, tmpScore);
            } else if (ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE})) {
                tmpScore = this.getCaseMixAdjustmentEquation(51, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "For CUR_AMBULATION", 51, tmpScore);
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Functional scoring", score);
        return score;
    }

    public void resolveEtiologyManifestationContention(DiagnosisCodeIF etiologyCode, int etiologyIdx, DiagnosisCodeIF manifestionCode, int manifestIdx, DiagnosisScoringGridIF scoringGrid) {
        if (scoringGrid.getTotalScoreForDiagnosis(manifestIdx) > scoringGrid.getTotalScoreForDiagnosis(etiologyIdx)) {
            scoringGrid.clearScore(etiologyIdx);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Previous etiology code ", etiologyCode.getCode(), " loses score for manifestion/etiology contention");
        } else {
            scoringGrid.clearScore(manifestIdx);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Manifestation code ", manifestionCode.getCode(), " loses score for manifestion/etiology contention");
        }
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        return this.score(record, validator, this.grouper.determineScoreOrder(record));
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        ScoringPoints points = new ScoringPoints(2);
        points.setScoreAt(0, this.scoreClinical(record, validator, scoreOrder));
        points.setScoreAt(1, this.scoreFunctional(record, validator));
        if (this.grouper.getListenerCount() > 0) {
            StringBuilder buffer = new StringBuilder("Final equation score (clinical + functional): ");
            buffer.append(points.getScores()[0] + points.getScores()[1]);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Final equation score (clinical + functional): ", Integer.toString(points.getScores()[0] + points.getScores()[1]));
        }
        return points;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        return this.score(record, validator, scoreOrder);
    }

    @Override
    public void populateCodes(HomeHealthRecordIF record) {
        DiagnosisCodeIF tmpCode = record.getPRIMARY_DIAG_ICD();
        if (tmpCode != DiagnosisCode_Empty.DEFAULT) {
            record.setPRIMARY_DIAG_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG1_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG1_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG2_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG2_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG3_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG3_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG4_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG4_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG5_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG5_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_A3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_A3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_B3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_B3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_C3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_C3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_D3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_D3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_E3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_E3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_F3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_F3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_A4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_A4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_B4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_B4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_C4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_C4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_D4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_D4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_E4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_E4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_F4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_F4(this.getDiagnosisCode(tmpCode.getCode()));
        }
    }

    public int getEquationId() {
        return this.id;
    }

    @Override
    public HomeHealthGrouperIF getGrouper() {
        return this.grouper;
    }

    @Override
    public void setGrouper(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
    }
}

