/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3312;

import com.mmm.cms.homehealth.DiagnosisScoringGrid;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.v3210.ClinicalFunctional_ScoringModel_v3210;
import com.mmm.cms.homehealth.v3312.ManifestationUtils;
import com.mmm.cms.util.ScoringEventFormatter;

public class ClinicalFunctional_ScoringModel_v3312
extends ClinicalFunctional_ScoringModel_v3210 {
    public ClinicalFunctional_ScoringModel_v3312(HomeHealthGrouperIF grouper, GrouperDataManager grouperDataManager, int equationId) {
        super(grouper, grouperDataManager, equationId);
    }

    @Override
    public String getName() {
        return "Clinical / Functional Scoring Model V3312";
    }

    @Override
    public void resolveEtiologyManifestationContention(DiagnosisCodeIF etiologyCode, int etiologyIdx, DiagnosisCodeIF manifestionCode, int manifestIdx, DiagnosisScoringGridIF scoringGrid) {
        if (scoringGrid.getScoredByWinningContention(etiologyIdx)) {
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Manifestation/Etiology Contention: Previous etiology code ", etiologyCode.getCode(), " already scored due to previous contention.");
            return;
        }
        if (scoringGrid.getTotalScoreForDiagnosis(manifestIdx) > scoringGrid.getTotalScoreForDiagnosis(etiologyIdx)) {
            scoringGrid.clearScore(etiologyIdx);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Manifestation/Etiology Contention: Previous etiology code ", etiologyCode.getCode(), " loses score for contention.");
        } else {
            scoringGrid.clearScore(manifestIdx);
            scoringGrid.setScoredByWinningContention(etiologyIdx, true);
            ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "Manifestation/Etiology Contention: Manifestation code ", manifestionCode.getCode(), " loses score for contention.");
        }
    }

    @Override
    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        DiagnosisScoringGrid scoringGrid = new DiagnosisScoringGrid();
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Clinical Scoring");
        for (int currentPass = 1; currentPass <= 2; ++currentPass) {
            for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
                DiagnosisCodeIF pairedDiagCode;
                DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
                if (diagCode.isOptionalPaymentCode()) {
                    this.scoreClinicalColumn3_4(record, validator, diagIdx, scoringGrid, scoreOrder, currentPass);
                    continue;
                }
                if (currentPass != scoreOrder[diagIdx][0] || !diagCode.isValidForScoring()) continue;
                this.scoreClinicalCode(record, diagCode, validator, diagIdx, scoringGrid);
                if (!diagCode.isSecondaryOnly() || (pairedDiagCode = ManifestationUtils.getPairedCode(this.grouper, record, diagCode, diagIdx)) == null || !pairedDiagCode.isValidForScoring()) continue;
                if (scoringGrid.getTotalScoreForDiagnosis(pairedDiagCode.getOffset()) == 0) {
                    this.scoreClinicalCode(record, pairedDiagCode, validator, pairedDiagCode.getOffset(), scoringGrid);
                }
                this.resolveEtiologyManifestationContention(pairedDiagCode, pairedDiagCode.getOffset(), diagCode, diagIdx, scoringGrid);
            }
        }
        int totalScore = scoringGrid.getTotalScore();
        totalScore += this.scoreRemainingVariables(record, validator, totalScore);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Clinical Scoring", totalScore);
        return totalScore;
    }
}

