/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3312;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.EtiologyPairingListIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;

public class ManifestationUtils {
    public static DiagnosisCodeIF getExclusionCode(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx) {
        DiagnosisCodeIF foundPairingCode = null;
        EtiologyPairingListIF pairList = diagCode.getEtiologyPairCodes();
        if (pairList == null) {
            return null;
        }
        if (pairList.isInclusionary()) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            DiagnosisCodeIF dx;
            if (i == diagIdx || !pairList.contains(dx = record.getDiagnosisCode(i))) continue;
            foundPairingCode = dx;
            foundPairingCode.setOffset(i);
            break;
        }
        return foundPairingCode;
    }

    public static DiagnosisCodeIF getPairedCode(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx) {
        DiagnosisCodeIF foundPairingCode = null;
        if (diagCode.getEtiologyPairCodes().isInclusionary()) {
            for (int preIdx = diagIdx - 1; preIdx >= 0; --preIdx) {
                DiagnosisCodeIF prevDiagCode = record.getDiagnosisCode(preIdx);
                if (!diagCode.isValidEtiologyPairing(prevDiagCode)) continue;
                foundPairingCode = prevDiagCode;
                foundPairingCode.setOffset(preIdx);
                break;
            }
        } else {
            for (int preIdx = diagIdx - 1; preIdx >= 0; --preIdx) {
                DiagnosisCodeIF prevDiagCode = record.getDiagnosisCode(preIdx);
                if (prevDiagCode.isSecondaryOnly()) continue;
                if (!diagCode.isValidEtiologyPairing(prevDiagCode)) break;
                foundPairingCode = prevDiagCode;
                foundPairingCode.setOffset(preIdx);
                break;
            }
        }
        return foundPairingCode;
    }
}

