/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3413;

import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.v3312.GrouperDataManager_V3312;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class GrouperDataManager_V3413
extends GrouperDataManager_V3312 {
    public GrouperDataManager_V3413(HomeHealthGrouperIF homeHealthGrouper) {
        super(homeHealthGrouper);
    }

    protected DiagnosticGroupIF findDiagnosticGroupByName(List<DiagnosticGroupIF> diagGroups, String name) {
        DiagnosticGroupIF diagGroup = null;
        for (DiagnosticGroupIF tmpDxGroup : diagGroups) {
            if (!name.equalsIgnoreCase(tmpDxGroup.getDescription())) continue;
            diagGroup = tmpDxGroup;
            break;
        }
        return diagGroup;
    }

    protected List<String> getPrimaryGroupNames(List<CaseMixAdjustmentItemIF> casemixItems) {
        ArrayList<String> diagGroupNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("=");
        for (CaseMixAdjustmentItemIF casemixItem : casemixItems) {
            String[] tokens = pattern.split(casemixItem.getName());
            if (!"Primary Diagnosis".equalsIgnoreCase(tokens[0].trim())) continue;
            int idx = tokens[1].indexOf(91);
            if (idx > -1) {
                tokens[1] = tokens[1].substring(0, idx);
            }
            diagGroupNames.add(tokens[1].trim());
        }
        return diagGroupNames;
    }

    @Override
    public void init(Properties props) throws Exception, RemoteException {
        DiagnosticGroupIF diagGroup;
        super.init(props);
        HomeHealthGrouperIF grouper = super.getHomeHealthGrouper();
        List<CaseMixAdjustmentItemIF> casemixItems = grouper.getCaseMixAdjustments();
        List<DiagnosticGroupIF> diagGroups = grouper.getDiagnosticGroups();
        List<String> diagGroupNames = this.getPrimaryGroupNames(casemixItems);
        for (String str : diagGroupNames) {
            diagGroup = this.findDiagnosticGroupByName(diagGroups, str);
            if (diagGroup == null) continue;
            diagGroup.setAlternatePrimaryScorable(true);
        }
        casemixItems = grouper.getNRSCaseMixAdjustments();
        diagGroups = grouper.getDiagnosticGroupsNRS();
        diagGroupNames = this.getPrimaryGroupNames(casemixItems);
        for (String str : diagGroupNames) {
            diagGroup = this.findDiagnosticGroupByName(diagGroups, str);
            if (diagGroup == null) continue;
            diagGroup.setAlternatePrimaryScorable(true);
        }
    }

    @Override
    protected void onParseDiagnosisCodeAttributes(DiagnosisCodeIF diag, String str) {
        if ("A".equals(str)) {
            diag.setPrimaryAwardableCode(true);
        } else {
            super.onParseDiagnosisCodeAttributes(diag, str);
        }
    }
}

