/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateBowlIncontinence
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4350});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            String bowel = record.getBWL_INCONT();
            if (!ValidateUtils.isValidValue(bowel, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4, ValidateUtils.ARRAY_DOUBLE_5, ValidateUtils.ARRAY_NOT_APPLICABLE, ValidateUtils.ARRAY_UNKNOWN_UK)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1620_BWL_INCONT", bowel)));
            }
            if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_4_5_9_ONLY}) && ValidateUtils.isValidValue(bowel, new String[][]{ValidateUtils.ARRAY_UNKNOWN_UK})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4350, new HHOasisDataItem("M1620_BWL_INCONT", bowel)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Bowl Incontinence for edits: 3060";
    }
}

