/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.pps.AbstractPPSClinicalItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateExistingCodes
extends AbstractPPSClinicalItemValidator
implements RecordItemValidator_HH_PPS_IF {
    public ValidateExistingCodes() {
    }

    public ValidateExistingCodes(String primaryPrefix, String otherPrefix, String optPrefix) {
        super(primaryPrefix, otherPrefix, optPrefix);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(HH_PPS_OasisC1EditsEN.EDIT_70000);
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            DiagnosisCodeIF code;
            int idx;
            for (idx = 0; idx < 6; ++idx) {
                code = record.getDiagnosisCode(idx);
                if (code.isValidCode() || code.isEmpty()) continue;
                ++count;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70000, new HHOasisDataItem(idx == 0 ? this.getPrimaryPrefix() : this.getOtherPrefix() + idx + "_ICD", code.getCode())));
            }
            for (idx = 0; idx < 6; ++idx) {
                code = record.getOptionalDiagnosisCode3(idx);
                if (code != null && !code.isValidCode() && !code.isEmpty()) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70000, new HHOasisDataItem(this.getPaymentPrefix() + (65 + idx) + "3", code.getCode())));
                }
                if ((code = record.getOptionalDiagnosisCode4(idx)) == null || code.isValidCode() || code.isEmpty()) continue;
                ++count;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70000, new HHOasisDataItem(this.getPaymentPrefix() + (65 + idx) + "4", code.getCode())));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Existing Codes for edits: 70000";
    }
}

