/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

public class IntegerUtils {
    public static int parseInt(String str, int defaultValue) {
        return IntegerUtils.parseInt(str, 10, defaultValue, true);
    }

    public static int parseInt(String s, int radix, int defaultValue, boolean onErrorUseDefault) {
        int result;
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        if (radix >= 2 && radix <= 36) {
            if (s.charAt(0) == ' ' && !onErrorUseDefault) {
                throw new NumberFormatException("Invalid character in number: \"" + s + "\"");
            }
            s = s.trim();
            boolean negative = false;
            int i = 0;
            int max = s.length();
            if (max > 0) {
                int digit;
                int limit;
                char firstChar = s.charAt(0);
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                    ++i;
                } else {
                    if (firstChar == '+') {
                        if (onErrorUseDefault) {
                            return defaultValue;
                        }
                        throw new NumberFormatException("Invalid character in number: \"" + s + "\"");
                    }
                    limit = -2147483647;
                }
                int multmin = limit / radix;
                if (i < max) {
                    if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                        if (onErrorUseDefault) {
                            return defaultValue;
                        }
                        throw new NumberFormatException("Invalid character in number: \"" + s + "\"");
                    }
                    result = -digit;
                } else {
                    result = 0;
                }
                while (i < max) {
                    if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                        return defaultValue;
                    }
                    if (result < multmin) {
                        return defaultValue;
                    }
                    if ((result *= radix) < limit + digit) {
                        return defaultValue;
                    }
                    result -= digit;
                }
                if (negative) {
                    if (i <= 1) {
                        result = defaultValue;
                    }
                } else {
                    result = -result;
                }
            } else {
                result = defaultValue;
            }
        } else {
            result = defaultValue;
        }
        return result;
    }
}

