/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import com.mmm.cms.homehealth.HomeHealthEvent;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.EventId_EN;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.util.HomeHealthUtils;
import java.util.Collection;

public class ScoringEventFormatter {
    private static void wrapFieldValue(StringBuilder buffer, String fieldName, String value) {
        buffer.append(fieldName);
        buffer.append(" with value '");
        buffer.append(value);
        buffer.append("'");
    }

    public static void fireClinicalIssueEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String fieldName, String value) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Clinical Issue: field = ");
            ScoringEventFormatter.wrapFieldValue(buffer, fieldName, value);
            ScoringEventFormatter.fireIssueEvent(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireFunctionalIssueEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String fieldName, String value) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Functional Issue: field = ");
            ScoringEventFormatter.wrapFieldValue(buffer, fieldName, value);
            ScoringEventFormatter.fireIssueEvent(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireManifestationIssueEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String fieldName, String value) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Manifestation Issue: field = ");
            ScoringEventFormatter.wrapFieldValue(buffer, fieldName, value);
            ScoringEventFormatter.fireIssueEvent(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireIssueEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message) {
        HomeHealthEvent event = new HomeHealthEvent(EventId_EN.VALIDATION_ISSUE, grouper, null, message, scoringModel);
        ScoringEventFormatter.fireScoringEvent(listeners, event);
    }

    public static void fireServiceIssueEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String fieldName, String value) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Service Issue: field = ");
            ScoringEventFormatter.wrapFieldValue(buffer, fieldName, value);
            ScoringEventFormatter.fireIssueEvent(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireScoringEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthEvent event) {
        if (listeners != null && !listeners.isEmpty()) {
            for (HomeHealthEventListenerIF listener : listeners) {
                listener.homeHealthEvent(event);
            }
        }
    }

    public static void fireScoringIncreasePrimaryCodeEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, DiagnosisCodeIF code, int diagnosisPosition, int rowId, int score) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Primary Diagnosis code '");
            buffer.append(code.getCode());
            buffer.append("'");
            DiagnosticGroupIF group = code.getDiagnosticGroup();
            if (group != null && group.getId() > 0) {
                buffer.append(" (");
                buffer.append(group.getDescription());
                buffer.append(")");
            }
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, grouper, scoringModel, buffer.toString(), rowId, score);
        }
    }

    public static void fireScoringIncreaseCodeEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, DiagnosisCodeIF code, int diagnosisPosition, int rowId, int score) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Diagnosis code '");
            buffer.append(code.getCode());
            buffer.append("'");
            DiagnosticGroupIF group = code.getDiagnosticGroup();
            if (group != null && group.getId() > 0) {
                buffer.append(" (");
                buffer.append(group.getDescription());
                buffer.append(")");
            }
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, grouper, scoringModel, buffer.toString(), rowId, score);
        }
    }

    public static void fireScoringIncreaseEvent(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message, int rowId, int score) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            buffer.append(": adding row ");
            buffer.append(rowId);
            buffer.append(", value = ");
            buffer.append(score);
            ScoringEventFormatter.fireScoringEvent(listeners, new HomeHealthEvent(EventId_EN.SCORING_INCREASED, grouper, null, buffer.toString(), scoringModel));
        }
    }

    public static void fireScoringCodeEligible(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, int position, DiagnosisCodeIF code) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Diagnosis code '");
            buffer.append(code.getCode());
            buffer.append("'");
            DiagnosticGroupIF group = code.getDiagnosticGroup();
            if (group != null && group.getId() > 0) {
                buffer.append(" (");
                buffer.append(group.getDescription());
                buffer.append(")");
            }
            buffer.append(" at position ");
            buffer.append(position);
            buffer.append(" is valid for scoring");
            if (code.isPrimary()) {
                buffer.append(" as Primary");
            }
            if (code.isSecondaryOnly()) {
                buffer.append(" as Secondary");
            }
            HomeHealthEvent event = new HomeHealthEvent(EventId_EN.GENERAL, grouper, null, buffer.toString(), scoringModel);
            ScoringEventFormatter.fireScoringEvent(listeners, event);
        }
    }

    public static void fireScoringGeneral(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String ... messages) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            if (messages != null) {
                for (int idx = 0; idx < messages.length; ++idx) {
                    buffer.append(messages[idx]);
                }
            }
            ScoringEventFormatter.fireScoringEvent(listeners, new HomeHealthEvent(EventId_EN.GENERAL, grouper, null, buffer.toString(), scoringModel));
        }
    }

    public static void fireScoringWarning(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            ScoringEventFormatter.fireScoringEvent(listeners, new HomeHealthEvent(EventId_EN.WARNING, grouper, null, buffer.toString(), scoringModel));
        }
    }

    public static void fireScoringSectionStart(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            buffer.append(": Starting... ");
            ScoringEventFormatter.fireScoringEvent(listeners, new HomeHealthEvent(EventId_EN.SCORING_SECTION_STARTING, grouper, null, buffer.toString(), scoringModel));
        }
    }

    public static void fireScoringSectionFinished(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message, int score) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            buffer.append(": Finished: score ");
            buffer.append(score);
            ScoringEventFormatter.fireScoringEvent(listeners, new HomeHealthEvent(EventId_EN.SCORING_SECTION_FINISHED, grouper, null, buffer.toString(), scoringModel));
        }
    }

    public static void fireScoringSectionFinished(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, String message, int[] scores) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(message);
            buffer.append(": Finished");
            if (scores != null) {
                buffer.append(": score ");
                buffer.append(HomeHealthUtils.sumIntArray(scores));
            }
            HomeHealthEvent event = new HomeHealthEvent(EventId_EN.SCORING_SECTION_FINISHED, grouper, null, buffer.toString(), scoringModel);
            ScoringEventFormatter.fireScoringEvent(listeners, event);
        }
    }

    public static void fireValidCodeWarning(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, DiagnosisCodeIF code, int position, boolean isValid) {
        if (listeners != null && !listeners.isEmpty() && !code.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Diagnosis code '");
            buffer.append(code.getCode());
            buffer.append("'");
            DiagnosticGroupIF group = code.getDiagnosticGroup();
            if (group != null && group.getId() > 0) {
                buffer.append(" (");
                buffer.append(group.getDescription());
                buffer.append(")");
            }
            buffer.append(" at position ");
            if (position == 1) {
                buffer.append("PRIMARY_DIAG_ICD");
            } else if (position <= 6) {
                buffer.append("OTH_DIAG");
                buffer.append(position - 1);
                buffer.append("_ICD");
            } else if (position <= 12) {
                buffer.append("DIAG_ICD_");
                buffer.append((char)(65 + (position - 7)));
                buffer.append("3");
            } else {
                buffer.append("DIAG_ICD_");
                buffer.append((char)(65 + (position - 13)));
                buffer.append("4");
            }
            if (isValid) {
                buffer.append(" is valid code BUT NOT valid for scoring.");
            } else {
                buffer.append(" is NOT a valid code.");
            }
            ScoringEventFormatter.fireScoringWarning(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireDxGroupAlreadyScored(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, HomeHealthScoringModelIF scoringModel, DiagnosisCodeIF code, int position, AlreadyScoredException e) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(" Diagnosis code '");
            buffer.append(code.getCode());
            buffer.append("' at position ");
            buffer.append(position);
            buffer.append(" - (");
            buffer.append(code.getDiagnosticGroup().getDescription());
            buffer.append(") already scored due to: ");
            if (e.isDiagnosticGroupAlreadyScored()) {
                buffer.append("Diagnostic Group already scored.");
            }
            if (e.isRowAlreadyScored()) {
                buffer.append("Case Mix Row already scored.");
            }
            ScoringEventFormatter.fireScoringWarning(listeners, grouper, scoringModel, buffer.toString());
        }
    }

    public static void fireScoringRecord(Collection<HomeHealthEventListenerIF> listeners, HomeHealthGrouperIF grouper, String message, HomeHealthRecordIF record) {
        if (listeners != null && !listeners.isEmpty()) {
            StringBuilder buffer = new StringBuilder(2000);
            buffer.append("HH-PPS: ");
            buffer.append(message);
            buffer.append("- Record: ");
            buffer.append(record.toString());
            HomeHealthEvent event = new HomeHealthEvent(EventId_EN.GENERAL, grouper, record, buffer.toString(), null);
            ScoringEventFormatter.fireScoringEvent(listeners, event);
        }
    }
}

