package com.mmm.cms.homehealth.vut.proto;

import java.io.Serializable;
import java.util.logging.Level;

/**
 * This is an enum that is populated with all the Oasis Edit numbers, descriptions, type and severity
 * so that the edits can easily be used in switch statements as well as be able to pass around
 * as a single unit.  The provided description elevates the need to store these in a separate
 * file and provides all client applications with consistent Edit information.  
 * 
 * @author GDIT in collaboration with 3M for CMS Home Health
 *
*/
public enum OasisEditsEN implements OasisEditIF {

	EDIT_3010	(-3010,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then the length of the submitted value must match exactly the maximum length that is listed for the item."),
	EDIT_3020	(-3020,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "If the value is not equal to [^], the first three characters must not be equal to [000]."),
	EDIT_3030	(-3030,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "The value must not be equal to any of the following: [111111111, 333333333, 123456789, 999999999]."),
	EDIT_3040	(-3040,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "If the first character is numeric [0-9], then the first 9 characters must be numeric [0-9]."),
	EDIT_3050	(-3050,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "If the first character is alphabetic, then there must be 1, 2, or 3 alphabetic characters followed by 6 or 9 numbers, up to the length of the item."),
	EDIT_3060	(-3060,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "VALUES OF CODE AND CHECKLIST ITEMS\n" + "Only the coded values listed in the \"Item Values\" table of the Detailed Data Specifications Report may be submitted for this item."),
	EDIT_3070	(-3070,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "VALUES OF DATE ITEMS\n" + "This item must contain either (a) a valid date in YYYYMMDD format, or (b) one of the special values (if any) that are listed in the \"Item Values\" table of the Detailed Data Specifications Report.  \n" + "\n" + "Note that if a date in YYYYMMDD format is submitted, it must be 8 characters in length and each of the 8 characters must contain the digits 0 (zero) through 9.  YYYY, MM, and DD must be zero filled, where necessary.  For example, January 1, 2014 must be submitted as \"20140101\"."),
	EDIT_3080	(-3080,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF BIRTHDATE\n" + "This item must contain either (a) a valid date in YYYYMMDD, YYYYMM, or YYYY format, or (b) one of the special values (if any) that are listed in the \"Item Values\" table of the Detailed Data Specifications Report.\n" + "\n" + "Note that if a date in YYYYMMDD format is submitted, it must be 8 characters in length and each of the 8 characters must contain the digits 0 (zero) through 9.  YYYY, MM, and DD must be zero filled, where necessary.  For example, January 1, 1909 must be submitted as \"19090101\".\n" + "\n" + "If a date is submitted in YYYYMM format, it must be 6 characters in length and each of the 6 characters must contain the digits 0 (zero) through 9.  YYYY and MM must be zero filled, where necessary.  For example, January, 1909 must be submitted as \"190901\".\n" + "\n" + "If a date is submitted in YYYY format, it must be 4 characters in length and each of the 4 characters must contain the digits 0 (zero) through 9.  YYYY must be zero filled, where necessary.  For example, 1909 must be submitted as \"1909\"."),
	EDIT_3090	(-3090,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "VALUES OF NUMERIC ITEMS\n" + "Only the values listed in the \"Item Values\" table of the Detailed Data Specifications Report may be submitted for this item.  The submitted value must be greater than or equal to the minimum value listed in the table and less than or equal to the maximum value listed in the table, or it must match one of the remaining special values (if any) that are listed in the table.  The length of the submitted value must not exceed the allowed maximum length for the item.  Signed numbers (with a leading plus or minus sign) will not be accepted."),
	EDIT_3100	(-3100,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF POSITIVE INTEGER NUMERIC ITEMS\n" + "Only positive integer values and the special values (if any) that are listed in the \"Item Values\" table of the Detailed Data Specifications Report will be accepted for this item.  Leading zeroes may be included or omitted from the submitted value as long as the resulting length of the string does not exceed the allowed maximum length for the item.  A decimal point and decimal values are not allowed.  A sign will not be accepted.\n" + "\n" + "The following examples are allowable if the value to be submitted is equal to [1] and the maximum length is equal to 2: [1], [01].  The following values are NOT allowed and will lead to a fatal error:  [1.], [1.0], [01.], [01.0], [1.1], [01.1], [1.01], [+1], [-2], [+1.3], [-4.5]."),
	EDIT_3110	(-3110,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF NUMERIC TEXT ITEMS\n" + "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then it must contain a text string.  This text string may contain only numeric characters: [0] through [9]."),
	EDIT_3120	(-3120,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF ALPHANUMERIC TEXT ITEMS\n" + "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then it must contain a text string.  This text string may contain only the following characters:\n" + "a) The numeric characters: [0] through [9].\n" + "b) The letters [A] through [Z] and [a] through [z]."),
	EDIT_3130	(-3130,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF ALPHANUMERIC TEXT ITEMS THAT CAN CONTAIN DASHES, SPACES, AND SPECIAL CHARACTERS\n" + "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then it must contain a text string.  This text string may contain only the following characters:\n" + "a) The numeric characters: [0] through [9].\n" + "b) The letters [A] through [Z] and [a] through [z].\n" + "c) The character [-].\n" + "d) The following special characters: \n" + "      [@]  (at sign)\n" + "      [']  (single quote)\n" + "      [/] (forward slash)\n" + "      [+] (plus sign)\n" + "      [,] (comma)\n" + "      [.] (period)\n" + "      [_] (underscore)\n" + "e) Embedded spaces (spaces surrounded by any of the characters listed above).  For example, [LEGAL TEXT] would be allowed."),
	EDIT_3140	(-3140,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF ALPHANUMERIC TEXT ITEMS THAT CAN CONTAIN SPECIAL CHARACTERS\n" + "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then it must contain a text string.  This text string may contain only the following characters:\n" + "a) The numeric characters: [0] through [9].\n" + "b) The letters [A] through [Z] and [a] through [z].\n" + "c) The following special characters: \n" + "      [@] (at sign)\n" + "      ['] (single quote)\n" + "      [/] (forward slash)\n" + "      [+] (plus sign)\n" + "      [,] (comma)\n" + "      [.] (period)\n" + "      [_] (underscore)"),
	EDIT_3150	(-3150,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF EMAIL ADDRESS\n" + "Any valid email address will be accepted.  The text string may contain any printable characters except single-quotes or double-quotes."),
	EDIT_3160	(-3160,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "HHA_AGENCY_ID is the provider's submission ID.  The value submitted for HHA_AGENCY_ID must match the HHA_AGENCY_ID in the QIES ASAP System for the provider."),
	EDIT_3162	(-3162,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "A user submitting a file must be authorized to submit for the provider identified by the HHA_AGENCY_ID item in the file."),
	EDIT_3170	(-3170,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "The value submitted for M0010_CCN (provider's CMS Certification Number -- CCN) will be compared with the value that is currently in the ASAP database.  If the values do not match, a warning will be issued."),
	EDIT_3180	(-3180,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "This is a required text item.  A valid non-blank value must be submitted."),
	EDIT_3190	(-3190,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "In order to modify or inactivate a record that has previously been accepted by the ASAP system, the system must be able to locate the previous record.  Appropriate values from the record to be corrected must therefore be submitted for the following locator items:\n" + "\n" + "M0030_START_CARE_DT\n" + "M0032_ROC_DT \n" + "M0032_ROC_DT_NA\n" + "M0040_PAT_FNAME\n" + "M0040_PAT_LNAME\n" + "M0064_SSN\n" + "M0064_SSN_UK\n" + "M0066_PAT_BIRTH_DT\n" + "M0069_PAT_GENDER\n" + "M0090_INFO_COMPLETED_DT\n" + "M0100_ASSMT_REASON\n" + "M0906_DC_TRAN_DTH_DT\n" + "\n" + "If a matching previously accepted record cannot be located, a fatal error will result and the submitted record will be rejected."),
	EDIT_3200	(-3200,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "The first record that is submitted to correct or inactivate an existing record must have a value of \"01\" in CORRECTION_NBR (correction number).  If that correction/inactivation is accepted and if a subsequent correction/inactivation is required, it must have a value of \"02\", and so on.  In other words, the correction number in CORRECTION_NBR on the first correction/inactivation must be \"01\", and the value on each subsequent correction/inactivation must be incremented by 1.  If the value submitted in CORRECTION_NBR is incorrect, a fatal error will result and the submitted record will be rejected."),
	EDIT_3210	(-3210,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "The length of the text submitted for a free-form text item must not exceed the maximum length specified for that item."),
	EDIT_3220	(-3220,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If SFW_PROD_NAME is equal to [^], then SFW_PROD_VRSN_CD must be equal to [^]."),
	EDIT_3230	(-3230,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If SFW_PROD_NAME is not equal to [^], then SFW_PROD_VRSN_CD must not be equal to [^]."),
	EDIT_3240	(-3240,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "The submission system will recalculate the ISC and compare the recalculated value with the value that is submitted in ITM_SBST_CD.  If the recalculated value does not match the value submitted in ITM_SBST_CD, a fatal error will result."),
	EDIT_3250	(-3250,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF ALPHANUMERIC TEXT ITEMS THAT CAN CONTAIN DASHES, SPACES, AMPERSANDS, AND OTHER SPECIAL CHARACTERS\n" + "If this item is not equal to one of the special values (if any) that are listed in the Item Values table of the Detailed Data Specifications Report, then it must contain a text string.  This text string may contain only the following characters:\n" + "a) The numeric characters: [0] through [9].\n" + "b) The letters [A] through [Z] and [a] through [z].\n" + "c) The character [-].\n" + "d) The following special characters:\n" + "      [&] (ampersand) \n" + "      [@]  (at sign)\n" + "      [']  (single quote)\n" + "      [/] (forward slash)\n" + "      [+] (plus sign)\n" + "      [,] (comma)\n" + "      [.] (period)\n" + "      [_] (underscore)\n" + "e) Embedded spaces (spaces surrounded by any of the characters listed above).  For example, [LEGAL TEXT] would be allowed."),
	EDIT_3260	(-3260,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "DATE ITEM CONSISTENCY: PATTERN 1\n" + "Each active item in the list below that contains a valid date (not blank) must be in the specified order.\n" + "\n" + "If M0032_ROC_DT  is equal to [^], then the following rules apply:\n" + "M0066_PAT_BIRTH_DT <\n" + "M1005_INP_DISCHARGE_DT <=\n" + "M0102_PHYSN_ORDRD_SOCROC_DT <=\n" + "M0104_PHYSN_RFRL_DT <=\n" + "M0030_START_CARE_DT <=\n" + "M1307_OLDST_STG2_ONST_DT <=\n" + "M0903_LAST_HOME_VISIT <=\n" + "M0906_DC_TRAN_DTH_DT <=\n" + "M0090_INFO_COMPLETED_DT <=\n" + "Current date"),
	EDIT_3270	(-3270,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "DATE ITEM CONSISTENCY: PATTERN 2\n" + "Each active item in the list below that contains a valid date (not blank) must be in the specified order.\n" + "\n" + "If M0032_ROC_DT is NOT equal to [^], then the following rules apply:\n" + "M0066_PAT_BIRTH_DT <\n" + "M0030_START_CARE_DT <=\n" + "M1005_INP_DISCHARGE_DT <=\n" + "M0102_PHYSN_ORDRD_SOCROC_DT <=\n" + "M0104_PHYSN_RFRL_DT <=\n" + "M0032_ROC_DT <=\n" + "M1307_OLDST_STG2_ONST_DT <=\n" + "M0903_LAST_HOME_VISIT <=\n" + "M0906_DC_TRAN_DTH_DT <=\n" + "M0090_INFO_COMPLETED_DT <=\n" + "Current date"),
	EDIT_3280	(-3280,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[01] and if M0030_START_CARE_DT and M1005_INP_DISCHARGE_DT are both active and contain valid dates (not [^]), then M0030_START_CARE_DT minus M1005_INP_DISCHARGE_DT should be greater than or equal to zero and less than or equal to 14 days."),
	EDIT_3290	(-3290,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[03] and if M0032_ROC_DT and  M1005_INP_DISCHARGE_DT are both active and contain valid dates (not [^]), then M0032_ROC_DT minus  M1005_INP_DISCHARGE_DT should be greater than or equal to zero and less than or equal to 14."),
	EDIT_3300	(-3300,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[01] and if M0090_INFO_COMPLETED_DT and M0030_START_CARE_DT are both active and contain valid dates (not [^]), then M0090_INFO_COMPLETED_DT minus M0030_START_CARE_DT should be greater than or equal to zero and less than or equal to 5."),
	EDIT_3310	(-3310,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[03] and if M0090_INFO_COMPLETED_DT and M0032_ROC_DT are both active and contain valid dates (not [^]), then M0090_INFO_COMPLETED_DT minus M0032_ROC_DT should be greater than or equal to zero and less than or equal to 2."),
	EDIT_3320	(-3320,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[09] and if M0090_INFO_COMPLETED_DT and M0906_DC_TRAN_DTH_DT are both active and contain valid dates (not [^]), then M0090_INFO_COMPLETED_DT minus M0906_DC_TRAN_DTH_DT should be greater than or equal to zero and less than or equal to 2."),
	EDIT_3330	(-3330,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If TRANS_TYPE_CD=[1] (new record), then submission date minus M0090_INFO_COMPLETED_DT should be less than or equal to 30 days."),
	EDIT_3340	(-3340,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If TRANS_TYPE_CD=[1], then CORRECTION_NBR must equal [00]."),
	EDIT_3350	(-3350,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, "2.10", "FORMATTING ICD-9 DIAGNOSIS CODES (NOT E- OR V-CODE)\n" + "For an item where an E- or V-code is not allowed, a non-blank ICD-9 diagnosis code must conform with the following rules:\n" + "\n" + "a) Character 1 must be a [^].\n" + "b) Character 2 must be [0-9].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Characters 6 and 7 must be [0-9,^].\n" + "f) If character 6 is [^], then character 7 must be [^].\n" + "\n" + "Note that ICD-10 diagnosis codes are formatted differently from ICD-9 codes and must not be submitted for this item."),
	EDIT_3360	(-3360,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, "2.10", "FORMATTING ICD-9 PROCEDURE CODES\n" + "An ICD-9 procedure code must conform with the following rules:\n" + "\n" + "a) Character 1 must be [^].\n" + "b) Character 2 must be [^].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Character 6 must be [0-9].\n" + "f) Character 7 must be [0-9,^].\n" + "\n" + "Note that ICD-10 procedure codes are formatted differently from ICD-9 codes and must not be submitted for this item."),
	EDIT_3370	(-3370,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, "2.10", "FORMATTING ICD-9 DIAGNOSIS CODES (V-CODES ALLOWED)\n" + "For an item where a V-code is allowed (but an E-code is not allowed), a non-blank ICD-9 diagnosis code must conform with one of the following two patterns:\n" + "\n" + "PATTERN A\n" + "a) Character 1 must be [^].\n" + "b) Character 2 must be [0-9].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Characters 6 and 7 must be [0-9,^].\n" + "f) If character 6 is [^], then character 7 must be [^].\n" + "\n" + "PATTERN B\n" + "a) Character 1 must be [^].\n" + "b) Character 2 must be [V].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Characters 6 and 7 must be [0-9,^].\n" + "f) If character 6 is [^], then character 7 must be [^].\n" + "\n" + "Note that ICD-10 diagnosis codes are formatted differently from ICD-9 codes and must not be submitted for this item."),
	EDIT_3380	(-3380,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, "2.10", "FORMATTING ICD-9 DIAGNOSIS CODES (E- OR V-CODE ALLOWED)\n" + "For an item where a V- or E-code is allowed, a non-blank ICD-9 diagnosis code must conform with one of the following two patterns:\n" + "\n" + "PATTERN A\n" + "a) Character 1 must be [E,^].\n" + "b) Character 2 must be [0-9].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Characters 6 and 7 must be [0-9,^].\n" + "f) If character 6 is [^], then character 7 must be [^].\n" + "\n" + "PATTERN B\n" + "a) Character 1 must be [^].\n" + "b) Character 2 must be [V].\n" + "c) Characters 3 thru 4 must be [0-9].\n" + "d) Character 5 must be a decimal point.\n" + "e) Characters 6 and 7 must be [0-9,^].\n" + "f) If character 6 is [^], then character 7 must be [^].\n" + "\n" + "Note that ICD-10 diagnosis codes are formatted differently from ICD-9 codes and must not be submitted for this item."),
	EDIT_3390	(-3390,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "PATIENT AGE\n" + "a) Patient age at the time the assessment was completed cannot be more than 140 years.\n" + "b) Patient age at the time the assessment was completed cannot be less than 18 years.\n" + "c) If M0066_PAT_BIRTH_DT is equal to [--------], then age cannot be computed and this edit does not apply.\n" + "\n" + "Patient age is computed as follows:\n" + " \n" + "1) If both the month and day in M0066_PAT_BIRTH_DT are unknown, replace the month with \"07\" and the day with \"02\" for the purpose of calculating age.\n" + "\n" + "2) If only the day in M0066_PAT_BIRTH_DT is unknown, replace the day with the \"15\" for the purpose of calculating age.\n" + "\n" + "3) Provisionally compute age (in years) by subtracting the year in M0066_PAT_BIRTH_DT from the year in M0090_INFO_COMPLETED_DT.\n" + "\n" + "4) If the month in M0090_INFO_COMPLETED_DT is less than the month in M0066_PAT_BIRTH_DT, then subtract 1 from the provisional age computed in (4) above.\n" + "\n" + "5) If the month in M0090_INFO_COMPLETED_DT is equal to the month in M0066_PAT_BIRTH_DT and if the day in M0090_INFO_COMPLETED_DT is less than the day in M0066_PAT_BIRTH_DT, then subtract 1 from the provisional age computed in (4) above."),
	EDIT_3400	(-3400,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, "2.10", "FORMATTING OF NUMERIC ITEMS WITH TENTHS DECIMAL VALUES:\n" + "Only integer values, values with tenths decimals, and the special values (if any) that are listed in the \"Item Values\" table of the Detailed Data Specifications Report will be accepted for this item. Leading and trailing zeroes may be included or omitted from the submitted value as long as the resulting length of the string does not exceed the allowed maximum length for the item. A decimal point and tenth value may be included; however the fractional portion beyond the tenths decimal place must not be included.\n" + "\n" + "The following examples are allowable if the value to be submitted is equal to [1.2] and the maximum length is equal to 4: [1.2], [01.2]. The following values are NOT allowed and will lead to a fatal error: [1.21], [1.20].\n" + "\n" + "The following examples are allowable if the value to be submitted is an integer equal to [1] and the maximum length is equal to 4: [1], [01], [1.], [01.], [1.0], [01.0]. The following values are NOT allowed and will lead to a fatal error: [1.00], [01.00]."),
	EDIT_3410	(-3410,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0016_BRANCH_ID contains a standard branch ID (i.e., is not equal to [N] or [P]), then M0014_BRANCH_STATE must not equal [^]."),
	EDIT_3420	(-3420,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0016_BRANCH_ID is equal to [N] or [P], then M0014_BRANCH_STATE must equal [^]."),
	EDIT_3430	(-3430,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "The patient ZIP code must be either 5 or 9 bytes in length.  Do not include a dash if a ZIP+4 code is submitted."),
	EDIT_3440	(-3440,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1000_DC_NONE_14_DA=[1], then all active items from M1005_INP_DISCHARGE_DT through M1012_INP_UK_ICD must equal [^]."),
	EDIT_3450	(-3450,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1005_INP_DSCHG_UNKNOWN=[0], then if M1005_INP_DISCHARGE_DT is active it must not equal [^]."),
	EDIT_3460	(-3460,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1005_INP_DSCHG_UNKNOWN=[1], then if M1005_INP_DISCHARGE_DT is active it must equal [^]."),
	EDIT_3470	(-3470,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0018_PHYSICIAN_UK=[0], then if M0018_PHYSICIAN_ID is active it cannot equal [^]."),
	EDIT_3480	(-3480,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0018_PHYSICIAN_UK=[1], then if M0018_PHYSICIAN_ID is active it must equal [^]."),
	EDIT_3490	(-3490,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0032_ROC_DT_NA=[0], then if M0032_ROC_DT is active it must not equal [^]."),
	EDIT_3500	(-3500,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0032_ROC_DT_NA=[1], then if M0032_ROC_DT is active it must equal [^]."),
	EDIT_3510	(-3510,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0063_MEDICARE_NA=[0], then if M0063_MEDICARE_NBR is active it must not equal [^]."),
	EDIT_3520	(-3520,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0063_MEDICARE_NA=[1], then if M0063_MEDICARE_NBR is active it must equal [^]."),
	EDIT_3530	(-3530,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0064_SSN_UK=[0], then if M0064_SSN is active it must not equal [^]."),
	EDIT_3540	(-3540,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0064_SSN_UK=[1], then if M0064_SSN is active it must equal [^]."),
	EDIT_3550	(-3550,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0065_MEDICAID_NA=[0], then if M0065_MEDICAID_NBR is active it must not equal [^]."),
	EDIT_3560	(-3560,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0065_MEDICAID_NA=[1], then if M0065_MEDICAID_NBR is active it must equal [^]."),
	EDIT_3570	(-3570,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0102_PHYSN_ORDRD_SOCROC_DT is not equal to [^] (contains a valid date), then if M0102_PHYSN_ORDRD_SOCROC_DT_NA is active it must equal [0,^]."),
	EDIT_3580	(-3580,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0102_PHYSN_ORDRD_SOCROC_DT=[^], then if M0102_PHYSN_ORDRD_SOCROC_DT_NA is active it must equal [1]."),
	EDIT_3590	(-3590,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0102_PHYSN_ORDRD_SOCROC_DT is not equal to [^] (contains a valid date), then if M0104_PHYSN_RFRL_DT is active it must equal [^]."),
	EDIT_3600	(-3600,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0102_PHYSN_ORDRD_SOCROC_DT=[^] then if M0104_PHYSN_RFRL_DT is active it must not equal [^]."),
	EDIT_3610	(-3610,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If SUBM_HIPPS_CODE is not equal to [^], then M0110_EPISODE_TIMING must equal [01,02,UK]."),
	EDIT_3620	(-3620,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If all items from M0140_ETHNIC_AI_AN through M0140_ETHNIC_WHITE are active, then at least one of these items must equal [1]."),
	EDIT_3630	(-3630,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "At least one of the following items must equal [1]: M0150_CPAY_MCARE_FFS, M0150_CPAY_MCARE_HMO, M0150_CPAY_MCAID_FFS, or M0150_CPAY_MCAID_HMO.  If all of these items are equal to [0], then the patient's care is not paid by Medicare or Medicaid and the assessment will be rejected if it is submitted."),
	EDIT_3640	(-3640,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "Both M0150_CPAY_NONE and M0150_CPAY_UK must equal [0]."),
	EDIT_3650	(-3650,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1000_DC_NONE_14_DA=[0], then at least one active item from M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA must equal [1]."),
	EDIT_3660	(-3660,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1000_DC_NONE_14_DA=[1], then all active items from M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA must equal [0]."),
	EDIT_3670	(-3670,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1010_14_DAY_INP1_ICD through M1010_14_DAY_INP6_ICD is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3680	(-3680,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1012_INP_NA_ICD=[1], then M1012_INP_UK_ICD must equal [0]."),
	EDIT_3690	(-3690,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1012_INP_UK_ICD=[1], then M1012_INP_NA_ICD must equal [0]."),
	EDIT_3700	(-3700,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1012_INP_NA_ICD=[0] and M1012_INP_UK_ICD=[0], then at least one active item from M1012_INP_PRCDR1_ICD through M1012_INP_PRCDR4_ICD must not equal [^]."),
	EDIT_3710	(-3710,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1012_INP_NA_ICD=[1] or M1012_INP_UK_ICD=[1], then M1012_INP_PRCDR1_ICD through M1012_INP_PRCDR4_ICD must equal [^]."),
	EDIT_3720	(-3720,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If any item from M1012_INP_PRCDR1_ICD through M1012_INP_PRCDR4_ICD is not equal to [^], then M1012_INP_NA_ICD must equal [0] and M1012_INP_UK_ICD and must equal [0]."),
	EDIT_3730	(-3730,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1012_INP_PRCDR1_ICD through M1012_INP_PRCDR4_ICD is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3740	(-3740,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1016_CHGREG_ICD_NA=[0], then at least one active item from M1016_CHGREG_ICD1 through M1016_CHGREG_ICD6 must not equal [^]."),
	EDIT_3750	(-3750,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1016_CHGREG_ICD_NA=[1], then M1016_CHGREG_ICD1 through M1016_CHGREG_ICD6 must equal [^]."),
	EDIT_3760	(-3760,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1016_CHGREG_ICD1 through M1016_CHGREG_ICD6 is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3770	(-3770,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If any one of the items M1018_PRIOR_NONE, M1018_PRIOR_NOCHG_14D, or M1018_PRIOR_UNKNOWN is equal to [1], then the remaining two items must equal [0]."),
	EDIT_3780	(-3780,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If any one of the items M1018_PRIOR_NONE, M1018_PRIOR_NOCHG_14D, or M1018_PRIOR_UNKNOWN is equal to [1], then all active items from M1018_PRIOR_UR_INCON through M1018_PRIOR_MEM_LOSS must equal [0]."),
	EDIT_3790	(-3790,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If any item from M1018_PRIOR_UR_INCON through M1018_PRIOR_MEM_LOSS is equal to [1], then all active items from M1018_PRIOR_NONE through M1018_PRIOR_UNKNOWN must equal [0]."),
	EDIT_3800	(-3800,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If any item from M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA is equal to [1] or M1016_CHGREG_ICD_NA=[0], then M1018_PRIOR_NOCHG_14D must equal [0]."),
	EDIT_3810	(-3810,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1000_DC_NONE_14_DA=[1] and M1016_CHGREG_ICD_NA=[1], then M1018_PRIOR_NOCHG_14D must equal [1]."),
	EDIT_3820	(-3820,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, "2.10", "M1020_PRIMARY_DIAG_SEVERITY should equal [01-04].  A warning will be issued if it is equal to [00]."),
	EDIT_3830	(-3830,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1020_PRIMARY_DIAG_ICD, M1022_OTH_DIAG1_ICD, M1022_OTH_DIAG2_ICD, M1022_OTH_DIAG3_ICD, M1022_OTH_DIAG4_ICD, or M1022_OTH_DIAG5_ICD is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3840	(-3840,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1024_PMT_DIAG_ICD_A3, M1024_PMT_DIAG_ICD_B3, M1024_PMT_DIAG_ICD_C3, M1024_PMT_DIAG_ICD_D3, M1024_PMT_DIAG_ICD_E3, or M1024_PMT_DIAG_ICD_F3. is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3850	(-3850,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a value submitted in items M1024_PMT_DIAG_ICD_A4, M1024_PMT_DIAG_ICD_B4, M1024_PMT_DIAG_ICD_C4, M1024_PMT_DIAG_ICD_D4, M1024_PMT_DIAG_ICD_E4, or M1024_PMT_DIAG_ICD_F4 is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_3860	(-3860,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Primary/Other ICD code in Column 2 code is equal to [^], then the corresponding Column 3 code must equal [^]."),
	EDIT_3870	(-3870,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If a Column 3 ICD code is equal to [^], then the corresponding Column 4 code must equal [^]."),
	EDIT_3880	(-3880,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1030_THH_NONE_ABOVE=[0], then at least one active item from M1030_THH_IV_INFUSION through M1030_THH_ENT_NUTRITION must equal [1]."),
	EDIT_3890	(-3890,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1030_THH_NONE_ABOVE=[1], then all active items from M1030_THH_IV_INFUSION through M1030_THH_ENT_NUTRITION must equal [0]."),
	EDIT_3900	(-3900,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1032_HOSP_RISK_NONE_ABOVE is equal to [0], then at least one active item from M1032_HOSP_RISK_RCNT_DCLN through M1032_HOSP_RISK_OTHR must equal [1]."),
	EDIT_3910	(-3910,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1032_HOSP_RISK_NONE_ABOVE is equal to [1], then all active items from M1032_HOSP_RISK_RCNT_DCLN through M1032_HOSP_RISK_OTHR must equal [0]."),
	EDIT_3920	(-3920,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1036_RSK_NONE=[0] and M1036_RSK_UNKNOWN=[0], then at least one active item from M1036_RSK_SMOKING through M1036_RSK_DRUGS must equal [1]."),
	EDIT_3930	(-3930,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1036_RSK_NONE=[1], then all active items from M1036_RSK_SMOKING through M1036_RSK_DRUGS and M1036_RSK_UNKNOWN must equal [0]."),
	EDIT_3940	(-3940,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1036_RSK_UNKNOWN=[1], then all active items from M1036_RSK_SMOKING through M1036_RSK_NONE must equal [0]."),
	EDIT_3950	(-3950,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1040_INFLNZ_RCVD_AGNCY=[00], then if M1045_INFLNZ_RSN_NOT_RCVD is active it must not equal [^]."),
	EDIT_3960	(-3960,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1040_INFLNZ_RCVD_AGNCY=[01,NA], then if M1045_INFLNZ_RSN_NOT_RCVD is active it must equal [^]."),
	EDIT_3970	(-3970,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1050_PPV_RCVD_AGNCY=[0], then if M1055_PPV_RSN_NOT_RCVD_AGNCY is active it must not equal [^]."),
	EDIT_3980	(-3980,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1050_PPV_RCVD_AGNCY=[1], then if M1055_PPV_RSN_NOT_RCVD_AGNCY is active it must equal [^]."),
	EDIT_3990	(-3990,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1300_PRSR_ULCR_RISK_ASMT=[00], then if M1302_RISK_OF_PRSR_ULCR is active it must equal [^]."),
	EDIT_4000	(-4000,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1300_PRSR_ULCR_RISK_ASMT=[01,02], then if M1302_RISK_OF_PRSR_ULCR is active it must not equal [^]."),
	EDIT_4010	(-4010,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[0], then all active items from M1307_OLDST_STG2_AT_DSCHRG through M1320_STUS_PRBLM_PRSR_ULCR must equal [^]."),
	EDIT_4020	(-4020,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1307_OLDST_STG2_AT_DSCHRG is active it must not equal [^]."),
	EDIT_4030	(-4030,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1307_OLDST_STG2_AT_DSCHRG=[01,NA], then if M1307_OLDST_STG2_ONST_DT is active it must equal [^]."),
	EDIT_4040	(-4040,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1307_OLDST_STG2_AT_DSCHRG=[02], then if M1307_OLDST_STG2_ONST_DT is active it must not equal [^]."),
	EDIT_4050	(-4050,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then all active items from M1308_NBR_PRSULC_STG2 through M1308_NSTG_DEEP_TISUE_SOC_ROC must not equal [^]."),
	EDIT_4060	(-4060,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then least one active item between M1308_NBR_PRSULC_STG2 and M1308_NSTG_DEEP_TISUE_SOC_ROC must be greater than [00]."),
	EDIT_4070	(-4070,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NBR_STG2_AT_SOC_ROC is active it must be less than or equal to M1308_NBR_PRSULC_STG2."),
	EDIT_4080	(-4080,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NBR_STG3_AT_SOC_ROC is active it must be less than or equal to M1308_NBR_PRSULC_STG3."),
	EDIT_4090	(-4090,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NBR_STG4_AT_SOC_ROC is active it must be less than or equal to M1308_NBR_PRSULC_STG4."),
	EDIT_4100	(-4100,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NSTG_DRSG_SOC_ROC is active it must be less than or equal to M1308_NSTG_DRSG."),
	EDIT_4110	(-4110,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NSTG_CVRG_SOC_ROC is active it must be less than or equal to M1308_NSTG_CVRG."),
	EDIT_4120	(-4120,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1308_NSTG_DEEP_TISUE_SOC_ROC is active it must be less than or equal to M1308_NSTG_DEEP_TISUE."),
	EDIT_4130	(-4130,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1308_NBR_PRSULC_STG2, M1308_NBR_PRSULC_STG3, M1308_NBR_PRSULC_STG4, M1308_NSTG_CVRG, and M1308_NSTG_DEEP_TISUE are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [NA]."),
        EDIT_4131	(-4131,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1311_NBR_PRSULC_STG2_A1, M1311_NBR_PRSULC_STG3_B1, M1311_NBR_PRSULC_STG4_C1, M1311_NSTG_CVRG_E1, and M1311_NSTG_DEEP_TSUE_F1 are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [NA]."),
        EDIT_4140	(-4140,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1308_NBR_PRSULC_STG2 or M1308_NSTG_DEEP_TISUE is greater than [00] and M1308_NBR_PRSULC_STG3, M1308_NBR_PRSULC_STG4, and M1308_NSTG_CVRG are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [03]."),
        EDIT_4141	(-4141,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1311_NBR_PRSULC_STG2_A1 or M1311_NSTG_DEEP_TSUE_F1 is greater than [00] and M1311_NBR_PRSULC_STG3_B1, M1311_NBR_PRSULC_STG4_C1, and M1311_NSTG_CVRG_E1 are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [03]."),
        EDIT_4150	(-4150,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1308_NBR_PRSULC_STG3 or M1308_NBR_PRSULC_STG4 is greater than [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [00,01,02,03]."),
        EDIT_4151	(-4151,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1311_NBR_PRSULC_STG3_B1 or M1311_NBR_PRSULC_STG4_C1 is greater than [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [00,01,02,03]."),
        EDIT_4160	(-4160,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1308_NSTG_CVRG is greater than [00] and M1308_NBR_PRSULC_STG2, M1308_NBR_PRSULC_STG3, M1308_NBR_PRSULC_STG4, and M1308_NSTG_DEEP_TISUE are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [02,03]."),
        EDIT_4161	(-4161,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1311_NSTG_CVRG_E1 is greater than [00] and M1311_NBR_PRSULC_STG2_A1, M1311_NBR_PRSULC_STG3_B1, M1311_NBR_PRSULC_STG4_C1, and M1311_NSTG_DEEP_TSUE_F1 are all equal to [00], then if M1320_STUS_PRBLM_PRSR_ULCR is active it must equal [02,03]."),
        EDIT_4170	(-4170,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1324_STG_PRBLM_ULCER=[01], then if M1322_NBR_PRSULC_STG1 is active it must be greater than [00]."),
	EDIT_4180	(-4180,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1324_STG_PRBLM_ULCER=[02], then if M1308_NBR_PRSULC_STG2 is active it must be greater than [00]."),
	EDIT_4181	(-4181,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1324_STG_PRBLM_ULCER=[02], then if M1311_NBR_PRSULC_STG2_A1 is active it must not equal [^] and it must be greater than [00]."),
        EDIT_4190	(-4190,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1324_STG_PRBLM_ULCER=[03], then if M1308_NBR_PRSULC_STG3 is active it must be greater than [00]."),
        EDIT_4191	(-4191,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1324_STG_PRBLM_ULCER=[03], then if M1311_NBR_PRSULC_STG3_B1 is active it must not equal [^] and it must be greater than [00]."),
        EDIT_4200	(-4200,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1324_STG_PRBLM_ULCER=[04], then if M1308_NBR_PRSULC_STG4 is active it must be greater than [00]."),
        EDIT_4201	(-4201,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1324_STG_PRBLM_ULCER=[04], then if M1311_NBR_PRSULC_STG4_C1 is active it must not equal [^] and it must be greater than [00]."),
        EDIT_4210	(-4210,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1322_NBR_PRSULC_STG1 and M1308_NBR_PRSULC_STG2 and M1308_NBR_PRSULC_STG3 and M1308_NBR_PRSULC_STG4 are all equal to [00,^ ], then if M1324_STG_PRBLM_ULCER is active it must be equal to [NA]."),
        EDIT_4211	(-4211,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1322_NBR_PRSULC_STG1 and M1311_NBR_PRSULC_STG2_A1 and M1311_NBR_PRSULC_STG3_B1 and M1311_NBR_PRSULC_STG4_C1 are all equal to [00,^], then if M1324_STG_PRBLM_ULCER is active it must be equal to [NA]."),
        EDIT_4220	(-4220,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1330_STAS_ULCR_PRSNT=[00,03], then all active items from M1332_NBR_STAS_ULCR through M1334_STUS_PRBLM_STAS_ULCR  must equal [^]."),
	EDIT_4230	(-4230,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1330_STAS_ULCR_PRSNT=[01,02], then all active items from M1332_NBR_STAS_ULCR through M1334_STUS_PRBLM_STAS_ULCR cannot not equal [^]."),
	EDIT_4240	(-4240,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1340_SRGCL_WND_PRSNT=[00,02], then if  M1342_STUS_PRBLM_SRGCL_WND is active it must equal [^]."),
	EDIT_4250	(-4250,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1340_SRGCL_WND_PRSNT=[01], then if M1342_STUS_PRBLM_SRGCL_WND is active it must not equal [^]."),
	EDIT_4260	(-4260,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1410_RESPTX_NONE=[0], then at least one active item from M1410_RESPTX_OXYGEN through M1410_RESPTX_AIRPRESS must equal [1]."),
	EDIT_4270	(-4270,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1410_RESPTX_NONE=[1], then all active items from M1410_RESPTX_OXYGEN through M1410_RESPTX_AIRPRESS must equal [0]."),
	EDIT_4280	(-4280,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1500_SYMTM_HRT_FAILR_PTNTS=[00,02,NA], then all active items from M1510_HRT_FAILR_NO_ACTN through M1510_HRT_FAILR_CARE_PLAN_CHG must equal [^]."),
	EDIT_4290	(-4290,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1500_SYMTM_HRT_FAILR_PTNTS=[01], then all active items from M1510_HRT_FAILR_NO_ACTN through M1510_HRT_FAILR_CARE_PLAN_CHG must not equal [^]."),
	EDIT_4300	(-4300,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1500_SYMTM_HRT_FAILR_PTNTS=[01], then at least one active item from M1510_HRT_FAILR_NO_ACTN through M1510_HRT_FAILR_CARE_PLAN_CHG must equal [1]."),
	EDIT_4310	(-4310,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1510_HRT_FAILR_NO_ACTN=[1], then all active items from M1510_HRT_FAILR_PHYSN_CNTCT through M1510_HRT_FAILR_CARE_PLAN_CHG must equal [0]."),
	EDIT_4320	(-4320,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[09], then if M1600_UTI is active it cannot equal [UK]."),
	EDIT_4330	(-4330,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1610_UR_INCONT=[00,02], then if M1615_INCNTNT_TIMING is active it must equal [^]."),
	EDIT_4340	(-4340,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1610_UR_INCONT=[01], then if M1615_INCNTNT_TIMING is active it must not equal [^]."),
	EDIT_4350	(-4350,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[04,05,09], then if M1620_BWL_INCONT is active it cannot equal [UK]."),
	EDIT_4360	(-4360,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1620_BWL_INCONT=[00-05,UK], then if M1630_OSTOMY is active it must equal [00]."),
	EDIT_4370	(-4370,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1620_BWL_INCONT=[NA], then if M1630_OSTOMY is active it must equal [01,02]."),
	EDIT_4380	(-4380,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1730_STDZ_DPRSN_SCRNG=[00,02,03], then all active items from M1730_PHQ2_LACK_INTRST through M1730_PHQ2_DPRSN must equal [^]."),
	EDIT_4390	(-4390,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1730_STDZ_DPRSN_SCRNG=[01], then all active items from M1730_PHQ2_LACK_INTRST through M1730_PHQ2_DPRSN must not equal [^]."),
	EDIT_4400	(-4400,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1740_BD_NONE=[0], then at least one active item from M1740_BD_MEM_DEFICIT through M1740_BD_DELUSIONS must equal [1]."),
	EDIT_4410	(-4410,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1740_BD_NONE=[1], then all active items from M1740_BD_MEM_DEFICIT through M1740_BD_DELUSIONS must equal [0]."),
	EDIT_4420	(-4420,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2000_DRUG_RGMN_RVW=[00,01,NA], then all active items from M2002_MDCTN_FLWP through M2004_MDCTN_INTRVTN must equal [^]."),
	EDIT_4430	(-4430,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2000_DRUG_RGMN_RVW=[02], then all active items from M2002_MDCTN_FLWP through M2004_MDCTN_INTRVTN must not equal [^]."),
	EDIT_4431	(-4431,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.20", "If M2001_DRUG_RGMN_RVW=[1], then all active items from M2003_MDCTN_FLWP through M2030_CRNT_MGMT_INJCTN_MDCTN must not equal [^]."),
        EDIT_4440	(-4440,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2000_DRUG_RGMN_RVW=[NA], then all active items from M2010_HIGH_RISK_DRUG_EDCTN through M2030_CRNT_MGMT_INJCTN_MDCTN must equal [^]."),
        EDIT_4441	(-4441,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.20", "If M2001_DRUG_RGMN_RVW=[9], then all active items from M2003_MDCTN_FLWP through M2030_CRNT_MGMT_INJCTN_MDCTN must equal [^]."),
        EDIT_4450	(-4450,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2000_DRUG_RGMN_RVW=[00,01,02], then all active items from M2010_HIGH_RISK_DRUG_EDCTN through M2030_CRNT_MGMT_INJCTN_MDCTN must not equal [^]."),
	EDIT_4460	(-4460,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[06,07,09], then M2004_MDCTN_INTRVTN cannot equal [^]."),
	EDIT_4470	(-4470,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[06,07,09], then M2015_DRUG_EDCTN_INTRVTN cannot equal [^]."),
	EDIT_4480	(-4480,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[09] then M2020_CRNT_MGMT_ORAL_MDCTN cannot equal [^]."),
	EDIT_4490	(-4490,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[04,05,09], then M2030_CRNT_MGMT_INJCTN_MDCTN cannot equal [^]."),
	EDIT_4500	(-4500,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[09], then if M2110_ADL_IADL_ASTNC_FREQ is active it cannot equal [UK]."),
	EDIT_4510	(-4510,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2200_THER_NEED_NA=[0], then if M2200_THER_NEED_NBR is active it must not equal [^]."),
	EDIT_4520	(-4520,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2200_THER_NEED_NA=[1], then if M2200_THER_NEED_NBR is active it must equal [^]."),
	EDIT_4530	(-4530,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2300_EMER_USE_AFTR_LAST_ASMT=[00,UK], then all active items from M2310_ECR_MEDICATION through M2310_ECR_UNKNOWN must equal [^]."),
	EDIT_4540	(-4540,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2300_EMER_USE_AFTR_LAST_ASMT=[01,02], then all active items from M2310_ECR_MEDICATION through M2310_ECR_UNKNOWN must not equal [^]."),
	EDIT_4550	(-4550,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M2310_ECR_UNKNOWN=[0], then at least one active item from M2310_ECR_MEDICATION through M2310_ECR_OTHER must equal [1]."),
	EDIT_4560	(-4560,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M2310_ECR_UNKNOWN=[1], then all active items from M2310_ECR_MEDICATION through M2310_ECR_OTHER must equal [0]."),
	EDIT_4570	(-4570,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[09], then if M2410_INPAT_FACILITY is active it must equal [NA]."),
	EDIT_4580	(-4580,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[06,07], then if M2410_INPAT_FACILITY is active it must not equal [NA]."),
	EDIT_4590	(-4590,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2410_INPAT_FACILITY=[01], then all active items from M2430_HOSP_MED through M2430_HOSP_UK must not equal [^]."),
	EDIT_4600	(-4600,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M2410_INPAT_FACILITY=[02,03,04,NA], then all active items from M2430_HOSP_MED through M2430_HOSP_UK must equal [^]."),
	EDIT_4610	(-4610,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M2410_INPAT_FACILITY=[01,02,04,NA], then all active items from M2440_NH_THERAPY through M2440_NH_UNKNOWN must equal [^]."),
	EDIT_4620	(-4620,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M2410_INPAT_FACILITY=[03], then all active items from M2440_NH_THERAPY through M2440_NH_UNKNOWN must not equal [^]."),
	EDIT_4630	(-4630,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M2430_HOSP_UK=[0], then at least one active item from M2430_HOSP_MED through M2430_HOSP_SCHLD_TRTMT must equal [1]."),
	EDIT_4640	(-4640,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M2430_HOSP_UK=[1], then all active items from M2430_HOSP_MED through M2430_HOSP_OTHER must equal [0]."),
	EDIT_4650	(-4650,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M2440_NH_UK=[0], then at least one active item from M2440_NH_THERAPY through M2440_NH_UNSAFE_HOME must equal [1]."),
	EDIT_4660	(-4660,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If M2440_NH_UNKNOWN=[1], then all active items from M2440_NH_THERAPY through M2440_NH_OTHER must equal [0]."),
	EDIT_4670	(-4670,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1308_NBR_PRSULC_STG3 is greater than [00] or M1308_NBR_PRSULC_STG4 is greater than [00] or M1308_NSTG_CVRG is greater than [00], then all active items from M1310_PRSR_ULCR_LNGTH through M1314_PRSR_ULCR_DEPTH must not equal [^]."),
	EDIT_4680	(-4680,	Level.SEVERE, 	OasisEditTypeEN.SKIP , "2.10", "If M1308_NBR_PRSULC_STG3, M1308_NBR_PRSULC_STG4 and M1308_NSTG_CVRG are all equal to [00], then all active items from M1310_PRSR_ULCR_LNGTH through M1314_PRSR_ULCR_DEPTH must equal [^]."),
	EDIT_4690	(-4690,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the assessment was performed by an HHA which has no branches or by a subunit which has no branches, then M0016_BRANCH_ID must contain [N]. This indicates that the assessment was completed by an HHA or subunit which has no branches."),
	EDIT_4700	(-4700,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the assessment was performed by the home office of an HHA which has branches or by the home office of a subunit which has branches, then M0016_BRANCH_ID must contain [P]. This indicates that the assessment was completed by the home office (an HHA parent or subunit -- not a branch)."),
	EDIT_4710	(-4710,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0016_BRANCH_ID does not contain a standard branch ID, [N], or [P], a fatal error will result and the record will be rejected."),
	EDIT_4720	(-4720,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a standard branch ID (i.e., not [N,P]) is submitted, then it will be checked against the system table of the HHA's or subunit's current and past branch IDs. If the submitted branch ID does not match the list of current IDs but does match a past branch ID, then a warning will be issued and the assessment record will be accepted. If the submitted branch ID does not match a current or past branch ID, then the assessment record will be rejected (i.e., it will result in a fatal error)."),
	EDIT_4730	(-4730,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[01], then M0032_ROC_DT_NA must be [1]."),
	EDIT_4740	(-4740,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON=[03], then M0032_ROC_DT_NA must be [0]."),
	EDIT_4800	(-4800,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M2410_INPAT_FACILITY=[NA], then M2420_DSCHRG_DISP must not equal [^]."),
	EDIT_4810	(-4810,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If SUBM_HIPPS_CODE is not equal to [^], then SUBM_HIPPS_VERSION cannot equal [^] and must match the appropriate HIPPS version code."),
	EDIT_4820	(-4820,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0100_ASSMT_REASON is equal to [01,03,04,05], then the state system will recalculate the SUBM_HIPPS_CODE and SUBM_HIPPS_VERSION and compare the recalculated values with the submitted values. If the submitted values do not match the recalculated values, a warning will be issued."),
	EDIT_4830	(-4830,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If any item M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA is equal to [1] and if all items from M1012_INP_PRCDR1_ICD through M1012_INP_UK_ICD are active, then one of the following three conditions must be true:\n" + "\n" + "a) At least one item from M1012_INP_PRCDR1_ICD through M1012_INP_PRCDR4_ICD must not equal [^], OR\n" + "\n" + "b) M1012_INP_NA_ICD must equal [1], OR\n" + "\n" + "c) M1012_INP_UK_ICD must equal [1]."),
	EDIT_4840	(-4840,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If any item M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA is equal to [1], then M1010_14_DAY_INP1_ICD cannot equal [^]."),
	EDIT_4750	(-4750,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Primary/Other ICD code in Column 2 is an E- or V-code, then the corresponding severity code must equal [^].\n" + "\n" + "Note:  An E-code contains [E] in byte 1.  A V-code contains [V] in byte 2."),
	EDIT_4760	(-4760,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Primary/Other ICD code in Column 2 is NOT equal to [^] and is NOT an E- or V-code, then the corresponding severity code must not equal [^].\n" + "\n" + "Note:  An E-code contains [E] in byte 1.  A V-code contains [V] in byte 2."),
	EDIT_4770	(-4770,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Primary/Other ICD code in Column 2 is equal to [^], then the corresponding severity code must equal [^]."),
	EDIT_4780	(-4780,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Column 3 diagnosis code is not equal to [^], then the corresponding Column 2 Primary/Other code should be a V-code (byte 2 of of the Column 2 code should equal [V])."),
	EDIT_4790	(-4790,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, "2.10", "If the Column 4 diagnosis code is not equal to [^], then the corresponding Column 2 Primary/Other code should be a V-code (byte 2 of of the Column 2 code should equal [V])."),
	EDIT_4850	(-4850,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0150_CPAY_MCARE_FFS=[1], then M0063_MEDICARE_NBR must not equal [^]."),
	EDIT_4860	(-4860,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M0150_CPAY_MCAID_FFS=[1], then M0065_MEDICAID_NBR must not equal [^]."),
	EDIT_4870	(-4870,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the SFW_ID is not equal to [^], then SFW_NAME and SFW_EMAIL_ADR must not equal [^]."),
	EDIT_4880	(-4880,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the SFW_ID is equal to [^], then SFW_NAME and SFW_EMAIL_ADR must equal [^]."),
	EDIT_4885	(-4885,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "FORMATTING OF ICD-10 DIAGNOSIS CODES\n" + "ICD-10 diagnosis codes must conform with the following formatting rules:\n" + "a) Character 1 must be alphabetic [A-Z,a-z].\n" + "b) Character 2 must be numeric [0-9].\n" + "c) Character 3 must be numeric [0-9] or alphabetic [A-Z,a-z].\n" + "d) Character 4 must be a decimal point.\n" + "e) Characters 5 through 8 must be numeric [0-9], alphabetic [A-Z,a-z], or caret [^].\n" + "f) If any character 5 through 8 is equal to [^], all subsequent characters must equal [^].\n" + "\n" + "Note that additional formatting rules for particular items may further restrict the range of allowable values in character 1.  Also note that an entirely blank ICD code must be submitted as a single caret: [^]."),
	EDIT_4890	(-4890,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "RESTRICTIONS ON ICD-10 DIAGNOSIS CODES\n" + "Character 1 of the ICD code must not equal [V,W,X,Y,Z]."),
	EDIT_4900	(-4900,	Level.SEVERE, 	OasisEditTypeEN.FORMAT, 	"2.11", "RESTRICTIONS ON ICD-10 DIAGNOSIS CODES\n" + "Character 1 of the ICD code must not equal [V,W,X,Y]."),
	EDIT_4920	(-4920,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1000_DC_NONE_14_DA=[1], then all active items from M1005_INP_DISCHARGE_DT through M1011_14_DAY_INP_NA must equal [^]."),
	EDIT_4930	(-4930,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a value submitted in items M1011_14_DAY_INP1_ICD through M1011_14_DAY_INP6_ICD is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_4940	(-4940,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1017_CHGREG_ICD_NA=[0], then at least one active item from M1017_CHGREG_ICD1 through M1017_CHGREG_ICD6 must not equal [^]."),
	EDIT_4950	(-4950,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1017_CHGREG_ICD_NA=[1], then M1017_CHGREG_ICD1 through M1017_CHGREG_ICD6 must equal [^]."),
	EDIT_4960	(-4960,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a value submitted in items M1017_CHGREG_ICD1 through M1017_CHGREG_ICD6 is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_4970	(-4970,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If any item from M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA is equal to [1] or M1017_CHGREG_ICD_NA=[0], then M1018_PRIOR_NOCHG_14D must equal [0]."),
	EDIT_4980	(-4980,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1000_DC_NONE_14_DA=[1] and M1017_CHGREG_ICD_NA=[1], then M1018_PRIOR_NOCHG_14D must equal [1]."),
	EDIT_4990	(-4990,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "M1021_PRIMARY_DIAG_SEVERITY should equal [01-04].  A warning will be issued if it is equal to [00]."),
	EDIT_5000	(-5000,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a value submitted in items M1021_PRIMARY_DIAG_ICD, M1023_OTH_DIAG1_ICD, M1023_OTH_DIAG2_ICD, M1023_OTH_DIAG3_ICD, M1023_OTH_DIAG4_ICD, or M1023_OTH_DIAG5_ICD is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_5010	(-5010,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a value submitted in items M1025_PMT_DIAG_ICD_A3, M1025_PMT_DIAG_ICD_B3, M1025_PMT_DIAG_ICD_C3, M1025_PMT_DIAG_ICD_D3, M1025_PMT_DIAG_ICD_E3, or M1025_PMT_DIAG_ICD_F3. is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_5020	(-5020,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a value submitted in items M1025_PMT_DIAG_ICD_A4, M1025_PMT_DIAG_ICD_B4, M1025_PMT_DIAG_ICD_C4, M1025_PMT_DIAG_ICD_D4, M1025_PMT_DIAG_ICD_E4, or M1025_PMT_DIAG_ICD_F4 is not equal to [^], it must not equal (must not duplicate) any value submitted in the remaining items in this list."),
	EDIT_5030	(-5030,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Primary/Other ICD code in Column 2 code is equal to [^], then the corresponding Column 3 code must equal [^]."),
	EDIT_5040	(-5040,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If a Column 3 ICD code is equal to [^], then the corresponding Column 4 code must equal [^]."),
	EDIT_5050	(-5050,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1033_HOSP_RISK_NONE_ABOVE is equal to [0], then at least one active item from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR must equal [1]."),
	EDIT_5060	(-5060,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1033_HOSP_RISK_NONE_ABOVE is equal to [1], then all active items from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR must equal [0]."),
	EDIT_5070	(-5070,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1041_IN_INFLNZ_SEASON=[1], then if M1046_INFLNZ_RECD_CUR_SEASON is active it must not equal [^]."),
	EDIT_5080	(-5080,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1041_IN_INFLNZ_SEASON=[0], then if M1046_INFLNZ_RECD_CUR_SEASON is active it must equal [^]."),
	EDIT_5090	(-5090,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1051_PPV_RCVD_AGNCY=[0], then if M1056_PPV_RSN_NOT_RCVD_AGNCY is active it must not equal [^]."),
	EDIT_5100	(-5100,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1051_PPV_RCVD_AGNCY=[1], then if M1056_PPV_RSN_NOT_RCVD_AGNCY is active it must equal [^]."),
	EDIT_5110	(-5110,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[0], then all active items from M1307_OLDST_STG2_AT_DSCHRG through M1320_STUS_PRBLM_PRSR_ULCR must equal [^]."),
	EDIT_5120	(-5120,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then all active items from M1308_NBR_PRSULC_STG2 through M1309_NBR_NEW_WRS_PRSULC_STG4 must not equal [^]."),
	EDIT_5121	(-5121,	Level.SEVERE, 	OasisEditTypeEN.SKIP, 	"2.20", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then the following items must not equal [^]: M1307_OLDST_STG2_AT_DSCHRG, M1311_NBR_PRSULC_STG2_A1, M1311_NBR_PRSULC_STG3_B1, M1311_NBR_PRSULC_STG4_C1, M1311_NSTG_DRSG_D1, M1311_NSTG_CVRG_E1, M1311_NSTG_DEEP_TSUE_F1, M1313_NW_WS_PRSULC_STG2_A, M1313_NW_WS_PRSULC_STG3_B, M1313_NW_WS_PRSULC_STG4_C, M1313_NW_WS_PRSULC_NSTG_DRSG_D, M1313_NW_WS_PRSULC_NSTG_CVRG_E, M1313_NW_WS_PRSULC_NSTG_TSUE_F, M1320_STUS_PRBLM_PRSR_ULCR."),
        EDIT_5130	(-5130,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then least one active item between M1308_NBR_PRSULC_STG2 and M1308_NSTG_DEEP_TISUE must be greater than [00]."),
        EDIT_5131	(-5131,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.20", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then at least one of the following items must be greater than [00]: M1311_NBR_PRSULC_STG2_A1, M1311_NBR_PRSULC_STG3_B1, M1311_NBR_PRSULC_STG4_C1, M1311_NSTG_DRSG_D1, M1311_NSTG_CVRG_E1, M1311_NSTG_DEEP_TSUE_F1."),
        EDIT_5140	(-5140,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1309_NBR_NEW_WRS_PRSULC_STG2 is active it must be less than or equal to M1308_NBR_PRSULC_STG2."),
	EDIT_5150	(-5150,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1309_NBR_NEW_WRS_PRSULC_STG3 is active it must be less than or equal to M1308_NBR_PRSULC_STG3."),
	EDIT_5160	(-5160,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1306_UNHLD_STG2_PRSR_ULCR=[1], then if M1309_NBR_NEW_WRS_PRSULC_STG4 is active it must be less than or equal to M1308_NBR_PRSULC_STG4."),
	EDIT_5200	(-5200,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Primary/Other ICD code in Column 2 is a Z-code, then the corresponding severity code must equal [^].\n" + "\n" + "Note:  A Z-code contains [Z] in byte 1."),
	EDIT_5210	(-5210,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Primary/Other ICD code in Column 2 is NOT equal to [^] and is NOT a Z-code, then the corresponding severity code must not equal [^].\n" + "\n" + "Note:  A Z-code contains [Z] in byte 1."),
	EDIT_5220	(-5220,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Primary/Other ICD code in Column 2 is equal to [^], then the corresponding severity code must equal [^]."),
	EDIT_5230	(-5230,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Column 3 diagnosis code is not equal to [^], then the corresponding Column 2 Primary/Other code should be a Z-code (byte 1 of of the Column 2 code should equal [Z])."),
	EDIT_5240	(-5240,	Level.INFO, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If the Column 4 diagnosis code is not equal to [^], then the corresponding Column 2 Primary/Other code should be a Z-code (byte 1 of of the Column 2 code should equal [Z])."),
	EDIT_5250	(-5250,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If any item M1000_DC_LTC_14_DA through M1000_DC_OTH_14_DA is equal to [1], then M1011_14_DAY_INP1_ICD cannot equal [^]."),
	EDIT_5260	(-5260,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1011_14_DAY_INP_NA=[0], then at least one active item from M1011_14_DAY_INP1_ICD through M1011_14_DAY_INP6_ICD must not equal [^]."),
	EDIT_5270	(-5270,	Level.SEVERE, 	OasisEditTypeEN.CONSISTENCY, 	"2.11", "If M1011_14_DAY_INP_NA=[1], then all active items from M1011_14_DAY_INP1_ICD through M1011_14_DAY_INP6_ICD must equal [^]."),
	EDIT_9010	(-9010,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "Vendor's version number for the software that was used to create the OASIS data submission file."),
	EDIT_9020	(-9020,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "Valid federal tax ID (EIN) for the company that developed the software used to create the OASIS data submission file."),
	EDIT_9030	(-9030,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "Name of the software that was used to create the OASIS data submission file."),
	EDIT_9040	(-9040,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "Email address of the vendor who created the software that was used to produce the OASIS submission file."),
	EDIT_9050	(-9050,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "Any letters that are contained in this item may be submitted as lower case or upper case, but will be converted and stored as upper case by the ASAP system.  System reports will therefore display upper case values."),
	EDIT_9060	(-9060,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "CALCULATION OF EFFECTIVE DATE\n" + "a) If M0100_ASSMT_REASON=[01], then ASMT_EFF_DATE is equal to M0030_START_CARE_DT.\n" + "\n" + "b) If M0100_ASSMT_REASON=[03], then ASMT_EFF_DATE is equal to M0032_ROC_DT.\n" + "\n" + "c) If M0100_ASSMT_REASON=[04,05], then ASMT_EFF_DATE is equal to M0090_INFO_COMPLETED_DT.\n" + "\n" + "d) If M0100_ASSMT_REASON=[06,07,08,09], then ASMT_EFF_DATE is equal to  M0906_DC_TRAN_DTH_DT."),
	EDIT_9070	(-9070,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "VERSION CODE VALUES\n" + "The version code submitted should match one of the values listed in the \"Item Values\" table of the Detailed Data Specifications Report.  For example,  if the version number was 1.00.1, do not submit [1.00.1] or  [1.00.].  A value of [1.00] should be submitted instead."),
	EDIT_9080	(-9080,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "COMPLETION OF FOLLOW-UP ASSESSMENTS\n" + "The allowable completion dates for the first and any subsequent follow-up assessments will be calculated relative to the start of care date. Follow-up assessments must be completed every 60 days that a patient is under care. Each time a follow-up assessment is due, it should be completed on or after the 56th day and on or before the 60th day of the period.\n" + "\n" + "More formally, the rules can be stated as follows:\n" + "\n" + "-Let j be the follow-up period number (i.e., 1=first follow-up period, 2=second follow-up period, etc.).\n" + "\n" + "-Let SOC be the start of care date (M0030_START_CARE_DT).\n" + "\n" + "-Let FCD be the completion date (M0090_INFO_COMPLETED_DT) of a follow-up assessment.\n" + "\n" + "Given these symbols, the rule for completion of follow-up assessments is as follows:\n" + "\n" + "SOC + (60*j) - 5 <= FCD <= SOC + (60*j) - 1\n" + "\n" + "Where j=1, 2, 3, etc.\n" + "\n" + "If a patient is under care by a home health agency during one of the follow-up windows defined above, a follow-up assessment must be submitted. An exception to this rule can occur if a patient resumes care following an inpatient stay and if the resumption of care date (M0032_ROC_DT) falls within one of the follow-up windows. In this case, the home health agency should submit an RFA 03 resumption of care (after inpatient stay) (M0100_ASSMT_REASON=[03]) instead of the normal follow-up assessment.  Submission of such a resumption of care assessment fulfills the requirement for the follow-up assessment because it includes all of the data items contained in the normal follow-up assessment."),
	EDIT_9090	(-9090,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "This is an optional item that can be used by agency for unique identification of record and tracking of records submitted to the ASAP system."),
	EDIT_9100	(-9100,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "If a non-blank value for National Provider ID (NPI) in NATL_PRVDR_ID is submitted, it should represent the NPI of the parent agency, not of any branches if they have separate NPIs. The NPI that is submitted should be the one that is used on the agency's HIPAA billing transactions with CMS."),
	EDIT_9110	(-9110,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "If state law prohibits transmission of certain ICD codes (e.g., HIV or STD diagnoses), these codes will be removed by the ASAP system if found on records submitted by HHAs within that state.  If any item within an ICD list contains such a code on a submitted record, it will be removed from the list.  If any of these items is removed, but a valid code remains in a subsequent item on the list, the subsequent codes will be \"moved up\" so that no missing codes remain.  \n" + "\n" + "Therefore, if a non-blank value is required in an ICD code list and all of the submitted items in that list contain blank and/or prohibited codes, a fatal error will result and the record will be rejected.  As long as at least one item in such a list contains a non-blank, correctly-formatted, allowable code, a fatal error will not occur."),

	EDIT_9130	(-9130,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "If the agency is located in AS (American Samoa), GU (Guam), or MP (Saipan -- Northern Mariana Islands), then STATE_CD must equal [HI]."),
	EDIT_9140	(-9140,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "If the assessment was performed by a branch, then M0016_BRANCH_ID must contain a standard branch ID. It must contain numbers or uppercase letters in bytes 1 and 2, Q in byte 3, numbers or uppercase letters in bytes 4 through 7, and numbers in bytes 8 through 10."),
	EDIT_9150	(-9150,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "If an ICD list contains multiple codes, there should be no intervening items in the list which are equal to [^].  For example, if a 5-item list is populated with 3 ICD codes, those codes should occupy items 1, 2, and 3; items 4 and 5 should be equal to [^].\n" + "\n" + "If the ASAP system finds a list which contains intervening items which are equal to [^], the values that are later in the list will be moved up to eliminate the intervening blank [^] item values.  Diagnoses are only moved up within the same type of diagnosis, so a secondary diagnosis code will never be moved into an item which is for a primary diagnosis code."),
	EDIT_9160	(-9160,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "The Item Subset Code (ISC) is a two-character code that indicates the type of record that is being submitted.  The set of active items is controlled by the ISC.  The ISC is defined as follows:\n" + "\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [01]\n" + "      then ITM_SBST_CD = [01]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [03]\n" + "      then ITM_SBST_CD = [03]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [04]\n" + "      then ITM_SBST_CD = [04]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [05]\n" + "      then ITM_SBST_CD = [05]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [06]\n" + "      then ITM_SBST_CD = [06]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [07]\n" + "      then ITM_SBST_CD = [07]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [08]\n" + "      then ITM_SBST_CD = [08]\n" + "If TRANS_TYPE_CD = [1,2] and M0100_ASSMT_REASON = [09]\n" + "      then ITM_SBST_CD = [09]\n" + "If TRANS_TYPE_CD = [3] and M0100_ASSMT_REASON = [01-09] then ITM_SBST_CD = [XX]\n" + "\n" + "For a more complete explanation of the meaning and use of the ISC codes, please refer to the documentation that accompanies these data specifications."),
	EDIT_9170	(-9170,	Level.INFO, 	OasisEditTypeEN.INFORMATION, 	"2.11", "SUBMITTING ICD-10 DIAGNOSIS CODES\n" + "If the ICD-10 item is active, it must be submitted as an 8 character, fixed-format string with all blanks replaced with [^], and with a decimal point as the 4th character. The only exception to this rule is that an entirely blank ICD-10 item must be submitted as a single [^].\n" + "\n" + "For example:\n" + "-The ICD-10 code \"A12.\" would be submitted as [A12.^^^^].\n" + "-The ICD-10 code \"A12.3\" would be submitted as [A12.3^^^]. \n" + "-The ICD-10 code \"A12.34\" would be submitted as [A12.34^^].\n" + "-The ICD-10 code \"A12.345\" would be submitted as [A12.345^]\n" + "-The ICD-10 code \"A12.3456\" would be submitted as [A12.3456]\n" + "-An entirely blank ICD-10 code would be submitted as [^].");
	
	private int id;
    private String description;
    private OasisEditTypeEN type;
    private Level serverityLevel;
    private String versionActiveTo;

    private OasisEditsEN (int id, Level serverityLevel, OasisEditTypeEN type, String versionActiveTo, String description) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.serverityLevel = serverityLevel;
        this.versionActiveTo = versionActiveTo;
    }

    /**
     * Gets the id - this is different from the ordinal value
     *
     * @return The status's id, which may or may not be equivalent to the ordinal
     * value
     */
    public long getId() {
        return id;
    }

    /**
     * Gets the description
     *
     * @return The status's description - this can not be set externally
     */
    public String getDescription() {
        return description;
    }


    /**
     * gets the edit type
     * 
     * @return non-null String
     */
    public OasisEditTypeEN getType() {
		return type;
	}

	public Level getServerityLevel() {
		return serverityLevel;
	}
	
	public String getVersionActiveTo() {
		return versionActiveTo;
	}

	@Override
    public String toString() {
        return id + ", " + description + ", " + type.getName() + ", " + serverityLevel.getName();
    }

    /**
     * Given a description, returns the OasisValiationErrorEN. The comparison is
     * case insensitive.
     * 
     * @param description
     * @return if description is not null, and the description matches one of
     * the OasisValiationErrorEN, then the OasisValiationErrorEN, otherwise, null
     */
    public static OasisEditsEN getType(String description) {
        OasisEditsEN values[] = OasisEditsEN.values();

        if (description != null) {
            for (int idx = values.length - 1; idx >= 0; idx--) {
                if (description.equalsIgnoreCase(values[idx].getDescription())) {
                    return values[idx];
                }
            }
        }
        return null;
    }

    /**
     * Given an ID, returns the OasisValiationErrorEN. 
     * 
     * @param id
     * @return if id matches one of the OasisValiationErrorEN, then the 
     * OasisValiationErrorEN, otherwise, null
     */
    public static OasisEditsEN getType(int id) {
        OasisEditsEN values[] = OasisEditsEN.values();
        for (int idx = values.length - 1; idx >= 0; idx--) {
            if (values[idx].getId() == id) {
                return values[idx];
            }
        }
        return null;
    }
	
}
