/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.SeverityLimitValue;
import java.util.ArrayList;
import java.util.List;

public class HIPPSThreshold {
    private final String timingValue;
    private final int visitsUpperLimit;
    private final int groupingStep;
    private final int equation;
    private final List<SeverityLimitValue> severityLimitValues;

    public HIPPSThreshold(String timingValue, int visitsUpperLimit, int groupingStep, int equation) {
        this.timingValue = timingValue;
        this.visitsUpperLimit = visitsUpperLimit;
        this.groupingStep = groupingStep;
        this.equation = equation;
        this.severityLimitValues = new ArrayList<SeverityLimitValue>(3);
    }

    public void addSeverityLimit(int lowerLimit, int upperLimit, char hippsSeverityValue) {
        this.severityLimitValues.add(new SeverityLimitValue(lowerLimit, upperLimit, hippsSeverityValue));
    }

    public List<SeverityLimitValue> getSeverityLimits() {
        return this.severityLimitValues;
    }

    public String getTimingValue() {
        return this.timingValue;
    }

    public int getVisitsUpperLimit() {
        return this.visitsUpperLimit;
    }

    public int getGroupingStep() {
        return this.groupingStep;
    }

    public int getEquation() {
        return this.equation;
    }

    public char getHippsSeverityValue(int equationValue) {
        for (SeverityLimitValue limitValue : this.severityLimitValues) {
            if (equationValue < limitValue.getLowerLimit() || equationValue > limitValue.getUpperLimit()) continue;
            return limitValue.getHippsSeverityValue();
        }
        throw new IllegalArgumentException("Equation Value is not represented by this HIPPThreshold.  Equation value it out of range: " + equationValue);
    }
}

