/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.DataValidityFlag;
import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.hipps.HIPPSCode;
import com.mmm.cms.homehealth.proto.DataValidityFlagIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringStatus_EN;
import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.TreatmentAuthorizationIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import java.io.Serializable;
import java.util.Collection;

public class ScoringResults
implements ScoringResultsIF,
Serializable {
    private HIPPSCodeIF hippsCode;
    private String grouperVersion;
    private DataValidityFlagIF validityFlag;
    private TreatmentAuthorizationIF treatmentAuthorization;
    private HomeHealthRecordValidatorIF clinicalValidator;
    private HomeHealthRecordValidatorIF nrsValidator;
    private CollectionValidationEditsIF validationEdits;
    private Collection<HomeHealthEventIF> scoringEvents;
    private DiagnosisScoringStatus_EN[] diagnosisScoringStatus;
    private DiagnosisScoringStatus_EN[] nrsDiagnosisScoringStatus;
    private Exception exception;

    public ScoringResults() {
        this.hippsCode = new HIPPSCode();
        this.grouperVersion = "     ";
        this.validityFlag = new DataValidityFlag();
        this.treatmentAuthorization = new TreatmentAuthorization(null, null, null, null);
    }

    public ScoringResults(HomeHealthRecordIF record) {
        this.hippsCode = new HIPPSCode();
        this.grouperVersion = "     ";
        this.validityFlag = new DataValidityFlag();
        this.treatmentAuthorization = new TreatmentAuthorization(record, null, null, null);
    }

    public ScoringResults(HIPPSCodeIF hippsCode, String grouperVersion, DataValidityFlagIF dataValidityFlag, TreatmentAuthorizationIF treatmentAuthorization, HomeHealthRecordValidatorIF clinValidator, HomeHealthRecordValidatorIF nValidator) {
        this.hippsCode = hippsCode;
        this.grouperVersion = grouperVersion;
        this.validityFlag = dataValidityFlag != null ? dataValidityFlag : new DataValidityFlag();
        this.treatmentAuthorization = treatmentAuthorization;
        this.clinicalValidator = clinValidator;
        this.nrsValidator = nValidator;
    }

    public ScoringResults(CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventIF> events, HIPPSCodeIF hippsCode, String grouperVersion, DataValidityFlagIF dataValidityFlag, TreatmentAuthorizationIF treatmentAuthorization, DiagnosisScoringStatus_EN[] diagnosisScoringStatus, DiagnosisScoringStatus_EN[] nrsDiagnosisScoringStatus) {
        this(hippsCode, grouperVersion, dataValidityFlag, treatmentAuthorization, null, null);
        this.validationEdits = validationEdits;
        this.scoringEvents = events;
        this.diagnosisScoringStatus = diagnosisScoringStatus;
        this.nrsDiagnosisScoringStatus = nrsDiagnosisScoringStatus;
    }

    public ScoringResults(ScoringResultsIF scoringResults) {
        this(scoringResults.getHIPPSCode(), scoringResults.getGrouperVersion(), scoringResults.getValidityFlag(), scoringResults.getTreatmentAuthorization(), scoringResults.getClinicalValidator(), scoringResults.getNrsValidator());
    }

    @Override
    public HomeHealthRecordValidatorIF getNrsValidator() {
        return this.nrsValidator;
    }

    @Override
    public void setNrsValidator(HomeHealthRecordValidatorIF nrsValidator) {
        this.nrsValidator = nrsValidator;
    }

    @Override
    public DataValidityFlagIF getValidityFlag() {
        return this.validityFlag;
    }

    public void setValidityFlag(DataValidityFlagIF dataValidityFlag) {
        this.validityFlag = dataValidityFlag;
    }

    @Override
    public String getGrouperVersion() {
        return this.grouperVersion;
    }

    public void setGrouperVersion(String grouperVersion) {
        this.grouperVersion = grouperVersion;
    }

    @Override
    public HIPPSCodeIF getHIPPSCode() {
        return this.hippsCode;
    }

    public void setHIPPSCode(HIPPSCodeIF hippsCode) {
        this.hippsCode = hippsCode;
    }

    @Override
    public TreatmentAuthorizationIF getTreatmentAuthorization() {
        return this.treatmentAuthorization;
    }

    public void setTreatmentAuthorization(TreatmentAuthorizationIF treatmentAuthorization) {
        this.treatmentAuthorization = treatmentAuthorization;
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return this.clinicalValidator;
    }

    @Override
    public void setClinicalValidator(HomeHealthRecordValidatorIF validator) {
        this.clinicalValidator = validator;
    }

    @Override
    public DiagnosisScoringStatus_EN[] getDiagnosisScoringStatus() {
        return this.diagnosisScoringStatus;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public DiagnosisScoringStatus_EN[] getNrsDiagnosisScoringStatus() {
        return this.nrsDiagnosisScoringStatus;
    }

    @Override
    public Collection<HomeHealthEventIF> getScoringEvents() {
        return this.scoringEvents;
    }

    @Override
    public CollectionValidationEditsIF getValidationEdits() {
        return this.validationEdits;
    }

    @Override
    public void setDiagnosisScoringStatus(DiagnosisScoringStatus_EN[] diagnosisScoringStatus) {
        this.diagnosisScoringStatus = diagnosisScoringStatus;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void setNrsDiagnosisScoringStatus(DiagnosisScoringStatus_EN[] nrsDiagnosisScoringStatus) {
        this.nrsDiagnosisScoringStatus = nrsDiagnosisScoringStatus;
    }

    @Override
    public void setScoringEvents(Collection<HomeHealthEventIF> events) {
        this.scoringEvents = events;
    }

    @Override
    public void setValidationEdits(CollectionValidationEditsIF validationEdits) {
        this.validationEdits = validationEdits;
    }

    public String toString() {
        return "ScoringResults{hippsCode=" + this.hippsCode + ", grouperVersion=" + this.grouperVersion + ", validityFlag=" + this.validityFlag + ", treatmentAuthorization=" + this.treatmentAuthorization + ", clinicalValidator=" + this.clinicalValidator + ", nrsValidator=" + this.nrsValidator + ", validationEdits=" + this.validationEdits + ", scoringEvents=" + this.scoringEvents + ", diagnosisScoringStatus=" + this.diagnosisScoringStatus + ", nrsDiagnosisScoringStatus=" + this.nrsDiagnosisScoringStatus + ", exception=" + this.exception + '}';
    }
}

