/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.util.DateRanger;
import java.text.ParseException;

public abstract class AbstractRecordConverter
implements OasisRecordConverterIF {
    protected DateRanger dateRanger;
    private int recordLength;
    private String versionCDPrefix;

    public AbstractRecordConverter() {
        this("20070101", "20091231");
    }

    protected AbstractRecordConverter(String startDate, String endDate) {
        this(startDate, endDate, 1446);
    }

    protected AbstractRecordConverter(String startDate, String endDate, int recordLength) {
        this(startDate, endDate, recordLength, "B1");
    }

    protected AbstractRecordConverter(String startDate, String endDate, int recordLength, String versionCDPrefix) {
        this.dateRanger = new DateRanger(startDate, endDate);
        this.recordLength = recordLength;
        this.versionCDPrefix = versionCDPrefix;
    }

    @Override
    public StringBuilder convertFromHomeHealthRec(HomeHealthRecordIF oasisRecord) {
        return this.convertFromHomeHealthRecDelimeted(oasisRecord, "");
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum) throws ParseException {
        return this.convertToHomeHealthRec(strRecord, recNum, false);
    }

    public DateRanger getDateRanger() {
        return this.dateRanger;
    }

    public void setDateRanger(DateRanger dateRanger) {
        this.dateRanger = dateRanger;
    }

    @Override
    public void setEndDate(String date) {
        if (date != null && date.length() == 8) {
            this.dateRanger.setEndDate(date);
        }
    }

    @Override
    public void setStartDate(String date) {
        if (date != null && date.length() == 8) {
            this.dateRanger.setStartDate(date);
        }
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    @Override
    public boolean isRecordConvertable(String record) {
        boolean convertable = false;
        if (record.length() >= this.recordLength) {
            String versionCD = this.getVersionCD(record);
            String recordDate = this.getRecordDate(record);
            convertable = versionCD.length() >= 2 && versionCD.startsWith(this.versionCDPrefix) && this.dateRanger.isDateWithinRange(recordDate);
        }
        return convertable;
    }

    protected abstract String getRecordDate(String var1);

    protected abstract String getVersionCD(String var1);
}

