/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.io;

import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.io.OasisXmlHandler;
import com.mmm.cms.homehealth.io.record.Oasis_C_Record;
import com.mmm.cms.homehealth.io.util.Oasis_C_RecordUtil_v2_10;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.util.DateRanger;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OasisXMLConverter
implements OasisRecordConverterIF {
    public static final String TAG_ASSESSMENT = "ASSESSMENT";
    public static final String TAG_SPEC_VRSN_CD = "SPEC_VRSN_CD";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C = "2.10";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C1_2_10A = "02.00";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C1_2_10A_OTHER = "2.00";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C1_2_11 = "2.11";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C1_2_12 = "2.12";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C2_2_20 = "2.20";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_C2_2_21 = "2.21";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_D_2_30 = "2.30";
    public static final String TAG_SPEC_VRSN_CD_VALUE_OASIS_DEFAULT = "DEFAULT";
    public static final String TAG_ASMT_SYS_CD = "ASMT_SYS_CD";
    public static final String TAG_TRANS_TYPE_CD = "TRANS_TYPE_CD";
    public static final String TAG_ITM_SBST_CD = "ITM_SBST_CD";
    public static final String TAG_ITM_SET_VRSN_CD = "ITM_SET_VRSN_CD";
    protected DateRanger dateRanger;

    public OasisXMLConverter() {
        this(new ArrayList<HomeHealthRecordIF>());
    }

    public OasisXMLConverter(List<HomeHealthRecordIF> recordList) {
        this(recordList, "20120101", "20191231");
    }

    public OasisXMLConverter(List<HomeHealthRecordIF> recordList, String startDate, String endDate) {
        if (recordList == null) {
            throw new IllegalArgumentException("HomeHealthXMLHandler.init - parameter 'recordList' can not be null");
        }
        this.dateRanger = new DateRanger(startDate, endDate);
    }

    public int readWith(InputStream inputStream, OasisXmlHandler xmlHandler) {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(inputStream, (DefaultHandler)xmlHandler);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
        return xmlHandler.getRecords().size();
    }

    @Override
    public boolean isRecordConvertable(String record) {
        int idx;
        boolean convertable = false;
        if (record.contains("<?xml") && (idx = record.indexOf("M0090_INFO_COMPLETED_DT")) >= 0) {
            int nextAmpIdx;
            int endTagIdx = record.indexOf(">", idx) + 1;
            String date = record.substring(endTagIdx, nextAmpIdx = record.indexOf("<", endTagIdx)).trim();
            convertable = this.dateRanger.isDateWithinRange(date) && (this.isOasisC_Convertable(record) || this.isOasisC1_Convertable(record));
        }
        return convertable;
    }

    protected boolean isOasisC_Convertable(String record) {
        return record.contains("PRSR_ULCR_LNGTH");
    }

    protected boolean isOasisC1_Convertable(String record) {
        return !this.isOasisC_Convertable(record);
    }

    @Override
    public StringBuilder convertFromHomeHealthRec(HomeHealthRecordIF homeHealthRecord) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        buffer.append((CharSequence)this.convertFromHomeHealthToXmlRecord((HomeHealthRecord_C_IF)homeHealthRecord));
        return buffer;
    }

    @Override
    public StringBuilder convertFromHomeHealthRecDelimeted(HomeHealthRecordIF homeHealthRecord, String delimiter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum) throws ParseException {
        return this.convertToHomeHealthRec(strRecord, recNum, false);
    }

    @Override
    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum, boolean skipPassthru) throws ParseException {
        return this.convertToHomeHealthRec(strRecord, recNum, skipPassthru, null);
    }

    public HomeHealthRecordIF convertToHomeHealthRec(String strRecord, int recNum, boolean skipPassthru, OasisXmlHandler xmlHandler) throws ParseException {
        HomeHealthRecordIF record;
        if (xmlHandler == null) {
            xmlHandler = new OasisXmlHandler();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strRecord.getBytes());
        int count = this.readWith(inputStream, xmlHandler);
        switch (count) {
            case 1: {
                record = xmlHandler.getRecords().get(0);
                break;
            }
            case 0: {
                throw new ParseException("No record found", 0);
            }
            default: {
                throw new ParseException("Too many records in string: count = " + count, 0);
            }
        }
        if (record.getClass() == Oasis_C_Record.class) {
            Oasis_C_RecordUtil_v2_10.postProcessRecord(record);
        }
        if (record instanceof Oasis_C_Record) {
            HomeHealthRecordUtil.justifyOasisCValues((Oasis_C_Record)record);
        }
        return record;
    }

    public StringBuilder convertFromHomeHealthToXmlRecord(HomeHealthRecord_C_IF oasisRecord) {
        StringBuilder buffer = new StringBuilder(3000);
        buffer.append("<ASSESSMENT>").append("\n");
        buffer.append("  <ASMT_SYS_CD>OASIS</ASMT_SYS_CD>").append("\n");
        buffer.append("  <TRANS_TYPE_CD>1</TRANS_TYPE_CD>").append("\n");
        buffer.append("  <ITM_SBST_CD>01</ITM_SBST_CD>").append("\n");
        buffer.append("  <ITM_SET_VRSN_CD>C1-102014</ITM_SET_VRSN_CD>").append("\n");
        buffer.append("  <SPEC_VRSN_CD>2.11</SPEC_VRSN_CD>").append("\n");
        buffer.append("  <CORRECTION_NUM>").append("</CORRECTION_NUM>").append("\n");
        buffer.append("  <STATE_CD>").append("</STATE_CD>").append("\n");
        buffer.append("  <HHA_AGENCY_ID>").append("</HHA_AGENCY_ID>").append("\n");
        buffer.append("  <NATL_PRVDR_ID>").append("</NATL_PRVDR_ID>").append("\n");
        buffer.append("  <SFW_ID>").append("</SFW_ID>").append("\n");
        buffer.append("  <SFW_NAME>").append("</SFW_NAME>").append("\n");
        buffer.append("  <SFW_EMAIL_ADR>").append("</SFW_EMAIL_ADR>").append("\n");
        buffer.append("  <SFW_PROD_NAME>").append("</SFW_PROD_NAME>").append("\n");
        buffer.append("  <SFW_PROD_VRSN_CD>").append("</SFW_PROD_VRSN_CD>").append("\n");
        buffer.append("  <ACY_DOC_CD>").append("</ACY_DOC_CD>").append("\n");
        buffer.append("  <SUBM_HIPPS_CODE>").append("</SUBM_HIPPS_CODE>").append("\n");
        buffer.append("  <SUBM_HIPPS_VERSION>").append("</SUBM_HIPPS_VERSION>").append("\n");
        buffer.append("  <M0010_CCN>").append("</M0010_CCN>").append("\n");
        buffer.append("  <M0014_BRANCH_STATE>").append("</M0014_BRANCH_STATE>").append("\n");
        buffer.append("  <M0016_BRANCH_ID>").append("</M0016_BRANCH_ID>").append("\n");
        buffer.append("  <M0018_PHYSICIAN_ID>").append("</M0018_PHYSICIAN_ID>").append("\n");
        buffer.append("  <M0018_PHYSICIAN_UK>").append("</M0018_PHYSICIAN_UK>").append("\n");
        buffer.append("  <M0020_PAT_ID>").append("</M0020_PAT_ID>").append("\n");
        buffer.append("  <M0030_START_CARE_DT>");
        OasisCalendarFormatter.format(oasisRecord.getSTART_CARE_DT(), buffer).append("</M0030_START_CARE_DT>").append("\n");
        buffer.append("  <M0032_ROC_DT>").append("</M0032_ROC_DT>").append("\n");
        buffer.append("  <M0032_ROC_DT_NA>").append("</M0032_ROC_DT_NA>").append("\n");
        buffer.append("  <M0040_PAT_FNAME>").append("</M0040_PAT_FNAME>").append("\n");
        buffer.append("  <M0040_PAT_MI>").append("</M0040_PAT_MI>").append("\n");
        buffer.append("  <M0040_PAT_LNAME>").append("</M0040_PAT_LNAME>").append("\n");
        buffer.append("  <M0040_PAT_SUFFIX>").append("</M0040_PAT_SUFFIX>").append("\n");
        buffer.append("  <M0050_PAT_ST>").append("</M0050_PAT_ST>").append("\n");
        buffer.append("  <M0060_PAT_ZIP>").append("</M0060_PAT_ZIP>").append("\n");
        buffer.append("  <M0063_MEDICARE_NUM>").append("</M0063_MEDICARE_NUM>").append("\n");
        buffer.append("  <M0063_MEDICARE_NA>").append("</M0063_MEDICARE_NA>").append("\n");
        buffer.append("  <M0064_SSN>").append("</M0064_SSN>").append("\n");
        buffer.append("  <M0064_SSN_UK>").append("</M0064_SSN_UK>").append("\n");
        buffer.append("  <M0065_MEDICAID_NUM>").append("</M0065_MEDICAID_NUM>").append("\n");
        buffer.append("  <M0065_MEDICAID_NA>").append("</M0065_MEDICAID_NA>").append("\n");
        buffer.append("  <M0066_PAT_BIRTH_DT>").append("</M0066_PAT_BIRTH_DT>").append("\n");
        buffer.append("  <M0069_PAT_GENDER>").append("</M0069_PAT_GENDER>").append("\n");
        buffer.append("  <M0140_ETHNIC_AI_AN>").append("</M0140_ETHNIC_AI_AN>").append("\n");
        buffer.append("  <M0140_ETHNIC_ASIAN>").append("</M0140_ETHNIC_ASIAN>").append("\n");
        buffer.append("  <M0140_ETHNIC_BLACK>").append("</M0140_ETHNIC_BLACK>").append("\n");
        buffer.append("  <M0140_ETHNIC_HISP>").append("</M0140_ETHNIC_HISP>").append("\n");
        buffer.append("  <M0140_ETHNIC_NH_PI>").append("</M0140_ETHNIC_NH_PI>").append("\n");
        buffer.append("  <M0140_ETHNIC_WHITE>").append("</M0140_ETHNIC_WHITE>").append("\n");
        buffer.append("  <M0150_CPAY_NONE>").append("</M0150_CPAY_NONE>").append("\n");
        buffer.append("  <M0150_CPAY_MCARE_FFS>").append("</M0150_CPAY_MCARE_FFS>").append("\n");
        buffer.append("  <M0150_CPAY_MCARE_HMO>").append("</M0150_CPAY_MCARE_HMO>").append("\n");
        buffer.append("  <M0150_CPAY_MCAID_FFS>").append("</M0150_CPAY_MCAID_FFS>").append("\n");
        buffer.append("  <M0150_CPAY_MCAID_HMO>").append("</M0150_CPAY_MCAID_HMO>").append("\n");
        buffer.append("  <M0150_CPAY_WRKCOMP>").append("</M0150_CPAY_WRKCOMP>").append("\n");
        buffer.append("  <M0150_CPAY_TITLEPGMS>").append("</M0150_CPAY_TITLEPGMS>").append("\n");
        buffer.append("  <M0150_CPAY_OTH_GOVT>").append("</M0150_CPAY_OTH_GOVT>").append("\n");
        buffer.append("  <M0150_CPAY_PRIV_INS>").append("</M0150_CPAY_PRIV_INS>").append("\n");
        buffer.append("  <M0150_CPAY_PRIV_HMO>").append("</M0150_CPAY_PRIV_HMO>").append("\n");
        buffer.append("  <M0150_CPAY_SELFPAY>").append("</M0150_CPAY_SELFPAY>").append("\n");
        buffer.append("  <M0150_CPAY_OTHER>").append("</M0150_CPAY_OTHER>").append("\n");
        buffer.append("  <M0150_CPAY_UK>").append("</M0150_CPAY_UK>").append("\n");
        buffer.append("  <M0080_ASSESSOR_DISCIPLINE>").append("</M0080_ASSESSOR_DISCIPLINE>").append("\n");
        buffer.append("  <M0090_INFO_COMPLETED_DT>");
        OasisCalendarFormatter.format(oasisRecord.getINFO_COMPLETED_DT(), buffer).append("</M0090_INFO_COMPLETED_DT>").append("\n");
        buffer.append("  <M0100_ASSMT_REASON>").append(oasisRecord.getASSMT_REASON()).append("</M0100_ASSMT_REASON>").append("\n");
        buffer.append("  <M0102_PHYSN_ORDRD_SOCROC_DT>").append("</M0102_PHYSN_ORDRD_SOCROC_DT>").append("\n");
        buffer.append("  <M0102_PHYSN_ORDRD_SOCROC_DT_NA>").append("</M0102_PHYSN_ORDRD_SOCROC_DT_NA>").append("\n");
        buffer.append("  <M0104_PHYSN_RFRL_DT>").append("</M0104_PHYSN_RFRL_DT>").append("\n");
        buffer.append("  <M0110_EPISODE_TIMING>").append(oasisRecord.getEPISODE_TIMING()).append("</M0110_EPISODE_TIMING>").append("\n");
        buffer.append("  <M1000_DC_LTC_14_DA>").append("</M1000_DC_LTC_14_DA>").append("\n");
        buffer.append("  <M1000_DC_SNF_14_DA>").append("</M1000_DC_SNF_14_DA>").append("\n");
        buffer.append("  <M1000_DC_IPPS_14_DA>").append("</M1000_DC_IPPS_14_DA>").append("\n");
        buffer.append("  <M1000_DC_LTCH_14_DA>").append("</M1000_DC_LTCH_14_DA>").append("\n");
        buffer.append("  <M1000_DC_IRF_14_DA>").append("</M1000_DC_IRF_14_DA>").append("\n");
        buffer.append("  <M1000_DC_PSYCH_14_DA>").append("</M1000_DC_PSYCH_14_DA>").append("\n");
        buffer.append("  <M1000_DC_OTH_14_DA>").append("</M1000_DC_OTH_14_DA>").append("\n");
        buffer.append("  <M1000_DC_NONE_14_DA>").append("</M1000_DC_NONE_14_DA>").append("\n");
        buffer.append("  <M1005_INP_DISCHARGE_DT>").append("</M1005_INP_DISCHARGE_DT>").append("\n");
        buffer.append("  <M1005_INP_DSCHG_UNKNOWN>").append("</M1005_INP_DSCHG_UNKNOWN>").append("\n");
        buffer.append("  <M1018_PRIOR_UR_INCON>").append("</M1018_PRIOR_UR_INCON>").append("\n");
        buffer.append("  <M1018_PRIOR_CATH>").append("</M1018_PRIOR_CATH>").append("\n");
        buffer.append("  <M1018_PRIOR_INTRACT_PAIN>").append("</M1018_PRIOR_INTRACT_PAIN>").append("\n");
        buffer.append("  <M1018_PRIOR_IMPR_DECSN>").append("</M1018_PRIOR_IMPR_DECSN>").append("\n");
        buffer.append("  <M1018_PRIOR_DISRUPTIVE>").append("</M1018_PRIOR_DISRUPTIVE>").append("\n");
        buffer.append("  <M1018_PRIOR_MEM_LOSS>").append("</M1018_PRIOR_MEM_LOSS>").append("\n");
        buffer.append("  <M1018_PRIOR_NONE>").append("</M1018_PRIOR_NONE>").append("\n");
        buffer.append("  <M1018_PRIOR_NOCHG_14D>").append("</M1018_PRIOR_NOCHG_14D>").append("\n");
        buffer.append("  <M1018_PRIOR_UNKNOWN>").append("</M1018_PRIOR_UNKNOWN>").append("\n");
        buffer.append("  <M1030_THH_IV_INFUSION>").append(oasisRecord.getTHH_IV_INFUSION()).append("</M1030_THH_IV_INFUSION>").append("\n");
        buffer.append("  <M1030_THH_PAR_NUTRITION>").append(oasisRecord.getTHH_PAR_NUTRITION()).append("</M1030_THH_PAR_NUTRITION>").append("\n");
        buffer.append("  <M1030_THH_ENT_NUTRITION>").append(oasisRecord.getTHH_ENT_NUTRITION()).append("</M1030_THH_ENT_NUTRITION>").append("\n");
        buffer.append("  <M1030_THH_NONE_ABOVE>").append(oasisRecord.getTHH_NONE_ABOVE()).append("</M1030_THH_NONE_ABOVE>").append("\n");
        buffer.append("  <M1034_PTNT_OVRAL_STUS>").append("</M1034_PTNT_OVRAL_STUS>").append("\n");
        buffer.append("  <M1036_RSK_SMOKING>").append("</M1036_RSK_SMOKING>").append("\n");
        buffer.append("  <M1036_RSK_OBESITY>").append("</M1036_RSK_OBESITY>").append("\n");
        buffer.append("  <M1036_RSK_ALCOHOLISM>").append("</M1036_RSK_ALCOHOLISM>").append("\n");
        buffer.append("  <M1036_RSK_DRUGS>").append("</M1036_RSK_DRUGS>").append("\n");
        buffer.append("  <M1036_RSK_NONE>").append("</M1036_RSK_NONE>").append("\n");
        buffer.append("  <M1036_RSK_UNKNOWN>").append("</M1036_RSK_UNKNOWN>").append("\n");
        buffer.append("  <M1100_PTNT_LVG_STUTN>").append("</M1100_PTNT_LVG_STUTN>").append("\n");
        buffer.append("  <M1200_VISION>").append(oasisRecord.getVISION()).append("</M1200_VISION>").append("\n");
        buffer.append("  <M1210_HEARG_ABLTY>").append("</M1210_HEARG_ABLTY>").append("\n");
        buffer.append("  <M1220_UNDRSTG_VERBAL_CNTNT>").append("</M1220_UNDRSTG_VERBAL_CNTNT>").append("\n");
        buffer.append("  <M1230_SPEECH>").append("</M1230_SPEECH>").append("\n");
        buffer.append("  <M1240_FRML_PAIN_ASMT>").append("</M1240_FRML_PAIN_ASMT>").append("\n");
        buffer.append("  <M1242_PAIN_FREQ_ACTVTY_MVMT>").append(oasisRecord.getPAIN_FREQ_ACTVTY_MVMT()).append("</M1242_PAIN_FREQ_ACTVTY_MVMT>").append("\n");
        buffer.append("  <M1300_PRSR_ULCR_RISK_ASMT>").append("</M1300_PRSR_ULCR_RISK_ASMT>").append("\n");
        buffer.append("  <M1302_RISK_OF_PRSR_ULCR>").append("</M1302_RISK_OF_PRSR_ULCR>").append("\n");
        buffer.append("  <M1306_UNHLD_STG2_PRSR_ULCR>").append(oasisRecord.getUNHLD_STG2_PRSR_ULCR()).append("</M1306_UNHLD_STG2_PRSR_ULCR>").append("\n");
        buffer.append("  <M1307_OLDST_STG2_AT_DSCHRG>").append("</M1307_OLDST_STG2_AT_DSCHRG>").append("\n");
        buffer.append("  <M1307_OLDST_STG2_ONST_DT>").append("</M1307_OLDST_STG2_ONST_DT>").append("\n");
        buffer.append("  <M1311_NBR_PRSULC_STG2_A1>").append(oasisRecord.getNBR_PRSULC_STG2()).append("</M1311_NBR_PRSULC_STG2_A1>").append("\n");
        buffer.append("  <M1311_NBR_PRSULC_STG3_B1>").append(oasisRecord.getNBR_PRSULC_STG3()).append("</M1311_NBR_PRSULC_STG3_B1>").append("\n");
        buffer.append("  <M1311_NBR_PRSULC_STG4_C1>").append(oasisRecord.getNBR_PRSULC_STG4()).append("</M1311_NBR_PRSULC_STG4_C1>").append("\n");
        buffer.append("  <M1311_NSTG_DRSG_D1>").append(oasisRecord.getNSTG_DRSG()).append("</M1311_NSTG_DRSG_D1>").append("\n");
        buffer.append("  <M1311_NSTG_CVRG_E1>").append(oasisRecord.getNSTG_CVRG()).append("</M1311_NSTG_CVRG_E1>").append("\n");
        buffer.append("  <M1311_NSTG_DEEP_TSUE_F1>").append(oasisRecord.getNSTG_DEEP_TISUE()).append("</M1311_NSTG_DEEP_TSUE_F1>").append("\n");
        buffer.append("  <M1320_STUS_PRBLM_PRSR_ULCR>").append(oasisRecord.getSTUS_PRBLM_PRSR_ULCR()).append("</M1320_STUS_PRBLM_PRSR_ULCR>").append("\n");
        buffer.append("  <M1322_NBR_PRSULC_STG1>").append(oasisRecord.getNBR_PRSULC_STG1()).append("</M1322_NBR_PRSULC_STG1>").append("\n");
        buffer.append("  <M1324_STG_PRBLM_ULCER>").append(oasisRecord.getSTG_PRBLM_ULCER()).append("</M1324_STG_PRBLM_ULCER>").append("\n");
        buffer.append("  <M1330_STAS_ULCR_PRSNT>").append(oasisRecord.getSTAS_ULCR_PRSNT()).append("</M1330_STAS_ULCR_PRSNT>").append("\n");
        buffer.append("  <M1332_NBR_STAS_ULCR>").append(oasisRecord.getNBR_STAS_ULCR()).append("</M1332_NBR_STAS_ULCR>").append("\n");
        buffer.append("  <M1334_STUS_PRBLM_STAS_ULCR>").append(oasisRecord.getSTUS_PRBLM_STAS_ULCR()).append("</M1334_STUS_PRBLM_STAS_ULCR>").append("\n");
        buffer.append("  <M1340_SRGCL_WND_PRSNT>").append(oasisRecord.getSRGCL_WND_PRSNT()).append("</M1340_SRGCL_WND_PRSNT>").append("\n");
        buffer.append("  <M1342_STUS_PRBLM_SRGCL_WND>").append(oasisRecord.getSTUS_PRBLM_SRGCL_WND()).append("</M1342_STUS_PRBLM_SRGCL_WND>").append("\n");
        buffer.append("  <M1350_LESION_OPEN_WND>").append(oasisRecord.getLESION_OPEN_WND()).append("</M1350_LESION_OPEN_WND>").append("\n");
        buffer.append("  <M1400_WHEN_DYSPNEIC>").append(oasisRecord.getWHEN_DYSPNEIC()).append("</M1400_WHEN_DYSPNEIC>").append("\n");
        buffer.append("  <M1410_RESPTX_OXYGEN>").append("</M1410_RESPTX_OXYGEN>").append("\n");
        buffer.append("  <M1410_RESPTX_VENTILATOR>").append("</M1410_RESPTX_VENTILATOR>").append("\n");
        buffer.append("  <M1410_RESPTX_AIRPRESS>").append("</M1410_RESPTX_AIRPRESS>").append("\n");
        buffer.append("  <M1410_RESPTX_NONE>").append("</M1410_RESPTX_NONE>").append("\n");
        buffer.append("  <M1500_SYMTM_HRT_FAILR_PTNTS>").append("</M1500_SYMTM_HRT_FAILR_PTNTS>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_NO_ACTN>").append("</M1510_HRT_FAILR_NO_ACTN>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_PHYSN_CNTCT>").append("</M1510_HRT_FAILR_PHYSN_CNTCT>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_ER_TRTMT>").append("</M1510_HRT_FAILR_ER_TRTMT>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_PHYSN_TRTMT>").append("</M1510_HRT_FAILR_PHYSN_TRTMT>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_CLNCL_INTRVTN>").append("</M1510_HRT_FAILR_CLNCL_INTRVTN>").append("\n");
        buffer.append("  <M1510_HRT_FAILR_CARE_PLAN_CHG>").append("</M1510_HRT_FAILR_CARE_PLAN_CHG>").append("\n");
        buffer.append("  <M1600_UTI>").append("</M1600_UTI>").append("\n");
        buffer.append("  <M1610_UR_INCONT>").append(oasisRecord.getUR_INCONT()).append("</M1610_UR_INCONT>").append("\n");
        buffer.append("  <M1615_INCNTNT_TIMING>").append(oasisRecord.getINCNTNT_TIMING()).append("</M1615_INCNTNT_TIMING>").append("\n");
        buffer.append("  <M1620_BWL_INCONT>").append(oasisRecord.getBWL_INCONT()).append("</M1620_BWL_INCONT>").append("\n");
        buffer.append("  <M1630_OSTOMY>").append(oasisRecord.getOSTOMY()).append("</M1630_OSTOMY>").append("\n");
        buffer.append("  <M1700_COG_FUNCTION>").append("</M1700_COG_FUNCTION>").append("\n");
        buffer.append("  <M1710_WHEN_CONFUSED>").append("</M1710_WHEN_CONFUSED>").append("\n");
        buffer.append("  <M1720_WHEN_ANXIOUS>").append("</M1720_WHEN_ANXIOUS>").append("\n");
        buffer.append("  <M1730_STDZ_DPRSN_SCRNG>").append("</M1730_STDZ_DPRSN_SCRNG>").append("\n");
        buffer.append("  <M1730_PHQ2_LACK_INTRST>").append("</M1730_PHQ2_LACK_INTRST>").append("\n");
        buffer.append("  <M1730_PHQ2_DPRSN>").append("</M1730_PHQ2_DPRSN>").append("\n");
        buffer.append("  <M1740_BD_MEM_DEFICIT>").append("</M1740_BD_MEM_DEFICIT>").append("\n");
        buffer.append("  <M1740_BD_IMP_DECISN>").append("</M1740_BD_IMP_DECISN>").append("\n");
        buffer.append("  <M1740_BD_VERBAL>").append("</M1740_BD_VERBAL>").append("\n");
        buffer.append("  <M1740_BD_PHYSICAL>").append("</M1740_BD_PHYSICAL>").append("\n");
        buffer.append("  <M1740_BD_SOC_INAPPRO>").append("</M1740_BD_SOC_INAPPRO>").append("\n");
        buffer.append("  <M1740_BD_DELUSIONS>").append("</M1740_BD_DELUSIONS>").append("\n");
        buffer.append("  <M1740_BD_NONE>").append("</M1740_BD_NONE>").append("\n");
        buffer.append("  <M1745_BEH_PROB_FREQ>").append("</M1745_BEH_PROB_FREQ>").append("\n");
        buffer.append("  <M1750_REC_PSYCH_NURS>").append("</M1750_REC_PSYCH_NURS>").append("\n");
        buffer.append("  <M1800_CRNT_GROOMING>").append("</M1800_CRNT_GROOMING>").append("\n");
        buffer.append("  <M1810_CRNT_DRESS_UPPER>").append(oasisRecord.getCRNT_DRESS_UPPER()).append("</M1810_CRNT_DRESS_UPPER>").append("\n");
        buffer.append("  <M1820_CRNT_DRESS_LOWER>").append(oasisRecord.getCRNT_DRESS_LOWER()).append("</M1820_CRNT_DRESS_LOWER>").append("\n");
        buffer.append("  <M1830_CRNT_BATHG>").append(oasisRecord.getCRNT_BATHG()).append("</M1830_CRNT_BATHG>").append("\n");
        buffer.append("  <M1840_CRNT_TOILTG>").append(oasisRecord.getCRNT_TOILTG()).append("</M1840_CRNT_TOILTG>").append("\n");
        buffer.append("  <M1845_CRNT_TOILTG_HYGN>").append("</M1845_CRNT_TOILTG_HYGN>").append("\n");
        buffer.append("  <M1850_CRNT_TRNSFRNG>").append(oasisRecord.getCRNT_TRNSFRNG()).append("</M1850_CRNT_TRNSFRNG>").append("\n");
        buffer.append("  <M1860_CRNT_AMBLTN>").append(oasisRecord.getCRNT_AMBLTN()).append("</M1860_CRNT_AMBLTN>").append("\n");
        buffer.append("  <M1870_CRNT_FEEDING>").append("</M1870_CRNT_FEEDING>").append("\n");
        buffer.append("  <M1880_CRNT_PREP_LT_MEALS>").append("</M1880_CRNT_PREP_LT_MEALS>").append("\n");
        buffer.append("  <M1890_CRNT_PHONE_USE>").append("</M1890_CRNT_PHONE_USE>").append("\n");
        buffer.append("  <M1900_PRIOR_ADLIADL_SELF>").append("</M1900_PRIOR_ADLIADL_SELF>").append("\n");
        buffer.append("  <M1900_PRIOR_ADLIADL_AMBLTN>").append("</M1900_PRIOR_ADLIADL_AMBLTN>").append("\n");
        buffer.append("  <M1900_PRIOR_ADLIADL_TRNSFR>").append("</M1900_PRIOR_ADLIADL_TRNSFR>").append("\n");
        buffer.append("  <M1900_PRIOR_ADLIADL_HSEHOLD>").append("</M1900_PRIOR_ADLIADL_HSEHOLD>").append("\n");
        buffer.append("  <M1910_MLT_FCTR_FALL_RISK_ASMT>").append("</M1910_MLT_FCTR_FALL_RISK_ASMT>").append("\n");
        buffer.append("  <M2001_DRUG_RGMN_RVW>").append(oasisRecord.getDRUG_RGMN_RVW()).append("</M2001_DRUG_RGMN_RVW>").append("\n");
        buffer.append("  <M2002_MDCTN_FLWP>").append("</M2002_MDCTN_FLWP>").append("\n");
        buffer.append("  <M2004_MDCTN_INTRVTN>").append("</M2004_MDCTN_INTRVTN>").append("\n");
        buffer.append("  <M2010_HIGH_RISK_DRUG_EDCTN>").append("</M2010_HIGH_RISK_DRUG_EDCTN>").append("\n");
        buffer.append("  <M2015_DRUG_EDCTN_INTRVTN>").append("</M2015_DRUG_EDCTN_INTRVTN>").append("\n");
        buffer.append("  <M2020_CRNT_MGMT_ORAL_MDCTN>").append("</M2020_CRNT_MGMT_ORAL_MDCTN>").append("\n");
        buffer.append("  <M2030_CRNT_MGMT_INJCTN_MDCTN>").append(oasisRecord.getCRNT_MGMT_INJCTN_MDCTN()).append("</M2030_CRNT_MGMT_INJCTN_MDCTN>").append("\n");
        buffer.append("  <M2040_PRIOR_MGMT_ORAL_MDCTN>").append("</M2040_PRIOR_MGMT_ORAL_MDCTN>").append("\n");
        buffer.append("  <M2040_PRIOR_MGMT_INJCTN_MDCTN>").append("</M2040_PRIOR_MGMT_INJCTN_MDCTN>").append("\n");
        buffer.append("  <M2110_ADL_IADL_ASTNC_FREQ>").append("</M2110_ADL_IADL_ASTNC_FREQ>").append("\n");
        buffer.append("  <M2200_THER_NEED_NBR>").append(oasisRecord.getTHER_NEED_NBR()).append("</M2200_THER_NEED_NBR>").append("\n");
        buffer.append("  <M2200_THER_NEED_NA>").append(oasisRecord.getTHER_NEED_NA()).append("</M2200_THER_NEED_NA>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_PTNT_SPECF>").append("</M2250_PLAN_SMRY_PTNT_SPECF>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_DBTS_FT_CARE>").append("</M2250_PLAN_SMRY_DBTS_FT_CARE>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_FALL_PRVNT>").append("</M2250_PLAN_SMRY_FALL_PRVNT>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_DPRSN_INTRVTN>").append("</M2250_PLAN_SMRY_DPRSN_INTRVTN>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_PAIN_INTRVTN>").append("</M2250_PLAN_SMRY_PAIN_INTRVTN>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_PRSULC_PRVNT>").append("</M2250_PLAN_SMRY_PRSULC_PRVNT>").append("\n");
        buffer.append("  <M2250_PLAN_SMRY_PRSULC_TRTMT>").append("</M2250_PLAN_SMRY_PRSULC_TRTMT>").append("\n");
        buffer.append("  <M2300_EMER_USE_AFTR_LAST_ASMT>").append("</M2300_EMER_USE_AFTR_LAST_ASMT>").append("\n");
        buffer.append("  <M2310_ECR_MEDICATION>").append("</M2310_ECR_MEDICATION>").append("\n");
        buffer.append("  <M2310_ECR_INJRY_BY_FALL>").append("</M2310_ECR_INJRY_BY_FALL>").append("\n");
        buffer.append("  <M2310_ECR_RSPRTRY_INFCTN>").append("</M2310_ECR_RSPRTRY_INFCTN>").append("\n");
        buffer.append("  <M2310_ECR_RSPRTRY_OTHR>").append("</M2310_ECR_RSPRTRY_OTHR>").append("\n");
        buffer.append("  <M2310_ECR_HRT_FAILR>").append("</M2310_ECR_HRT_FAILR>").append("\n");
        buffer.append("  <M2310_ECR_CRDC_DSRTHM>").append("</M2310_ECR_CRDC_DSRTHM>").append("\n");
        buffer.append("  <M2310_ECR_MI_CHST_PAIN>").append("</M2310_ECR_MI_CHST_PAIN>").append("\n");
        buffer.append("  <M2310_ECR_OTHR_HRT_DEASE>").append("</M2310_ECR_OTHR_HRT_DEASE>").append("\n");
        buffer.append("  <M2310_ECR_STROKE_TIA>").append("</M2310_ECR_STROKE_TIA>").append("\n");
        buffer.append("  <M2310_ECR_HYPOGLYC>").append("</M2310_ECR_HYPOGLYC>").append("\n");
        buffer.append("  <M2310_ECR_GI_PRBLM>").append("</M2310_ECR_GI_PRBLM>").append("\n");
        buffer.append("  <M2310_ECR_DHYDRTN_MALNTR>").append("</M2310_ECR_DHYDRTN_MALNTR>").append("\n");
        buffer.append("  <M2310_ECR_UTI>").append("</M2310_ECR_UTI>").append("\n");
        buffer.append("  <M2310_ECR_CTHTR_CMPLCTN>").append("</M2310_ECR_CTHTR_CMPLCTN>").append("\n");
        buffer.append("  <M2310_ECR_WND_INFCTN_DTRORTN>").append("</M2310_ECR_WND_INFCTN_DTRORTN>").append("\n");
        buffer.append("  <M2310_ECR_UNCNTLD_PAIN>").append("</M2310_ECR_UNCNTLD_PAIN>").append("\n");
        buffer.append("  <M2310_ECR_MENTL_BHVRL_PRBLM>").append("</M2310_ECR_MENTL_BHVRL_PRBLM>").append("\n");
        buffer.append("  <M2310_ECR_DVT_PULMNRY>").append("</M2310_ECR_DVT_PULMNRY>").append("\n");
        buffer.append("  <M2310_ECR_OTHER>").append("</M2310_ECR_OTHER>").append("\n");
        buffer.append("  <M2310_ECR_UNKNOWN>").append("</M2310_ECR_UNKNOWN>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_DBTS_FT>").append("</M2400_INTRVTN_SMRY_DBTS_FT>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_FALL_PRVNT>").append("</M2400_INTRVTN_SMRY_FALL_PRVNT>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_DPRSN>").append("</M2400_INTRVTN_SMRY_DPRSN>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_PAIN_MNTR>").append("</M2400_INTRVTN_SMRY_PAIN_MNTR>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_PRSULC_PRVN>").append("</M2400_INTRVTN_SMRY_PRSULC_PRVN>").append("\n");
        buffer.append("  <M2400_INTRVTN_SMRY_PRSULC_WET>").append("</M2400_INTRVTN_SMRY_PRSULC_WET>").append("\n");
        buffer.append("  <M2410_INPAT_FACILITY>").append("</M2410_INPAT_FACILITY>").append("\n");
        buffer.append("  <M2420_DSCHRG_DISP>").append("</M2420_DSCHRG_DISP>").append("\n");
        buffer.append("  <M2430_HOSP_MED>").append("</M2430_HOSP_MED>").append("\n");
        buffer.append("  <M2430_HOSP_INJRY_BY_FALL>").append("</M2430_HOSP_INJRY_BY_FALL>").append("\n");
        buffer.append("  <M2430_HOSP_RSPRTRY_INFCTN>").append("</M2430_HOSP_RSPRTRY_INFCTN>").append("\n");
        buffer.append("  <M2430_HOSP_RSPRTRY_OTHR>").append("</M2430_HOSP_RSPRTRY_OTHR>").append("\n");
        buffer.append("  <M2430_HOSP_HRT_FAILR>").append("</M2430_HOSP_HRT_FAILR>").append("\n");
        buffer.append("  <M2430_HOSP_CRDC_DSRTHM>").append("</M2430_HOSP_CRDC_DSRTHM>").append("\n");
        buffer.append("  <M2430_HOSP_MI_CHST_PAIN>").append("</M2430_HOSP_MI_CHST_PAIN>").append("\n");
        buffer.append("  <M2430_HOSP_OTHR_HRT_DEASE>").append("</M2430_HOSP_OTHR_HRT_DEASE>").append("\n");
        buffer.append("  <M2430_HOSP_STROKE_TIA>").append("</M2430_HOSP_STROKE_TIA>").append("\n");
        buffer.append("  <M2430_HOSP_HYPOGLYC>").append("</M2430_HOSP_HYPOGLYC>").append("\n");
        buffer.append("  <M2430_HOSP_GI_PRBLM>").append("</M2430_HOSP_GI_PRBLM>").append("\n");
        buffer.append("  <M2430_HOSP_DHYDRTN_MALNTR>").append("</M2430_HOSP_DHYDRTN_MALNTR>").append("\n");
        buffer.append("  <M2430_HOSP_UR_TRACT>").append("</M2430_HOSP_UR_TRACT>").append("\n");
        buffer.append("  <M2430_HOSP_CTHTR_CMPLCTN>").append("</M2430_HOSP_CTHTR_CMPLCTN>").append("\n");
        buffer.append("  <M2430_HOSP_WND_INFCTN>").append("</M2430_HOSP_WND_INFCTN>").append("\n");
        buffer.append("  <M2430_HOSP_PAIN>").append("</M2430_HOSP_PAIN>").append("\n");
        buffer.append("  <M2430_HOSP_MENTL_BHVRL_PRBLM>").append("</M2430_HOSP_MENTL_BHVRL_PRBLM>").append("\n");
        buffer.append("  <M2430_HOSP_DVT_PULMNRY>").append("</M2430_HOSP_DVT_PULMNRY>").append("\n");
        buffer.append("  <M2430_HOSP_SCHLD_TRTMT>").append("</M2430_HOSP_SCHLD_TRTMT>").append("\n");
        buffer.append("  <M2430_HOSP_OTHER>").append("</M2430_HOSP_OTHER>").append("\n");
        buffer.append("  <M2430_HOSP_UK>").append("</M2430_HOSP_UK>").append("\n");
        buffer.append("  <M0903_LAST_HOME_VISIT>").append("</M0903_LAST_HOME_VISIT>").append("\n");
        buffer.append("  <M0906_DC_TRAN_DTH_DT>").append("</M0906_DC_TRAN_DTH_DT>").append("\n");
        buffer.append("  <CONTROL_ITEMS_FILLER>").append("</CONTROL_ITEMS_FILLER>").append("\n");
        buffer.append("  <M1011_14_DAY_INP1_ICD>").append("</M1011_14_DAY_INP1_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP2_ICD>").append("</M1011_14_DAY_INP2_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP3_ICD>").append("</M1011_14_DAY_INP3_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP4_ICD>").append("</M1011_14_DAY_INP4_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP5_ICD>").append("</M1011_14_DAY_INP5_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP6_ICD>").append("</M1011_14_DAY_INP6_ICD>").append("\n");
        buffer.append("  <M1011_14_DAY_INP_NA>").append("</M1011_14_DAY_INP_NA>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD1>").append("</M1017_CHGREG_ICD1>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD2>").append("</M1017_CHGREG_ICD2>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD3>").append("</M1017_CHGREG_ICD3>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD4>").append("</M1017_CHGREG_ICD4>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD5>").append("</M1017_CHGREG_ICD5>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD6>").append("</M1017_CHGREG_ICD6>").append("\n");
        buffer.append("  <M1017_CHGREG_ICD_NA>").append("</M1017_CHGREG_ICD_NA>").append("\n");
        buffer.append("  <M1021_PRIMARY_DIAG_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPRIMARY_DIAG_ICD())).append("</M1021_PRIMARY_DIAG_ICD>").append("\n");
        buffer.append("  <M1021_PRIMARY_DIAG_SEVERITY>").append("</M1021_PRIMARY_DIAG_SEVERITY>").append("\n");
        buffer.append("  <M1023_OTH_DIAG1_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG1_ICD())).append("</M1023_OTH_DIAG1_ICD>").append("\n");
        buffer.append("  <M1023_OTH_DIAG1_SEVERITY>").append("</M1023_OTH_DIAG1_SEVERITY>").append("\n");
        buffer.append("  <M1023_OTH_DIAG2_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG2_ICD())).append("</M1023_OTH_DIAG2_ICD>").append("\n");
        buffer.append("  <M1023_OTH_DIAG2_SEVERITY>").append("</M1023_OTH_DIAG2_SEVERITY>").append("\n");
        buffer.append("  <M1023_OTH_DIAG3_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG3_ICD())).append("</M1023_OTH_DIAG3_ICD>").append("\n");
        buffer.append("  <M1023_OTH_DIAG3_SEVERITY>").append("</M1023_OTH_DIAG3_SEVERITY>").append("\n");
        buffer.append("  <M1023_OTH_DIAG4_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG4_ICD())).append("</M1023_OTH_DIAG4_ICD>").append("\n");
        buffer.append("  <M1023_OTH_DIAG4_SEVERITY>").append("</M1023_OTH_DIAG4_SEVERITY>").append("\n");
        buffer.append("  <M1023_OTH_DIAG5_ICD>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getOTH_DIAG5_ICD())).append("</M1023_OTH_DIAG5_ICD>").append("\n");
        buffer.append("  <M1023_OTH_DIAG5_SEVERITY>").append("</M1023_OTH_DIAG5_SEVERITY>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_A3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A3())).append("</M1025_PMT_DIAG_ICD_A3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_A4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_A4())).append("</M1025_PMT_DIAG_ICD_A4>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_B3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B3())).append("</M1025_PMT_DIAG_ICD_B3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_B4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_B4())).append("</M1025_PMT_DIAG_ICD_B4>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_C3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C3())).append("</M1025_PMT_DIAG_ICD_C3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_C4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_C4())).append("</M1025_PMT_DIAG_ICD_C4>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_D3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D3())).append("</M1025_PMT_DIAG_ICD_D3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_D4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_D4())).append("</M1025_PMT_DIAG_ICD_D4>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_E3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E3())).append("</M1025_PMT_DIAG_ICD_E3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_E4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_E4())).append("</M1025_PMT_DIAG_ICD_E4>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_F3>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F3())).append("</M1025_PMT_DIAG_ICD_F3>").append("\n");
        buffer.append("  <M1025_PMT_DIAG_ICD_F4>").append(HomeHealthRecordUtil.formatDxCode_C1(oasisRecord.getPMT_DIAG_ICD_F4())).append("</M1025_PMT_DIAG_ICD_F4>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_HSTRY_FALLS>").append("</M1033_HOSP_RISK_HSTRY_FALLS>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_WEIGHT_LOSS>").append("</M1033_HOSP_RISK_WEIGHT_LOSS>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_MLTPL_HOSPZTN>").append("</M1033_HOSP_RISK_MLTPL_HOSPZTN>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_MLTPL_ED_VISIT>").append("</M1033_HOSP_RISK_MLTPL_ED_VISIT>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_MNTL_BHV_DCLN>").append("</M1033_HOSP_RISK_MNTL_BHV_DCLN>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_COMPLIANCE>").append("</M1033_HOSP_RISK_COMPLIANCE>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_6PLUS_MDCTN>").append("</M1033_HOSP_RISK_6PLUS_MDCTN>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_CURR_EXHSTN>").append("</M1033_HOSP_RISK_CURR_EXHSTN>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_OTHR>").append("</M1033_HOSP_RISK_OTHR>").append("\n");
        buffer.append("  <M1033_HOSP_RISK_NONE_ABOVE>").append("</M1033_HOSP_RISK_NONE_ABOVE>").append("\n");
        buffer.append("  <M1041_IN_INFLNZ_SEASON>").append("</M1041_IN_INFLNZ_SEASON>").append("\n");
        buffer.append("  <M1046_INFLNZ_RECD_CUR_SEASON>").append("</M1046_INFLNZ_RECD_CUR_SEASON>").append("\n");
        buffer.append("  <M1051_PPV_RCVD_AGNCY>").append("</M1051_PPV_RCVD_AGNCY>").append("\n");
        buffer.append("  <M1056_PPV_RSN_NOT_RCVD_AGNCY>").append("</M1056_PPV_RSN_NOT_RCVD_AGNCY>").append("\n");
        buffer.append("  <M1309_NBR_NEW_WRS_PRSULC_STG2>").append("</M1309_NBR_NEW_WRS_PRSULC_STG2>").append("\n");
        buffer.append("  <M1309_NBR_NEW_WRS_PRSULC_STG3>").append("</M1309_NBR_NEW_WRS_PRSULC_STG3>").append("\n");
        buffer.append("  <M1309_NBR_NEW_WRS_PRSULC_STG4>").append("</M1309_NBR_NEW_WRS_PRSULC_STG4>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_ADL>").append("</M2102_CARE_TYPE_SRC_ADL>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_IADL>").append("</M2102_CARE_TYPE_SRC_IADL>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_MDCTN>").append("</M2102_CARE_TYPE_SRC_MDCTN>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_PRCDR>").append("</M2102_CARE_TYPE_SRC_PRCDR>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_EQUIP>").append("</M2102_CARE_TYPE_SRC_EQUIP>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_SPRVSN>").append("</M2102_CARE_TYPE_SRC_SPRVSN>").append("\n");
        buffer.append("  <M2102_CARE_TYPE_SRC_ADVCY>").append("</M2102_CARE_TYPE_SRC_ADVCY>").append("\n");
        buffer.append("  <ASMT_ITEMS_FILLER>").append("</ASMT_ITEMS_FILLER>").append("\n");
        buffer.append("  <LEGACY_ITEMS_FILLER>").append("</LEGACY_ITEMS_FILLER>").append("\n");
        buffer.append("  <CALCULATED_ITEMS_FILLER>").append("</CALCULATED_ITEMS_FILLER>").append("\n");
        buffer.append("  <HHA_ASMT_INT_ID>").append("</HHA_ASMT_INT_ID>").append("\n");
        buffer.append("  <ORIG_ASMT_INT_ID>").append("</ORIG_ASMT_INT_ID>").append("\n");
        buffer.append("  <RES_INT_ID>").append("</RES_INT_ID>").append("\n");
        buffer.append("  <ASMT_EFF_DATE>").append("</ASMT_EFF_DATE>").append("\n");
        buffer.append("  <BRANCH_IDENTIFIER>").append("</BRANCH_IDENTIFIER>").append("\n");
        buffer.append("  <FAC_INT_ID>").append("</FAC_INT_ID>").append("\n");
        buffer.append("  <SUBMISSION_ID>").append("</SUBMISSION_ID>").append("\n");
        buffer.append("  <SUBMISSION_DATE>").append("</SUBMISSION_DATE>").append("\n");
        buffer.append("  <SUBMISSION_COMPLETE_DATE>").append("</SUBMISSION_COMPLETE_DATE>").append("\n");
        buffer.append("  <SUBMITTING_USER_ID>").append("</SUBMITTING_USER_ID>").append("\n");
        buffer.append("  <RES_MATCH_CRITERIA>").append("</RES_MATCH_CRITERIA>").append("\n");
        buffer.append("  <RESIDENT_AGE>").append("</RESIDENT_AGE>").append("\n");
        buffer.append("  <BIRTHDATE_SUBM_IND>").append("</BIRTHDATE_SUBM_IND>").append("\n");
        buffer.append("  <CALC_HIPPS_CODE>").append("</CALC_HIPPS_CODE>").append("\n");
        buffer.append("  <CALC_HIPPS_VERSION>").append("</CALC_HIPPS_VERSION>").append("\n");
        buffer.append("</ASSESSMENT>").append("\n");
        return buffer;
    }

    public String getStartDate() {
        return this.dateRanger.getStartDate();
    }

    public String getEndDate() {
        return this.dateRanger.getEndDate();
    }

    @Override
    public void setStartDate(String date) {
        this.dateRanger.setStartDate(date);
    }

    @Override
    public void setEndDate(String date) throws IllegalArgumentException {
        this.dateRanger.setEndDate(date);
    }
}

