/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.test;

import com.mmm.cms.homehealth.DataValidityFlag;
import com.mmm.cms.homehealth.ScoringEventCollector;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.EventId_EN;
import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperFactoryIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.ServiceIssueException;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.test.CommandLineParams;
import com.mmm.cms.homehealth.test.CommonTester;
import com.mmm.cms.homehealth.vut.CollectionValidationEdits_HhPpsOnly;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisDataItemIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisValidationEditIF;
import com.mmm.cms.util.HHEventConsole;
import com.mmm.cms.util.ScoringResultsFormatter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeHealthGrouper_HP
extends CommonTester {
    protected ScoringResultsIF scoringResultsEmpty;
    protected ScoringResultsIF scoringBLANK = new ScoringResults();

    public HomeHealthGrouper_HP() {
        this.scoringResultsEmpty = new ScoringResults();
    }

    public static void main(String[] args) {
        HomeHealthGrouper_HP tester = new HomeHealthGrouper_HP();
        tester.runTest(args);
    }

    @Override
    public void runTest(BufferedReader bufReader, Writer writer, HomeHealthGrouperFactoryIF grouperFactory, CommandLineParams commandLine) {
        long overallStarttime = System.currentTimeMillis();
        int recCount = this.scoreEachIndividually(bufReader, writer, grouperFactory, (GrouperTestParams)commandLine);
        long elapsedTime = System.currentTimeMillis() - overallStarttime;
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.INFO, "Records processed: {0}, Elapsed time: {1}, records/sec {2}", new Object[]{recCount, elapsedTime, elapsedTime > 0L ? (long)(recCount * 1000) / elapsedTime : (long)recCount});
    }

    public void calendarCompareTest() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd GGG hh:mm:ss");
        GregorianCalendar effectiveThruDate = new GregorianCalendar(2013, 11, 31);
        System.out.println("effectiveThruDate: " + dateFormat.format(effectiveThruDate.getTime()));
        GregorianCalendar effectiveStartDate = new GregorianCalendar(2013, 11, 31);
        System.out.println("effectiveStartDate: " + dateFormat.format(effectiveStartDate.getTime()));
        GregorianCalendar calendar3 = new GregorianCalendar();
        calendar3.set(2013, 11, 31, 0, 0, 0);
        calendar3.set(14, 0);
        System.out.println("Calendar 3: " + dateFormat.format(effectiveStartDate.getTime()));
        if (effectiveThruDate.after(effectiveStartDate)) {
            System.out.println("effectiveThruDate is after effectiveStartDate");
        } else if (effectiveStartDate.after(effectiveThruDate)) {
            System.out.println("effectiveStartDate is after effectiveThruDate");
        } else if (!effectiveThruDate.after(effectiveStartDate)) {
            System.out.println("effectiveThruDate is not after effectiveStartDate");
        }
        if (calendar3.before(effectiveStartDate)) {
            System.out.println("calendar3 is before effectiveStartDate");
        }
        if (calendar3.after(effectiveThruDate)) {
            System.out.println("calendar3 is after effectiveThruDate");
        }
        int compareValue = calendar3.compareTo(effectiveThruDate);
        System.out.println("calendar3 compared to effectiveThruDate = " + compareValue);
    }

    public int scoreEachIndividually(BufferedReader inReader, Writer outWriter, HomeHealthGrouperFactoryIF grouperFactory, GrouperTestParams commandLineParams) {
        int idx;
        block16: {
            ScoringResultsIF scoring;
            HomeHealthRecordIF record;
            block17: {
                block15: {
                    record = null;
                    idx = 1;
                    if (commandLineParams.getNumOfRecords() <= 0) break block15;
                    int recordLimit = commandLineParams.getNumOfRecords();
                    while (recordLimit-- > 0 && (record = this.readRecord(inReader, idx)) != this.recordEOF) {
                        if (record == null) {
                            scoring = this.scoringBLANK;
                        } else if (!this.isRecordIncludingCodes(record, commandLineParams.getSkipWithCodes())) {
                            scoring = this.scoreRecord(grouperFactory, record, false, commandLineParams);
                        } else {
                            ++recordLimit;
                            continue;
                        }
                        this.writeOutput(outWriter, scoring, idx++, commandLineParams);
                        this.displayEdits(commandLineParams, scoring, idx);
                    }
                    break block16;
                }
                if (commandLineParams.getDetailRecordNum() <= 0) break block17;
                int detailRecNum = commandLineParams.getDetailRecordNum();
                while (detailRecNum-- > 0 && (record = this.readRecord(inReader, idx)) != this.recordEOF) {
                    if (!this.isRecordIncludingCodes(record, commandLineParams.getSkipWithCodes())) continue;
                    ++detailRecNum;
                }
                if (record == this.recordEOF) break block16;
                scoring = record != null ? this.scoreRecord(grouperFactory, record, true, commandLineParams) : this.scoringBLANK;
                this.writeOutput(outWriter, scoring, idx++, commandLineParams);
                this.displayDetails(scoring, record);
                break block16;
            }
            if (commandLineParams.getFirstRecord() > 0) {
                int firstRecord = commandLineParams.getFirstRecord();
                int recsToScore = commandLineParams.getLastRecord() - firstRecord;
                while (firstRecord-- > 0 && (record = this.readRecord(inReader, idx++)) != this.recordEOF) {
                    if (!this.isRecordIncludingCodes(record, commandLineParams.getSkipWithCodes())) continue;
                    ++firstRecord;
                }
                if (record != this.recordEOF && record != null) {
                    int n;
                    idx = commandLineParams.getFirstRecord();
                    do {
                        if (!this.isRecordIncludingCodes(record, commandLineParams.getSkipWithCodes())) {
                            scoring = this.scoreRecord(grouperFactory, record, false, commandLineParams);
                            this.displayEdits(commandLineParams, scoring, idx);
                            this.writeOutput(outWriter, scoring, idx++, commandLineParams);
                        }
                        n = ++recsToScore;
                        --recsToScore;
                    } while (n > 0 && (record = this.readRecord(inReader, idx)) != this.recordEOF);
                }
                idx = commandLineParams.getLastRecord() - commandLineParams.getFirstRecord() + 1 - recsToScore;
            } else {
                while ((record = this.readRecord(inReader, idx)) != this.recordEOF) {
                    if (record == null) {
                        scoring = this.scoringBLANK;
                    } else {
                        if (this.isRecordIncludingCodes(record, commandLineParams.getSkipWithCodes())) continue;
                        scoring = this.scoreRecord(grouperFactory, record, false, commandLineParams);
                    }
                    this.writeOutput(outWriter, scoring, idx, commandLineParams);
                    this.displayEdits(commandLineParams, scoring, idx++);
                }
            }
        }
        return --idx;
    }

    public void writeOutput(Writer writer, ScoringResultsIF scoring, int curRecNum, GrouperTestParams commandLineParams) {
        try {
            writer.write(ScoringResultsFormatter.formatTestingScore(scoring, curRecNum, commandLineParams.isHideTAC(), commandLineParams.isHideVersion()));
            writer.write(System.getProperty("line.separator"));
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
    }

    public void writeOutput(Writer writer, HomeHealthRecordIF record, int curRecNum) {
        try {
            writer.write(ScoringResultsFormatter.formatRecordNumber(curRecNum, true));
            writer.write(": ");
            if (record == null) {
                System.out.println("Rec null");
            } else {
                writer.write(record.toString());
            }
            writer.write(System.getProperty("line.separator"));
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
        }
    }

    public void displayEdits(GrouperTestParams commandLineParams, ScoringResultsIF scoring, int recId) {
        block2: {
            StringBuilder buffer;
            block3: {
                if (!commandLineParams.isShowEdits()) break block2;
                CollectionValidationEditsIF edits = scoring.getValidationEdits();
                buffer = new StringBuilder(500);
                buffer.append("***** Edits for Rec: ");
                buffer.append(recId);
                buffer.append(" *****");
                buffer.append(System.getProperty("line.separator"));
                if (edits == null || edits.isEmpty()) break block3;
                for (OasisValidationEditIF edit : edits) {
                    OasisEditIF oasisEdit = edit.getEdit();
                    OasisDataItemIF dataItem = edit.getOasisDataItem();
                    buffer.append("  edit: ");
                    buffer.append(oasisEdit.getId());
                    buffer.append(", item: ");
                    buffer.append((String)dataItem.getKey());
                    buffer.append("='");
                    buffer.append((String)dataItem.getValue());
                    buffer.append("'");
                    buffer.append(", desc: ");
                    buffer.append(oasisEdit.getDescription());
                    System.out.println(buffer.toString());
                    buffer.setLength(0);
                }
                break block2;
            }
            Collection<HomeHealthEventIF> scoreEvents = scoring.getScoringEvents();
            if (scoreEvents == null) break block2;
            for (HomeHealthEventIF scoreEvent : scoreEvents) {
                if (scoreEvent.getEventId() != EventId_EN.VALIDATION_ISSUE) continue;
                buffer.append("  validation issue: ");
                buffer.append(scoreEvent.getMessage());
                System.out.println(buffer.toString());
                buffer.setLength(0);
            }
        }
    }

    public ScoringResultsIF scoreRecord(HomeHealthGrouperFactoryIF grouperFactory, HomeHealthRecordIF record, boolean showDetails, GrouperTestParams commandLineParams) {
        ScoringResultsIF scoring;
        ScoringEventCollector scoringEventCollector = null;
        try {
            HomeHealthGrouperIF grouper = grouperFactory.getGrouper(record);
            if (grouper == null) {
                scoring = this.scoringResultsEmpty;
            } else {
                String testVersion = commandLineParams.getTestVersion();
                if (testVersion == null || testVersion.isEmpty() || grouper.getVersion().compareToIgnoreCase(testVersion) <= 0) {
                    if (commandLineParams.isUseNewScoreMethod()) {
                        ArrayList<HomeHealthEventListenerIF> lisetners = null;
                        CollectionValidationEdits_HhPpsOnly validation = null;
                        if (showDetails) {
                            lisetners = new ArrayList<HomeHealthEventListenerIF>();
                            lisetners.add(new HHEventConsole());
                            if (grouper.getVersion().compareTo("V4115") < 0) {
                                scoringEventCollector = new ScoringEventCollector();
                                lisetners.add(scoringEventCollector);
                            }
                        }
                        if (commandLineParams.isTurnOffValidation()) {
                            validation = new CollectionValidationEdits_HhPpsOnly();
                        }
                        scoring = grouper.score(record, false, validation, lisetners);
                    } else {
                        scoringEventCollector = new ScoringEventCollector();
                        grouper.addEventListener(scoringEventCollector);
                        scoring = grouper.score(record, false);
                        grouper.removeEventListener(scoringEventCollector);
                    }
                    if (scoringEventCollector != null && !scoringEventCollector.getEvents().isEmpty()) {
                        scoring.setScoringEvents(scoringEventCollector.getEvents());
                    }
                } else {
                    scoring = this.scoringResultsEmpty;
                }
            }
        }
        catch (ServiceIssueException ex) {
            DataValidityFlag flag = new DataValidityFlag();
            flag.setServiceIssue(true);
            scoring = new ScoringResults(null, ex.getGrouper() != null ? ex.getGrouper().getVersion() : "", flag, null, null, null);
            Logger.getLogger(HomeHealthGrouper_HP.class.getName()).log(Level.SEVERE, null, ex);
        }
        return scoring;
    }

    private boolean isRecordIncludingCodes(HomeHealthRecordIF record, Map<String, String> codes) {
        boolean recIncludes = false;
        if (codes != null) {
            for (int idx = 0; idx < 18; ++idx) {
                DiagnosisCodeIF recCode = record.getDiagnosisCode(idx);
                if (recCode.isEmpty() || codes.get(recCode.getCode().trim()) == null) continue;
                recIncludes = true;
                break;
            }
        }
        return recIncludes;
    }

    public void displayDetails(ScoringResultsIF scoring, HomeHealthRecordIF record) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String newLine = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("ScoringResults{").append(newLine).append("\thippsCode=");
        buffer.append(scoring.getHIPPSCode());
        buffer.append(",").append(newLine).append("\tgrouperVersion=");
        buffer.append(scoring.getGrouperVersion());
        buffer.append(",").append(newLine).append("\tvalidityFlag=");
        buffer.append(scoring.getValidityFlag());
        buffer.append(",").append(newLine).append("\ttreatmentAuthorization=");
        buffer.append(scoring.getTreatmentAuthorization());
        buffer.append(",").append(newLine).append("\tclinicalValidator=");
        buffer.append(scoring.getClinicalValidator());
        buffer.append(",").append(newLine).append("\tnrsValidator=");
        buffer.append(scoring.getNrsValidator());
        buffer.append(",").append(newLine).append("\tvalidationEdits=");
        buffer.append(this.formatScoringEvents((Collection)scoring.getValidationEdits()));
        buffer.append(",").append(newLine).append("\tscoringEvents=");
        buffer.append(this.formatScoringEvents(scoring.getScoringEvents()));
        buffer.append(",").append(newLine).append("\tdiagnosisScoringStatus=");
        buffer.append(Arrays.toString(scoring.getDiagnosisScoringStatus()));
        buffer.append(",").append(newLine).append("\tnrsDiagnosisScoringStatus=");
        buffer.append(Arrays.toString(scoring.getNrsDiagnosisScoringStatus()));
        buffer.append(",").append(newLine).append("\texception=");
        buffer.append(scoring.getException());
        buffer.append("}").append(newLine);
        logger.log(Level.INFO, "HH-PPS: Score Details: {0}", buffer.toString());
    }

    public String formatScoringEvents(Collection events) {
        String newLine = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        if (events != null) {
            for (Object event : events) {
                buffer.append(event.toString());
                buffer.append(newLine);
            }
        }
        return buffer.toString();
    }

    @Override
    public CommandLineParams getCommandLineParams(String[] args) {
        return new GrouperTestParams(args);
    }

    class GrouperTestParams
    extends CommandLineParams {
        boolean useNewScoreMethod;
        boolean turnOffValidation;
        boolean showEdits;
        String testVersion;

        public GrouperTestParams(String[] args) {
            super(args);
        }

        @Override
        public void parseExtra(String[] nameValue) {
            if ("useNewScoreMethod".equalsIgnoreCase(nameValue[0])) {
                this.useNewScoreMethod = nameValue.length == 1 || "true".equalsIgnoreCase(nameValue[1]) || "T".equalsIgnoreCase(nameValue[1]) || "yes".equalsIgnoreCase(nameValue[1]) || "Y".equalsIgnoreCase(nameValue[1]);
            } else if ("turnOffValidation".equalsIgnoreCase(nameValue[0])) {
                this.turnOffValidation = nameValue.length == 1 || "true".equalsIgnoreCase(nameValue[1]) || "T".equalsIgnoreCase(nameValue[1]) || "yes".equalsIgnoreCase(nameValue[1]) || "Y".equalsIgnoreCase(nameValue[1]);
            } else if ("showEdits".equalsIgnoreCase(nameValue[0])) {
                this.showEdits = true;
            } else if ("testVersion".equalsIgnoreCase(nameValue[0])) {
                this.testVersion = nameValue[1];
            }
        }

        @Override
        public void validateParams() {
            super.validateParams();
            if (this.turnOffValidation && !this.useNewScoreMethod) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "'turnOffValidation' can only be used when 'useNewScoreMethod' is true.");
            }
        }

        public boolean isUseNewScoreMethod() {
            return this.useNewScoreMethod;
        }

        public boolean isTurnOffValidation() {
            return this.turnOffValidation;
        }

        public boolean isShowEdits() {
            return this.showEdits;
        }

        @Override
        public List<String> getCommandOptions() {
            List<String> options = super.getCommandOptions();
            if (super.isShowExtraOptions()) {
                options.add("useNewScoreMethod[=true/T/Yes/Y] If no equals or blank, assumed to be true.  Any other value is assumed false. Default = false.");
                options.add("turnOffValidation[=true/T/Yes/Y] If no equals or blank, assumed to be true.  Any other value is assumed false. Default = false.");
                options.add("showEdits - Not required.  Shows the edit items whenever the validity flag is not 1. Default = false.");
                options.add("testVersion - Not required.  The version number to test such as v4115. Default is to test all versions");
            }
            return options;
        }

        public String getTestVersion() {
            return this.testVersion;
        }
    }
}

