/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.test;

import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.test.OasisRecord_B_ReadWriteTest;
import com.mmm.cms.homehealth.v3210.GrouperVersion_v3210;
import com.mmm.cms.util.HHEventConsole;
import com.mmm.cms.util.IntegerFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeHealthGroupingTest {
    public static void main(String[] args) {
        String suffix = "_TESTOUT";
        List<HomeHealthRecordIF> oasisRecords = null;
        Properties props = null;
        int recordNumber = 0;
        Properties props2 = System.getProperties();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.println(key + "=" + props2.getProperty(key));
        }
        System.out.flush();
        if (args.length > 0) {
            long elapsedTime;
            long starttime;
            long overallStarttime = System.currentTimeMillis();
            String inputFilename = args[0];
            int idx = inputFilename.lastIndexOf(".");
            String outputFilename = idx > -1 ? inputFilename.substring(0, idx) + suffix + inputFilename.substring(idx) : inputFilename + suffix;
            props = new Properties();
            if (args.length > 1) {
                try {
                    File tmpfile = new File(args[1]);
                    props.load(new FileInputStream(tmpfile));
                }
                catch (IOException ex) {
                    Logger.getLogger(HomeHealthGrouperIF.class.getName()).log(Level.SEVERE, "HH-PPS: Could not open properties file: " + args[1], ex);
                }
            }
            if (args.length > 2) {
                recordNumber = Integer.parseInt(args[2]);
            }
            System.out.println("Input file is: " + inputFilename);
            System.out.println("Output file is: " + outputFilename);
            OasisRecord_B_ReadWriteTest tester = new OasisRecord_B_ReadWriteTest();
            HomeHealthGroupingTest groupingTester = new HomeHealthGroupingTest();
            GrouperVersion_v3210 grouper = new GrouperVersion_v3210();
            try {
                starttime = System.currentTimeMillis();
                oasisRecords = tester.readConvertTest(new File(inputFilename));
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Oasis Records read: " + oasisRecords.size() + ", elapsed time: " + elapsedTime);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(HomeHealthGrouperIF.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest", ex);
                System.out.println("During ReadTest: " + ex);
                System.exit(2);
            }
            catch (IOException ex) {
                Logger.getLogger(HomeHealthGrouperIF.class.getName()).log(Level.SEVERE, "HH-PPS: During ReadTest", ex);
                System.out.println("During ReadTest: " + ex);
                System.exit(3);
            }
            try {
                starttime = System.currentTimeMillis();
                List<ScoringResultsIF> scoringResults = groupingTester.groupingTest(grouper, oasisRecords, props, recordNumber);
                elapsedTime = System.currentTimeMillis() - starttime;
                System.out.println("Number of Oasis Records scored: " + scoringResults.size() + ", elapsed time: " + elapsedTime);
                groupingTester.writeOutputFile(scoringResults, new File(outputFilename));
            }
            catch (Exception ex) {
                Logger.getLogger(HomeHealthGrouperIF.class.getName()).log(Level.SEVERE, "HH-PPS: Validation Test", ex);
                System.out.println("Grouping test could not complete due to: " + ex);
                ex.printStackTrace();
            }
            elapsedTime = System.currentTimeMillis() - overallStarttime;
            System.out.println();
            System.out.println("Total processing elapsed time: " + elapsedTime);
        } else {
            System.out.println("Syntax: HomeHealthGroupingTest \"nput file name\" <output file name - optional>");
        }
    }

    public List<ScoringResultsIF> groupingTest(HomeHealthGrouperIF grouper, List<HomeHealthRecordIF> oasisRecords, Properties grouperProperties, int recordNumber) throws Exception {
        int idx = 0;
        Level tmpLevel = null;
        ConsoleHandler consoleHandler = null;
        Logger logger = null;
        HHEventConsole listener = null;
        if (grouperProperties != null) {
            grouper.init(grouperProperties);
        }
        ArrayList<ScoringResultsIF> scoringResults = new ArrayList<ScoringResultsIF>(oasisRecords.size());
        for (HomeHealthRecordIF record : oasisRecords) {
            if (++idx == recordNumber) {
                System.out.println("record " + idx);
                System.out.flush();
                listener = new HHEventConsole();
                grouper.addEventListener(listener);
                consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.FINE);
                logger = Logger.getLogger(this.getClass().getName());
                tmpLevel = logger.getLevel();
                logger.setLevel(Level.FINE);
                logger.addHandler(consoleHandler);
            }
            ScoringResultsIF scoring = grouper.score(record, true);
            scoringResults.add(scoring);
            if (logger == null) continue;
            logger.removeHandler(consoleHandler);
            logger.setLevel(tmpLevel);
            System.err.flush();
            logger = null;
            grouper.removeEventListener(listener);
            listener = null;
        }
        return scoringResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutputFile(List<ScoringResultsIF> scoringResults, File output) throws IOException {
        long starttime = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder();
        FileWriter fileWriter = new FileWriter(output);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        IntegerFormat iformat = new IntegerFormat('0');
        iformat.setMinimumIntegerDigits(6);
        iformat.setMaximumIntegerDigits(6);
        try {
            int idx = 1;
            for (ScoringResultsIF scoringResult : scoringResults) {
                buffer.setLength(0);
                buffer.append("Record ");
                buffer.append(iformat.format(idx++));
                buffer.append(": Code ");
                if (scoringResult.getHIPPSCode() != null) {
                    buffer.append(scoringResult.getHIPPSCode().getCode());
                    buffer.append("--OASIS ");
                } else {
                    buffer.append("     ");
                }
                if (scoringResult.getHIPPSCode() != null && !scoringResult.getHIPPSCode().getCode().trim().isEmpty()) {
                    buffer.append(scoringResult.getTreatmentAuthorization().getAuthorizationCode());
                } else {
                    buffer.append("                  ");
                }
                buffer.append("--Version ");
                buffer.append(scoringResult.getGrouperVersion());
                buffer.append(" --Flag ");
                buffer.append(scoringResult.getValidityFlag().getValidityFlag());
                buffer.append("\r\n");
                writer.write(buffer.toString());
            }
        }
        finally {
            writer.close();
            long elapsedTime = System.currentTimeMillis() - starttime;
            System.out.println("Records written: elapsed time: " + elapsedTime);
        }
    }
}

