/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v2308_1;

import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.util.HomeHealthUtils;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class ClinicalFunctional_ScoringModel_v2308
implements HomeHealthScoringModelIF {
    private GrouperDataManager grouperDataManager;
    private int id;
    private HomeHealthGrouperIF grouper;
    private transient CaseMixAdjustmentItemIF lastCaseMix = null;

    public ClinicalFunctional_ScoringModel_v2308(HomeHealthGrouperIF grouper, GrouperDataManager grouperDataManager, int equationId) {
        this.grouper = grouper;
        this.grouperDataManager = grouperDataManager;
        this.id = equationId;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        ScoringPoints points = new ScoringPoints(2);
        points.setScoreAt(0, this.scoreClinical(record, validator));
        points.setScoreAt(1, this.scoreFunctional(record, validator));
        return points;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        return this.score(record, validator);
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        return this.score(record, validator);
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int[] calculateInitialScore(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void determinePrimaryDiagnosis(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePoints) {
        DiagnosisCodeIF M0230_PRIMARY_DIAG_ICD = record.getPRIMARY_DIAG_ICD();
        DiagnosisCodeIF M0240_OTH_DIAG1_ICD = record.getOTH_DIAG1_ICD();
        DiagnosisCodeIF M0246_PMT_DIAG_ICD_A3 = record.getPMT_DIAG_ICD_A3();
        DiagnosisCodeIF M0246_PMT_DIAG_ICD_A4 = record.getPMT_DIAG_ICD_A4();
        M0230_PRIMARY_DIAG_ICD.setPrimary(false);
        M0240_OTH_DIAG1_ICD.setPrimary(false);
        M0246_PMT_DIAG_ICD_A3.setPrimary(false);
        M0246_PMT_DIAG_ICD_A4.setPrimary(false);
        if (M0246_PMT_DIAG_ICD_A4.isValidForScoring() && M0246_PMT_DIAG_ICD_A4.isSecondaryOnly()) {
            if (M0246_PMT_DIAG_ICD_A3.isValidCode()) {
                if (M0246_PMT_DIAG_ICD_A4.getDiagnosticGroup().getId() == M0246_PMT_DIAG_ICD_A3.getDiagnosticGroup().getId()) {
                    M0246_PMT_DIAG_ICD_A3.setPrimary(true);
                } else if (codePoints[12] > codePoints[6]) {
                    M0246_PMT_DIAG_ICD_A4.setPrimary(true);
                } else {
                    M0246_PMT_DIAG_ICD_A3.setPrimary(true);
                }
            } else {
                M0246_PMT_DIAG_ICD_A4.setPrimary(true);
            }
        } else if (M0246_PMT_DIAG_ICD_A3.isValidForScoring()) {
            M0246_PMT_DIAG_ICD_A3.setPrimary(true);
        } else if (M0240_OTH_DIAG1_ICD.isSecondaryOnly()) {
            if (M0230_PRIMARY_DIAG_ICD.isValidCode()) {
                if (M0230_PRIMARY_DIAG_ICD.getDiagnosticGroup().getId() == M0240_OTH_DIAG1_ICD.getDiagnosticGroup().getId()) {
                    M0230_PRIMARY_DIAG_ICD.setPrimary(true);
                } else if (codePoints[1] > codePoints[0]) {
                    M0240_OTH_DIAG1_ICD.setPrimary(true);
                } else {
                    M0230_PRIMARY_DIAG_ICD.setPrimary(true);
                }
            } else {
                M0240_OTH_DIAG1_ICD.setPrimary(true);
            }
        } else {
            M0230_PRIMARY_DIAG_ICD.setPrimary(true);
        }
    }

    public boolean[] resolveEtiologyManifestationContention(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePointsSE, boolean[] diagGroupsUsed) {
        int diagIdx;
        int groupId;
        boolean[] pointsLost = new boolean[18];
        DiagnosisCodeIF code = record.getDiagnosisCode(0);
        int n = groupId = code.getDiagnosticGroup() != null ? code.getDiagnosticGroup().getId() : 0;
        if (groupId > 0 && codePointsSE[0] > 0) {
            diagGroupsUsed[groupId - 1] = true;
        }
        int n2 = groupId = (code = record.getDiagnosisCode(6)).getDiagnosticGroup() != null ? code.getDiagnosticGroup().getId() : 0;
        if (groupId > 0 && codePointsSE[6] > 0) {
            if (diagGroupsUsed[groupId - 1]) {
                codePointsSE[6] = 0;
                ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[6] reset to 0");
            } else if (codePointsSE[6] > 0) {
                diagGroupsUsed[groupId - 1] = true;
            }
        }
        int n3 = groupId = (code = record.getDiagnosisCode(12)).getDiagnosticGroup() != null ? code.getDiagnosticGroup().getId() : 0;
        if (groupId > 0 && codePointsSE[12] > 0) {
            if (diagGroupsUsed[groupId - 1]) {
                codePointsSE[12] = 0;
                ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[12] reset to 0");
            } else {
                if (code.isSecondaryOnly() && codePointsSE[6] > 0) {
                    if (codePointsSE[12] > codePointsSE[6]) {
                        codePointsSE[6] = 0;
                        pointsLost[6] = true;
                        ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[6] reset to 0 due to codePointsSE[12] > codePointsSE[6]");
                    } else {
                        codePointsSE[12] = 0;
                        ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[12] reset to 0 due to codePointsSE[12] <= codePointsSE[6]");
                    }
                }
                if (codePointsSE[12] > 0) {
                    diagGroupsUsed[groupId - 1] = true;
                }
            }
        }
        for (diagIdx = 1; diagIdx < 6; ++diagIdx) {
            code = record.getDiagnosisCode(diagIdx);
            if (!code.isValidForScoring()) continue;
            int n4 = groupId = code.getDiagnosticGroup() != null ? code.getDiagnosticGroup().getId() : 0;
            if (groupId <= 0 || codePointsSE[diagIdx] <= 0) continue;
            if (diagGroupsUsed[groupId - 1]) {
                codePointsSE[diagIdx] = 0;
                ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[" + diagIdx + "] reset to 0 for diagnosis position " + (diagIdx + 1));
                continue;
            }
            if (code.isSecondaryOnly() && codePointsSE[diagIdx - 1] > 0) {
                if (codePointsSE[diagIdx] > codePointsSE[diagIdx - 1]) {
                    codePointsSE[diagIdx - 1] = 0;
                    pointsLost[diagIdx - 1] = true;
                    ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[" + (diagIdx - 1) + "] reset to 0 for secondary diagnosis position " + (diagIdx + 1));
                } else {
                    codePointsSE[diagIdx] = 0;
                    ScoringEventFormatter.fireScoringGeneral(null, this.grouper, this, "codePointsSE[" + diagIdx + "] reset to 0 for secondary diagnosis position " + (diagIdx + 1));
                }
            }
            if (codePointsSE[diagIdx] <= 0) continue;
            diagGroupsUsed[groupId - 1] = true;
        }
        for (diagIdx = 7; diagIdx < 12; ++diagIdx) {
            code = record.getDiagnosisCode(diagIdx);
            if (!code.isValidForScoring() || (groupId = code.getDiagnosticGroup().getId()) <= 0 || codePointsSE[diagIdx] <= 0) continue;
            if (diagGroupsUsed[groupId - 1]) {
                codePointsSE[diagIdx] = 0;
                continue;
            }
            if (codePointsSE[diagIdx] <= 0) continue;
            diagGroupsUsed[groupId - 1] = true;
        }
        for (diagIdx = 13; diagIdx < 18; ++diagIdx) {
            code = record.getDiagnosisCode(diagIdx);
            if (!code.isValidForScoring()) continue;
            groupId = code.getDiagnosticGroup().getId();
            if (groupId > 0 && diagGroupsUsed[groupId - 1]) {
                codePointsSE[diagIdx] = 0;
            } else if (code.isSecondaryOnly() && codePointsSE[diagIdx - 6] > 0) {
                if (codePointsSE[diagIdx] > codePointsSE[diagIdx - 6]) {
                    codePointsSE[diagIdx - 6] = 0;
                    pointsLost[diagIdx - 6] = true;
                } else {
                    codePointsSE[diagIdx] = 0;
                }
            } else if (!record.getDiagnosisCode(diagIdx - 6).isValidCode()) {
                codePointsSE[diagIdx] = 0;
            }
            if (codePointsSE[diagIdx] <= 0) continue;
            diagGroupsUsed[groupId - 1] = true;
        }
        return pointsLost;
    }

    public void recalculateNonPrimaryCodes(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] codePoints, int[] dualPointsSE) {
        block5: for (int idx = 0; idx < 18; ++idx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(idx);
            if (!diagCode.isValidForScoring()) continue;
            int groupId = diagCode.getDiagnosticGroup().getId();
            if (diagCode.isPrimary()) continue;
            switch (groupId) {
                case 4: {
                    codePoints[idx] = this.getCaseMixAdjustmentEquation(5, this.id);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 5, codePoints[idx]);
                    continue block5;
                }
                case 10: {
                    int n = idx;
                    codePoints[n] = codePoints[n] - this.getCaseMixAdjustmentEquation(12, this.id);
                    ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "For Diagnosis Group 10 - reduced value by from row 12 by " + this.getCaseMixAdjustmentEquation(12, this.id));
                    continue block5;
                }
                case 19: {
                    int n = idx;
                    codePoints[n] = codePoints[n] - this.getCaseMixAdjustmentEquation(25, this.id);
                    ScoringEventFormatter.fireScoringGeneral(this.grouper.getEventListenersList(), this.grouper, this, "For Diagnosis Group 19 - reduced value by from row 25 by " + this.getCaseMixAdjustmentEquation(25, this.id));
                    int tmpScore = this.getCaseMixAdjustmentEquation(26, this.id);
                    int n2 = idx;
                    codePoints[n2] = codePoints[n2] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 26, tmpScore);
                    continue block5;
                }
            }
        }
    }

    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[] points) {
        String tmpStr;
        int tmpScore;
        int score = 0;
        if (validator.isINTERNAL_LOGIC_Valid() && validator.isTHERAPIES_Valid()) {
            if ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION())) {
                tmpScore = this.getCaseMixAdjustmentEquation(31, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to THH_IV_INFUSION or THH_PAR_NUTRITION ", 31, tmpScore);
            }
            if ("1".equals(record.getTHH_ENT_NUTRITION())) {
                tmpScore = this.getCaseMixAdjustmentEquation(32, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to THH_ENT_NUTRITION", 32, tmpScore);
            }
        }
        if (ValidateUtils.isValidValue(record.getVISION(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(33, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to VISION", 33, tmpScore);
        }
        if (ValidateUtils.isValidValue(record.getPAIN_FREQ_ACTVTY_MVMT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(34, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to FREQ_PAIN", 34, tmpScore);
        }
        if (validator.isNPRSULC3_Valid() && validator.isNPRSULC4_Valid()) {
            int tmpInt2;
            int tmpInt1;
            tmpStr = record.getNBR_PRSULC_STG3();
            if (tmpStr != null && !tmpStr.trim().isEmpty()) {
                try {
                    tmpInt1 = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    tmpInt1 = 0;
                }
            } else {
                tmpInt1 = 0;
            }
            if ((tmpStr = record.getNBR_PRSULC_STG4()) != null && !tmpStr.trim().isEmpty()) {
                try {
                    tmpInt2 = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    tmpInt2 = 0;
                }
            } else {
                tmpInt2 = 0;
            }
            if (tmpInt1 + tmpInt2 >= 2) {
                tmpScore = this.getCaseMixAdjustmentEquation(35, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to NBR_PRSULC_STG3 + NBR_PRSULC_STG4", 35, tmpScore);
            }
        }
        if (validator.isSTGPRSUL_Valid()) {
            if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                tmpScore = this.getCaseMixAdjustmentEquation(36, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STG_PRBLM_ULCER", 36, tmpScore);
            } else if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR})) {
                tmpScore = this.getCaseMixAdjustmentEquation(37, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STG_PRBLM_ULCER", 37, tmpScore);
            }
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpStr = record.getSTUS_PRBLM_STAS_ULCR();
            if (tmpStr.equals("02")) {
                tmpScore = this.getCaseMixAdjustmentEquation(38, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 38, tmpScore);
            } else if (tmpStr.equals("03")) {
                tmpScore = this.getCaseMixAdjustmentEquation(39, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_STASULC", 39, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpStr = record.getSTUS_PRBLM_SRGCL_WND();
            if (tmpStr.equals("02")) {
                tmpScore = this.getCaseMixAdjustmentEquation(40, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 40, tmpScore);
            } else if (tmpStr.equals("03")) {
                tmpScore = this.getCaseMixAdjustmentEquation(41, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to STAT_PRB_SURGWND", 41, tmpScore);
            }
        }
        if (validator.isDYSPNEIC_Valid() && ValidateUtils.isValidValue(record.getWHEN_DYSPNEIC(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
            tmpScore = this.getCaseMixAdjustmentEquation(42, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to WHEN_DYSPNEIC", 42, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ValidateUtils.isValidValue(record.getBWL_INCONT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            tmpScore = this.getCaseMixAdjustmentEquation(43, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to BWL_INCONT", 43, tmpScore);
        }
        if (validator.isOSTOMY_Valid() && ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(44, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to OSTOMY", 44, tmpScore);
        }
        if (validator.isCUR_INJECT_MEDS_Valid() && ValidateUtils.isValidValue(record.getCRNT_MGMT_INJCTN_MDCTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            tmpScore = this.getCaseMixAdjustmentEquation(45, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "score added due to CUR_INJECT_MEDS", 45, tmpScore);
        }
        return score;
    }

    @Override
    public String getName() {
        return "Clinical / Functional Scoring Model 2308";
    }

    @Override
    public void setName(String arg0) {
    }

    public int getCaseMixAdjustmentEquation(int caseMixId, int equationId) {
        CaseMixAdjustmentItemIF caseMix = this.getCaseMixAdjustment(caseMixId);
        return caseMix == null ? 0 : caseMix.getAdjustment(equationId);
    }

    public CaseMixAdjustmentItemIF getCaseMixAdjustment(int caseMixId) {
        if (this.lastCaseMix == null || this.lastCaseMix.getId() != caseMixId) {
            this.lastCaseMix = this.grouperDataManager.getCaseMixAdjustment(caseMixId);
        }
        return this.lastCaseMix;
    }

    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getDiagnosisCode(codeValue)) == null) {
            code = new DiagnosisCode(codeValue);
        }
        return code;
    }

    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        int idx;
        int clinicalScore = 0;
        boolean Row11C8Flag = false;
        boolean Row11C9Flag = false;
        boolean Row14C10Flag = false;
        boolean Row14C11Flag = false;
        boolean Row19C6Flag = false;
        boolean Row19C14Flag = false;
        boolean Row20C14Flag = false;
        boolean Row20C15Flag = false;
        boolean Row27C19Flag = false;
        boolean Row27C20Flag = false;
        int[] codePoints = new int[18];
        int[] dualPointsSE = new int[18];
        boolean[] diagGroupsUsed = new boolean[22];
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Diagnosis Group scoring");
        block32: for (idx = 0; idx < 18; ++idx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(idx);
            if (!diagCode.isValidForScoring()) {
                if (!diagCode.isValidCode()) {
                    if (diagCode.isEmpty()) continue;
                    ScoringEventFormatter.fireValidCodeWarning(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, false);
                    continue;
                }
                ScoringEventFormatter.fireValidCodeWarning(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, true);
                continue;
            }
            ScoringEventFormatter.fireScoringCodeEligible(this.grouper.getEventListenersList(), this.grouper, this, idx + 1, diagCode);
            int diagGroupId = diagCode.getDiagnosticGroup().getId();
            switch (diagGroupId) {
                case 1: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(1, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 1, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 2: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(2, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 2, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 3: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(3, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 3, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 4: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(4, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 4, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 5: {
                    int tmpScore;
                    if (record.isDiagnosticGroupOnRecord(12, -1)) {
                        tmpScore = this.getCaseMixAdjustmentEquation(6, this.id);
                        int n = idx;
                        codePoints[n] = codePoints[n] + tmpScore;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 6, tmpScore);
                        diagGroupsUsed[diagGroupId - 1] = true;
                    }
                    if (!"1".equals(record.getTHH_ENT_NUTRITION()) || !validator.isTHERAPIES_Valid() || !validator.isINTERNAL_LOGIC_Valid()) continue block32;
                    tmpScore = this.getCaseMixAdjustmentEquation(7, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 7, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 6: {
                    if (!validator.isSTGPRSUL_Valid() || !ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || Row19C14Flag) continue block32;
                    Row19C6Flag = true;
                    int tmpScore = this.getCaseMixAdjustmentEquation(19, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 19, tmpScore);
                    int n2 = idx;
                    dualPointsSE[n2] = dualPointsSE[n2] + 19;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 7: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(8, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 8, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    if (validator.isOSTOMY_Valid() && ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                        tmpScore = this.getCaseMixAdjustmentEquation(9, this.id);
                        int n3 = idx;
                        codePoints[n3] = codePoints[n3] + tmpScore;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 9, tmpScore);
                    }
                    if (!record.isDiagnosticGroupOnRecord(10, -1) && !record.isDiagnosticGroupOnRecord(11, -1) && !record.isDiagnosticGroupOnRecord(12, -1) && !record.isDiagnosticGroupOnRecord(13, -1)) continue block32;
                    tmpScore = this.getCaseMixAdjustmentEquation(10, this.id);
                    int n4 = idx;
                    codePoints[n4] = codePoints[n4] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 10, tmpScore);
                    continue block32;
                }
                case 8: {
                    if (Row11C9Flag) continue block32;
                    Row11C8Flag = true;
                    int tmpScore = this.getCaseMixAdjustmentEquation(11, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 11, tmpScore);
                    int n5 = idx;
                    dualPointsSE[n5] = dualPointsSE[n5] + 11;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 9: {
                    if (Row11C8Flag) continue block32;
                    Row11C9Flag = true;
                    int tmpScore = this.getCaseMixAdjustmentEquation(11, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 11, tmpScore);
                    int n6 = idx;
                    dualPointsSE[n6] = dualPointsSE[n6] + 11;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 10: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(12, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 12, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    if (validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
                        tmpScore = this.getCaseMixAdjustmentEquation(13, this.id);
                        int n7 = idx;
                        codePoints[n7] = codePoints[n7] + tmpScore;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 13, tmpScore);
                    }
                    if (Row14C11Flag || !validator.isCUR_DRESS_Valid() || !ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) && !ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE})) continue block32;
                    Row14C10Flag = true;
                    tmpScore = this.getCaseMixAdjustmentEquation(14, this.id);
                    int n8 = idx;
                    codePoints[n8] = codePoints[n8] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 14, tmpScore);
                    int n9 = idx;
                    dualPointsSE[n9] = dualPointsSE[n9] + 14;
                    continue block32;
                }
                case 11: {
                    if (Row14C10Flag || !validator.isCUR_DRESS_Valid() || !ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) && !ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE})) continue block32;
                    Row14C11Flag = true;
                    int tmpScore = this.getCaseMixAdjustmentEquation(14, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 14, tmpScore);
                    int n10 = idx;
                    dualPointsSE[n10] = dualPointsSE[n10] + 14;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 12: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(15, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 15, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    if (validator.isCUR_DRESS_Valid() && (ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) || ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}))) {
                        tmpScore = this.getCaseMixAdjustmentEquation(16, this.id);
                        int n11 = idx;
                        codePoints[n11] = codePoints[n11] + tmpScore;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 16, tmpScore);
                    }
                    if (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE})) continue block32;
                    tmpScore = this.getCaseMixAdjustmentEquation(17, this.id);
                    int n12 = idx;
                    codePoints[n12] = codePoints[n12] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 17, tmpScore);
                    continue block32;
                }
                case 13: {
                    if (!(validator.isCUR_BATHING_Valid() && ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE}) || validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR}) || validator.isCUR_TRANSFER_Valid() && ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) && (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE}))) continue block32;
                    int tmpScore = this.getCaseMixAdjustmentEquation(18, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 18, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 14: {
                    int tmpScore;
                    if (!Row19C6Flag && validator.isSTGPRSUL_Valid() && ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                        Row19C14Flag = true;
                        tmpScore = this.getCaseMixAdjustmentEquation(19, this.id);
                        int n = idx;
                        codePoints[n] = codePoints[n] + tmpScore;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 19, tmpScore);
                        int n13 = idx;
                        dualPointsSE[n13] = dualPointsSE[n13] + 19;
                        diagGroupsUsed[diagGroupId - 1] = true;
                    }
                    if (Row20C15Flag || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION()) || !validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid()) continue block32;
                    Row20C14Flag = true;
                    tmpScore = this.getCaseMixAdjustmentEquation(20, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 20, tmpScore);
                    int n14 = idx;
                    dualPointsSE[n14] = dualPointsSE[n14] + 20;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 15: {
                    if (Row20C14Flag || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION()) || !validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid()) continue block32;
                    Row20C15Flag = true;
                    int tmpScore = this.getCaseMixAdjustmentEquation(20, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 20, tmpScore);
                    int n15 = idx;
                    dualPointsSE[n15] = dualPointsSE[n15] + 20;
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 16: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(21, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 21, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 17: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(22, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 22, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 18: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(23, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 23, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    if (!validator.isCUR_AMBULATION_Valid() || !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR_FIVE})) continue block32;
                    tmpScore = this.getCaseMixAdjustmentEquation(24, this.id);
                    int n16 = idx;
                    codePoints[n16] = codePoints[n16] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 24, tmpScore);
                    continue block32;
                }
                case 19: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(25, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 25, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    if (Row27C20Flag || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION()) || !validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid()) continue block32;
                    Row27C19Flag = true;
                    tmpScore = this.getCaseMixAdjustmentEquation(27, this.id);
                    int n17 = idx;
                    codePoints[n17] = codePoints[n17] + tmpScore;
                    int n18 = idx;
                    dualPointsSE[n18] = dualPointsSE[n18] + 27;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 27, tmpScore);
                    continue block32;
                }
                case 20: {
                    int tmpScore;
                    if (!Row27C19Flag && ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION())) && validator.isINTERNAL_LOGIC_Valid() && validator.isTHERAPIES_Valid()) {
                        Row27C20Flag = true;
                        tmpScore = this.getCaseMixAdjustmentEquation(27, this.id);
                        int n = idx;
                        codePoints[n] = codePoints[n] + tmpScore;
                        int n19 = idx;
                        dualPointsSE[n19] = dualPointsSE[n19] + 27;
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 27, tmpScore);
                    }
                    tmpScore = this.getCaseMixAdjustmentEquation(28, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 28, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 21: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(29, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 29, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
                case 22: {
                    int tmpScore = this.getCaseMixAdjustmentEquation(30, this.id);
                    int n = idx;
                    codePoints[n] = codePoints[n] + tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(this.grouper.getEventListenersList(), this.grouper, this, diagCode, idx + 1, 30, tmpScore);
                    diagGroupsUsed[diagGroupId - 1] = true;
                    continue block32;
                }
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Diagnosis Group scoring", codePoints);
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Determining primary Diagnosis");
        this.determinePrimaryDiagnosis(record, validator, codePoints);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Determining primary Diagnosis", codePoints);
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Recalculate for non-primary diagnosis");
        this.recalculateNonPrimaryCodes(record, validator, codePoints, dualPointsSE);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Recalculate for non-primary diagnosis", codePoints);
        diagGroupsUsed = new boolean[22];
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Resolve contention within etiology/manifestation pairs");
        boolean[] pointsLost = this.resolveEtiologyManifestationContention(record, validator, codePoints, diagGroupsUsed);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Resolve contention within etiology/manifestation pairs", codePoints);
        clinicalScore += HomeHealthUtils.sumIntArray(codePoints);
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Recapture the points for any dual-diagnosis");
        block33: for (idx = 0; idx < 18; ++idx) {
            if (!pointsLost[idx]) continue;
            switch (dualPointsSE[idx]) {
                case 11: {
                    if (!record.isDiagnosticGroupOnRecord(8, idx) && !record.isDiagnosticGroupOnRecord(9, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(11, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 11);
                    continue block33;
                }
                case 14: {
                    if (!record.isDiagnosticGroupOnRecord(10, idx) && !record.isDiagnosticGroupOnRecord(11, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(14, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 14);
                    continue block33;
                }
                case 19: {
                    if (!record.isDiagnosticGroupOnRecord(6, idx) && !record.isDiagnosticGroupOnRecord(14, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(19, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 19);
                    continue block33;
                }
                case 20: {
                    if (!record.isDiagnosticGroupOnRecord(14, idx) && !record.isDiagnosticGroupOnRecord(15, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(20, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 20);
                    continue block33;
                }
                case 27: {
                    if (!record.isDiagnosticGroupOnRecord(19, idx) && !record.isDiagnosticGroupOnRecord(20, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(27, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 27);
                    continue block33;
                }
                case 39: {
                    if (record.isDiagnosticGroupOnRecord(6, idx) || record.isDiagnosticGroupOnRecord(14, idx)) {
                        clinicalScore += this.getCaseMixAdjustmentEquation(19, this.id);
                        ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 19);
                    }
                    if (!record.isDiagnosticGroupOnRecord(14, idx) && !record.isDiagnosticGroupOnRecord(15, idx)) continue block33;
                    clinicalScore += this.getCaseMixAdjustmentEquation(20, this.id);
                    ScoringEventFormatter.fireScoringIncreaseEvent(this.grouper.getEventListenersList(), this.grouper, this, "Points Lost added back ", idx + 1, 20);
                    continue block33;
                }
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Recapture the points for any dual-diagnosis", clinicalScore);
        ScoringEventFormatter.fireScoringSectionStart(this.grouper.getEventListenersList(), this.grouper, this, "Scoring remaining clinical variables");
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Scoring remaining clinical variables", null);
        ScoringEventFormatter.fireScoringSectionFinished(this.grouper.getEventListenersList(), this.grouper, (HomeHealthScoringModelIF)this, "Diagnosis Group scoring (final)", clinicalScore += this.scoreRemainingVariables(record, validator, codePoints));
        return clinicalScore;
    }

    public int scoreFunctional(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        int score = 0;
        if (validator.isCUR_DRESS_Valid() && (ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}) || ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE}))) {
            score += this.getCaseMixAdjustmentEquation(46, this.id);
        }
        if (validator.isCUR_BATHING_Valid() && ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            score += this.getCaseMixAdjustmentEquation(47, this.id);
        }
        if (validator.isCUR_TOILETING_Valid() && ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR})) {
            score += this.getCaseMixAdjustmentEquation(48, this.id);
        }
        if (validator.isCUR_TRANSFER_Valid() && ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE_FOUR_FIVE})) {
            score += this.getCaseMixAdjustmentEquation(49, this.id);
        }
        if (validator.isCUR_AMBULATION_Valid()) {
            if (ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                score += this.getCaseMixAdjustmentEquation(50, this.id);
            } else if (ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_THREE_FOUR_FIVE})) {
                score += this.getCaseMixAdjustmentEquation(51, this.id);
            }
        }
        return score;
    }

    @Override
    public void populateCodes(HomeHealthRecordIF record) {
        DiagnosisCodeIF tmpCode = record.getPRIMARY_DIAG_ICD();
        if (tmpCode != DiagnosisCode_Empty.DEFAULT) {
            record.setPRIMARY_DIAG_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG1_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG1_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG2_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG2_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG3_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG3_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG4_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG4_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG5_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG5_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_A3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_A3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_B3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_B3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_C3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_C3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_D3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_D3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_E3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_E3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_F3()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_F3(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_A4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_A4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_B4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_B4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_C4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_C4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_D4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_D4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_E4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_E4(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getPMT_DIAG_ICD_F4()) != DiagnosisCode_Empty.DEFAULT) {
            record.setPMT_DIAG_ICD_F4(this.getDiagnosisCode(tmpCode.getCode()));
        }
    }

    @Override
    public HomeHealthGrouperIF getGrouper() {
        return this.grouper;
    }

    @Override
    public void setGrouper(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }
}

