/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3110_1;

import com.mmm.cms.homehealth.PointsScoringEquations;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.hipps.HIPPSCode;
import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.v2308_1.GrouperVersion_v2308_1;
import com.mmm.cms.homehealth.v3110_1.HomeHealthRecordClinicalValidator_v3110_1;
import com.mmm.cms.homehealth.v3110_1.HomeHealthRecordNRSValidator_3110;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.GregorianCalendar;

public class GrouperVersion_v3110_1
extends GrouperVersion_v2308_1 {
    private boolean mapValues;

    public GrouperVersion_v3110_1() {
        super(new GregorianCalendar(2010, 0, 1), new GregorianCalendar(2010, 8, 30), null);
        this.setVersion("V3110");
        this.mapValues = true;
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - January 1, 2010 - " + this.getVersion();
    }

    @Override
    public String getDescription() {
        return "Provides the version 2.03 scoring logic for codes valid between January 1, 2010 thru September 30, 2010 inclusive.";
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF recordOasisC, boolean validateDates) {
        ScoringResults scoringResult;
        ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Pre-scoring: ", recordOasisC);
        if (validateDates && !this.isValidForVersion(recordOasisC)) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": record not valid for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else if (!(recordOasisC instanceof HomeHealthRecord_C_IF)) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": Invalid record format for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else {
            PointsScoringEquations clinicalScore = new PointsScoringEquations();
            PointsScoringEquations functionalScore = new PointsScoringEquations();
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Clinical/Functional scoring");
            this.clinicalModel_1.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populating record: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating record");
            HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
            validator.validate(recordOasisC, this.getEventListenersList());
            HomeHealthRecord_B_IF recordOasisB = HomeHealthRecordUtil.convertToHomeHealthRecord_OasisB((HomeHealthRecord_C_IF)recordOasisC, this.mapValues);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-converting record to Oasis-B values: ", recordOasisB);
            ScoringPointsIF scoringPoints = this.clinicalModel_1.score(recordOasisB, validator);
            clinicalScore.setEarly13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setEarly13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_2.score(recordOasisB, validator);
            clinicalScore.setEarly14Plus(scoringPoints.getScores()[0]);
            functionalScore.setEarly14Plus(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_3.score(recordOasisB, validator);
            clinicalScore.setLater13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setLater13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_4.score(recordOasisB, validator);
            clinicalScore.setLater14Plus(scoringPoints.getScores()[0]);
            functionalScore.setLater14Plus(scoringPoints.getScores()[1]);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Non-Routine Supplies scoring");
            this.nrsScoringModel.populateCodes(recordOasisC);
            HomeHealthRecordValidatorIF nrsValidator = this.getNRSValidator();
            nrsValidator.validate(recordOasisC, this.getEventListenersList());
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populate with NRS Diagnosis: ", recordOasisC);
            this.copyCodes(recordOasisC, recordOasisB);
            scoringPoints = this.nrsScoringModel.score(recordOasisB, nrsValidator);
            int nrsScore = scoringPoints.getScores()[0];
            HIPPSCode hippsCode = new HIPPSCode(recordOasisC, validator, clinicalScore, functionalScore, nrsScore);
            TreatmentAuthorization treatment = hippsCode.getCode().trim().isEmpty() ? new TreatmentAuthorization(recordOasisC, null, null, null) : new TreatmentAuthorization(recordOasisC, validator, clinicalScore, functionalScore);
            scoringResult = new ScoringResults(hippsCode, this.getVersion(), validator.getDataValidityFlag(), treatment, validator, nrsValidator);
        }
        return scoringResult;
    }

    public void copyCodes(HomeHealthRecordIF recordSrc, HomeHealthRecordIF recordDest) {
        recordDest.setPRIMARY_DIAG_ICD(recordSrc.getPRIMARY_DIAG_ICD());
        recordDest.setOTH_DIAG1_ICD(recordSrc.getOTH_DIAG1_ICD());
        recordDest.setOTH_DIAG2_ICD(recordSrc.getOTH_DIAG2_ICD());
        recordDest.setOTH_DIAG3_ICD(recordSrc.getOTH_DIAG3_ICD());
        recordDest.setOTH_DIAG4_ICD(recordSrc.getOTH_DIAG4_ICD());
        recordDest.setOTH_DIAG5_ICD(recordSrc.getOTH_DIAG5_ICD());
        recordDest.setPMT_DIAG_ICD_A3(recordSrc.getPMT_DIAG_ICD_A3());
        recordDest.setPMT_DIAG_ICD_B3(recordSrc.getPMT_DIAG_ICD_B3());
        recordDest.setPMT_DIAG_ICD_C3(recordSrc.getPMT_DIAG_ICD_C3());
        recordDest.setPMT_DIAG_ICD_D3(recordSrc.getPMT_DIAG_ICD_D3());
        recordDest.setPMT_DIAG_ICD_E3(recordSrc.getPMT_DIAG_ICD_E3());
        recordDest.setPMT_DIAG_ICD_F3(recordSrc.getPMT_DIAG_ICD_F3());
        recordDest.setPMT_DIAG_ICD_A4(recordSrc.getPMT_DIAG_ICD_A4());
        recordDest.setPMT_DIAG_ICD_B4(recordSrc.getPMT_DIAG_ICD_B4());
        recordDest.setPMT_DIAG_ICD_C4(recordSrc.getPMT_DIAG_ICD_C4());
        recordDest.setPMT_DIAG_ICD_D4(recordSrc.getPMT_DIAG_ICD_D4());
        recordDest.setPMT_DIAG_ICD_E4(recordSrc.getPMT_DIAG_ICD_E4());
        recordDest.setPMT_DIAG_ICD_F4(recordSrc.getPMT_DIAG_ICD_F4());
    }

    @Override
    public Class getAcceptableRecordClass() {
        return HomeHealthRecord_C_IF.class;
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator_v3110_1(this);
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordNRSValidator_3110(this);
    }
}

