/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3210;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.HomeHealthEventNotifier;
import com.mmm.cms.homehealth.PointsScoringEquations;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.hipps.HIPPSCode;
import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringStatus_EN;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.v3210.ClinicalFunctional_ScoringModel_v3210;
import com.mmm.cms.homehealth.v3210.HomeHealthRecordClinicalValidator_v3210;
import com.mmm.cms.homehealth.v3210.NRS_ScoringModel_v3210;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;

public class GrouperVersion_v3210
extends HomeHealthEventNotifier
implements HomeHealthGrouperIF {
    private Calendar effectiveDateStart;
    private Calendar effectiveDateStartWindow;
    private Calendar effectiveDateThru;
    private GrouperDataManager grouperDataManager;
    protected HomeHealthScoringModelIF nrsScoringModel;
    protected HomeHealthScoringModelIF clinicalModel_1;
    protected HomeHealthScoringModelIF clinicalModel_2;
    protected HomeHealthScoringModelIF clinicalModel_3;
    protected HomeHealthScoringModelIF clinicalModel_4;
    protected String version;
    private boolean mapValues;

    public GrouperVersion_v3210() {
        this(new GregorianCalendar(2010, 9, 1), new GregorianCalendar(2011, 8, 30), null, "V3210");
    }

    public GrouperVersion_v3210(Calendar start, Calendar thru, Calendar window, String versionName) {
        if (start == null || thru == null) {
            throw new IllegalArgumentException("Neither the start date or the thru date can be null");
        }
        if (versionName == null || versionName.length() != 5) {
            throw new IllegalArgumentException("versionName " + (versionName == null ? " can not be null!" : " of '" + versionName + "' is invalid. Must be a 5 characte string."));
        }
        this.effectiveDateStart = start;
        this.effectiveDateThru = thru;
        this.effectiveDateStartWindow = window != null ? window : this.effectiveDateStart;
        this.mapValues = true;
        this.version = versionName;
    }

    public void copyCodes(HomeHealthRecordIF recordSrc, HomeHealthRecordIF recordDest) {
        recordDest.setPRIMARY_DIAG_ICD(recordSrc.getPRIMARY_DIAG_ICD());
        recordDest.setOTH_DIAG1_ICD(recordSrc.getOTH_DIAG1_ICD());
        recordDest.setOTH_DIAG2_ICD(recordSrc.getOTH_DIAG2_ICD());
        recordDest.setOTH_DIAG3_ICD(recordSrc.getOTH_DIAG3_ICD());
        recordDest.setOTH_DIAG4_ICD(recordSrc.getOTH_DIAG4_ICD());
        recordDest.setOTH_DIAG5_ICD(recordSrc.getOTH_DIAG5_ICD());
        recordDest.setPMT_DIAG_ICD_A3(recordSrc.getPMT_DIAG_ICD_A3());
        recordDest.setPMT_DIAG_ICD_B3(recordSrc.getPMT_DIAG_ICD_B3());
        recordDest.setPMT_DIAG_ICD_C3(recordSrc.getPMT_DIAG_ICD_C3());
        recordDest.setPMT_DIAG_ICD_D3(recordSrc.getPMT_DIAG_ICD_D3());
        recordDest.setPMT_DIAG_ICD_E3(recordSrc.getPMT_DIAG_ICD_E3());
        recordDest.setPMT_DIAG_ICD_F3(recordSrc.getPMT_DIAG_ICD_F3());
        recordDest.setPMT_DIAG_ICD_A4(recordSrc.getPMT_DIAG_ICD_A4());
        recordDest.setPMT_DIAG_ICD_B4(recordSrc.getPMT_DIAG_ICD_B4());
        recordDest.setPMT_DIAG_ICD_C4(recordSrc.getPMT_DIAG_ICD_C4());
        recordDest.setPMT_DIAG_ICD_D4(recordSrc.getPMT_DIAG_ICD_D4());
        recordDest.setPMT_DIAG_ICD_E4(recordSrc.getPMT_DIAG_ICD_E4());
        recordDest.setPMT_DIAG_ICD_F4(recordSrc.getPMT_DIAG_ICD_F4());
    }

    @Override
    public int[][] determineScoreOrder(HomeHealthRecordIF record) {
        int[][] scoreOrder = new int[6][3];
        for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
            if (diagCode.isOptionalPaymentCode()) {
                DiagnosisCodeIF diagCodeOptional = record.getOptionalDiagnosisCode4(diagIdx);
                if (diagCodeOptional.isValidForScoring()) {
                    scoreOrder[diagIdx][2] = 2;
                    scoreOrder[diagIdx][1] = 2;
                    continue;
                }
                diagCodeOptional = record.getOptionalDiagnosisCode3(diagIdx);
                if (!diagCodeOptional.isValidForScoring()) continue;
                scoreOrder[diagIdx][1] = 1;
                continue;
            }
            if (!diagCode.isValidForScoring()) continue;
            if (diagCode.isSecondaryOnly()) {
                scoreOrder[diagIdx][0] = 2;
                scoreOrder[diagIdx - 1][0] = 2;
                continue;
            }
            scoreOrder[diagIdx][0] = 1;
        }
        return scoreOrder;
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroups() {
        return this.grouperDataManager.getDiagnosticGroups();
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroupsNRS() {
        return this.grouperDataManager.getDiagnosticGroupsNRS();
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        SimpleDateFormat dformatter = new SimpleDateFormat("MMM d, yyyy");
        buffer.append(this.getName());
        buffer.append(" - Effective dates: ");
        buffer.append(dformatter.format(this.getEffectiveDateStart().getTime()));
        buffer.append(" thru ");
        buffer.append(dformatter.format(this.getEffectiveDateThru().getTime()));
        if (this.effectiveDateStartWindow != null && this.effectiveDateStartWindow != this.effectiveDateStart) {
            buffer.append(" (with effective start window of ");
            buffer.append(dformatter.format(this.effectiveDateStartWindow.getTime()));
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getCaseMixAdjustments() {
        return this.grouperDataManager.getCaseMixAdjustments();
    }

    public HomeHealthScoringModelIF getClinicalModel_1() {
        return this.clinicalModel_1;
    }

    public HomeHealthScoringModelIF getClinicalModel_2() {
        return this.clinicalModel_2;
    }

    public HomeHealthScoringModelIF getClinicalModel_3() {
        return this.clinicalModel_3;
    }

    public HomeHealthScoringModelIF getClinicalModel_4() {
        return this.clinicalModel_4;
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator_v3210(this);
    }

    @Override
    public List<DiagnosisCodeIF> getClinicalCodes() {
        return this.grouperDataManager.getClinicalCodes();
    }

    @Override
    public Calendar getEffectiveDateStart() {
        return this.effectiveDateStart;
    }

    @Override
    public Calendar getEffectiveDateThru() {
        return this.effectiveDateThru;
    }

    @Override
    public GrouperDataManager getGrouperDataManager() {
        return this.grouperDataManager;
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - October 2010 ICD-9-CM codes, " + this.getVersion();
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getNRSCaseMixAdjustments() {
        return this.grouperDataManager.getNRSCaseMixAdjustments();
    }

    public HomeHealthScoringModelIF getNrsScoringModel() {
        return this.nrsScoringModel;
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordClinicalValidator_v3210(this);
    }

    @Override
    public List<DiagnosisCodeIF> getNonRoutineCodes() {
        return this.grouperDataManager.getNonRoutineCodes();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void init(Properties props) throws Exception {
        this.grouperDataManager = new GrouperDataManager(this);
        this.grouperDataManager.init(props);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v3210(this, this.grouperDataManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v3210(this, this.grouperDataManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v3210(this, this.grouperDataManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v3210(this, this.grouperDataManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v3210(this, this.grouperDataManager);
    }

    @Override
    public boolean isValidForVersion(HomeHealthRecordIF record) {
        boolean valid;
        Calendar date = record.getINFO_COMPLETED_DT();
        if (date != null) {
            int tmpInt = IntegerUtils.parseInt(record.getASSMT_REASON(), 0);
            switch (tmpInt) {
                case 1: 
                case 3: {
                    valid = !date.before(this.effectiveDateStart);
                    break;
                }
                case 4: 
                case 5: {
                    valid = !date.before(this.effectiveDateStartWindow);
                    break;
                }
                default: {
                    valid = false;
                }
            }
            if (valid) {
                valid = !date.after(this.effectiveDateThru);
            }
        } else {
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean isValidDiagnosisCode(HomeHealthRecordIF record, DiagnosisCodeIF code) {
        return code == null ? false : this.grouperDataManager.getDiagnosisCode(code.getCode()) != null;
    }

    @Override
    public HomeHealthRecordValidatorIF populateValidateClinicalCodes(HomeHealthRecordIF record) {
        HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
        this.clinicalModel_1.populateCodes(record);
        validator.validate(record);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ScoringResultsIF score(HomeHealthRecordIF record, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        try {
            if (listeners != null) {
                for (HomeHealthEventListenerIF listener : listeners) {
                    this.addEventListener(listener);
                }
            }
            ScoringResultsIF scoringResultsIF = this.score(record, validateDates);
            return scoringResultsIF;
        }
        finally {
            if (listeners != null) {
                for (HomeHealthEventListenerIF listener : listeners) {
                    this.removeEventListener(listener);
                }
            }
        }
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF recordOasisC, boolean validateDates) {
        ScoringResults scoringResult;
        ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Pre-scoring: ", recordOasisC);
        if (validateDates && !this.isValidForVersion(recordOasisC)) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": record not valid for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else if (!(recordOasisC instanceof HomeHealthRecord_C_IF)) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": Invalid record format for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else {
            DiagnosisCodeIF diagCode;
            int idx;
            DiagnosisScoringStatus_EN[] diagnosisStatus = new DiagnosisScoringStatus_EN[18];
            DiagnosisScoringStatus_EN[] nrsDiagnosisStatus = new DiagnosisScoringStatus_EN[18];
            PointsScoringEquations clinicalScore = new PointsScoringEquations();
            PointsScoringEquations functionalScore = new PointsScoringEquations();
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Clinical/Functional scoring");
            this.clinicalModel_1.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populating record: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating record");
            HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
            validator.validate(recordOasisC, this.getEventListenersList());
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating record - Done");
            HomeHealthRecord_B_IF recordOasisB = HomeHealthRecordUtil.convertToHomeHealthRecord_OasisB((HomeHealthRecord_C_IF)recordOasisC, this.mapValues);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-converting record to Oasis-B values: ", recordOasisB);
            for (idx = 0; idx < diagnosisStatus.length; ++idx) {
                diagCode = recordOasisC.getDiagnosisCode(idx);
                DiagnosisScoringStatus_EN diagnosisScoringStatus_EN = diagCode.isValidCode() ? (diagCode.isValidForScoring() ? DiagnosisScoringStatus_EN.VALID_SCORABLE : DiagnosisScoringStatus_EN.VALID) : (diagnosisStatus[idx] = DiagnosisScoringStatus_EN.INVALID);
                if (diagCode.isEmpty() || diagCode.isValidForScoring()) continue;
                ScoringEventFormatter.fireValidCodeWarning(this.getEventListenersList(), this, this.clinicalModel_1, diagCode, idx + 1, diagCode.isValidCode());
            }
            int[][] scoreOrder = this.determineScoreOrder(recordOasisB);
            ScoringPointsIF scoringPoints = this.clinicalModel_1.score(recordOasisB, validator, scoreOrder);
            clinicalScore.setEarly13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setEarly13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_2.score(recordOasisB, validator, scoreOrder);
            clinicalScore.setEarly14Plus(scoringPoints.getScores()[0]);
            functionalScore.setEarly14Plus(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_3.score(recordOasisB, validator, scoreOrder);
            clinicalScore.setLater13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setLater13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_4.score(recordOasisB, validator, scoreOrder);
            clinicalScore.setLater14Plus(scoringPoints.getScores()[0]);
            functionalScore.setLater14Plus(scoringPoints.getScores()[1]);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Non-Routine Supplies scoring");
            this.nrsScoringModel.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populate with NRS Diagnosis: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating NRS record");
            HomeHealthRecordValidatorIF nrsValidator = this.getNRSValidator();
            nrsValidator.validate(recordOasisC, this.getEventListenersList());
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating NRS record - Done");
            this.copyCodes(recordOasisC, recordOasisB);
            for (idx = 0; idx < nrsDiagnosisStatus.length; ++idx) {
                diagCode = recordOasisC.getDiagnosisCode(idx);
                DiagnosisScoringStatus_EN diagnosisScoringStatus_EN = diagCode.isValidCode() ? (diagCode.isValidForScoring() ? DiagnosisScoringStatus_EN.VALID_SCORABLE : DiagnosisScoringStatus_EN.VALID) : (nrsDiagnosisStatus[idx] = DiagnosisScoringStatus_EN.INVALID);
                if (diagCode.isEmpty() || diagCode.isValidForScoring()) continue;
                ScoringEventFormatter.fireValidCodeWarning(this.getEventListenersList(), this, this.nrsScoringModel, diagCode, idx + 1, diagCode.isValidCode());
            }
            scoreOrder = this.determineScoreOrder(recordOasisB);
            scoringPoints = this.nrsScoringModel.score(recordOasisB, nrsValidator, scoreOrder);
            int nrsScore = scoringPoints.getScores()[0];
            HIPPSCode hippsCode = new HIPPSCode(recordOasisC, validator, clinicalScore, functionalScore, nrsScore);
            TreatmentAuthorization treatment = hippsCode.getCode().trim().isEmpty() ? new TreatmentAuthorization(recordOasisC, null, null, null) : new TreatmentAuthorization(recordOasisC, validator, clinicalScore, functionalScore);
            scoringResult = new ScoringResults(hippsCode, this.getVersion(), validator.getDataValidityFlag(), treatment, validator, nrsValidator);
            scoringResult.setDiagnosisScoringStatus(diagnosisStatus);
            scoringResult.setNrsDiagnosisScoringStatus(nrsDiagnosisStatus);
        }
        return scoringResult;
    }

    @Override
    public void setDescription(String arg0) {
    }

    public void setClinicalModel_1(ClinicalFunctional_ScoringModel_v3210 clinicalModel_1) {
        this.clinicalModel_1 = clinicalModel_1;
    }

    public void setClinicalModel_2(ClinicalFunctional_ScoringModel_v3210 clinicalModel_2) {
        this.clinicalModel_2 = clinicalModel_2;
    }

    public void setClinicalModel_3(ClinicalFunctional_ScoringModel_v3210 clinicalModel_3) {
        this.clinicalModel_3 = clinicalModel_3;
    }

    public void setClinicalModel_4(ClinicalFunctional_ScoringModel_v3210 clinicalModel_4) {
        this.clinicalModel_4 = clinicalModel_4;
    }

    public void setGrouperDataManager(GrouperDataManager grouperDataManager) {
        this.grouperDataManager = grouperDataManager;
    }

    @Override
    public void setName(String name) {
    }

    public void setNrsScoringModel(NRS_ScoringModel_v3210 nrsScoringModel) {
        this.nrsScoringModel = nrsScoringModel;
    }

    @Override
    public void setVersion(String version) {
    }

    @Override
    public void setEffectiveDateStart(Calendar effectiveDateStart) {
        this.effectiveDateStart = effectiveDateStart;
    }

    @Override
    public void setEffectiveDateThru(Calendar effectiveDateThru) {
        this.effectiveDateThru = effectiveDateThru;
    }

    @Override
    public Class getAcceptableRecordClass() {
        return HomeHealthRecord_C_IF.class;
    }

    @Override
    public void setEffectiveDateStartWindow(Calendar effectiveDateStartWindow) {
        this.effectiveDateStartWindow = effectiveDateStartWindow;
    }

    @Override
    public Calendar getEffectiveDateStartWindow() {
        return this.effectiveDateStartWindow;
    }
}

